/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.internal.ui.pages.template;

import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectTemplate;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ITemplateCategory;
import com.ibm.faceted.project.wizard.core.serviceability.Logger;
import com.ibm.faceted.project.wizard.core.serviceability.ServiceablilityUtil;
import com.ibm.faceted.project.wizard.ui.FacetedProjectWizard;
import com.ibm.faceted.project.wizard.ui.IImageManager;
import java.net.MalformedURLException;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TemplateLabelProvider
extends LabelProvider {
    private final Image defaultIcon;
    private IImageManager imageManager;
    private static Logger logger = ServiceablilityUtil.getServiceabilityManager().getLogger();

    public TemplateLabelProvider(FacetedProjectWizard wizard) {
        this.imageManager = wizard.getImageManager();
        this.defaultIcon = wizard.getDefaultProjectTemplateIcon();
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof IProjectTemplate) {
            result = this.defaultIcon;
            IProjectTemplate projectTemplate = (IProjectTemplate)element;
            String imagePath = projectTemplate.getSmallIcon();
            String pluginId = projectTemplate.getContributingPluginId();
            if (imagePath != null) {
                try {
                    result = this.imageManager.getImage(pluginId, imagePath);
                }
                catch (MalformedURLException malformedURLException) {
                    String message = "Project template icon could not be created because of invalid path";
                    logger.logContributorError(projectTemplate, message);
                    result = this.defaultIcon;
                }
            }
        }
        return result;
    }

    public String getText(Object element) {
        if (element != null) {
            if (element instanceof IProjectTemplate) {
                return ((IProjectTemplate)element).getTitle();
            }
            if (element instanceof ITemplateCategory) {
                return ((ITemplateCategory)element).getLabel();
            }
        }
        return null;
    }
}

