/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.internal.ui.pages.template;

import com.ibm.faceted.project.wizard.core.management.IExtensionPointManager;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectTemplate;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ITemplateCategory;
import com.ibm.faceted.project.wizard.ui.FacetedProjectWizard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TemplateContentProvider
implements IStructuredContentProvider {
    private Object[] listElements;

    public TemplateContentProvider(final FacetedProjectWizard wizard) {
        IExtensionPointManager manager = wizard.getExtensionPointManager();
        Set<ITemplateCategory> categorySet = manager.getTemplateCategories();
        ArrayList<ITemplateCategory> categories = new ArrayList<ITemplateCategory>(categorySet);
        HashMap<ITemplateCategory, Object> categoryToTemplateMap = new HashMap<ITemplateCategory, Object>();
        HashMap<String, IProjectTemplate> templatesInCategories = new HashMap<String, IProjectTemplate>();
        for (ITemplateCategory templateCategory : categorySet) {
            Set<String> projectTemplateSet = templateCategory.getProjectTemplates();
            ArrayList sortedTemplates = new ArrayList();
            for (String ptId : projectTemplateSet) {
                IProjectTemplate pt = manager.getProjectTemplateById(ptId);
                if (pt == null) continue;
                sortedTemplates.add(pt);
                templatesInCategories.put(ptId, pt);
            }
            Collections.sort(sortedTemplates, wizard.getProjectTemplateComparator());
            categoryToTemplateMap.put(templateCategory, sortedTemplates);
        }
        Set<IProjectTemplate> allWizardProjectTemplates = manager.getProjectTemplates();
        HashSet<String> mutableDefaultCategoryTemplateIds = new HashSet<String>();
        for (IProjectTemplate projectTemplate : allWizardProjectTemplates) {
            if (templatesInCategories.containsKey(projectTemplate.getId())) continue;
            mutableDefaultCategoryTemplateIds.add(projectTemplate.getId());
        }
        if (!mutableDefaultCategoryTemplateIds.isEmpty()) {
            final Set defaultCategoryTemplateIds = Collections.unmodifiableSet(mutableDefaultCategoryTemplateIds);
            ITemplateCategory defaultCategory = new ITemplateCategory(){

                @Override
                public String getContributingPluginId() {
                    return "com.ibm.adapter.j2c.codegen";
                }

                @Override
                public String getExtensionPointId() {
                    return "com.ibm.adapter.j2c.codegen.wizardAssociation";
                }

                @Override
                public String getId() {
                    return ITemplateCategory.DEFAULT_CATEGORY_ID;
                }

                @Override
                public String getLabel() {
                    return wizard.getDefaultCategoryLabel();
                }

                @Override
                public Set<String> getProjectTemplates() {
                    return defaultCategoryTemplateIds;
                }
            };
            Set<String> projectTemplateSet = defaultCategory.getProjectTemplates();
            ArrayList<IProjectTemplate> sortedTemplates = new ArrayList<IProjectTemplate>();
            for (String ptId : projectTemplateSet) {
                IProjectTemplate pt = manager.getProjectTemplateById(ptId);
                if (pt == null) continue;
                sortedTemplates.add(pt);
                templatesInCategories.put(ptId, pt);
            }
            Collections.sort(sortedTemplates, wizard.getProjectTemplateComparator());
            categoryToTemplateMap.put(defaultCategory, sortedTemplates);
            categories.add(defaultCategory);
        }
        Collections.sort(categories, wizard.getTemplateCategoryComparator());
        ArrayList<IProjectTemplate> objectList = new ArrayList<IProjectTemplate>();
        for (ITemplateCategory templateCategoryDefinition : categories) {
            List templates = (List)categoryToTemplateMap.get(templateCategoryDefinition);
            for (IProjectTemplate projectTemplate : templates) {
                objectList.add(projectTemplate);
            }
        }
        this.listElements = objectList.toArray();
    }

    public void dispose() {
        this.listElements = null;
    }

    public Object[] getElements(Object inputElement) {
        return this.listElements;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

