/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.internal.ui.pages.template;

import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSet;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectTemplate;
import com.ibm.faceted.project.wizard.ui.FacetedProjectWizard;
import com.ibm.faceted.project.wizard.ui.IProjectTemplateUIProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class ProjectTemplateUiManager {
    private final String coreFacetSetTitle;
    private final SelectionListener listener;
    private Map<Button, ICoreFacetSet> templateButtonMap;
    private FacetedProjectWizard wizard;
    private IProjectTemplateUIProvider templateUIProvider;

    ProjectTemplateUiManager(FacetedProjectWizard wizard, SelectionListener listener) {
        this.listener = listener;
        this.wizard = wizard;
        this.coreFacetSetTitle = wizard.getCoreFacetSetHeadingLabel();
        this.templateUIProvider = wizard.getProjectTemplateUIProvider();
    }

    ICoreFacetSet getCoreFacetSet(Button button) {
        return this.templateButtonMap.get(button);
    }

    Composite switchProjectTemplate(Composite parent, IProjectTemplate newTemplate, ICoreFacetSet newCoreFacetSet) {
        if (this.templateButtonMap != null) {
            Set<Button> oldButtons = this.templateButtonMap.keySet();
            for (Button button : oldButtons) {
                button.removeSelectionListener(this.listener);
                button.setSelection(false);
            }
            this.templateButtonMap = null;
        }
        Group templateGroup = new Group(parent, 0);
        templateGroup.setText(newTemplate.getTitle());
        GridLayout gridLayout = new GridLayout(1, false);
        templateGroup.setLayout((Layout)gridLayout);
        Composite templateUIComposite = new Composite((Composite)templateGroup, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        templateUIComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 0;
        templateUIComposite.setLayoutData((Object)gridData);
        this.templateUIProvider.getContent(templateUIComposite, newTemplate, newCoreFacetSet);
        Set<ICoreFacetSet> unsortedCoreFacetSets = this.wizard.getExtensionPointManager().getCoreFacetSetsForTemplate(newTemplate);
        ArrayList<ICoreFacetSet> coreFacetSetsForTemplate = new ArrayList<ICoreFacetSet>(unsortedCoreFacetSets);
        Collections.sort(coreFacetSetsForTemplate, this.wizard.getCoreFacetSetComparator());
        if (coreFacetSetsForTemplate.size() > 1) {
            this.templateButtonMap = new HashMap<Button, ICoreFacetSet>();
            Label programmingModelLabel = new Label((Composite)templateGroup, 0);
            programmingModelLabel.setText(this.coreFacetSetTitle);
            GridData gData = new GridData(16384, 128, true, false);
            programmingModelLabel.setLayoutData((Object)gData);
            ICoreFacetSet defaultModel = coreFacetSetsForTemplate.contains(newCoreFacetSet) ? newCoreFacetSet : (ICoreFacetSet)coreFacetSetsForTemplate.get(0);
            Button defaultButton = null;
            for (ICoreFacetSet programmingModel : coreFacetSetsForTemplate) {
                Button modelButton = new Button((Composite)templateGroup, 16);
                gData = new GridData(16384, 128, true, false);
                gData.horizontalIndent = 10;
                modelButton.setLayoutData((Object)gData);
                modelButton.setText(programmingModel.getDescription());
                modelButton.addSelectionListener(this.listener);
                this.templateButtonMap.put(modelButton, programmingModel);
                if (!programmingModel.equals(defaultModel)) continue;
                defaultButton = modelButton;
            }
            if (defaultButton != null) {
                defaultButton.setSelection(true);
            }
        }
        return templateGroup;
    }
}

