/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.internal.ui.pages.configuration;

import com.ibm.etools.slickui.SlickControlList;
import com.ibm.etools.slickui.validation.IValidationStateChangedListener;
import com.ibm.etools.slickui.validation.ValidationEvent;
import com.ibm.faceted.project.wizard.contributions.configurations.AbstractTemplateConfigurationDelegate;
import com.ibm.faceted.project.wizard.contributions.configurations.ui.slickui.WizardPageSlickControlDescriptor;
import com.ibm.faceted.project.wizard.contributions.configurations.ui.slickui.WizardPageSlickControlProvider;
import com.ibm.faceted.project.wizard.core.serviceability.ServiceablilityUtil;
import com.ibm.faceted.project.wizard.internal.nls.Messages;
import com.ibm.faceted.project.wizard.internal.ui.pages.AbstractWebWizardDataModelWizardPage;
import com.ibm.faceted.project.wizard.internal.ui.pages.configuration.ConfigurationPageProvider;
import com.ibm.faceted.project.wizard.ui.FacetedProjectWizard;
import com.ibm.faceted.project.wizard.ui.FacetedProjectWizardOptions;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;

public class ConfigurationPage
extends AbstractWebWizardDataModelWizardPage
implements IValidationStateChangedListener {
    private SlickControlList slickControlList;
    private String selectedTemplateConfigurationId = null;
    private static ConfigurationPage currentPage;
    private FacetedProjectWizard wizard;
    private AbstractTemplateConfigurationDelegate lastDelegate;
    private static final String CONFIGURATION_PAGE_HELP = "com.ibm.adapter.j2c.codegen.configurationPageHelp";

    public ConfigurationPage(IDataModel model, String pageName, IFacetedProjectWorkingCopy projectFacetWorkingCopy) {
        super(model, pageName, projectFacetWorkingCopy);
        currentPage = this;
    }

    public static void setConfigurationSelection(String configurationId) {
        ConfigurationPage.currentPage.selectedTemplateConfigurationId = configurationId;
        WizardPageSlickControlDescriptor descriptorForTemplateConfiguration = ConfigurationPage.currentPage.wizard.getDescriptorForTemplateConfiguration(configurationId);
        if (descriptorForTemplateConfiguration != null) {
            ConfigurationPage.currentPage.slickControlList.setSelection(descriptorForTemplateConfiguration);
        }
    }

    public Point computeSize() {
        try {
            if (this.isControlCreated()) {
                WizardPageSlickControlDescriptor[] slickControlDescriptors = this.wizard.getSlickControlDescriptors();
                if (slickControlDescriptors != null && slickControlDescriptors.length > 0) {
                    Point oldMaxDescriptorSize = null;
                    Point pageSize = this.getControl().getSize();
                    Point buffer = null;
                    Point newMaxDescriptorSize = new Point(0, 0);
                    WizardPageSlickControlDescriptor[] wizardPageSlickControlDescriptorArray = slickControlDescriptors;
                    int n = slickControlDescriptors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Composite composite;
                        WizardPageSlickControlDescriptor wizardPageSlickControlDescriptor = wizardPageSlickControlDescriptorArray[n2];
                        if (wizardPageSlickControlDescriptor.getControlProvider().shouldShow(this.projectFacetWorkingCopy) && (composite = wizardPageSlickControlDescriptor.getComposite()) != null) {
                            if (oldMaxDescriptorSize == null) {
                                oldMaxDescriptorSize = composite.getParent().getSize();
                                buffer = new Point(pageSize.x - oldMaxDescriptorSize.x, pageSize.y - oldMaxDescriptorSize.y);
                            }
                            Point descSize = composite.computeSize(-1, -1);
                            if (descSize.x > newMaxDescriptorSize.x) {
                                newMaxDescriptorSize.x = descSize.x;
                            }
                            if (descSize.y > newMaxDescriptorSize.y) {
                                newMaxDescriptorSize.y = descSize.y;
                            }
                        }
                        ++n2;
                    }
                    newMaxDescriptorSize.x += buffer.x;
                    newMaxDescriptorSize.y += buffer.y;
                    return newMaxDescriptorSize;
                }
                return this.getControl().getSize();
            }
        }
        catch (Exception e) {
            ServiceablilityUtil.getServiceabilityManager().getLogger().logException(e);
        }
        return new Point(0, 0);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        this.wizard = (FacetedProjectWizard)this.getWizard();
        FacetedProjectWizardOptions projectWizardOptions = this.wizard.getOptions();
        Composite baseComposite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)baseComposite, CONFIGURATION_PAGE_HELP);
        GridData layoutData = new GridData(1808);
        baseComposite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        baseComposite.setLayout((Layout)layout);
        this.slickControlList = new SlickControlList(baseComposite, null, new int[]{30, 70});
        this.slickControlList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigurationPage.this.handleConfigurationDescriptorChanged(event);
            }
        });
        this.slickControlList.setContentProvider(new ConfigurationPageProvider(this.wizard));
        this.slickControlList.setInput(this.projectFacetWorkingCopy);
        if (projectWizardOptions.shouldShowChangeFeaturesButton()) {
            Button addFeaturesButton = new Button(baseComposite, 8);
            addFeaturesButton.setText(Messages.AddFeatures);
            addFeaturesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfigurationPage.this.handleAddFeaturesButtonClicked();
                }
            });
        }
        this.setImageDescriptor(this.wizard.getWizardBannerImageDescriptor());
        this.updateValidationState();
        return baseComposite;
    }

    public void dispose() {
        super.dispose();
        currentPage = null;
    }

    protected void enter() {
        this.wizard.resize(true);
    }

    @Override
    public String[] getValidationPropertyNames() {
        return new String[0];
    }

    private void handleAddFeaturesButtonClicked() {
        this.wizard.launchFacetSelectionDialog();
    }

    private void handleConfigurationDescriptorChanged(SelectionChangedEvent event) {
        WizardPageSlickControlDescriptor selectedDescriptor;
        AbstractTemplateConfigurationDelegate delegate;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (!selection.isEmpty() && !(delegate = (selectedDescriptor = (WizardPageSlickControlDescriptor)selection.getFirstElement()).getConfigurationDelegate()).equals(this.lastDelegate)) {
            if (this.lastDelegate != null && !this.lastDelegate.isDisposed()) {
                this.lastDelegate.exit();
            }
            delegate.enter();
            this.setTitle(selectedDescriptor.getTitle());
            this.setDescription(selectedDescriptor.getDescription());
            this.updateMessage(selectedDescriptor.getControlProvider().getValidationState());
            this.updateValidationState();
            this.lastDelegate = delegate;
        }
    }

    public boolean isPageComplete() {
        if (this.slickControlList == null) {
            return false;
        }
        return super.isPageComplete();
    }

    public void refreshConfigurations() {
        if (this.slickControlList != null && this.wizard != null) {
            WizardPageSlickControlDescriptor descriptorForTemplateConfiguration;
            IStructuredSelection oldSelection = (IStructuredSelection)this.slickControlList.getSelection();
            this.slickControlList.refresh();
            boolean success = false;
            if (this.isCurrentPage() && oldSelection != null && !oldSelection.isEmpty() && (descriptorForTemplateConfiguration = (WizardPageSlickControlDescriptor)oldSelection.getFirstElement()) != null && !descriptorForTemplateConfiguration.isDisposed() && (descriptorForTemplateConfiguration = this.wizard.getDescriptorForTemplateConfiguration(descriptorForTemplateConfiguration.getId())) != null && descriptorForTemplateConfiguration.getControlProvider().shouldShow(this.projectFacetWorkingCopy)) {
                this.slickControlList.setSelection(descriptorForTemplateConfiguration);
                success = true;
            }
            if (!success || !this.isCurrentPage()) {
                WizardPageSlickControlDescriptor[] elements = this.wizard.getSlickControlDescriptors();
                WizardPageSlickControlDescriptor descriptorForTemplateConfiguration2 = this.wizard.getDescriptorForTemplateConfiguration(this.selectedTemplateConfigurationId);
                if (elements != null && elements.length > 0) {
                    if (descriptorForTemplateConfiguration2 != null && descriptorForTemplateConfiguration2.getControlProvider().shouldShow(this.projectFacetWorkingCopy)) {
                        this.slickControlList.setSelection(descriptorForTemplateConfiguration2);
                    } else {
                        WizardPageSlickControlDescriptor firstVisible = null;
                        WizardPageSlickControlDescriptor[] wizardPageSlickControlDescriptorArray = elements;
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            WizardPageSlickControlDescriptor wizardPageSlickControlDescriptor = wizardPageSlickControlDescriptorArray[n2];
                            if (wizardPageSlickControlDescriptor.getControlProvider().shouldShow(this.projectFacetWorkingCopy)) {
                                firstVisible = wizardPageSlickControlDescriptor;
                                break;
                            }
                            ++n2;
                        }
                        if (firstVisible != null) {
                            StructuredSelection selection = new StructuredSelection(firstVisible);
                            this.slickControlList.setSelection((ISelection)selection);
                        }
                    }
                }
            }
        }
        this.updateValidationState();
    }

    public void updateValidationState() {
        boolean pageComplete = true;
        IStatus messageStatus = Status.OK_STATUS;
        if (this.wizard != null && this.wizard.isInitComplete() && this.slickControlList != null) {
            IFacetedProjectWorkingCopy workingCopy = (IFacetedProjectWorkingCopy)this.wizard.getDataModel().getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            IStatus facetState = workingCopy.validate();
            if (facetState.getSeverity() == 4) {
                pageComplete = false;
                messageStatus = new Status(4, "com.ibm.adapter.j2c.codegen", Messages.ConfigurationPage_FeaturesAreNotCompatible);
            } else {
                WizardPageSlickControlProvider controlProvider;
                WizardPageSlickControlDescriptor selectedDescriptor;
                IStatus state = this.slickControlList.getValidationState();
                pageComplete = state.getSeverity() != 4;
                IStructuredSelection selection = (IStructuredSelection)this.slickControlList.getSelection();
                if (!selection.isEmpty() && !(selectedDescriptor = (WizardPageSlickControlDescriptor)selection.getFirstElement()).isDisposed() && (controlProvider = selectedDescriptor.getControlProvider()) != null) {
                    messageStatus = controlProvider.getValidationState();
                }
            }
            this.setPageComplete(pageComplete);
            this.updateMessage(messageStatus);
            this.getContainer().updateButtons();
        }
    }

    @Override
    public void validateStateChanged(ValidationEvent event) {
        if (this.slickControlList != null) {
            this.slickControlList.validateStateChanged(event);
            this.updateValidationState();
        }
    }
}

