/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.internal.ui.categorylist;

import com.ibm.faceted.project.wizard.internal.ui.categorylist.ICategorizedElementFormatProvider;
import com.ibm.faceted.project.wizard.internal.ui.categorylist.ICategorizedSelectorProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public final class DefaultCategorizedElementFormatProvider
implements ICategorizedElementFormatProvider {
    private ICategorizedSelectorProvider selectorProvider = null;
    private Font defaultBoldSystemFont;
    private final boolean IS_RUNNING_MAC = Platform.getOS().equals("macosx");

    public DefaultCategorizedElementFormatProvider() {
        FontData currentFontData = Display.getCurrent().getSystemFont().getFontData()[0];
        this.defaultBoldSystemFont = new Font(null, currentFontData.getName(), currentFontData.getHeight(), currentFontData.getStyle() | 1);
    }

    @Override
    public void dispose() {
        this.defaultBoldSystemFont.dispose();
        this.defaultBoldSystemFont = null;
        this.selectorProvider = null;
    }

    @Override
    public Font getFont(Object element) {
        if (this.selectorProvider != null) {
            if (this.selectorProvider.isSelectable(element)) {
                return Display.getCurrent().getSystemFont();
            }
            return this.defaultBoldSystemFont;
        }
        return Display.getCurrent().getSystemFont();
    }

    @Override
    public Color getSelectedAndFocusedFirstBackgroundColor(Object element) {
        if (this.selectorProvider != null && this.selectorProvider.isSelectable(element)) {
            if (this.IS_RUNNING_MAC) {
                return Display.getCurrent().getSystemColor(31);
            }
            return Display.getCurrent().getSystemColor(26);
        }
        return Display.getCurrent().getSystemColor(26);
    }

    @Override
    public Color getSelectedAndFocusedForegroundColor(Object element) {
        if (this.selectorProvider != null && this.selectorProvider.isSelectable(element)) {
            if (this.IS_RUNNING_MAC) {
                return Display.getCurrent().getSystemColor(25);
            }
            return Display.getCurrent().getSystemColor(27);
        }
        return Display.getCurrent().getSystemColor(27);
    }

    @Override
    public Color getSelectedAndFocusedSecondBackgroundColor(Object element) {
        if (this.selectorProvider != null && this.selectorProvider.isSelectable(element)) {
            if (this.IS_RUNNING_MAC) {
                return Display.getCurrent().getSystemColor(31);
            }
            return Display.getCurrent().getSystemColor(26);
        }
        return Display.getCurrent().getSystemColor(26);
    }

    @Override
    public Color getSelectedAndUnfocusedFirstBackgroundColor(Object element) {
        if (this.selectorProvider != null && this.selectorProvider.isSelectable(element)) {
            return Display.getCurrent().getSystemColor(22);
        }
        return Display.getCurrent().getSystemColor(22);
    }

    @Override
    public Color getSelectedAndUnfocusedForegroundColor(Object element) {
        if (this.selectorProvider != null && this.selectorProvider.isSelectable(element)) {
            return Display.getCurrent().getSystemColor(21);
        }
        return Display.getCurrent().getSystemColor(21);
    }

    @Override
    public Color getSelectedAndUnfocusedSecondBackgroundColor(Object element) {
        if (this.selectorProvider != null && this.selectorProvider.isSelectable(element)) {
            return Display.getCurrent().getSystemColor(22);
        }
        return Display.getCurrent().getSystemColor(22);
    }

    public ICategorizedSelectorProvider getSelectorProvider() {
        return this.selectorProvider;
    }

    @Override
    public Color getStandardFirstBackgroundColor(Object element) {
        if (this.selectorProvider != null) {
            if (this.selectorProvider.isSelectable(element)) {
                return Display.getCurrent().getSystemColor(25);
            }
            return Display.getCurrent().getSystemColor(25);
        }
        return Display.getCurrent().getSystemColor(25);
    }

    @Override
    public Color getStandardForegroundColor(Object element) {
        if (this.selectorProvider != null) {
            if (this.selectorProvider.isSelectable(element)) {
                return Display.getCurrent().getSystemColor(24);
            }
            return Display.getCurrent().getSystemColor(21);
        }
        return Display.getCurrent().getSystemColor(24);
    }

    @Override
    public Color getStandardSecondBackgroundColor(Object element) {
        if (this.selectorProvider != null) {
            if (this.selectorProvider.isSelectable(element)) {
                return Display.getCurrent().getSystemColor(25);
            }
            return Display.getCurrent().getSystemColor(22);
        }
        return Display.getCurrent().getSystemColor(25);
    }

    public void setSelectorProvider(ICategorizedSelectorProvider selectorProvider) {
        this.selectorProvider = selectorProvider;
    }

    @Override
    public boolean useVerticalGradientForSelectedBackground(Object element) {
        if (this.selectorProvider != null) {
            if (this.selectorProvider.isSelectable(element)) {
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean useVerticalGradientForStandardBackground(Object element) {
        if (this.selectorProvider != null) {
            return !this.selectorProvider.isSelectable(element);
        }
        return false;
    }
}

