/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.internal.management.extensionpts;

import com.ibm.faceted.project.wizard.contributions.configurations.AbstractTemplateConfigurationDelegate;
import com.ibm.faceted.project.wizard.contributions.configurations.DefaultDataModelBasedWizardPageConfigurationDelegate;
import com.ibm.faceted.project.wizard.contributions.template.AbstractProjectTemplateDelegate;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.ConfigurationDelegateDefinition;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.ProjectTemplateDefinition;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IConfigurationDelegate;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectTemplate;
import com.ibm.faceted.project.wizard.core.serviceability.Logger;
import com.ibm.faceted.project.wizard.core.serviceability.ServiceablilityUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;

public class DelegateUtil {
    private static Logger logger = ServiceablilityUtil.getServiceabilityManager().getLogger();

    public static AbstractTemplateConfigurationDelegate createConfigurationDelegateClass(IConfigurationDelegate configurationDelegate) {
        ConfigurationDelegateDefinition configurationExtension = (ConfigurationDelegateDefinition)configurationDelegate;
        AbstractTemplateConfigurationDelegate delegate = null;
        if (configurationExtension.isWizardConfigration() && configurationExtension.getDelegateClassName() == null) {
            return new DefaultDataModelBasedWizardPageConfigurationDelegate();
        }
        IConfigurationElement delegateElement = configurationExtension.getDelegateElement();
        if (delegateElement != null) {
            try {
                delegate = (AbstractTemplateConfigurationDelegate)delegateElement.createExecutableExtension("class");
                delegate.setConfigurationElement(configurationExtension.getConfigurationElement());
            }
            catch (CoreException e) {
                String message = "Failed to create configuration delegate\n\n";
                message = String.valueOf(message) + "Responsible plug-in:  " + configurationExtension.getConfigurationElement().getNamespaceIdentifier() + "\n";
                message = String.valueOf(message) + "Responsible class:  " + configurationExtension.getDelegateClassName() + "\n";
                logger.logContributorError(configurationDelegate, message, (Exception)((Object)e));
                configurationExtension.invalidate();
            }
        }
        return delegate;
    }

    public static IFacetWizardPage createConfigurationDelegateOverrideClass(IConfigurationDelegate configurationDelegate) {
        IConfigurationElement delegateElement;
        ConfigurationDelegateDefinition configurationExtension = (ConfigurationDelegateDefinition)configurationDelegate;
        IFacetWizardPage overridePage = null;
        if (configurationExtension.hasOverrideWizardClass() && (delegateElement = configurationExtension.getDelegateElement()) != null) {
            try {
                overridePage = (IFacetWizardPage)delegateElement.createExecutableExtension("wizardOverrideClass");
            }
            catch (CoreException e) {
                String message = "Failed to create configuration delegate override wizard class\n\n";
                message = String.valueOf(message) + "Responsible plug-in:  " + configurationExtension.getConfigurationElement().getNamespaceIdentifier() + "\n";
                message = String.valueOf(message) + "Responsible class:  " + configurationExtension.getOverrideWizardClassName() + "\n";
                logger.logContributorError(configurationDelegate, message, (Exception)((Object)e));
                configurationExtension.invalidate();
            }
        }
        return overridePage;
    }

    public static AbstractProjectTemplateDelegate createProjectTemplateDelegate(IProjectTemplate projectTemplate) {
        ProjectTemplateDefinition projectTemplateDefinition = (ProjectTemplateDefinition)projectTemplate;
        AbstractProjectTemplateDelegate delegate = null;
        IConfigurationElement delegateElement = projectTemplateDefinition.getDelegateElement();
        if (delegateElement != null) {
            try {
                delegate = (AbstractProjectTemplateDelegate)delegateElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                String message = "Failed to create project template delegate class\n\n";
                message = String.valueOf(message) + "Responsible plug-in:  " + projectTemplateDefinition.getConfigurationElement().getNamespaceIdentifier() + "\n";
                message = String.valueOf(message) + "Responsible class:  " + projectTemplateDefinition.getDelegateClassName() + "\n";
                logger.logContributorError(projectTemplate, message, (Exception)((Object)e));
                projectTemplateDefinition.invalidate("Delegate defined by class cannot be created.");
            }
        }
        return delegate;
    }
}

