/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.serviceability;

import com.ibm.faceted.project.wizard.core.serviceability.Debugger;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;

public class Tracer {
    private final String pluginId;
    private DebugTrace debugTrace;
    private final Debugger debugger;

    Tracer(String pluginId, Debugger debugger) {
        this.pluginId = pluginId;
        this.debugger = debugger;
    }

    public boolean isEnabled() {
        return TraceType.TRACE.isEnabled();
    }

    void optionsChanged(DebugOptions options) {
        this.debugTrace = options.newDebugTrace(this.pluginId, this.getClass());
        TraceType[] traceTypeArray = TraceType.values();
        int n = traceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceType type = traceTypeArray[n2];
            boolean enabled = options.getBooleanOption(String.valueOf(this.pluginId) + type.getTypeId(), false);
            type.setEnabled(enabled);
            ++n2;
        }
    }

    public void trace(TraceType type, String message) {
        if (!this.isEnabled() || type == TraceType.TRACE) {
            return;
        }
        this.debugTrace.trace(type.getTypeId(), message);
        if (TraceType.TRACE_CONSOLE.isEnabled()) {
            this.debugger.debug(Debugger.DebugType.DEBUG, message);
        }
    }

    public static enum TraceType {
        TRACE("/trace"),
        TRACE_CONSOLE("/trace/console"),
        WIZARD("/trace/wizard"),
        CONFIGURATION("/trace/wizard/configuration"),
        GLOBAL_EXTENSION_POINT("/trace/extension/global"),
        WIZARD_EXTENSION_POINT("/trace/extension/wizard");

        private String typeId;
        private boolean enabled;

        private TraceType(String typeId) {
            this.typeId = typeId;
            this.enabled = false;
        }

        public String getTypeId() {
            return this.typeId;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

