/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.management;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;

public class RuntimeComparator
implements Comparator<IRuntime> {
    private static final String ID = "id";
    private static final List<String> preferredRuntimeOrder = new ArrayList<String>();

    static {
        preferredRuntimeOrder.add("com.ibm.websphere.runtime");
        preferredRuntimeOrder.add("was.base");
        preferredRuntimeOrder.add("Web Preview Server Runtime");
        preferredRuntimeOrder.add("AJAX Test Server Runtime");
        preferredRuntimeOrder.add("wps.base");
    }

    @Override
    public int compare(IRuntime runtime1, IRuntime runtime2) {
        Integer weight2;
        Integer weight1 = this.getRuntimeWeight(runtime1);
        if (weight1 != (weight2 = Integer.valueOf(this.getRuntimeWeight(runtime2)))) {
            return weight1.compareTo(weight2);
        }
        IRuntimeComponentVersion runtime1Version = this.getRuntimeVersion(runtime1);
        IRuntimeComponentVersion runtime2Version = this.getRuntimeVersion(runtime2);
        if (runtime1Version != null && runtime2Version != null) {
            return -runtime1Version.compareTo((Object)runtime2Version);
        }
        if (runtime1Version == null) {
            return -1;
        }
        if (runtime2Version == null) {
            return 1;
        }
        return 0;
    }

    private IRuntimeComponentVersion getRuntimeVersion(IRuntime runtime) {
        String runtimeId = runtime.getProperty(ID);
        IRuntimeComponentVersion result = null;
        if (runtimeId != null) {
            List runtimeComponents = runtime.getRuntimeComponents();
            for (IRuntimeComponent tempComponent : runtimeComponents) {
                String tempId = tempComponent.getProperty(ID);
                if (!runtimeId.equals(tempId)) continue;
                result = tempComponent.getRuntimeComponentVersion();
            }
        }
        return result;
    }

    private int getRuntimeWeight(IRuntime runtime) {
        int index = Integer.MAX_VALUE;
        String runtimeId = runtime.getProperty(ID);
        if (runtimeId != null) {
            int i = 0;
            while (i < preferredRuntimeOrder.size()) {
                String tempRuntimeId = preferredRuntimeOrder.get(i);
                if (runtimeId.startsWith(tempRuntimeId)) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }
}

