/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.management;

import com.ibm.faceted.project.wizard.core.management.ProjectFacetVersionInfo;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSet;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectTemplate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class ProjectConfiguration {
    private final Set<ProjectFacetVersionInfo> projectFacetVersionInfos = new HashSet<ProjectFacetVersionInfo>();
    private Set<IProjectFacet> fixedProjectFacets;
    private Map<String, IProjectFacet> projectFacetIdMap;
    private Set<IProjectFacetVersion> projectFacetVersions;
    private Map<IProjectFacetVersion, ProjectFacetVersionInfo> projectFacetVersionsMap;
    private Map<IProjectFacet, ProjectFacetVersionInfo> projectFacetMap;
    private Set<IProjectFacetVersion> userAddedFacets;
    private boolean isRuntimeDirty = false;
    private boolean isProjectFacetVersionsDirty = false;
    private boolean isFixedFacetsDirty = false;
    private IRuntime runtime;
    private Map<ICoreFacetSet, IRuntime> programmingModelToDefaultRuntimeMap = new HashMap<ICoreFacetSet, IRuntime>();

    public IStatus addFacetVersion(IProjectFacetVersion facetVersion, IProjectTemplate projectTemplate, ICoreFacetSet programmingModel) {
        IStatus result = Status.OK_STATUS;
        if (facetVersion == null) {
            return new Status(4, "com.ibm.adapter.j2c.codegen", "IProjectFacetVersion was null.  Request ignored.");
        }
        ProjectFacetVersionInfo info = this.getProjectFacetVersionInfo(facetVersion);
        if (info == null) {
            info = new ProjectFacetVersionInfo(facetVersion, projectTemplate, programmingModel);
            this.projectFacetVersionInfos.add(info);
            this.isProjectFacetVersionsDirty = true;
            this.clearDependentCache();
        }
        return result;
    }

    public IStatus changeFacetVersion(IProjectFacetVersion facetVersion, IProjectTemplate projectTemplate, ICoreFacetSet programmingModel) {
        IStatus result = Status.OK_STATUS;
        if (facetVersion == null) {
            return new Status(4, "com.ibm.adapter.j2c.codegen", "IProjectFacetVersion was null.  Request ignored.");
        }
        ProjectFacetVersionInfo info = this.getProjectFacetVersionInfo(facetVersion.getProjectFacet());
        if (info != null) {
            boolean fixedFacet = info.isFixedFacet();
            if (this.projectFacetVersionInfos.remove(info)) {
                info = new ProjectFacetVersionInfo(facetVersion, projectTemplate, programmingModel);
                info.setFixedFacet(fixedFacet);
                this.projectFacetVersionInfos.add(info);
                this.isProjectFacetVersionsDirty = true;
                this.clearDependentCache();
            }
        }
        return result;
    }

    public void clean() {
        this.isRuntimeDirty = false;
        this.isFixedFacetsDirty = false;
        this.isProjectFacetVersionsDirty = false;
    }

    private void clearDependentCache() {
        this.fixedProjectFacets = null;
        this.projectFacetIdMap = null;
        this.projectFacetVersions = null;
        this.projectFacetVersionsMap = null;
        this.projectFacetMap = null;
        this.userAddedFacets = null;
    }

    public IRuntime getDefaultRuntime(ICoreFacetSet programmingModel) {
        return this.programmingModelToDefaultRuntimeMap.get(programmingModel);
    }

    public Set<IProjectFacet> getFixedProjectFacets() {
        if (this.fixedProjectFacets == null) {
            this.fixedProjectFacets = new HashSet<IProjectFacet>();
            for (ProjectFacetVersionInfo info : this.projectFacetVersionInfos) {
                if (!info.isFixedFacet()) continue;
                this.fixedProjectFacets.add(info.getProjectFacet());
            }
            this.fixedProjectFacets = Collections.unmodifiableSet(this.fixedProjectFacets);
        }
        return this.fixedProjectFacets;
    }

    public IProjectFacet getProjectFacetById(String facetId) {
        if (this.projectFacetIdMap == null) {
            this.initProjectFacetVersionCaches();
        }
        return this.projectFacetIdMap.get(facetId);
    }

    private ProjectFacetVersionInfo getProjectFacetVersionInfo(IProjectFacet projectFacet) {
        if (this.projectFacetMap == null) {
            this.initProjectFacetVersionCaches();
        }
        return this.projectFacetMap.get(projectFacet);
    }

    private ProjectFacetVersionInfo getProjectFacetVersionInfo(IProjectFacetVersion facetVersion) {
        if (this.projectFacetVersionsMap == null) {
            this.initProjectFacetVersionCaches();
        }
        return this.projectFacetVersionsMap.get(facetVersion);
    }

    public Set<IProjectFacetVersion> getProjectFacetVersions() {
        if (this.projectFacetVersions == null) {
            this.initProjectFacetVersionCaches();
        }
        return this.projectFacetVersions;
    }

    public IRuntime getRuntime() {
        return this.runtime;
    }

    public Set<IProjectFacetVersion> getUserAddedFacets() {
        if (this.userAddedFacets == null) {
            this.initProjectFacetVersionCaches();
        }
        return this.userAddedFacets;
    }

    public boolean hasFacet(String facetId) {
        if (facetId == null || facetId.isEmpty()) {
            return false;
        }
        return this.getProjectFacetById(facetId) != null;
    }

    public boolean hasFacetVersion(IProjectFacetVersion facetVersion) {
        if (facetVersion == null) {
            return false;
        }
        ProjectFacetVersionInfo info = this.getProjectFacetVersionInfo(facetVersion);
        return info != null;
    }

    private void initProjectFacetVersionCaches() {
        this.projectFacetVersions = new HashSet<IProjectFacetVersion>();
        this.projectFacetVersionsMap = new HashMap<IProjectFacetVersion, ProjectFacetVersionInfo>();
        this.projectFacetMap = new HashMap<IProjectFacet, ProjectFacetVersionInfo>();
        this.projectFacetIdMap = new HashMap<String, IProjectFacet>();
        this.userAddedFacets = new HashSet<IProjectFacetVersion>();
        for (ProjectFacetVersionInfo info : this.projectFacetVersionInfos) {
            IProjectFacetVersion projectFacetVersion = info.getProjectFacetVersion();
            this.projectFacetVersionsMap.put(projectFacetVersion, info);
            this.projectFacetVersions.add(projectFacetVersion);
            if (!info.isBaseFacet()) {
                this.userAddedFacets.add(projectFacetVersion);
            }
            IProjectFacet projectFacet = info.getProjectFacet();
            this.projectFacetMap.put(projectFacet, info);
            this.projectFacetIdMap.put(projectFacet.getId(), projectFacet);
        }
        this.projectFacetVersions = Collections.unmodifiableSet(this.projectFacetVersions);
        this.userAddedFacets = Collections.unmodifiableSet(this.userAddedFacets);
    }

    public boolean isDirty() {
        return this.isFixedFacetsDirty || this.isProjectFacetVersionsDirty || this.isRuntimeDirty;
    }

    public boolean isFixedFacetsDirty() {
        return this.isFixedFacetsDirty;
    }

    public boolean isProjectFacetVersionsDirty() {
        return this.isProjectFacetVersionsDirty;
    }

    public boolean isRuntimeDirty() {
        return this.isRuntimeDirty;
    }

    public IStatus removeFacet(String facetId) {
        ProjectFacetVersionInfo info;
        Status result = new Status(4, "com.ibm.adapter.j2c.codegen", "Facet not present on project so it cannot be removed: " + facetId);
        if (facetId == null || facetId.isEmpty()) {
            return new Status(4, "com.ibm.adapter.j2c.codegen", "facetId was null or empty string.  Request ignored.");
        }
        IProjectFacet projectFacet = this.getProjectFacetById(facetId);
        if (projectFacet != null && (info = this.getProjectFacetVersionInfo(projectFacet)) != null) {
            IProjectFacetVersion projectFacetVersion = info.getProjectFacetVersion();
            result = this.removeFacetVersion(projectFacetVersion);
        }
        return result;
    }

    private IStatus removeFacetVersion(IProjectFacetVersion facetVersion) {
        IStatus result = Status.OK_STATUS;
        if (facetVersion == null) {
            return new Status(4, "com.ibm.adapter.j2c.codegen", "IProjectFacetVersion was null.  Request ignored.");
        }
        ProjectFacetVersionInfo info = this.getProjectFacetVersionInfo(facetVersion.getProjectFacet());
        if (info != null) {
            if (!info.isBaseFacet()) {
                if (this.projectFacetVersionInfos.remove(info)) {
                    this.isProjectFacetVersionsDirty = true;
                    if (info.isFixedFacet()) {
                        this.isFixedFacetsDirty = true;
                    }
                    this.clearDependentCache();
                }
            } else {
                result = new Status(4, "com.ibm.adapter.j2c.codegen", "Base facets cannot be removed from project using this method." + facetVersion.getProjectFacet().getId());
            }
        }
        return result;
    }

    public void setDefaultRuntime(ICoreFacetSet programmingModel, IRuntime defaultRuntime) {
        if (programmingModel != null) {
            this.programmingModelToDefaultRuntimeMap.put(programmingModel, defaultRuntime);
        }
    }

    public void setFixedFacets(Set<IProjectFacet> newFixedProjectFacets) {
        if (newFixedProjectFacets != null && !newFixedProjectFacets.isEmpty()) {
            Set<IProjectFacet> oldFixedFacets = this.getFixedProjectFacets();
            this.fixedProjectFacets = new HashSet<IProjectFacet>();
            for (ProjectFacetVersionInfo info : this.projectFacetVersionInfos) {
                IProjectFacet projectFacet = info.getProjectFacet();
                if (!info.isBaseFacet() && !newFixedProjectFacets.contains(projectFacet)) continue;
                info.setFixedFacet(true);
                this.fixedProjectFacets.add(projectFacet);
            }
            if (oldFixedFacets.size() != this.fixedProjectFacets.size() || oldFixedFacets.size() != newFixedProjectFacets.size()) {
                this.isFixedFacetsDirty = true;
            } else if (!oldFixedFacets.containsAll(this.fixedProjectFacets) || !this.fixedProjectFacets.containsAll(oldFixedFacets)) {
                this.isFixedFacetsDirty = true;
            }
        } else {
            this.isFixedFacetsDirty = true;
        }
    }

    public void setProjectFacetVersions(Set<IProjectFacetVersion> newProjectFacetVersions, IProjectTemplate newProjectTemplate, ICoreFacetSet newProgrammingModel) {
        HashSet<ProjectFacetVersionInfo> toRemove = new HashSet<ProjectFacetVersionInfo>();
        HashSet<ProjectFacetVersionInfo> toAdd = new HashSet<ProjectFacetVersionInfo>();
        for (ProjectFacetVersionInfo info : this.projectFacetVersionInfos) {
            IProjectFacetVersion oldIProjectFacetVersion = info.getProjectFacetVersion();
            if (!newProjectFacetVersions.contains(oldIProjectFacetVersion)) {
                toRemove.add(info);
                continue;
            }
            info.setProjectTemplate(newProjectTemplate);
            info.setProgrammingModel(newProgrammingModel);
        }
        for (IProjectFacetVersion projectFacetVersion : newProjectFacetVersions) {
            if (this.hasFacetVersion(projectFacetVersion)) continue;
            ProjectFacetVersionInfo info = new ProjectFacetVersionInfo(projectFacetVersion, newProjectTemplate, newProgrammingModel);
            toAdd.add(info);
        }
        if (!toRemove.isEmpty() || !toAdd.isEmpty()) {
            this.isProjectFacetVersionsDirty = true;
        }
        Set<IProjectFacet> oldFixedFacets = this.getFixedProjectFacets();
        this.projectFacetVersionInfos.removeAll(toRemove);
        this.projectFacetVersionInfos.addAll(toAdd);
        this.clearDependentCache();
        Set<IProjectFacet> newFixedFacets = this.getFixedProjectFacets();
        if (oldFixedFacets.size() != newFixedFacets.size()) {
            this.isFixedFacetsDirty = true;
        } else if (!oldFixedFacets.containsAll(newFixedFacets) || !newFixedFacets.containsAll(oldFixedFacets)) {
            this.isFixedFacetsDirty = true;
        }
    }

    public void setRuntime(IRuntime newRuntime) {
        this.runtime = newRuntime;
        this.isRuntimeDirty = true;
    }

    public IStatus validateAddFacetVersion(IProjectFacetVersion facetVersion) {
        IStatus result = Status.OK_STATUS;
        if (facetVersion == null) {
            return new Status(4, "com.ibm.adapter.j2c.codegen", "IProjectFacetVersion was null.  Request ignored.");
        }
        ProjectFacetVersionInfo info = this.getProjectFacetVersionInfo(facetVersion);
        if (info == null) {
            HashSet<IFacetedProject.Action> actionSet = new HashSet<IFacetedProject.Action>();
            actionSet.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, facetVersion, null));
            result = ProjectFacetsManager.check(this.getProjectFacetVersions(), actionSet);
        }
        return result;
    }

    public IStatus validateChangeFacetVersion(IProjectFacetVersion facetVersion) {
        IStatus result = Status.OK_STATUS;
        if (facetVersion == null) {
            return new Status(4, "com.ibm.adapter.j2c.codegen", "IProjectFacetVersion was null.  Request ignored.");
        }
        ProjectFacetVersionInfo info = this.getProjectFacetVersionInfo(facetVersion.getProjectFacet());
        if (info != null) {
            HashSet<IFacetedProject.Action> actionSet = new HashSet<IFacetedProject.Action>();
            actionSet.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, facetVersion, null));
            HashSet<IProjectFacetVersion> newVersionSet = new HashSet<IProjectFacetVersion>(this.getProjectFacetVersions());
            newVersionSet.remove(info.getProjectFacetVersion());
            result = ProjectFacetsManager.check(newVersionSet, actionSet);
        } else {
            result = new Status(4, "com.ibm.adapter.j2c.codegen", "Facet not present on project so it cannot be changed: " + facetVersion.getProjectFacet().getId());
        }
        return result;
    }

    public IStatus validateRemoveFacet(String facetId) {
        ProjectFacetVersionInfo info;
        Status result = new Status(4, "com.ibm.adapter.j2c.codegen", "Facet not present on project so it cannot be removed: " + facetId);
        if (facetId == null || facetId.isEmpty()) {
            return new Status(4, "com.ibm.adapter.j2c.codegen", "facetId was null or empty string.  Request ignored.");
        }
        IProjectFacet projectFacet = this.getProjectFacetById(facetId);
        if (projectFacet != null && (info = this.getProjectFacetVersionInfo(projectFacet)) != null) {
            IProjectFacetVersion projectFacetVersion = info.getProjectFacetVersion();
            result = this.validateRemoveFacetVersion(projectFacetVersion);
        }
        return result;
    }

    private IStatus validateRemoveFacetVersion(IProjectFacetVersion projectFacetVersion) {
        IStatus result = Status.OK_STATUS;
        if (projectFacetVersion == null) {
            return new Status(4, "com.ibm.adapter.j2c.codegen", "IProjectFacetVersion was null.  Request ignored.");
        }
        ProjectFacetVersionInfo info = this.getProjectFacetVersionInfo(projectFacetVersion.getProjectFacet());
        if (info != null) {
            if (!info.isBaseFacet()) {
                HashSet<IFacetedProject.Action> actionSet = new HashSet<IFacetedProject.Action>();
                actionSet.add(new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, info.getProjectFacetVersion(), null));
                result = ProjectFacetsManager.check(this.getProjectFacetVersions(), actionSet);
            } else {
                result = new Status(4, "com.ibm.adapter.j2c.codegen", "Base facets cannot be removed from project using this method." + projectFacetVersion.getProjectFacet().getId());
            }
        }
        return result;
    }
}

