/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.internal.util;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class WebProjectFacetUtil {
    public static IProjectFacet getProjectFacet(String facet_id) {
        if (ProjectFacetsManager.isProjectFacetDefined((String)facet_id)) {
            return ProjectFacetsManager.getProjectFacet((String)facet_id);
        }
        return null;
    }

    public static IProjectFacetVersion getProjectFacetVersion(String facet_id, String version) {
        block4: {
            try {
                if (!ProjectFacetsManager.isProjectFacetDefined((String)facet_id)) break block4;
                IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)facet_id);
                if (version != null && !version.isEmpty()) {
                    IProjectFacetVersion pfv;
                    if (projectFacet.hasVersion(version) && (pfv = projectFacet.getVersion(version)) != null) {
                        return pfv;
                    }
                    break block4;
                }
                return projectFacet.getDefaultVersion();
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static boolean hasProjectFacet(IFacetedProjectWorkingCopy fpwc, String facet_id) {
        IProjectFacet pf = WebProjectFacetUtil.getProjectFacet(facet_id);
        if (pf == null) {
            return false;
        }
        return fpwc.hasProjectFacet(pf);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasProjectFacetVersions(IFacetedProjectWorkingCopy fpwc, String facet_id, String version_expression) {
        IProjectFacet pf = WebProjectFacetUtil.getProjectFacet(facet_id);
        if (pf == null) {
            return false;
        }
        try {
            IProjectFacetVersion pfv;
            Set pfvs = pf.getVersions(version_expression);
            Iterator iterator = pfvs.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (fpwc.hasProjectFacet(pfv = (IProjectFacetVersion)iterator.next()));
            return false;
        }
        catch (Throwable throwable) {}
        return true;
    }

    public static boolean statusAreEqual(IStatus status1, IStatus status2) {
        boolean equal = true;
        if (status1.getSeverity() != status2.getSeverity()) {
            equal = false;
        } else if (!status1.isOK()) {
            String statusMessage = status1.getMessage();
            String newStatusMessage = status2.getMessage();
            equal = statusMessage == null && newStatusMessage == null ? true : (statusMessage != null && newStatusMessage != null ? statusMessage.equals(newStatusMessage) : false);
        }
        return equal;
    }
}

