/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.internal.management.extensionpts;

import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.ExtensionPointUtil;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.FacetRangeDefinition;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.GlobalExtensionPointManager;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IFacetRange;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectTemplate;
import com.ibm.faceted.project.wizard.core.serviceability.Logger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;

public final class ProjectTemplateDefinition
implements IProjectTemplate {
    private String defaultConfiguration;
    private Set<IFacetRange> templateFacetPresets;
    private boolean isValid;
    private final IConfigurationElement configurationElement;
    private String delegateClassName;
    private IConfigurationElement delegateElement;
    private String smallIcon;
    private String title;
    private String description;
    private String id;
    private GlobalExtensionPointManager globalExtensionPointManager;
    private static final Logger logger = ExtensionPointUtil.getServiceabilityManager().getLogger();
    private Set<IFacetRange> programmingModelFacetPresets;

    ProjectTemplateDefinition(GlobalExtensionPointManager globalExtensionPointManager, IConfigurationElement configurationElement) {
        IConfigurationElement[] delegates;
        this.configurationElement = configurationElement;
        this.globalExtensionPointManager = globalExtensionPointManager;
        this.isValid = true;
        this.defaultConfiguration = configurationElement.getAttribute("defaultConfiguration");
        if (this.defaultConfiguration != null && this.defaultConfiguration.isEmpty()) {
            this.defaultConfiguration = null;
        }
        if ((delegates = configurationElement.getChildren("templateDelegate")) != null && delegates.length > 0) {
            this.delegateElement = delegates[0];
        }
        if (this.getId() == null || this.getId().isEmpty()) {
            this.invalidate("Id is not defined.");
        }
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    @Override
    public String getContributingPluginId() {
        return this.configurationElement.getNamespaceIdentifier();
    }

    @Override
    public Set<IFacetRange> getCoreFacetSetFacetPresets() {
        return this.programmingModelFacetPresets;
    }

    @Override
    public String getDefaultConfigurationId() {
        return this.defaultConfiguration;
    }

    @Override
    public String getDelegateClassName() {
        if (this.delegateClassName == null) {
            this.delegateElement = this.getDelegateElement();
            if (this.delegateElement != null) {
                this.delegateClassName = this.delegateElement.getAttribute("class");
            }
        }
        return this.delegateClassName;
    }

    public IConfigurationElement getDelegateElement() {
        return this.delegateElement;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = this.configurationElement.getAttribute("description");
        }
        return this.description;
    }

    String getExtensionPoint() {
        return "com.ibm.adapter.j2c.codegen.projectTemplate";
    }

    @Override
    public String getExtensionPointId() {
        return "com.ibm.adapter.j2c.codegen.projectTemplate";
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = this.configurationElement.getAttribute("id");
        }
        return this.id;
    }

    @Override
    public String getSmallIcon() {
        if (this.smallIcon == null) {
            this.smallIcon = this.configurationElement.getAttribute("smallIcon");
        }
        return this.smallIcon;
    }

    @Override
    public Set<IFacetRange> getTemplateFacetPresets() {
        return this.templateFacetPresets;
    }

    @Override
    public String getTitle() {
        if (this.title == null) {
            this.title = this.configurationElement.getAttribute("title");
        }
        return this.title;
    }

    void initializeFacetPresets() {
        IConfigurationElement[] presets;
        this.templateFacetPresets = new HashSet<IFacetRange>();
        this.programmingModelFacetPresets = new HashSet<IFacetRange>();
        if (this.isValid && (presets = this.configurationElement.getChildren("presets")) != null && presets.length > 0) {
            IConfigurationElement[] facets;
            IConfigurationElement preset = presets[0];
            IConfigurationElement[] iConfigurationElementArray = facets = preset.getChildren("facet");
            int n = facets.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement facetElement = iConfigurationElementArray[n2];
                FacetRangeDefinition facet = new FacetRangeDefinition(facetElement);
                if (this.globalExtensionPointManager.isFacetInProjectTemplateCoreFacetSet(this.getId(), facet)) {
                    if (facet.isValid()) {
                        this.programmingModelFacetPresets.add(facet);
                    } else if (facet.isDefined()) {
                        this.invalidate("Facet definition in template is not valid: " + facet.getId());
                    }
                } else if (!this.templateFacetPresets.contains(facet)) {
                    if (facet.isValid()) {
                        this.templateFacetPresets.add(facet);
                    } else {
                        this.invalidate("Facet definition in template is not valid: " + facet.getId());
                    }
                }
                ++n2;
            }
        }
        this.programmingModelFacetPresets = Collections.unmodifiableSet(this.programmingModelFacetPresets);
        this.templateFacetPresets = Collections.unmodifiableSet(this.templateFacetPresets);
    }

    public void invalidate(String message) {
        if (this.isValid) {
            String errorMessage = NLS.bind((String)"Removing project template {0} because it was not valid by definition of the extension point.\nProblem Description: {1}", (Object)(this.getId() != null ? this.getId() : "<No ID>"), (Object)message);
            logger.logContributorError(this, errorMessage);
            this.isValid = false;
        }
    }

    boolean isValid() {
        return this.isValid;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append(":  ");
        buffer.append(this.getId());
        buffer.append(" [");
        buffer.append("delegate class: ");
        buffer.append(this.getDelegateClassName());
        buffer.append("]");
        return buffer.toString();
    }
}

