/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.internal.management.extensionpts;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.IExtensionPointConstants;
import com.ibm.faceted.project.wizard.core.serviceability.ServiceabilityManager;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ExtensionPointUtil
implements IExtensionPointConstants {
    private static final ServiceabilityManager serviceabilityManager = CodegenPlugin.getDefault().getServiceabilityManager();

    static ServiceabilityManager getServiceabilityManager() {
        return serviceabilityManager;
    }

    private static Expression getEnablementExpression(IConfigurationElement element) {
        Expression exp = null;
        try {
            if (element != null) {
                exp = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), element);
            }
        }
        catch (CoreException e) {
            serviceabilityManager.getLogger().logException((Exception)((Object)e));
        }
        return exp;
    }

    static IExtension[] getExtensions(String extensionPointID) {
        IExtension[] extensions = null;
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extRegistry.getExtensionPoint(extensionPointID);
        if (extPoint != null) {
            extensions = extPoint.getExtensions();
        } else {
            serviceabilityManager.getLogger().logError("Extension point not defined:" + extensionPointID);
        }
        return extensions;
    }

    static boolean isConfigurationElementEnabled(IConfigurationElement configurationElement, Object contextObject) {
        boolean enabled = true;
        IConfigurationElement[] enablements = configurationElement.getChildren("enablement");
        if (enablements != null && enablements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = enablements;
            int n = enablements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement enablement = iConfigurationElementArray[n2];
                Expression expression = ExtensionPointUtil.getEnablementExpression(enablement);
                if (expression != null && contextObject != null) {
                    EvaluationContext econtext = new EvaluationContext(null, contextObject);
                    try {
                        enabled &= EvaluationResult.TRUE.equals(expression.evaluate((IEvaluationContext)econtext));
                    }
                    catch (Exception exception) {
                        enabled = false;
                    }
                }
                ++n2;
            }
        }
        return enabled;
    }
}

