/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.core.internal.management.extensionpts;

import com.ibm.faceted.project.wizard.core.internal.management.extensionpts.ExtensionPointUtil;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IConfigurationDelegate;
import org.eclipse.core.runtime.IConfigurationElement;

public final class ConfigurationDelegateDefinition
implements IConfigurationDelegate {
    private String wizardClass;
    private boolean isHidden;
    private String overrideClassName;
    private boolean hasOverrideClass;
    private final IConfigurationElement configurationElement;
    private String delegateClassName;
    private IConfigurationElement delegateElement;
    private String smallIcon;
    private String title;
    private String description;
    private String id;
    private boolean isValid;

    ConfigurationDelegateDefinition(IConfigurationElement configurationElement) {
        this.configurationElement = configurationElement;
        this.isValid = true;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    @Override
    public String getContributingPluginId() {
        return this.configurationElement.getNamespaceIdentifier();
    }

    @Override
    public String getDelegateClassName() {
        if (this.delegateClassName == null) {
            this.delegateElement = this.getDelegateElement();
            if (this.delegateElement != null) {
                this.delegateClassName = this.delegateElement.getAttribute("class");
            }
        }
        return this.delegateClassName;
    }

    public IConfigurationElement getDelegateElement() {
        return this.configurationElement;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = this.configurationElement.getAttribute("description");
        }
        return this.description;
    }

    public String getExtensionPoint() {
        return "com.ibm.adapter.j2c.codegen.configurationDelegate";
    }

    @Override
    public String getExtensionPointId() {
        return "com.ibm.adapter.j2c.codegen.configurationDelegate";
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = this.configurationElement.getAttribute("id");
        }
        return this.id;
    }

    @Override
    public String getOverrideWizardClassName() {
        IConfigurationElement delegateElement;
        if (this.overrideClassName == null && (delegateElement = this.getDelegateElement()) != null) {
            this.overrideClassName = delegateElement.getAttribute("wizardOverrideClass");
            if (this.overrideClassName == null) {
                this.overrideClassName = "";
            }
            this.hasOverrideClass = !this.overrideClassName.isEmpty();
        }
        return this.overrideClassName;
    }

    @Override
    public String getSmallIcon() {
        if (this.smallIcon == null) {
            this.smallIcon = this.configurationElement.getAttribute("smallIcon");
        }
        return this.smallIcon;
    }

    @Override
    public String getTitle() {
        if (this.title == null) {
            this.title = this.configurationElement.getAttribute("title");
        }
        return this.title;
    }

    @Override
    public String getWizardClassName() {
        if (this.wizardClass == null) {
            String hiddenString;
            this.isHidden = false;
            this.wizardClass = this.configurationElement.getAttribute("wizardClass");
            if (this.wizardClass != null && (hiddenString = this.configurationElement.getAttribute("hidden")) != null && !hiddenString.isEmpty()) {
                this.isHidden = Boolean.parseBoolean(hiddenString);
            }
        }
        return this.wizardClass;
    }

    @Override
    public boolean hasOverrideWizardClass() {
        this.getOverrideWizardClassName();
        return this.hasOverrideClass;
    }

    @Override
    public boolean isEnabled(Object ... contexts) {
        boolean isEnabled = false;
        if (contexts != null) {
            Object[] objectArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (isEnabled |= ExtensionPointUtil.isConfigurationElementEnabled(this.configurationElement, object)) break;
                ++n2;
            }
        }
        return isEnabled;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public boolean isValid() {
        if (!this.isValid) {
            return false;
        }
        if (this.isWizardConfigration() && this.getDelegateClassName() == null) {
            return this.getWizardClassName() != null && !this.getWizardClassName().isEmpty();
        }
        return this.getDelegateClassName() != null;
    }

    @Override
    public boolean isWizardConfigration() {
        return this.getWizardClassName() != null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append(":  ");
        buffer.append(this.getId());
        buffer.append(" [");
        buffer.append("delegate class: ");
        buffer.append(this.getDelegateClassName());
        buffer.append("]");
        return buffer.toString();
    }

    public void invalidate() {
        this.isValid = false;
    }
}

