/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.contributions.configurations;

import com.ibm.faceted.project.wizard.contributions.configurations.AbstractTemplateConfigurationDelegate;
import com.ibm.faceted.project.wizard.core.serviceability.Logger;
import com.ibm.faceted.project.wizard.core.serviceability.ServiceablilityUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;

public class DefaultWizardPageConfigurationDelegate
extends AbstractTemplateConfigurationDelegate {
    private IFacetWizardPage wizardPage = null;
    private boolean pageCreateSuccessful = true;
    private String facetId;
    private static Logger logger = ServiceablilityUtil.getServiceabilityManager().getLogger();

    @Override
    public void dispose() {
        super.dispose();
        if (Thread.currentThread() != Display.getDefault().getThread()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (DefaultWizardPageConfigurationDelegate.this.wizardPage != null) {
                        DefaultWizardPageConfigurationDelegate.this.wizardPage.dispose();
                    }
                    DefaultWizardPageConfigurationDelegate.this.wizardPage = null;
                }
            });
        } else {
            if (this.wizardPage != null) {
                this.wizardPage.dispose();
            }
            this.wizardPage = null;
        }
    }

    @Override
    public void enter() {
        super.enter();
        if (Thread.currentThread() != Display.getDefault().getThread()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (DefaultWizardPageConfigurationDelegate.this.wizardPage != null) {
                        DefaultWizardPageConfigurationDelegate.this.wizardPage.setVisible(true);
                    }
                }
            });
        } else if (this.wizardPage != null) {
            this.wizardPage.setVisible(true);
        }
    }

    @Override
    public void exit() {
        super.exit();
        if (Thread.currentThread() != Display.getDefault().getThread()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (DefaultWizardPageConfigurationDelegate.this.wizardPage != null) {
                        DefaultWizardPageConfigurationDelegate.this.wizardPage.setVisible(false);
                    }
                }
            });
        } else if (this.wizardPage != null) {
            this.wizardPage.setVisible(false);
        }
    }

    @Override
    public final Composite getContent(Composite parent) {
        this.checkDisposed();
        Composite c = new Composite(parent, 0);
        c.setLayout(this.getLayout());
        try {
            this.wizardPage.createControl(c);
            c.layout(true, true);
        }
        catch (Exception e) {
            String message = NLS.bind((String)"Wizard page creation failed:  {0} \nFacet cannot be installed: {1}", (Object[])new String[]{this.wizardPage != null ? this.wizardPage.getClass().getCanonicalName() : "null", this.facetId});
            logger.logContributorError(this.getExtensionPointId(), this.getConfigurationElement(), message, e);
            this.pageCreateSuccessful = false;
            this.getProjectManager().removeFacet(this.facetId);
            if (this.wizardPage != null) {
                this.wizardPage.dispose();
                this.wizardPage = null;
            }
            throw new RuntimeException(message, e);
        }
        return c;
    }

    public final IFacetWizardPage getWizardPage() {
        this.checkDisposed();
        return this.wizardPage;
    }

    public void setFacetId(String facetId) {
        this.checkDisposed();
        this.facetId = facetId;
    }

    public final void setWizardPage(IFacetWizardPage wizardPage) {
        this.checkDisposed();
        this.wizardPage = wizardPage;
    }

    @Override
    public boolean shouldShow(Object model) {
        this.checkDisposed();
        return super.shouldShow(model) && this.pageCreateSuccessful;
    }
}

