/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faceted.project.wizard.contributions.configurations;

import com.ibm.etools.slickui.validation.IValidationStateChangedListener;
import com.ibm.etools.slickui.validation.IValidationStateProvider;
import com.ibm.etools.slickui.validation.ValidationEvent;
import com.ibm.faceted.project.wizard.core.configuration.IContributionProjectManager;
import com.ibm.faceted.project.wizard.core.serviceability.Logger;
import com.ibm.faceted.project.wizard.core.serviceability.ServiceablilityUtil;
import com.ibm.faceted.project.wizard.internal.ui.pages.configuration.ConfigurationPage;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public abstract class AbstractTemplateConfigurationDelegate
implements IValidationStateProvider {
    private ListenerList listeners = new ListenerList();
    private Layout layout;
    private IWizard wizard;
    private IConfigurationElement configurationElement;
    private boolean isDisposed = false;
    private IDataModel model;
    private IContributionProjectManager projectManager;
    private static Logger logger = ServiceablilityUtil.getServiceabilityManager().getLogger();

    protected AbstractTemplateConfigurationDelegate() {
    }

    @Override
    public final void addValidationStateChangedListener(IValidationStateChangedListener listener) {
        this.checkDisposed();
        this.listeners.add((Object)listener);
    }

    protected final void checkDisposed() {
        if (this.isDisposed) {
            String message = String.valueOf(this.getClass().getCanonicalName()) + " has been disposed.  Check to make sure listeners have been removed.";
            RuntimeException e = new RuntimeException(message);
            this.logContributionException(e, message);
            throw e;
        }
    }

    protected final SelectionListener createConfigurationSelectionListener(final String templateConfigurationId) {
        this.checkDisposed();
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationPage.setConfigurationSelection(templateConfigurationId);
            }
        };
    }

    public void dispose() {
        this.layout = null;
        this.listeners = null;
        this.isDisposed = true;
        this.model = null;
    }

    public void enter() {
        this.checkDisposed();
    }

    public void execute(IProgressMonitor monitor) throws Exception {
        monitor.done();
    }

    public void exit() {
        this.checkDisposed();
    }

    @Override
    public final void fireValidationStateChangedEvent(ValidationEvent event) {
        this.checkDisposed();
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IValidationStateChangedListener)listener).validateStateChanged(event);
            ++n2;
        }
    }

    public final IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public abstract Composite getContent(Composite var1);

    public final IDataModel getDataModel() {
        return this.model;
    }

    public final String getExtensionPointId() {
        return "com.ibm.adapter.j2c.codegen.configurationDelegate";
    }

    protected final Layout getLayout() {
        this.checkDisposed();
        return this.layout;
    }

    protected IContributionProjectManager getProjectManager() {
        return this.projectManager;
    }

    @Override
    public IStatus getValidationState() {
        this.checkDisposed();
        return Status.OK_STATUS;
    }

    protected final IWizard getWizard() {
        this.checkDisposed();
        return this.wizard;
    }

    public void init() {
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    protected final void logContributionException(Exception e, String message) {
        logger.logContributorError(this.getExtensionPointId(), this.configurationElement, message, e);
    }

    public boolean recreateRequired() {
        this.checkDisposed();
        return false;
    }

    @Override
    public final synchronized void removeValidationStateChangedListener(IValidationStateChangedListener listener) {
        this.checkDisposed();
        this.listeners.remove((Object)listener);
    }

    public final void setConfigurationElement(IConfigurationElement configurationElement) {
        if (this.configurationElement == null) {
            this.configurationElement = configurationElement;
        }
    }

    public final void setDataModel(IDataModel model) {
        this.checkDisposed();
        this.model = model;
    }

    public final void setLayout(Layout layout) {
        this.checkDisposed();
        this.layout = layout;
    }

    public final void setProjectManager(IContributionProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public final void setWizard(IWizard wizard) {
        this.checkDisposed();
        this.wizard = wizard;
    }

    public boolean shouldShow(Object model) {
        this.checkDisposed();
        this.updateValidationState();
        return true;
    }

    @Override
    public void updateValidationState() {
        this.checkDisposed();
    }

    public void wizardFinished() {
        this.checkDisposed();
    }
}

