/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.webproject.wizard;

import com.ibm.etools.webtools.webproject.wizard.internal.management.CoreFacetSetManager;
import com.ibm.etools.webtools.webproject.wizard.internal.nls.Messages;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSet;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSetApprover;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectTemplate;
import com.ibm.faceted.project.wizard.ui.FacetedProjectWizard;
import java.net.MalformedURLException;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WebProjectWizard
extends FacetedProjectWizard {
    private final CoreFacetSetManager coreFacetSetManager;
    protected IProjectTemplate defaultTemplate;
    protected static final String WEB_DEV_PERSPECTIVE = "org.eclipse.wst.web.ui.webDevPerspective";
    protected static final String WEB_WIZARD_ID = "com.ibm.etools.webtools.webproject.wizard";
    protected static final String ORG_ECLIPSE_WST_WEB_UI = "org.eclipse.wst.web.ui";
    protected static final String ICONS_WEB_APPLICATION_16 = "icons/full/obj16/web_application.gif";
    protected static final String ICONS_NEW_WEB_PROJ_BANNER = "icons/newWebProj_banner.png";
    protected static final String SIMPLE_TEMPLATE = "com.ibm.etools.webtools.basicTemplate";

    public WebProjectWizard() {
        this.setWindowTitle(Messages.WebProjectWizard_Title);
        this.coreFacetSetManager = new CoreFacetSetManager(this.getExtensionPointManager());
    }

    @Override
    public ICoreFacetSetApprover getCoreFacetSetApprover() {
        return this.coreFacetSetManager;
    }

    @Override
    public Comparator<ICoreFacetSet> getCoreFacetSetComparator() {
        return this.coreFacetSetManager;
    }

    @Override
    public ICoreFacetSet getDefaultCoreFacetSetForProjectTemplate(IProjectTemplate projectTemplate) {
        ICoreFacetSet osgiJavaeeProgrammingModel;
        Set<ICoreFacetSet> programmingModelsForTemplate = this.getExtensionPointManager().getCoreFacetSetsForTemplate(projectTemplate);
        if (this.coreFacetSetManager.hasJavaeeProgrammingModel()) {
            ICoreFacetSet javaeeProgrammingModel = this.coreFacetSetManager.getJavaeeProgrammingModel();
            if (programmingModelsForTemplate.contains(javaeeProgrammingModel)) {
                return javaeeProgrammingModel;
            }
        } else if (this.coreFacetSetManager.hasClientProgrammingModel()) {
            ICoreFacetSet clientProgrammingModel = this.coreFacetSetManager.getClientProgrammingModel();
            if (programmingModelsForTemplate.contains(clientProgrammingModel)) {
                return clientProgrammingModel;
            }
        } else if (this.coreFacetSetManager.hasOsgiJavaEEProgrammingModel() && programmingModelsForTemplate.contains(osgiJavaeeProgrammingModel = this.coreFacetSetManager.getOsgiJavaEEProgrammingModel())) {
            return osgiJavaeeProgrammingModel;
        }
        return super.getDefaultCoreFacetSetForProjectTemplate(projectTemplate);
    }

    @Override
    public IProjectTemplate getDefaultProjectTemplate() {
        if (this.defaultTemplate == null) {
            this.defaultTemplate = this.getExtensionPointManager().getProjectTemplateById(SIMPLE_TEMPLATE);
            if (this.defaultTemplate == null) {
                this.defaultTemplate = super.getDefaultProjectTemplate();
            }
        }
        return this.defaultTemplate;
    }

    @Override
    public Image getDefaultProjectTemplateIcon() {
        try {
            return this.getImageManager().getImage(ORG_ECLIPSE_WST_WEB_UI, ICONS_WEB_APPLICATION_16);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    protected String getFinalPerspectiveID() {
        return WEB_DEV_PERSPECTIVE;
    }

    @Override
    public String getId() {
        return WEB_WIZARD_ID;
    }

    @Override
    public String getTemplateSelectionPageDescription() {
        return Messages.TemplateSelectionPage_Description;
    }

    @Override
    public String getTemplateSelectionPageTitle() {
        return Messages.TemplateSelectionPage_Title;
    }

    @Override
    public ImageDescriptor getWizardBannerImageDescriptor() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.adapter.j2c.codegen", (String)ICONS_NEW_WEB_PROJ_BANNER);
    }
}

