/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.flatui;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.etools.webtools.flatui.HyperlinkHandler;
import com.ibm.etools.webtools.flatui.IHyperlinkListener;
import com.ibm.etools.webtools.flatui.LinkLabel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class WidgetFactory {
    public static final String DEFAULT_HEADER_COLOR = "__default__header__";
    public static final String COLOR_BACKGROUND = "__bg";
    public static final String COLOR_BORDER = "__border";
    public static final String COLOR_COMPOSITE_SEPARATOR = "__compSep";
    public static final String COLOR_HYPERLINK = "__hyperlink";
    public static final String COLOR_ACTIVE_HYPERLINK = "__active_hyperlink";
    public static final String COLOR_SEPARATOR = "__separatorColor";
    public static final String COLOR_WHITE = "__whiteColor";
    public static final String COLOR_BLACK = "__blackColor";
    public static final String COLOR_FLAT_LABEL = "__flatLabelColor";
    public static final int SEPARATOR_WIDTH = 4;
    private static final int HBAR_INCREMENT = 20;
    private static final int HPAGE_INCREMENT = 20;
    private static final int VBAR_INCREMENT = 20;
    private static final int VPAGE_INCREMENT = 200;
    private Hashtable fColorRegistry = new Hashtable();
    private Color fClientAreaColor;
    private Color fWidgetBackgroundColor;
    protected Color fForegroundColor;
    private Color fReadOnlyColor;
    private Display fDisplay = Display.getDefault();
    public static final int BORDER_STYLE = 0;
    private BorderPainter fBorderPainter;
    protected Color fBorderColor;
    private HyperlinkHandler fHyperlinkHandler;
    private Image fBanner;

    public WidgetFactory() {
        this.initialize();
    }

    public Button createButton(Composite parent, String text, int style) {
        int flatStyle = 0x800000;
        Button button = new Button(parent, style | flatStyle);
        button.setBackground(this.fClientAreaColor);
        button.setForeground(this.fForegroundColor);
        if (text != null) {
            button.setText(text);
        }
        return button;
    }

    public Composite createComposite(Composite parent) {
        return this.createComposite(parent, 0);
    }

    public CCombo createCCombo(Composite parent) {
        int comboStyle = 8;
        comboStyle = !SWT.getPlatform().equals("motif") ? (comboStyle |= 0x800000) : (comboStyle |= 0x800);
        return this.createCCombo(parent, comboStyle);
    }

    public CCombo createCCombo(Composite parent, int comboStyle) {
        CCombo combo = new CCombo(parent, comboStyle);
        combo.setBackground(this.fClientAreaColor);
        combo.setForeground(this.fForegroundColor);
        return combo;
    }

    public Composite createComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setBackground(this.fClientAreaColor);
        return composite;
    }

    public Composite createCompositeSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getColor(COLOR_COMPOSITE_SEPARATOR));
        return composite;
    }

    public Label[] createFlatHeaderComposite(Composite parent, String[] cHeaders) {
        Composite labelsContainer = this.createComposite(parent);
        GridData gd = new GridData(272);
        labelsContainer.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        int numHeaders = 1;
        if (cHeaders.length != 1) {
            numHeaders = cHeaders.length * 2 + 1;
        }
        gl.numColumns = numHeaders;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 5;
        gl.verticalSpacing = 0;
        labelsContainer.setLayout((Layout)gl);
        Color separatorColor = this.getColor(COLOR_SEPARATOR);
        Color borderColor = this.getColor(COLOR_BORDER);
        Color whiteColor = this.getColor(COLOR_WHITE);
        parent.setBackground(borderColor);
        Label[] headerLabels = new Label[numHeaders];
        Composite[] labelBoxes = new Composite[numHeaders];
        if (numHeaders == 1) {
            labelsContainer.setBackground(this.fWidgetBackgroundColor);
            labelBoxes[0] = this.createComposite(labelsContainer);
            gl = new GridLayout();
            gl.marginHeight = 1;
            gl.marginWidth = 1;
            labelBoxes[0].setLayout((Layout)gl);
            labelBoxes[0].setLayoutData((Object)new GridData(272));
            labelBoxes[0].setBackground(this.fWidgetBackgroundColor);
            headerLabels[0] = this.createTableLabel(labelBoxes[0], cHeaders[0], this.fWidgetBackgroundColor);
            headerLabels[0].setLayoutData((Object)new GridData(272));
            headerLabels[0].setBackground(this.fWidgetBackgroundColor);
        } else {
            int i = 0;
            while (i < numHeaders) {
                labelBoxes[i] = this.createComposite(labelsContainer);
                gd = new GridData(272);
                labelBoxes[i].setLayoutData((Object)gd);
                gl = new GridLayout();
                gl.marginHeight = 1;
                gl.marginWidth = 1;
                labelBoxes[i].setLayout((Layout)gl);
                labelBoxes[i].setBackground(whiteColor);
                if (i % 2 != 0) {
                    headerLabels[i] = this.createTableLabel(labelBoxes[i], "", this.fWidgetBackgroundColor);
                    gd = new GridData(272);
                    gd.widthHint = 4;
                    headerLabels[i].setLayoutData((Object)gd);
                    headerLabels[i].setBackground(separatorColor);
                } else {
                    int j = 0;
                    if (i != 0) {
                        j = i / 2;
                    }
                    if (j < cHeaders.length) {
                        headerLabels[i] = this.createTableLabel(labelBoxes[i], cHeaders[j], this.fWidgetBackgroundColor);
                        headerLabels[i].setBackground(this.fWidgetBackgroundColor);
                    } else {
                        headerLabels[i] = this.createTableLabel(labelBoxes[i], "", this.fWidgetBackgroundColor);
                        headerLabels[i].setBackground(this.fWidgetBackgroundColor);
                    }
                    gd = new GridData(272);
                    headerLabels[i].setLayoutData((Object)gd);
                }
                labelBoxes[i].layout(true);
                ++i;
            }
        }
        return headerLabels;
    }

    public Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 32);
        group.setText(text);
        group.setBackground(this.fClientAreaColor);
        group.setForeground(this.fForegroundColor);
        return group;
    }

    public Label createHeadingLabel(Composite parent, String text, Color bg) {
        return this.createHeadingLabel(parent, text, bg, 0);
    }

    public Label createTableLabel(Composite parent, String text, Color bg) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setBackground(this.fClientAreaColor);
        label.setForeground(this.fForegroundColor);
        return label;
    }

    public Label createHeadingLabel(Composite parent, String text, Color bg, int style) {
        Label label = new Label(parent, style);
        label.setText(text);
        label.setBackground(this.fClientAreaColor);
        label.setForeground(this.fForegroundColor);
        label.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        return label;
    }

    public Label createHyperlinkLabel(Composite parent, String text, IHyperlinkListener listener) {
        return this.createHyperlinkLabel(parent, text, listener, 0);
    }

    public Label createHyperlinkLabel(Composite parent, String text, IHyperlinkListener listener, int style) {
        Label label = this.createLabel(parent, text, style);
        this.turnIntoHyperlink((Control)label, listener);
        return label;
    }

    public Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 0);
    }

    public Label createLabel(Composite parent, String text, int style) {
        Label label = new Label(parent, style);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fClientAreaColor);
        label.setForeground(this.fForegroundColor);
        return label;
    }

    public Label createSeparator(Composite parent, int style) {
        Label label = new Label(parent, 2 | style);
        label.setBackground(this.fClientAreaColor);
        label.setForeground(this.fBorderColor);
        return label;
    }

    public ScrolledComposite createScrolledComposite(Composite parent) {
        ScrolledComposite scrolledcomposite = new ScrolledComposite(parent, 768);
        scrolledcomposite.setBackground(this.fClientAreaColor);
        scrolledcomposite.setForeground(this.fForegroundColor);
        return scrolledcomposite;
    }

    public LinkLabel createLinkLabel(Composite parent, String text) {
        return this.createLinkLabel(parent, text, 0);
    }

    public LinkLabel createLinkLabel(Composite parent, String text, int style) {
        LinkLabel label = new LinkLabel(parent, style);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fClientAreaColor);
        label.setForeground(this.fForegroundColor);
        return label;
    }

    public Table createTable(Composite parent, int style) {
        Table table = new Table(parent, style);
        table.setBackground(this.fClientAreaColor);
        table.setForeground(this.fForegroundColor);
        return table;
    }

    public Text createText(Composite parent, String value) {
        return this.createText(parent, value, 4);
    }

    public Text createText(Composite parent, String value, int style) {
        Text text = new Text(parent, style);
        text.setText(value);
        text.setBackground(this.fClientAreaColor);
        text.setForeground(this.fForegroundColor);
        if ((style & 8) != 0) {
            text.setForeground(this.fReadOnlyColor);
        }
        return text;
    }

    public Tree createTree(Composite parent, int style) {
        Tree tree = new Tree(parent, style);
        tree.setBackground(this.fClientAreaColor);
        tree.setForeground(this.fForegroundColor);
        return tree;
    }

    public ViewForm createViewForm(Composite parent) {
        ViewForm viewForm = new ViewForm(parent, 0);
        viewForm.setBackground(this.fClientAreaColor);
        viewForm.setForeground(this.fForegroundColor);
        return viewForm;
    }

    public void dispose() {
        if (this.fColorRegistry != null) {
            Enumeration colors = this.fColorRegistry.elements();
            while (colors.hasMoreElements()) {
                Color c = (Color)colors.nextElement();
                if (c == null || c.isDisposed()) continue;
                c.dispose();
            }
        }
        if (this.fHyperlinkHandler != null) {
            this.fHyperlinkHandler.dispose();
        }
        this.fColorRegistry = null;
        if (this.fBanner != null && !this.fBanner.isDisposed()) {
            this.fBanner.dispose();
        }
    }

    public Color getBackgroundColor() {
        return this.fClientAreaColor;
    }

    public Color getWidgetBackgroundColor() {
        return this.fWidgetBackgroundColor;
    }

    public Image getBanner() {
        return this.fBanner;
    }

    public Color getBorderColor() {
        return this.fBorderColor;
    }

    public Cursor getBusyCursor() {
        return this.fHyperlinkHandler.getBusyCursor();
    }

    public Color getClientAreaColor() {
        return this.fClientAreaColor;
    }

    public Color getColor(String key) {
        return (Color)this.fColorRegistry.get(key);
    }

    public Color getForegroundColor() {
        return this.fForegroundColor;
    }

    public Color getHyperlinkColor() {
        return this.fHyperlinkHandler.getForeground();
    }

    public Cursor getHyperlinkCursor() {
        return this.fHyperlinkHandler.getHyperlinkCursor();
    }

    public Color getHyperlinkHoverColor() {
        return this.fHyperlinkHandler.getActiveForeground();
    }

    public int getHyperlinkUnderlineMode() {
        return this.fHyperlinkHandler.getHyperlinkUnderlineMode();
    }

    private void initialize() {
        this.fClientAreaColor = this.fDisplay.getSystemColor(25);
        this.fWidgetBackgroundColor = this.fDisplay.getSystemColor(22);
        this.fReadOnlyColor = this.fDisplay.getSystemColor(16);
        this.registerColor(COLOR_BACKGROUND, 255, 254, 249);
        this.registerColor(COLOR_BORDER, 195, 191, 179);
        this.registerColor(COLOR_COMPOSITE_SEPARATOR, 152, 170, 203);
        this.registerColor(DEFAULT_HEADER_COLOR, 72, 112, 152);
        this.registerColor(COLOR_SEPARATOR, 168, 168, 168);
        this.registerColor(COLOR_WHITE, 255, 255, 255);
        this.registerColor(COLOR_BLACK, 0, 0, 0);
        this.registerColor(COLOR_FLAT_LABEL, 214, 211, 206);
        this.fBorderColor = this.getColor(COLOR_BORDER);
        this.fForegroundColor = this.fDisplay.getSystemColor(24);
        this.fHyperlinkHandler = new HyperlinkHandler();
        this.fHyperlinkHandler.setForeground(this.registerColor(COLOR_HYPERLINK, 0, 0, 153));
        this.fHyperlinkHandler.setActiveForeground(this.registerColor(COLOR_ACTIVE_HYPERLINK, 255, 0, 0));
        this.fHyperlinkHandler.setBackground(this.fClientAreaColor);
        try {
            this.fBanner = ImageDescriptor.createFromURL((URL)new URL(CodegenPlugin.getDefault().getBundle().getEntry("/"), "icons/form_banner.gif")).createImage();
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public void paintBordersFor(Composite parent) {
        if (this.fBorderPainter == null) {
            this.fBorderPainter = new BorderPainter();
        }
        parent.addPaintListener((PaintListener)this.fBorderPainter);
    }

    public Color registerColor(String key, int r, int g, int b) {
        Color c = new Color((Device)this.fDisplay, r, g, b);
        this.fColorRegistry.put(key, c);
        return c;
    }

    public void setHyperlinkColor(Color color) {
        this.fHyperlinkHandler.setForeground(color);
    }

    public void setHyperlinkHoverColor(Color hoverColor) {
        this.fHyperlinkHandler.setActiveForeground(hoverColor);
    }

    public void setHyperlinkUnderlineMode(int newHyperlinkUnderlineMode) {
        this.fHyperlinkHandler.setHyperlinkUnderlineMode(newHyperlinkUnderlineMode);
    }

    public void turnIntoHyperlink(Control control, IHyperlinkListener listener) {
        this.fHyperlinkHandler.registerHyperlink(control, listener);
    }

    public void initializeScrollBars(ScrolledComposite scrollComp) {
        ScrollBar vbar;
        ScrollBar hbar = scrollComp.getHorizontalBar();
        if (hbar != null) {
            hbar.setIncrement(20);
            hbar.setPageIncrement(20);
        }
        if ((vbar = scrollComp.getVerticalBar()) != null) {
            vbar.setIncrement(20);
            vbar.setPageIncrement(200);
        }
    }

    public void reInitializeScrolledComposite(ScrolledComposite scrolledComposite) {
        Point minSize = scrolledComposite.getChildren()[0].computeSize(-1, -1);
        scrolledComposite.setMinHeight(minSize.y);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
    }

    public GridLayout createCommonGridLayout() {
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        return gl;
    }

    class BorderPainter
    implements PaintListener {
        BorderPainter() {
        }

        public void paintControl(PaintEvent event) {
            Composite composite = (Composite)event.widget;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                GC gc;
                Rectangle b;
                Control c = children[i];
                if (c instanceof Text || c instanceof Canvas || c instanceof CCombo) {
                    b = c.getBounds();
                    gc = event.gc;
                    gc.setForeground(c.getBackground());
                    gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
                    gc.setForeground(WidgetFactory.this.fForegroundColor);
                    gc.drawRectangle(b.x - 2, b.y - 2, b.width + 3, b.height + 3);
                } else if (c instanceof Table || c instanceof Tree || c instanceof Tree || c instanceof List) {
                    b = c.getBounds();
                    gc = event.gc;
                    gc.setForeground(WidgetFactory.this.fBorderColor);
                    gc.drawRectangle(b.x - 1, b.y - 1, b.width + 2, b.height + 2);
                }
                ++i;
            }
        }
    }
}

