/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.flatui;

import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class ToggleControl
extends Canvas {
    protected boolean fCollapsed;
    private Color fDecorationColor;
    private Color fActiveColor;
    protected Cursor fActiveCursor;
    protected boolean fHasFocus;
    protected boolean fHover = false;
    private static final int MARGIN_WIDTH = 2;
    private static final int MARGIN_HEIGHT = 2;
    private static final int DEFAULT_HEIGHT = 8;
    private static final int[] EXPANDED_POINTS;
    private static final int[] COLLAPSED_POINTS;
    private int fHeight = 8;
    protected String fName = "toggle button";
    protected String fDescription = "toggle button for collapsable sections";

    static {
        int[] nArray = new int[6];
        nArray[1] = 2;
        nArray[2] = 8;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 6;
        EXPANDED_POINTS = nArray;
        int[] nArray2 = new int[6];
        nArray2[0] = 2;
        nArray2[2] = 2;
        nArray2[3] = 8;
        nArray2[4] = 6;
        nArray2[5] = 4;
        COLLAPSED_POINTS = nArray2;
    }

    public ToggleControl(Composite parent, int style) {
        super(parent, style);
        this.initAccessible();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ToggleControl.this.paint(e);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ToggleControl.this.notifyListeners(13);
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' || e.character == ' ') {
                    ToggleControl.this.notifyListeners(13);
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail != 4) {
                    e.doit = true;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!ToggleControl.this.fHasFocus) {
                    ToggleControl.this.fHasFocus = true;
                    ToggleControl.this.redraw();
                }
            }

            public void focusLost(FocusEvent e) {
                if (ToggleControl.this.fHasFocus) {
                    ToggleControl.this.fHasFocus = false;
                    ToggleControl.this.redraw();
                }
            }
        });
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToggleControl.this.fCollapsed = !ToggleControl.this.fCollapsed;
                ToggleControl.this.redraw();
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                ToggleControl.this.fHover = true;
                if (ToggleControl.this.fActiveCursor != null) {
                    ToggleControl.this.setCursor(ToggleControl.this.fActiveCursor);
                }
                ToggleControl.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                ToggleControl.this.fHover = false;
                if (ToggleControl.this.fActiveCursor != null) {
                    ToggleControl.this.setCursor(null);
                }
                ToggleControl.this.redraw();
            }
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener != null) {
            this.addListener(13, (Listener)new TypedListener((SWTEventListener)listener));
        }
    }

    public void setDecorationColor(Color decorationColor) {
        this.fDecorationColor = decorationColor;
    }

    public Color getDecorationColor() {
        return this.fDecorationColor;
    }

    public void setActiveDecorationColor(Color activeColor) {
        this.fActiveColor = activeColor;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener != null) {
            this.removeListener(13, (SWTEventListener)listener);
        }
    }

    public void setActiveCursor(Cursor activeCursor) {
        this.fActiveCursor = activeCursor;
    }

    public Color getActiveDecorationColor() {
        return this.fActiveColor;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(wHint != -1 ? wHint : this.fHeight + 4, hHint != -1 ? hHint : this.fHeight + 4);
    }

    protected void paint(PaintEvent e) {
        GC gc = e.gc;
        Point size = this.getSize();
        gc.setFont(this.getFont());
        this.paint(gc);
        if (this.fHasFocus) {
            gc.setForeground(this.getForeground());
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }

    protected void paint(GC gc) {
        if (this.fHover && this.fActiveColor != null) {
            gc.setBackground(this.fActiveColor);
        } else if (this.fDecorationColor != null) {
            gc.setBackground(this.fDecorationColor);
        } else {
            gc.setBackground(this.getForeground());
        }
        Point size = this.getSize();
        gc.fillPolygon(this.translate(this.fCollapsed ? COLLAPSED_POINTS : EXPANDED_POINTS, (size.x - this.fHeight) / 2, (size.y - this.fHeight) / 2));
        gc.setBackground(this.getBackground());
    }

    private int[] translate(int[] data, int x, int y) {
        int[] target = new int[data.length];
        int i = 0;
        while (i < data.length) {
            target[i] = data[i] * this.fHeight / 8 + x;
            i += 2;
        }
        i = 1;
        while (i < data.length) {
            target[i] = data[i] * this.fHeight / 8 + y;
            i += 2;
        }
        return target;
    }

    public void setHeight(int y) {
        this.fHeight = y;
    }

    protected final void notifyListeners(int eventType) {
        Event event = new Event();
        event.type = eventType;
        event.widget = this;
        this.notifyListeners(eventType, event);
    }

    public boolean getSelection() {
        return this.fCollapsed;
    }

    public void setSelection(boolean selection) {
        this.fCollapsed = selection;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    private void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ToggleControl.this.fCollapsed ? String.valueOf(ToggleControl.this.fName) + " collapsed" : String.valueOf(ToggleControl.this.fName) + " expanded";
            }

            public void getDescription(AccessibleEvent e) {
                e.result = ToggleControl.this.fDescription;
            }
        });
    }
}

