/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.flatui;

import com.ibm.etools.webtools.flatui.LinkLabel;
import com.ibm.etools.webtools.flatui.ToggleControl;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ShowFocusScrolledComposite
extends ScrolledComposite {
    private static final int MARGIN = 10;
    public static final int ALL = 0;
    public static final int SUBSET = 1;
    private static final Class COMPOSITE = Composite.class;
    private Class[] fSubSet = new Class[]{Button.class, Text.class, ToggleControl.class, LinkLabel.class, Table.class, CCombo.class};
    private Point fPoint = new Point(0, 0);

    public ShowFocusScrolledComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void showControl(Control control) {
        Rectangle controlBounds = this.getAbsoluteBounds(control);
        Rectangle scrollableBounds = this.getAbsoluteBounds((Control)this);
        if (scrollableBounds.y + scrollableBounds.height < controlBounds.y + controlBounds.height + 5) {
            Point origin = this.getOrigin();
            this.setOrigin(origin.x, origin.y + controlBounds.y + controlBounds.height + 10 - scrollableBounds.height - scrollableBounds.y);
        } else if (controlBounds.y - 5 < scrollableBounds.y) {
            Point origin = this.getOrigin();
            int y = origin.y - scrollableBounds.y + controlBounds.y - 10;
            this.setOrigin(origin.x, y < 0 ? 0 : y);
        }
    }

    private Rectangle getAbsoluteBounds(Control control) {
        Point location = control.toDisplay(this.fPoint);
        Rectangle relativeRect = control.getBounds();
        return new Rectangle(location.x, location.y, relativeRect.width, relativeRect.height);
    }

    public void init(int style) {
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                ShowFocusScrolledComposite.this.showControl((Control)e.widget);
            }

            public void focusLost(FocusEvent e) {
            }
        };
        this.parseChildren((Composite)this, style, focusListener);
    }

    private void parseChildren(Composite composite, int style, FocusListener focusListener) {
        Control[] children = composite.getChildren();
        Control control = null;
        int i = 0;
        while (i < children.length) {
            control = children[i];
            if (style == 1) {
                int j = 0;
                while (j < this.fSubSet.length) {
                    if (this.fSubSet[j].isInstance(control)) {
                        control.addFocusListener(focusListener);
                    }
                    ++j;
                }
            } else {
                control.addFocusListener(focusListener);
            }
            if (COMPOSITE.isInstance(control)) {
                this.parseChildren((Composite)control, style, focusListener);
            }
            ++i;
        }
    }

    public void setSubSet(Class[] classes) {
        this.fSubSet = classes;
    }
}

