/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.flatui;

import com.ibm.etools.webtools.flatui.FlatPageSection;
import com.ibm.etools.webtools.flatui.IFlatPage;
import com.ibm.etools.webtools.flatui.IFlatPageSection;
import com.ibm.etools.webtools.flatui.ITableWithButtonsSection;
import com.ibm.etools.webtools.flatui.ShowFocusScrolledComposite;
import com.ibm.etools.webtools.flatui.WidgetFactory;
import java.util.Vector;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.ActionFactory;

public abstract class FlatPage
implements IFlatPage {
    protected WidgetFactory fWf;
    protected Color fHeadingBackground = null;
    protected Color fHeadingForeground = null;
    protected boolean fHeadingVisible = true;
    protected Image fHeadingImage;
    protected String fHeadingText;
    protected int fPageIndex;
    protected Composite fParent;
    private boolean fScrollable = true;
    protected Font fTitleFont;
    protected Vector fSections = null;
    protected Composite fControl1;
    protected Composite fControl2;
    private int TITLE_HMARGIN = 10;
    private int TITLE_VMARGIN = 5;
    protected String fTabText;
    private boolean fVerticalFit = true;
    private static final int HBAR_INCREMENT = 10;
    private static final int HPAGE_INCREMENT = 40;
    public static final int VBAR_INCREMENT = 10;
    public static final int VPAGE_INCREMENT = 40;
    protected static final int HSPACING = 10;
    protected static final int VSPACING = 20;

    public FlatPage(WidgetFactory wf) {
        this.fWf = wf;
        this.fTitleFont = JFaceResources.getHeaderFont();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.createHeadingImage();
    }

    @Override
    public void createControl(Composite parent) {
        this.fParent = parent;
        this.setHeadingForeground(this.fWf.getColor("__blackColor"));
        if (this.fScrollable) {
            ShowFocusScrolledComposite scomp = new ShowFocusScrolledComposite(this.fParent, 768);
            if (this.isVerticalFit()) {
                scomp.setExpandHorizontal(true);
                scomp.setExpandVertical(true);
            }
            this.initializeScrollBars(scomp);
            this.fControl1 = scomp;
        } else {
            this.fControl1 = new Composite(this.fParent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.fControl1.setLayout((Layout)layout);
        }
    }

    protected void createSectionControls(Composite formParent) {
        for (IFlatPageSection fps : this.fSections) {
            Control secCon = fps.createControl(formParent);
            fps.setGridData(secCon);
        }
    }

    private void createHeadingImage() {
        this.fHeadingImage = this.fWf.getBanner();
    }

    @Override
    public void dispose() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        if (this.fSections != null) {
            for (IFlatPageSection section : this.fSections) {
                section.dispose();
            }
        }
    }

    @Override
    public Composite getPageControl() {
        return this.fControl1;
    }

    @Override
    public final Color getHeadingBackground() {
        return this.fHeadingBackground;
    }

    @Override
    public final Color getHeadingForeground() {
        return this.fHeadingForeground;
    }

    @Override
    public final Image getHeadingImage() {
        return this.fHeadingImage;
    }

    @Override
    public final String getHeadingText() {
        return this.fHeadingText;
    }

    protected final int getTitleHeight() {
        int imageHeight = 0;
        if (this.fHeadingImage != null && !SWT.getPlatform().equals("motif")) {
            imageHeight = this.fHeadingImage.getBounds().height;
        }
        GC gc = new GC((Drawable)this.fControl2);
        gc.setFont(this.fTitleFont);
        FontMetrics fm = gc.getFontMetrics();
        int fontHeight = fm.getHeight();
        gc.dispose();
        int height = fontHeight + this.TITLE_VMARGIN + this.TITLE_VMARGIN;
        return Math.max(height, imageHeight);
    }

    protected final void initializeScrollBars(ScrolledComposite scomp) {
        ScrollBar vbar;
        ScrollBar hbar = scomp.getHorizontalBar();
        if (hbar != null) {
            hbar.setIncrement(10);
            hbar.setPageIncrement(40);
        }
        if ((vbar = scomp.getVerticalBar()) != null) {
            vbar.setIncrement(10);
            vbar.setPageIncrement(40);
        }
    }

    @Override
    public boolean isHeadingVisible() {
        return this.fHeadingVisible;
    }

    @Override
    public boolean isVerticalFit() {
        return this.fVerticalFit;
    }

    private void paint(Control form, GC gc) {
        Rectangle bounds = form.getBounds();
        int height = this.getTitleHeight();
        if (this.fHeadingImage != null) {
            Rectangle imageBounds = this.fHeadingImage.getBounds();
            int x = bounds.width - imageBounds.width;
            int y = 0;
            x = 0;
            if (this.fHeadingBackground != null) {
                gc.setBackground(this.fHeadingBackground);
                gc.fillRectangle(0, 0, bounds.width, height);
            }
            if (!SWT.getPlatform().equals("motif")) {
                gc.drawImage(this.fHeadingImage, x, y);
            }
            if (this.fHeadingForeground != null) {
                gc.setForeground(this.fHeadingForeground);
            } else {
                gc.setForeground(this.fWf.getForegroundColor());
            }
            gc.setFont(this.fTitleFont);
            gc.drawText(this.getHeadingText(), this.TITLE_HMARGIN, this.TITLE_VMARGIN, true);
        } else {
            gc.setFont(this.fTitleFont);
            gc.setBackground(this.fWf.getColor("__default__header__"));
            gc.setForeground(this.fWf.getForegroundColor());
            gc.drawText(this.getHeadingText(), this.TITLE_HMARGIN, this.TITLE_VMARGIN, true);
        }
    }

    @Override
    public void setActivated(boolean isActivated) {
        if (isActivated && this.fControl2 == null) {
            this.fControl2 = new Composite(this.fControl1, 0);
            this.fControl2.setBackground(this.fWf.getBackgroundColor());
            this.fControl2.setForeground(this.fWf.getForegroundColor());
            this.fControl2.addPaintListener((PaintListener)this);
            this.fControl2.setLayout((Layout)new FormLayout());
            Composite formParent = this.fWf.createComposite(this.fControl2);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            gl.marginWidth = 10;
            gl.horizontalSpacing = 10;
            gl.verticalSpacing = 20;
            formParent.setLayout((Layout)gl);
            this.createSectionControls(formParent);
            if (this.fControl1 instanceof ShowFocusScrolledComposite) {
                ShowFocusScrolledComposite sc = (ShowFocusScrolledComposite)this.fControl1;
                sc.setContent((Control)this.fControl2);
                sc.init(1);
                this.updateScrolledComposite();
            }
            GridData gd = new GridData(1808);
            this.fControl2.setLayoutData((Object)gd);
            this.fControl1.setBackground(this.fControl2.getBackground());
            this.fControl2.layout(true);
            this.fControl1.layout(true);
        }
        if (!isActivated) {
            for (IFlatPageSection section : this.fSections) {
                if (!(section instanceof ITableWithButtonsSection)) continue;
                ((ITableWithButtonsSection)section).finishTableEditing();
            }
        }
    }

    @Override
    public void setSectionFocus() {
        if (this.fSections != null && this.fSections.size() > 0 && this.fSections.get(0) instanceof IFlatPageSection) {
            ((IFlatPageSection)this.fSections.get(0)).setFocus();
        }
    }

    public final void paintControl(PaintEvent event) {
        if (this.fHeadingVisible) {
            Control form = (Control)event.widget;
            this.paint(form, event.gc);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.fTitleFont = JFaceResources.getHeaderFont();
        if (this.fControl2 != null) {
            if (this.fSections != null) {
                for (IFlatPageSection section : this.fSections) {
                    section.propertyChange(null);
                }
            }
            this.fControl2.layout(true);
            this.fControl2.redraw();
            this.updateScrolledComposite();
        }
    }

    protected void registerSection(IFlatPageSection section) {
        if (this.fSections == null) {
            this.fSections = new Vector();
        }
        if (!this.fSections.contains(section)) {
            this.fSections.add(section);
        }
    }

    protected void setScrollable(boolean s) {
        this.fScrollable = s;
    }

    @Override
    public final void setHeadingBackground(Color newHeadingBackground) {
        this.fHeadingBackground = newHeadingBackground;
    }

    @Override
    public final void setHeadingForeground(Color newHeadingForeground) {
        this.fHeadingForeground = newHeadingForeground;
    }

    @Override
    public final void setHeadingImage(Image headingImage) {
        this.fHeadingImage = headingImage;
    }

    @Override
    public void setHeadingVisible(boolean vis) {
        this.fHeadingVisible = vis;
        if (this.fControl2 != null) {
            this.fControl2.layout(true);
        }
    }

    @Override
    public void setOutlineSelection(IStructuredSelection sel) {
    }

    @Override
    public final void setHeadingText(String headingText) {
        this.fHeadingText = headingText;
    }

    @Override
    public final void setVerticalFit(boolean newVerticalFit) {
        this.fVerticalFit = newVerticalFit;
    }

    @Override
    public void unregisterSection(IFlatPageSection section) {
        if (this.fSections != null && this.fSections.contains(section)) {
            this.fSections.remove(section);
        }
        this.updateScrolledComposite();
    }

    @Override
    public void updateScrolledComposite() {
        if (this.fControl1 instanceof ScrolledComposite) {
            ScrolledComposite sc = (ScrolledComposite)this.fControl1;
            Point newSize = this.fControl2.computeSize(-1, -1);
            this.fControl2.setSize(newSize);
            sc.setMinSize(newSize);
        }
    }

    protected boolean canPerformDirectly(String id, Control control) {
        if (control instanceof Text) {
            Text text = (Text)control;
            if (id.equals(ActionFactory.CUT)) {
                text.cut();
                return true;
            }
            if (id.equals(ActionFactory.COPY)) {
                text.copy();
                return true;
            }
            if (id.equals(ActionFactory.PASTE)) {
                text.paste();
                return true;
            }
            if (id.equals(ActionFactory.SELECT_ALL)) {
                text.selectAll();
                return true;
            }
            if (id.equals(ActionFactory.DELETE)) {
                int count = text.getSelectionCount();
                if (count == 0) {
                    int caretPos = text.getCaretPosition();
                    text.setSelection(caretPos, caretPos + 1);
                }
                text.insert("");
                return true;
            }
        }
        return false;
    }

    @Override
    public final int getPageIndex() {
        return this.fPageIndex;
    }

    @Override
    public final void setPageIndex(int pageIndex) {
        this.fPageIndex = pageIndex;
    }

    @Override
    public final void setReadOnly(boolean boo) {
        if (this.fSections != null) {
            for (IFlatPageSection section : this.fSections) {
                section.setReadOnly(boo);
            }
        }
    }

    @Override
    public final String getTabText() {
        return this.fTabText;
    }

    @Override
    public final void setTabText(String tabText) {
        this.fTabText = tabText;
    }

    public Vector getSections() {
        return this.fSections;
    }

    public void refreshSections() {
        if (this.fSections != null) {
            for (FlatPageSection section : this.fSections) {
                section.refresh();
            }
        }
    }

    class FormLayout
    extends Layout {
        FormLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Control client = composite.getChildren()[0];
            Point csize = client.computeSize(-1, -1, flushCache);
            if (FlatPage.this.fHeadingVisible) {
                csize.y += FlatPage.this.getTitleHeight();
            }
            return csize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clientArea = composite.getClientArea();
            Control client = composite.getChildren()[0];
            int theight = FlatPage.this.fHeadingVisible ? FlatPage.this.getTitleHeight() : 0;
            client.setBounds(clientArea.x, clientArea.y + theight, clientArea.width, clientArea.height - theight);
        }
    }
}

