/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.slickui;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.etools.slickui.internal.nls.Messages;
import com.ibm.etools.slickui.validation.IValidationStateChangedListener;
import com.ibm.etools.slickui.validation.IValidationStateProvider;
import com.ibm.etools.slickui.validation.ValidationEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class SlickControlProvider
implements IValidationStateProvider {
    private Composite cachedComposite;
    protected Object modelObject;
    private List<IValidationStateChangedListener> validationListeners;
    private boolean contentValid = true;

    @Override
    public void addValidationStateChangedListener(IValidationStateChangedListener listener) {
        List<IValidationStateChangedListener> listenerList = this.getValidationListeners();
        if (!listenerList.contains(listener)) {
            listenerList.add(listener);
        }
    }

    public void dispose() {
        if (this.cachedComposite != null) {
            this.cachedComposite.dispose();
        }
    }

    public void doInitialize(Composite parent) {
    }

    @Override
    public void fireValidationStateChangedEvent(ValidationEvent event) {
        List<IValidationStateChangedListener> listeners = this.getValidationListeners();
        for (IValidationStateChangedListener currentListener : listeners) {
            currentListener.validateStateChanged(event);
        }
    }

    public final Composite getCachedComposite() {
        return this.cachedComposite;
    }

    public abstract Composite getContents(Composite var1);

    public final Object getModel() {
        return this.modelObject;
    }

    private List<IValidationStateChangedListener> getValidationListeners() {
        if (this.validationListeners == null) {
            this.validationListeners = new ArrayList<IValidationStateChangedListener>();
        }
        return this.validationListeners;
    }

    public final void initialize(Composite parent, Object model) {
        this.modelObject = model;
        this.doInitialize(parent);
        try {
            this.cachedComposite = this.getContents(parent);
        }
        catch (Exception e) {
            this.contentValid = false;
            this.cachedComposite = new Composite(parent, 0);
            this.cachedComposite.setLayout((Layout)new GridLayout(2, false));
            Label error = new Label(this.cachedComposite, 0);
            error.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
            error.setLayoutData((Object)new GridData(2));
            Label message = new Label(this.cachedComposite, 64);
            message.setText(Messages.SlickControlProvider_ControlFailedToBeCreated);
            message.setLayoutData((Object)new GridData(768));
            CodegenPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.adapter.j2c.codegen", String.valueOf(this.getClass().getCanonicalName()) + ": Failed to create content due to unexpected errors: ", (Throwable)e));
        }
    }

    public final boolean isContentValid() {
        return this.contentValid;
    }

    @Override
    public void removeValidationStateChangedListener(IValidationStateChangedListener listener) {
        this.getValidationListeners().remove(listener);
    }

    public abstract boolean shouldShow(Object var1);

    @Override
    public void updateValidationState() {
        IStatus currentStatus = this.getValidationState();
        this.fireValidationStateChangedEvent(new ValidationEvent(currentStatus));
    }
}

