/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.slickui;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.etools.slickui.SlickControlDescriptor;
import com.ibm.etools.slickui.SlickControlProvider;
import com.ibm.etools.slickui.internal.SingleTableColumnMaximizer;
import com.ibm.etools.slickui.internal.SlickControlFilter;
import com.ibm.etools.slickui.internal.SlickControlLabelProvider;
import com.ibm.etools.slickui.validation.DefaultValidationDecorationProvider;
import com.ibm.etools.slickui.validation.IValidationDecorationProvider;
import com.ibm.etools.slickui.validation.IValidationStateChangedListener;
import com.ibm.etools.slickui.validation.IValidationStateProvider;
import com.ibm.etools.slickui.validation.ValidationEvent;
import com.ibm.etools.webtools.flatui.SnappyTableViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SlickControlList
implements ISelectionChangedListener,
ISelectionProvider,
IValidationStateChangedListener,
IValidationStateProvider {
    public static final Object NO_SELECTION = new Object();
    private List<ISelectionChangedListener> listeners;
    private Object model;
    private StackLayout fControlsStack;
    private SnappyTableViewer fListViewer;
    private Composite fControlsComposite;
    private IStructuredContentProvider contentProvider;
    private IValidationDecorationProvider decorationProvider;
    private List<IValidationStateChangedListener> validationListeners;

    public SlickControlList(Composite parent, IValidationDecorationProvider decorationProvider) {
        this(parent, decorationProvider, new int[]{25, 75});
    }

    public SlickControlList(Composite parent, IValidationDecorationProvider decorationProvider, int[] weights) {
        this.setValidationDecorationProvider(decorationProvider);
        SashForm sashComposite = new SashForm(parent, 256);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        sashComposite.setLayout((Layout)layout);
        sashComposite.setLayoutData((Object)new GridData(1808));
        this.createOptionsListViewer((Composite)sashComposite);
        this.fControlsComposite = new Composite((Composite)sashComposite, 64);
        GridData gData = new GridData(1808);
        gData.grabExcessVerticalSpace = true;
        this.fControlsComposite.setLayoutData((Object)gData);
        sashComposite.setWeights(weights);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        List<ISelectionChangedListener> listeners = this.getListeners();
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    @Override
    public void addValidationStateChangedListener(IValidationStateChangedListener listener) {
        List<IValidationStateChangedListener> validationListeners = this.getValidationStateListeners();
        if (!validationListeners.contains(listener)) {
            validationListeners.add(listener);
        }
    }

    private void createOptionsListViewer(Composite baseComposite) {
        this.fListViewer = new SnappyTableViewer(new Table(baseComposite, 67584));
        TableColumn tc1 = new TableColumn(this.fListViewer.getTable(), 0);
        tc1.setText("Title");
        tc1.setResizable(false);
        this.fListViewer.setColumnProperties(new String[]{"Title"});
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.fListViewer.getTable().setLayout((Layout)tlayout);
        this.fListViewer.getTable().setHeaderVisible(false);
        this.fListViewer.getTable().setLinesVisible(false);
        new SingleTableColumnMaximizer(this.fListViewer.getTable());
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new SlickControlLabelProvider(this.getValidationDecorationProvider()));
        this.fListViewer.addFilter(new SlickControlFilter());
        this.fListViewer.addSelectionChangedListener(this);
        this.fListViewer.setComparator(new ViewerComparator());
        GridData gData = new GridData(1808);
        this.fListViewer.getControl().setLayoutData((Object)gData);
    }

    public void dispose() {
        List<SlickControlProvider> contribs = this.getVisibleContributions();
        for (SlickControlProvider provider : contribs) {
            provider.removeValidationStateChangedListener(this);
            provider.dispose();
        }
    }

    private void fireSelectionChangedEvent(Object newSelection) {
        if (newSelection == null) {
            newSelection = NO_SELECTION;
        }
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(newSelection));
        for (ISelectionChangedListener current : this.getListeners()) {
            current.selectionChanged(event);
        }
    }

    @Override
    public void fireValidationStateChangedEvent(ValidationEvent event) {
        List<IValidationStateChangedListener> listeners = this.getValidationStateListeners();
        for (IValidationStateChangedListener currentListener : listeners) {
            currentListener.validateStateChanged(event);
        }
    }

    private List<ISelectionChangedListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ISelectionChangedListener>();
        }
        return this.listeners;
    }

    public ISelection getSelection() {
        return this.fListViewer.getSelection();
    }

    public IValidationDecorationProvider getValidationDecorationProvider() {
        if (this.decorationProvider == null) {
            this.decorationProvider = new DefaultValidationDecorationProvider();
        }
        return this.decorationProvider;
    }

    @Override
    public IStatus getValidationState() {
        IStatus status = CodegenPlugin.OK_STATUS;
        List<SlickControlProvider> visibleList = this.getVisibleContributions();
        for (SlickControlProvider provider : visibleList) {
            IStatus currentStatus = provider.getValidationState();
            if (currentStatus.getSeverity() == 4) {
                status = currentStatus;
                break;
            }
            if (currentStatus.getSeverity() <= status.getSeverity()) continue;
            status = currentStatus;
        }
        return status;
    }

    private List<IValidationStateChangedListener> getValidationStateListeners() {
        if (this.validationListeners == null) {
            this.validationListeners = new ArrayList<IValidationStateChangedListener>();
        }
        return this.validationListeners;
    }

    private List<SlickControlProvider> getVisibleContributions() {
        Object[] allContributors;
        ArrayList<SlickControlProvider> visibleContributions = new ArrayList<SlickControlProvider>();
        if (this.model != null && (allContributors = this.contentProvider.getElements(this.model)) != null && allContributors.length > 0) {
            int i = 0;
            while (i < allContributors.length) {
                SlickControlProvider provider;
                SlickControlDescriptor currentDescriptor = (SlickControlDescriptor)allContributors[i];
                if (currentDescriptor.isEnabled(this.model) && (provider = currentDescriptor.getControlProvider()).shouldShow(this.model)) {
                    visibleContributions.add(provider);
                }
                ++i;
            }
        }
        return visibleContributions;
    }

    private void initContributedControls() {
        this.fControlsStack = new StackLayout();
        this.fControlsComposite.setLayout((Layout)this.fControlsStack);
        List<SlickControlProvider> visibleContributionList = this.getVisibleContributions();
        for (SlickControlProvider provider : visibleContributionList) {
            try {
                provider.initialize(this.fControlsComposite, this.model);
                provider.addValidationStateChangedListener(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getListeners().remove(listener);
    }

    @Override
    public void removeValidationStateChangedListener(IValidationStateChangedListener listener) {
        this.getValidationStateListeners().remove(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection;
        SlickControlDescriptor fSelectedOption;
        if (event.getSource().equals((Object)this.fListViewer) && (fSelectedOption = (SlickControlDescriptor)(selection = (IStructuredSelection)event.getSelection()).getFirstElement()) != null) {
            this.fControlsStack.topControl = fSelectedOption.getComposite();
            this.fControlsComposite.layout();
            this.fireSelectionChangedEvent(fSelectedOption);
        }
    }

    public void setContentProvider(IStructuredContentProvider provider) {
        this.contentProvider = provider;
    }

    private void setInitialSelection() {
        Object firstOption = this.fListViewer.getElementAt(0);
        if (firstOption != null) {
            StructuredSelection selection = new StructuredSelection(firstOption);
            this.fListViewer.setSelection((ISelection)selection);
        }
    }

    public void setInput(Object model) {
        this.dispose();
        Object oldInput = this.model;
        this.model = model;
        this.fListViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.fListViewer.setInput(model);
        this.contentProvider.inputChanged((Viewer)this.fListViewer, oldInput, this.model);
        this.initContributedControls();
        this.setInitialSelection();
        this.updateValidationState();
    }

    public void setSelection(ISelection selection) {
        if (this.fListViewer != null && !this.fListViewer.getControl().isDisposed()) {
            this.fListViewer.setSelection(selection);
        }
    }

    public void setSelection(SlickControlDescriptor descriptor) {
        if (descriptor != null && descriptor.isEnabled(this.model)) {
            this.setSelection((ISelection)new StructuredSelection((Object)descriptor));
        }
    }

    public void setValidationDecorationProvider(IValidationDecorationProvider provider) {
        this.decorationProvider = provider;
    }

    public void setViewerSorter(ViewerComparator sorter) {
        this.fListViewer.setComparator(sorter);
    }

    @Override
    public void updateValidationState() {
        IStatus currentStatus = this.getValidationState();
        this.fireValidationStateChangedEvent(new ValidationEvent(currentStatus));
    }

    @Override
    public void validateStateChanged(ValidationEvent event) {
        this.fListViewer.refresh();
        this.fireValidationStateChangedEvent(new ValidationEvent(this.getValidationState()));
    }

    public void refresh() {
        this.initContributedControls();
        this.fListViewer.refresh();
    }
}

