/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.project.facet;

import com.ibm.etools.javaee.core.JavaEEResourceImpl;
import com.ibm.etools.javaee.model.internal.JEE5ModelProviderUtil;
import com.ibm.etools.javaee.project.facet.JavaEEFacetVersionChangeUtil;
import com.ibm.etools.javaee.xml.JavaEEXMLResourceHandler;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.internal.xml.EarDeploymentDescriptorXmlMapperI;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.xml.core.internal.emf2xml.EMF2DOMSSERenderer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Attr;

public abstract class JavaEEFacetVersionChangeDelegate
implements EarDeploymentDescriptorXmlMapperI {
    protected IProjectFacetVersion targetFacet;

    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            this.setTargetFacet(fv);
            if (JavaEEFacetVersionChangeUtil.deploymentDescriptorExists(project.getName())) {
                this.updateNamespace(project);
            }
            this.updateModelProvider(fv.getProjectFacet(), project);
            if (monitor != null) {
                monitor.worked(1);
            }
            this.migrateJaxRpcWSDDIfNecessary(project);
            IJavaProject jp = null;
            try {
                jp = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            }
            catch (CoreException coreException) {}
            if (jp != null) {
                ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
                ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void updateNamespace(IProject project) throws CoreException {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (JavaEEProjectUtilities.isLegacyJ2EEComponent((IVirtualComponent)component)) {
            EObject rootObject = (EObject)provider.getModelObject();
            if (rootObject == null) {
                return;
            }
            XMLResource res = (XMLResource)rootObject.eResource();
            this.updateNamespace(res);
        } else {
            URI ddUri = ((EObject)provider.getModelObject()).eResource().getURI();
            ProjectResourceSet resSet = (ProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)project);
            Resource res = resSet.getResource(ddUri, true);
            if (res instanceof XMLResource) {
                this.updateNamespace((XMLResource)res);
            } else {
                this.updateNamespace((JavaEEResourceImpl)res);
            }
        }
    }

    private void updateNamespace(XMLResource res) throws CoreException {
        EMF2DOMSSERenderer renderer = (EMF2DOMSSERenderer)res.getRenderer();
        IDOMDocument doc = this.getUpdatedDoc(renderer);
        try {
            try {
                doc.getModel().save();
            }
            catch (CoreException e) {
                Status stat = new Status(4, "com.ibm.etools.javaee.core", NLS.bind((String)JavaEEXMLResourceHandler.JavaEEFacetVersionChangeDelegate_Error_occured_upgrading_namespace_f_, (Object)res.getURI()), (Throwable)e);
                throw new CoreException((IStatus)stat);
            }
            catch (IOException e) {
                Status stat = new Status(4, "com.ibm.etools.javaee.core", NLS.bind((String)JavaEEXMLResourceHandler.JavaEEFacetVersionChangeDelegate_Error_occured_upgrading_namespace_f_, (Object)res.getURI()), (Throwable)e);
                throw new CoreException((IStatus)stat);
            }
        }
        finally {
            res.unload();
        }
    }

    private void updateNamespace(JavaEEResourceImpl res) throws CoreException {
        EMF2DOMSSERenderer renderer = (EMF2DOMSSERenderer)res.getRenderer();
        IDOMDocument doc = this.getUpdatedDoc(renderer);
        try {
            try {
                doc.getModel().save();
            }
            catch (CoreException e) {
                Status stat = new Status(4, "com.ibm.etools.javaee.core", NLS.bind((String)JavaEEXMLResourceHandler.JavaEEFacetVersionChangeDelegate_Error_occured_upgrading_namespace_f_, (Object)res.getURI()), (Throwable)e);
                throw new CoreException((IStatus)stat);
            }
            catch (IOException e) {
                Status stat = new Status(4, "com.ibm.etools.javaee.core", NLS.bind((String)JavaEEXMLResourceHandler.JavaEEFacetVersionChangeDelegate_Error_occured_upgrading_namespace_f_, (Object)res.getURI()), (Throwable)e);
                throw new CoreException((IStatus)stat);
            }
        }
        finally {
            res.unload();
        }
    }

    private IDOMDocument getUpdatedDoc(EMF2DOMSSERenderer renderer) {
        IDOMDocument doc = renderer.getXMLModel().getDocument();
        IDOMElement root = (IDOMElement)doc.getDocumentElement();
        Attr attrXML_NS = root.getAttributeNode("xmlns");
        if (attrXML_NS == null) {
            attrXML_NS = doc.createAttribute("xmlns");
            root.setAttributeNode(attrXML_NS);
        }
        attrXML_NS.setNodeValue(this.getXML_NS());
        Attr attrXSI_SCHEMA_LOCATION = root.getAttributeNode("xsi:schemaLocation");
        if (attrXSI_SCHEMA_LOCATION == null) {
            attrXSI_SCHEMA_LOCATION = doc.createAttribute("xsi:schemaLocation");
            root.setAttributeNode(attrXSI_SCHEMA_LOCATION);
        }
        attrXSI_SCHEMA_LOCATION.setNodeValue(this.getSchemaLocation());
        Attr attrVERSION = root.getAttributeNode("version");
        if (attrVERSION == null) {
            attrVERSION = doc.createAttribute("version");
            root.setAttributeNode(attrVERSION);
        }
        attrVERSION.setNodeValue(this.getVersionText());
        return doc;
    }

    private void migrateJaxRpcWSDDIfNecessary(IProject project) throws CoreException {
        block9: {
            WSDDArtifactEdit edit = null;
            try {
                WsddResource resource;
                edit = WSDDArtifactEdit.getWSDDArtifactEditForRead((IProject)project);
                if (edit == null || (resource = edit.getWsddXmiResource()) == null) break block9;
                resource.setVersionID(this.getJ2EEVersion());
                if (resource.getContents().isEmpty()) break block9;
                EObject rootObject = resource.getRootObject();
                resource.getContents().remove((Object)rootObject);
                resource.getContents().add((Object)rootObject);
                try {
                    resource.saveIfNecessary();
                    return;
                }
                catch (Exception e) {
                    try {
                        Status stat = new Status(4, "com.ibm.etools.javaee.core", JavaEEXMLResourceHandler.JavaEEFacetVersionChangeDelegate_Error_occured_migrating_webservices_, (Throwable)e);
                        throw new CoreException((IStatus)stat);
                    }
                    catch (IllegalArgumentException e2) {
                        Status stat = new Status(4, "com.ibm.etools.javaee.core", JavaEEXMLResourceHandler.JavaEEFacetVersionChangeDelegate_Error_occured_migrating_webservices_, (Throwable)e2);
                        throw new CoreException((IStatus)stat);
                    }
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
    }

    private void setTargetFacet(IProjectFacetVersion fv) {
        this.targetFacet = fv;
    }

    protected abstract String getVersionText();

    protected abstract String getSchemaLocation();

    protected abstract int getJ2EEVersion();

    protected void updateModelProvider(IProjectFacet facet, IProject project) {
        JEE5ModelProviderUtil.removeProvider(facet, project);
    }

    protected String getXML_NS() {
        int version = this.getJ2EEVersion();
        if (version == 50 || version == 60) {
            return "http://java.sun.com/xml/ns/javaee";
        }
        return "http://xmlns.jcp.org/xml/ns/javaee";
    }
}

