/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.project.facet;

import com.ibm.etools.j2ee.J2EEProjectUtilities;
import com.ibm.etools.javaee.core.JavaEEPlugin;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFFacetException;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtilFactory;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class JSFFacetVersionChangeDelegate
implements IDelegate {
    private boolean isJEE6 = true;
    private final String XML_NS_XSI = "xmlns:xsi";
    private final String XML_NS = "xmlns";
    private final String XSI_SCHEMA_LOCATION = "xsi:schemaLocation";
    private final String XSI_NS_URL = "http://www.w3.org/2001/XMLSchema-instance";
    private final String JAVAEE_NS_URL = "http://java.sun.com/xml/ns/javaee";
    private final String JAVAEE7_NS_URL = "http://xmlns.jcp.org/xml/ns/javaee";
    private final String VERSION = "version";
    private final String JSF_DD__SCHEMA_LOCATION1 = "/web-facesconfig_";
    private final String JSF_DD__SCHEMA_LOCATION2 = ".xsd";
    private final String DELIIMTER_COMMA = ",";

    public void execute(IProject project, IProjectFacetVersion jsfFacetVersion, Object actionConfig, IProgressMonitor monitor) throws CoreException {
        JSFUtils jsfUtil = new JSFUtilFactory().create(jsfFacetVersion, ModelProviderManager.getModelProvider((IProject)project));
        if (jsfUtil == null) {
            throw new JSFFacetException(NLS.bind((String)Messages.Could_Not_GetJSFVersion, (Object)jsfFacetVersion.toString()));
        }
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        ArrayList<IPath> pathJSFConfigs = this.getJSFConfigFilePath(jsfUtil, project);
        boolean bl = this.isJEE6 = jsfFacetVersion.getVersionString().compareTo("2.2") < 0;
        if (monitor != null) {
            monitor.worked(20);
        }
        for (IPath pathJSFConfig : pathJSFConfigs) {
            IFile facesFile;
            IResource configFile = ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder().findMember(pathJSFConfig);
            if (!(configFile instanceof IFile) || !(facesFile = (IFile)configFile).exists()) continue;
            try {
                this.updateNamespace(facesFile, jsfUtil.getVersion());
            }
            catch (Exception exception) {
                JavaEEPlugin.logError("Failed to update the CDI beans.xml during facet change.", exception);
            }
        }
        if (monitor != null) {
            monitor.worked(20);
        }
        project.refreshLocal(2, monitor);
        if (monitor != null) {
            monitor.done();
        }
    }

    private void updateNamespace(IFile file, JSFVersion version) throws Exception {
        InputStream inputStream = file.getContents();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document document = dBuilder.parse(inputStream);
        this.updateAttributes(document, version);
        J2EEProjectUtilities.saveXMLFileContent(file, document);
    }

    private void updateAttributes(Document document, JSFVersion version) {
        Element root = document.getDocumentElement();
        this.updateAttribute(document, root, "xmlns:xsi", this.getattrXML_NS_XSI());
        Attr attrXML_NS = root.getAttributeNode("xmlns");
        if (attrXML_NS == null) {
            attrXML_NS = document.createAttribute("xmlns");
            root.setAttributeNode(attrXML_NS);
        }
        attrXML_NS.setNodeValue(this.getXML_NS());
        Attr attrXSI_SCHEMA_LOCATION = root.getAttributeNode("xsi:schemaLocation");
        if (attrXSI_SCHEMA_LOCATION == null) {
            attrXSI_SCHEMA_LOCATION = document.createAttribute("xsi:schemaLocation");
            root.setAttributeNode(attrXSI_SCHEMA_LOCATION);
        }
        String schemaVersionString = version.toString().replaceAll("\\.", "_");
        attrXSI_SCHEMA_LOCATION.setNodeValue(this.getSchemaLocation(schemaVersionString));
        Attr attrVERSION = root.getAttributeNode("version");
        if (attrVERSION == null) {
            attrVERSION = document.createAttribute("version");
            root.setAttributeNode(attrVERSION);
        }
        attrVERSION.setNodeValue(version.toString());
    }

    private void updateAttribute(Document document, Element root, String attributeName, String attributeValue) throws DOMException {
        Attr attribute = root.getAttributeNode(attributeName);
        if (attribute == null) {
            attribute = document.createAttribute(attributeName);
            root.setAttributeNode(attribute);
        }
        attribute.setNodeValue(attributeValue);
    }

    private ArrayList<IPath> getJSFConfigFilePath(JSFUtils jsfUtil, IProject project) {
        String[] fileNamesJSF;
        ArrayList<IPath> pathList = new ArrayList<IPath>();
        pathList.add((IPath)new Path("/WEB-INF/faces-config.xml"));
        if (!JavaEEProjectUtilities.deploymentDescriptorExists((IProject)project)) {
            return pathList;
        }
        WebApp webApp = (WebApp)ModelProviderManager.getModelProvider((IProject)project).getModelObject();
        String fileNamesListJSF = this.getContextParam(webApp);
        if (fileNamesListJSF == null || fileNamesListJSF.length() == 0) {
            return pathList;
        }
        String[] stringArray = fileNamesJSF = fileNamesListJSF.split(",");
        int n = fileNamesJSF.length;
        int n2 = 0;
        while (n2 < n) {
            String fileNameJSF = stringArray[n2];
            Path path = new Path(fileNameJSF.trim());
            if (!pathList.contains(path)) {
                pathList.add((IPath)path);
            }
            ++n2;
        }
        return pathList;
    }

    private String getContextParam(WebApp webApp) {
        String paramName = "javax.faces.CONFIG_FILES";
        String fileNames = "";
        List contextList = webApp.getContextParams();
        for (ParamValue context : contextList) {
            if (context.getParamName() == null || !context.getParamName().trim().equals(paramName)) continue;
            fileNames = String.valueOf(fileNames) + context.getParamValue() + ",";
        }
        if (fileNames.length() == 0) {
            return null;
        }
        return fileNames.substring(0, fileNames.length() - ",".length());
    }

    private String getSchemaLocation(String versionNum) {
        return String.valueOf(this.getXML_NS()) + " " + this.getXML_NS() + "/web-facesconfig_" + versionNum + ".xsd";
    }

    private String getattrXML_NS_XSI() {
        return "http://www.w3.org/2001/XMLSchema-instance";
    }

    private String getXML_NS() {
        if (this.isJEE6) {
            return "http://java.sun.com/xml/ns/javaee";
        }
        return "http://xmlns.jcp.org/xml/ns/javaee";
    }
}

