/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.model.internal;

import com.ibm.etools.javaee.annotations.base.EMF2AnnotationModelBaseProvider;
import com.ibm.etools.javaee.core.JavaEEPlugin;
import com.ibm.etools.javaee.core.JavaEEResourceImpl;
import com.ibm.etools.javaee.core.WebResourceImpl;
import com.ibm.etools.javaee.merge.MergeUtil;
import com.ibm.etools.javaee.merge.WebMergedModelAdapter;
import com.ibm.etools.javaee.merge.WebStructureChangedAdapter;
import com.ibm.etools.javaee.model.internal.Ejb3ModelProvider;
import com.ibm.etools.javaee.model.internal.EjbInWarModelProvider;
import com.ibm.etools.javaee.model.internal.IJEE5ModelProvider;
import com.ibm.etools.javaee.model.internal.JEE5ModelProvider;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebAppDeploymentDescriptor;
import org.eclipse.jst.javaee.web.WebAppVersionType;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.javaee.web.internal.impl.WebAppImpl;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class Web25ModelProvider
extends JEE5ModelProvider {
    protected IModelProvider ejbInWarModelProvider;
    protected boolean allowEjbsInWars = true;
    private static final String WAR25_CONTENT_TYPE = "org.eclipse.jst.jee.ee5webDD";
    private WebStructureChangedAdapter wscAdapter;
    private static boolean debug = false;
    private Object lockObject = new Object();
    protected Reference<EObject> cachedAnnotationsModelRef = null;
    private Reference<WebApp> cachedMergeModelRef = null;

    static {
        try {
            String debugS = System.getProperty("com.ibm.etools.javaee.merge.DEBUG");
            if (debugS != null) {
                debug = true;
            }
        }
        catch (Throwable throwable) {}
    }

    public Web25ModelProvider(IProject proj) {
        int j2eeDDProjectVersion;
        this.proj = proj;
        String ddVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)proj);
        if (ddVersion != null && (j2eeDDProjectVersion = J2EEVersionUtil.convertVersionStringToInt((String)ddVersion)) < 25) {
            this.useLegacy = true;
        }
        this.setDefaultResourcePath(IJEE5ModelProvider.WEB_DD_MODEL_MERGED);
        this.wscAdapter = new WebStructureChangedAdapter();
    }

    protected Object getAnnotationsModel() {
        EObject result = null;
        if (this.cachedAnnotationsModelRef != null) {
            result = this.cachedAnnotationsModelRef.get();
        }
        if (result == null) {
            result = EMF2AnnotationModelBaseProvider.getInstance().getTopLevelAnnotationObject(this.proj, IJEE5ModelProvider.WEB_DD_MODEL_XML_NODEVICE);
            this.cachedAnnotationsModelRef = new SoftReference<EObject>(result);
        }
        return result;
    }

    @Override
    protected EnterpriseArtifactEdit createArtifactEdit() {
        return WebArtifactEdit.getWebArtifactEditForRead((IProject)this.proj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getModelObject(IPath modelPath) {
        IPath modelPathNoDevice = modelPath.setDevice(null);
        if (this.useLegacy) {
            return this.getLegacyDDArtifactEdit().getModelObject(modelPathNoDevice);
        }
        if (IJEE5ModelProvider.EJB_IN_WAR_DD_MODEL_XML_NODEVICE.equals((Object)modelPathNoDevice)) {
            this.initEjbInWarModelProvider();
            if (this.ejbInWarModelProvider != null) {
                return this.ejbInWarModelProvider.getModelObject(modelPath);
            }
            return null;
        }
        if (this.getWritableResource() != null) {
            return this.getXMLModel(modelPath);
        }
        String device = modelPath.getDevice();
        if (device == null || "xmlonly:".equals(device) && IJEE5ModelProvider.WEB_DD_MODEL_XML_NODEVICE.equals((Object)modelPathNoDevice)) {
            return this.getXMLModel(modelPath);
        }
        if ("annotated:".equals(device) && IJEE5ModelProvider.WEB_DD_MODEL_XML_NODEVICE.equals((Object)modelPathNoDevice)) {
            return this.getAnnotationsModel();
        }
        if ("merged:".equals(device) && IJEE5ModelProvider.WEB_DD_MODEL_XML_NODEVICE.equals((Object)modelPathNoDevice)) {
            WebApp result = null;
            Object object = this.lockObject;
            synchronized (object) {
                if (this.cachedMergeModelRef != null) {
                    result = this.cachedMergeModelRef.get();
                }
                if (result == null) {
                    WebApp annotationsRoot = (WebApp)this.getModelObject(IJEE5ModelProvider.WEB_DD_MODEL_ANNOTATIONS);
                    WebApp xmlRoot = (WebApp)this.getModelObject(IJEE5ModelProvider.WEB_DD_MODEL_XML_NODEVICE);
                    if (xmlRoot == null) {
                        result = annotationsRoot;
                    } else if (annotationsRoot == null) {
                        result = xmlRoot;
                    } else {
                        MergeUtil.removeStaleAdapters((EObject)annotationsRoot);
                        List<List> orderedLists = MergeUtil.getOrderedLists(this.proj, xmlRoot);
                        List fragmentsXml = orderedLists.get(0);
                        List fragmentsAnno = orderedLists.get(1);
                        if (fragmentsXml.size() == 0 && fragmentsAnno.size() == 0) {
                            result = MergeUtil.compose(xmlRoot, annotationsRoot);
                        } else {
                            int i = 0;
                            while (i < fragmentsXml.size()) {
                                MergeUtil.removeStaleAdapters((EObject)fragmentsXml.get(i));
                                ++i;
                            }
                            i = 0;
                            while (i < fragmentsAnno.size()) {
                                MergeUtil.removeStaleAdapters((EObject)fragmentsAnno.get(i));
                                ++i;
                            }
                            boolean metadataComplete = xmlRoot.isMetadataComplete();
                            result = metadataComplete ? MergeUtil.compose(xmlRoot, annotationsRoot) : MergeUtil.compose(xmlRoot, annotationsRoot, fragmentsXml, fragmentsAnno);
                        }
                        if (debug) {
                            TestAdapter tA = new TestAdapter();
                            ((EObject)result).eAdapters().add((Object)tA);
                        }
                        boolean hasWsca = false;
                        Object[] listenerList = this.listeners.getListeners();
                        int i = 0;
                        while (i < listenerList.length) {
                            if (listenerList[i] instanceof WebStructureChangedAdapter) {
                                WebStructureChangedAdapter adp = (WebStructureChangedAdapter)((Object)listenerList[i]);
                                adp.updateAdapter((EObject)xmlRoot, (EObject)annotationsRoot, (EObject)result);
                                hasWsca = true;
                            }
                            ++i;
                        }
                        if (!hasWsca) {
                            this.wscAdapter.initialize((EObject)xmlRoot, (EObject)annotationsRoot, (EObject)result);
                            this.addListener(this.wscAdapter);
                            Resource projResource = ((EObject)xmlRoot).eResource();
                            IVirtualComponent webComponent = ComponentCore.createComponent((IProject)WorkbenchResourceHelper.getProject((Resource)projResource));
                            List webFragmentComponents = WebUtilities.getWebFragments((IVirtualComponent)webComponent);
                            MergeUtil.setStructureChangeListenersOnWebFragments(this.wscAdapter, webFragmentComponents);
                            List<IVirtualComponent> ejbLibs = MergeUtil.getEJBLibModules(WebUtilities.getLibModules((IProject)WorkbenchResourceHelper.getProject((Resource)projResource)));
                            for (IVirtualComponent ejbLib : ejbLibs) {
                                if (ejbLib.isBinary()) continue;
                                Ejb3ModelProvider ejbModelProvider = (Ejb3ModelProvider)ModelProviderManager.getModelProvider((IProject)ejbLib.getProject());
                                ejbModelProvider.addListener(this.wscAdapter);
                            }
                        }
                    }
                    this.cachedMergeModelRef = new SoftReference<WebApp>(result);
                }
            }
            return result;
        }
        return null;
    }

    protected Object getXMLModel(IPath modelPath) {
        WebResourceImpl webRes = (WebResourceImpl)this.getModelResource(modelPath);
        if (webRes != null && webRes.getContents().size() > 0) {
            if (webRes.getRootObject() instanceof WebAppDeploymentDescriptor) {
                return ((WebAppDeploymentDescriptor)webRes.getRootObject()).getWebApp();
            }
            return webRes.getRootObject();
        }
        return null;
    }

    @Override
    protected String getContentTypeDescriber() {
        return WAR25_CONTENT_TYPE;
    }

    @Override
    public void populateRoot(XMLResourceImpl res, String name) {
        WebApp war = WebFactory.eINSTANCE.createWebApp();
        war.setVersion(WebAppVersionType._25_LITERAL);
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        war.getDisplayNames().add(dn);
        res.getContents().add((Object)((EObject)war));
    }

    @Override
    public void populateRoot(XMLResourceImpl res, String name, String version) {
        WebApp war = WebFactory.eINSTANCE.createWebApp();
        if (version.equals("2.5")) {
            war.setVersion(WebAppVersionType._25_LITERAL);
        } else if (version.equals("3.0")) {
            war.setVersion(WebAppVersionType._30_LITERAL);
        } else if (version.equals("3.1")) {
            war.setVersion(WebAppVersionType._31);
        } else if (version.equals("4.0")) {
            war.setVersion(WebAppVersionType._40);
        }
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        war.getDisplayNames().add(dn);
        res.getContents().add((Object)((EObject)war));
    }

    @Override
    public void modelsChanged(IModelProviderEvent anEvent) {
        int code = anEvent.getEventCode();
        switch (code) {
            case 4: 
            case 64: {
                List resList = anEvent.getChangedResources();
                if (resList.size() == 1 && resList.get(0) instanceof WebResourceImpl) {
                    this.cachedMergeModelRef = null;
                    super.modelsChanged(anEvent);
                    return;
                }
                if (!this.hasResourceReference(anEvent.getChangedResources())) break;
                this.clearMergedCaches();
            }
        }
        super.modelsChanged(anEvent);
    }

    private void clearMergedCaches() {
        this.cachedMergeModelRef = null;
        this.cachedAnnotationsModelRef = null;
    }

    @Override
    public void modify(Runnable runnable, IPath modelPath) {
        if (modelPath != null && IJEE5ModelProvider.EJB_IN_WAR_DD_MODEL_XML_NODEVICE.equals((Object)modelPath.setDevice(null))) {
            this.initEjbInWarModelProvider();
            this.ejbInWarModelProvider.modify(runnable, modelPath);
        } else if (this.useLegacy) {
            this.getLegacyDDArtifactEdit().modify(runnable, modelPath);
        } else {
            try {
                try {
                    final JavaEEResourceImpl res = (JavaEEResourceImpl)this.getModelResource(IJEE5ModelProvider.WEB_DD_MODEL_XML);
                    if (res != null) {
                        this.setWritableResource((XMLResourceImpl)res);
                        res.setTrackingModification(true);
                    }
                    runnable.run();
                    final JavaEEResourceImpl newRes = (JavaEEResourceImpl)this.getModelResource(IJEE5ModelProvider.WEB_DD_MODEL_XML);
                    try {
                        if (res != null && (res.isModified() || newRes != null && newRes.isModified() || modelPath != null && modelPath.equals((Object)IModelProvider.FORCESAVE))) {
                            IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)res);
                            if (modelPath != null && modelPath.equals((Object)IModelProvider.FORCESAVE) || modelPath == null && file != null && !file.exists()) {
                                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                                workspace.run(new IWorkspaceRunnable(){

                                    public void run(IProgressMonitor monitor) throws CoreException {
                                        try {
                                            if (res.getResourceSet() == null && newRes != null) {
                                                newRes.save(Collections.EMPTY_MAP, true);
                                            } else {
                                                res.save(Collections.EMPTY_MAP, true);
                                            }
                                        }
                                        catch (IOException e) {
                                            JavaEEPlugin.logError(e);
                                        }
                                    }
                                }, (IProgressMonitor)new NullProgressMonitor());
                            } else if (res.getResourceSet() == null && newRes != null) {
                                newRes.save(Collections.EMPTY_MAP);
                            } else {
                                res.save(Collections.EMPTY_MAP);
                            }
                        }
                    }
                    catch (IOException e) {
                        JavaEEPlugin.logError(e);
                    }
                }
                catch (Exception ex) {
                    JavaEEPlugin.logError(ex);
                    this.setWritableResource(null);
                }
            }
            finally {
                this.setWritableResource(null);
            }
        }
    }

    @Override
    protected XMLResourceImpl getModelResource(IPath modelPath) {
        IPath modelPathNoDevice = modelPath.setDevice(null);
        return super.getModelResource(modelPathNoDevice);
    }

    @Override
    public void projectClosed() {
        WebMergedModelAdapter adapter;
        WebApp mergedModel;
        if (this.cachedMergeModelRef != null && (mergedModel = this.cachedMergeModelRef.get()) != null && (adapter = MergeUtil.getWebMMAdapterFromEObject((EObject)mergedModel)) != null) {
            ArrayList<IModelProviderListener> removeListeners = MergeUtil.removeAdaptersOnProjectClose(adapter, (EObject)mergedModel, this.listeners.getListeners());
            for (IModelProviderListener listener : removeListeners) {
                this.removeListener(listener);
            }
        }
        this.clearMergedCaches();
        super.projectClosed();
    }

    @Override
    protected String getVersionString() {
        IProjectFacetVersion facetVersion = Web25ModelProvider.getDefaultFacet(this.proj);
        return facetVersion.getVersionString();
    }

    protected void initEjbInWarModelProvider() {
        if (this.ejbInWarModelProvider == null && this.allowEjbsInWars) {
            String ddVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)this.proj);
            int j2eeFacetVersion = J2EEVersionUtil.convertVersionStringToInt((String)ddVersion);
            if (j2eeFacetVersion >= 30) {
                this.ejbInWarModelProvider = new EjbInWarModelProvider(this.proj);
            } else {
                this.allowEjbsInWars = false;
            }
        }
    }

    public IModelProvider getEjbInWarModelProvider() {
        this.initEjbInWarModelProvider();
        return this.ejbInWarModelProvider;
    }

    class TestAdapter
    extends AdapterImpl {
        String id = Integer.toHexString(System.identityHashCode((Object)this));

        TestAdapter() {
            System.out.println("New TestAdapter: " + this.id);
        }

        public void notifyChanged(Notification notification) {
            System.out.println("=== TestAdapter " + this.id + " : ");
            System.out.println("\tType " + notification.getEventType());
            System.out.println("\tfrom " + notification.getNotifier());
            System.out.println("\tfeature " + notification.getFeature());
            System.out.println("\toldValue " + notification.getOldValue());
            System.out.println("\tnewValue " + notification.getNewValue());
            if (notification.getEventType() == 8) {
                System.out.println("====== TA - REMOVING_ADAPTER event: ");
                if (notification.getNotifier() instanceof WebAppImpl) {
                    System.out.println("======== !! removing adapter from WebAppImpl");
                }
            }
        }
    }
}

