/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.model.internal;

import com.ibm.etools.javaee.core.JcaResourceImpl;
import com.ibm.etools.javaee.model.internal.JEE5ModelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.jca.modulecore.util.ConnectorArtifactEdit;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.jca.Connector;
import org.eclipse.jst.javaee.jca.ConnectorDeploymentDescriptor;
import org.eclipse.jst.javaee.jca.JcaFactory;
import org.eclipse.jst.javaee.jca.ResourceAdapter;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class Connector16ModelProvider
extends JEE5ModelProvider {
    private static final String CONNECTOR_1_6_CONTENT_TYPE = "org.eclipse.jst.jee.ee6connectorDD";

    public Connector16ModelProvider(IProject proj) {
        int j2eeDDProjectVersion;
        this.proj = proj;
        String ddVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)proj);
        if (ddVersion != null && (j2eeDDProjectVersion = J2EEVersionUtil.convertVersionStringToInt((String)ddVersion)) < 16) {
            this.useLegacy = true;
        }
        this.setDefaultResourcePath((IPath)new Path("META-INF/ra.xml"));
    }

    @Override
    public Object getModelObject(IPath modelPath) {
        if (this.useLegacy) {
            return this.getLegacyDDArtifactEdit().getModelObject(modelPath);
        }
        JcaResourceImpl connectorRes = (JcaResourceImpl)this.getModelResource(modelPath);
        if (connectorRes != null && connectorRes.getContents().size() > 0) {
            if (connectorRes.getRootObject() instanceof ConnectorDeploymentDescriptor) {
                return ((ConnectorDeploymentDescriptor)connectorRes.getRootObject()).getConnector();
            }
            return connectorRes.getRootObject();
        }
        return null;
    }

    @Override
    protected EnterpriseArtifactEdit createArtifactEdit() {
        return ConnectorArtifactEdit.getConnectorArtifactEditForRead((IProject)this.proj);
    }

    @Override
    protected String getContentTypeDescriber() {
        return CONNECTOR_1_6_CONTENT_TYPE;
    }

    @Override
    public void populateRoot(XMLResourceImpl res, String name) {
        Connector connector = JcaFactory.eINSTANCE.createConnector();
        connector.setVersion("1.6");
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        connector.getDisplayNames().add(dn);
        res.getContents().add((Object)((EObject)connector));
    }

    @Override
    public void populateRoot(XMLResourceImpl res, String name, String version) {
        Connector connector = JcaFactory.eINSTANCE.createConnector();
        connector.setVersion(version);
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        connector.getDisplayNames().add(dn);
        String emptyString = "";
        connector.setVendorName(emptyString);
        connector.setEisType(emptyString);
        connector.setResourceadapterVersion(emptyString);
        ResourceAdapter resourceAdpater = JcaFactory.eINSTANCE.createResourceAdapter();
        connector.setResourceadapter(resourceAdpater);
        res.getContents().add((Object)((EObject)connector));
    }

    @Override
    protected String getVersionString() {
        IProjectFacetVersion facetVersion = Connector16ModelProvider.getDefaultFacet(this.proj);
        return facetVersion.getVersionString();
    }
}

