/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.model.internal;

import com.ibm.etools.j2ee.J2EEProjectUtilities;
import com.ibm.etools.javaee.core.AppClientResourceImpl;
import com.ibm.etools.javaee.model.internal.JEE5ModelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.javaee.applicationclient.ApplicationClient;
import org.eclipse.jst.javaee.applicationclient.ApplicationClientDeploymentDescriptor;
import org.eclipse.jst.javaee.applicationclient.ApplicationclientFactory;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class AppClient5ModelProvider
extends JEE5ModelProvider {
    private static final String APPCLIENT5_CONTENT_TYPE = "org.eclipse.jst.jee.ee5appclientDD";

    public AppClient5ModelProvider(IProject proj) {
        int j2eeDDProjectVersion;
        this.proj = proj;
        String ddVersion = J2EEProjectUtilities.getJ2EEDDProjectVersion(proj);
        if (ddVersion != null && (j2eeDDProjectVersion = J2EEVersionUtil.convertVersionStringToInt((String)J2EEProjectUtilities.getJ2EEDDProjectVersion(proj))) < 50) {
            this.useLegacy = true;
        }
        this.setDefaultResourcePath((IPath)new Path("META-INF/application-client.xml"));
    }

    @Override
    public Object getModelObject(IPath modelPath) {
        if (this.useLegacy) {
            return this.getLegacyDDArtifactEdit().getModelObject(modelPath);
        }
        AppClientResourceImpl appRes = (AppClientResourceImpl)this.getModelResource(modelPath);
        if (appRes != null && appRes.getContents().size() > 0) {
            if (appRes.getRootObject() instanceof ApplicationClientDeploymentDescriptor) {
                return ((ApplicationClientDeploymentDescriptor)appRes.getRootObject()).getApplicationClient();
            }
            return appRes.getRootObject();
        }
        return null;
    }

    @Override
    protected EnterpriseArtifactEdit createArtifactEdit() {
        return AppClientArtifactEdit.getAppClientArtifactEditForRead((IProject)this.proj);
    }

    @Override
    protected String getContentTypeDescriber() {
        return APPCLIENT5_CONTENT_TYPE;
    }

    @Override
    public void populateRoot(XMLResourceImpl res, String name) {
        ApplicationClient client = ApplicationclientFactory.eINSTANCE.createApplicationClient();
        client.setVersion("5");
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        client.getDisplayNames().add(dn);
        res.getContents().add((Object)((EObject)client));
    }

    @Override
    public void populateRoot(XMLResourceImpl res, String name, String version) {
        ApplicationClient client = ApplicationclientFactory.eINSTANCE.createApplicationClient();
        client.setVersion(version);
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        client.getDisplayNames().add(dn);
        res.getContents().add((Object)((EObject)client));
    }

    @Override
    protected String getVersionString() {
        IProjectFacetVersion facetVersion = AppClient5ModelProvider.getDefaultFacet(this.proj);
        if (facetVersion.getVersionString().equals("5.0")) {
            return "5";
        }
        if (facetVersion.getVersionString().equals("6.0")) {
            return "6";
        }
        if (facetVersion.getVersionString().equals("7.0")) {
            return "7";
        }
        if (facetVersion.getVersionString().equals("8.0")) {
            return "8";
        }
        return null;
    }
}

