/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.merge;

import com.ibm.etools.javaee.core.JavaEEPlugin;
import com.ibm.etools.javaee.merge.MergeUtil;
import com.ibm.etools.javaee.merge.MergedModelAdapter2;
import com.ibm.etools.javaee.merge.WebMergedModelAdapter;
import com.ibm.etools.javaee.model.internal.Ejb3ModelProvider;
import com.ibm.etools.javaee.model.internal.IJEE5ModelProvider;
import com.ibm.etools.javaee.model.internal.Web25ModelProvider;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class WebStructureChangedAdapter
extends AdapterImpl
implements IResourceChangeListener,
IResourceDeltaVisitor,
IModelProviderListener {
    EObject mergedObj;
    EObject xmlObj;
    EObject annotationObj;
    private static final String REBUILD_MERGE_MODEL_JOB = "Build Merge Model Job";
    private HashMap<IPath, Boolean> webFragments = new HashMap();
    boolean rebuildRequired = false;
    IModelProviderEvent scheduledEvent = null;
    final ILock lock = Job.getJobManager().newLock();

    public void initialize(EObject xmlObj, EObject annotationObj, EObject merged) {
        this.mergedObj = merged;
        this.xmlObj = xmlObj;
        this.annotationObj = annotationObj;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void updateAdapter(EObject xmlObj, EObject annotationObj, EObject merged) {
        this.mergedObj = merged;
        this.xmlObj = xmlObj;
        this.annotationObj = annotationObj;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                try {
                    WebMergedModelAdapter wmma;
                    this.rebuildRequired = false;
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                    if (!this.rebuildRequired || (wmma = this.getMergedModelAdapterForRoot()) == null) break;
                    Job job = new Job(REBUILD_MERGE_MODEL_JOB){

                        protected IStatus run(IProgressMonitor monitor) {
                            WebStructureChangedAdapter.waitForClasspathUpdate();
                            try {
                                WebStructureChangedAdapter.this.lock.acquire();
                                wmma.reorderAndRebuildMergedModel(WebStructureChangedAdapter.this.xmlObj.eResource());
                                IStatus iStatus = Status.OK_STATUS;
                                return iStatus;
                            }
                            finally {
                                WebStructureChangedAdapter.this.lock.release();
                            }
                        }
                    };
                    job.setPriority(50);
                    job.schedule();
                    break;
                }
                catch (CoreException e) {
                    JavaEEPlugin.logError(e);
                }
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta.getFlags() == 131072) {
            return false;
        }
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                IProject proj;
                return this.xmlObj.eResource() != null && (proj = WorkbenchResourceHelper.getProject((Resource)this.xmlObj.eResource())) != null && resource.equals((Object)proj);
            }
            case 2: {
                String name = resource.getName();
                if (name.equals("WebContent") || name.equals("WEB-INF")) {
                    return true;
                }
                String[] pathSegments = resource.getProjectRelativePath().segments();
                return pathSegments.length == 3 && pathSegments[pathSegments.length - 1].equals("lib") && pathSegments[pathSegments.length - 2].equals("WEB-INF");
            }
            case 1: {
                if (!resource.getFileExtension().endsWith("jar")) break;
                IPath resourceLocation = resource.getLocation();
                if (resource.exists()) {
                    JavaEEQuickPeek qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek((IPath)resource.getLocation());
                    if (qp.getType() != 6) break;
                    this.webFragments.put(resourceLocation, true);
                    this.rebuildRequired = true;
                    break;
                }
                if (delta.getKind() != 2 || !this.webFragments.containsKey(resourceLocation) || !this.webFragments.get(resourceLocation).booleanValue()) break;
                this.webFragments.remove(resourceLocation);
                this.rebuildRequired = true;
            }
        }
        return false;
    }

    public void modelsChanged(IModelProviderEvent event) {
        int code = event.getEventCode();
        switch (code) {
            case 512: {
                IVirtualComponent webComponent;
                Resource xmlRes;
                if (this.scheduledEvent != null && this.scheduledEvent.getModel().equals(event.getModel()) && this.scheduledEvent.getProject().equals((Object)event.getProject())) {
                    return;
                }
                if (!(this.mergedObj instanceof WebApp)) break;
                final IModelProvider modelProvider = event.getModel();
                final WebMergedModelAdapter wmma = this.getMergedModelAdapterForRoot();
                if (wmma == null || (xmlRes = this.xmlObj.eResource()) == null || (webComponent = ComponentCore.createComponent((IProject)WorkbenchResourceHelper.getProject((Resource)xmlRes))) == null) break;
                Job job = new Job(REBUILD_MERGE_MODEL_JOB){

                    protected IStatus run(IProgressMonitor monitor) {
                        WebStructureChangedAdapter.waitForClasspathUpdate();
                        try {
                            EJBJar ejbJar;
                            WebStructureChangedAdapter.this.lock.acquire();
                            if (!(modelProvider instanceof Ejb3ModelProvider)) {
                                wmma.reorderAndRebuildMergedModel(WebStructureChangedAdapter.this.xmlObj.eResource());
                                List webFragmentComponents = WebUtilities.getWebFragments((IVirtualComponent)webComponent);
                                MergeUtil.setStructureChangeListenersOnWebFragments(WebStructureChangedAdapter.this, webFragmentComponents);
                            }
                            if ((modelProvider instanceof Web25ModelProvider || modelProvider instanceof Ejb3ModelProvider) && (ejbJar = modelProvider instanceof Web25ModelProvider ? (EJBJar)((Web25ModelProvider)modelProvider).getModelObject(IJEE5ModelProvider.EJB_IN_WAR_DD_MODEL_MERGED) : (EJBJar)((Web25ModelProvider)ModelProviderManager.getModelProvider((IProject)WorkbenchResourceHelper.getProject((Resource)xmlRes))).getModelObject(IJEE5ModelProvider.EJB_IN_WAR_DD_MODEL_MERGED)) != null) {
                                List<IVirtualComponent> ejbLibs = MergeUtil.getEJBLibModules(WebUtilities.getLibModules((IProject)WorkbenchResourceHelper.getProject((Resource)xmlRes)));
                                MergedModelAdapter2 ejbInWarAdapter = MergeUtil.getAdapterFromEObject((EObject)ejbJar);
                                ejbInWarAdapter.rebuildAndReuseMergedModel(xmlRes);
                                if (ejbLibs.size() > 0) {
                                    MergeUtil.setStructureChangeListenersOnWebFragments(WebStructureChangedAdapter.this, ejbLibs);
                                }
                            }
                            WebStructureChangedAdapter.this.scheduledEvent = null;
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        finally {
                            WebStructureChangedAdapter.this.lock.release();
                        }
                    }
                };
                job.setPriority(50);
                job.schedule();
                this.scheduledEvent = event;
            }
        }
    }

    private static void waitForClasspathUpdate() {
        Job[] jobs = Job.getJobManager().find((Object)J2EEComponentClasspathUpdater.MODULE_UPDATE_JOB_NAME);
        if (jobs.length > 0) {
            try {
                int i = 0;
                while (i < jobs.length) {
                    if (jobs[i].getName().equals(J2EEComponentClasspathUpdater.MODULE_UPDATE_JOB_NAME)) {
                        jobs[i].join();
                    }
                    ++i;
                }
            }
            catch (InterruptedException e) {
                JavaEEPlugin.logError(e);
            }
        }
    }

    private WebMergedModelAdapter getMergedModelAdapterForRoot() {
        WebMergedModelAdapter wmma = null;
        for (Adapter adapter : this.mergedObj.eAdapters()) {
            if (!(adapter instanceof WebMergedModelAdapter)) continue;
            wmma = (WebMergedModelAdapter)adapter;
            if (wmma.xmlObject == this.xmlObj && wmma.mergedObject == this.mergedObj) break;
        }
        return wmma;
    }
}

