/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.merge;

import com.ibm.etools.javaee.core.JavaEEPlugin;
import com.ibm.etools.javaee.merge.MMAdapter;
import com.ibm.etools.javaee.merge.MergeUtil;
import com.ibm.etools.javaee.merge.OrderingAdapter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.javaee.web.OrderingType;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFragment;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class WebMergedModelAdapter
extends MMAdapter {
    public static Class ADAPTER_CLASS = WebMergedModelAdapter.class;
    private ArrayList<EObject> xmlFragments = new ArrayList();
    private ArrayList<EObject> annoFragments = new ArrayList();

    public ArrayList<EObject> getXmlFragments() {
        return this.xmlFragments;
    }

    ArrayList<EObject> getAnnoFragments() {
        return this.annoFragments;
    }

    public WebMergedModelAdapter(EObject xml, EObject annotation, EObject merged) {
        super(xml, annotation, merged);
    }

    public WebApp getSourceWebApp() {
        EObject parent = this.xmlObject != null ? this.xmlObject : this.annotationObject;
        while (!(parent instanceof WebApp)) {
            if (parent == null) break;
            parent = parent.eContainer();
        }
        return (WebApp)parent;
    }

    @Override
    public boolean getMetadataComplete() {
        EObject modelRoot = this.getModelRoot(this.mergedObject);
        boolean result = false;
        if (modelRoot instanceof WebApp) {
            result = ((WebApp)this.getModelRoot(this.mergedObject)).isMetadataComplete();
        } else if (modelRoot instanceof WebFragment) {
            result = ((WebFragment)this.getModelRoot(this.mergedObject)).isMetadataComplete();
        }
        return result;
    }

    public void addXmlFragObject(EObject fragObject) {
        this.xmlFragments.add(fragObject);
    }

    @Override
    void rebuildMergedModel() {
        this.removeAdapters(this.mergedObject);
        if (this.mergedObject instanceof WebApp) {
            MergeUtil.clearWebApp((WebApp)this.mergedObject);
        } else if (this.mergedObject instanceof WebFragment) {
            MergeUtil.clearWebApp((WebFragment)this.mergedObject);
        }
        MergeUtil.composeInto(this.xmlObject, this.annotationObject, this.mergedObject, ((Object)((Object)this)).getClass());
        new WebMergedModelAdapter(this.xmlObject, this.annotationObject, this.mergedObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reorderAndRebuildMergedModel(Resource res) {
        EObject eObject = this.mergedObject;
        synchronized (eObject) {
            IProject proj;
            MergeUtil.clearMergeObject((WebApp)this.mergedObject);
            if (res != null && (proj = WorkbenchResourceHelper.getProject((Resource)res)) != null) {
                if (this.xmlObject instanceof WebApp) {
                    boolean metadataComplete = ((WebApp)this.xmlObject).isMetadataComplete();
                    if (metadataComplete) {
                        this.rebuildMergedModel();
                    } else {
                        List<List> orderedFrags = MergeUtil.getOrderedLists(proj, (WebApp)this.xmlObject);
                        if (orderedFrags.size() == 2) {
                            if (((Object)((Object)this)).getClass() == WebMergedModelAdapter.class) {
                                MergeUtil.composeInto(this.xmlObject, this.annotationObject, orderedFrags.get(0), orderedFrags.get(1), this.mergedObject, this);
                            } else if (((Object)((Object)this)).getClass() == OrderingAdapter.class) {
                                WebMergedModelAdapter wmma = MergeUtil.getWebMMAdapterFromEObject(this.mergedObject);
                                MergeUtil.composeInto(this.xmlObject, this.annotationObject, orderedFrags.get(0), orderedFrags.get(1), this.mergedObject, wmma);
                            }
                        } else if (debug) {
                            System.out.println("WMMA.reorderAndRebuildMergedModel: ordered fragment list size is " + orderedFrags.size() + " no reorder and rebuild");
                        }
                    }
                } else {
                    this.rebuildMergedModel();
                }
            }
        }
    }

    public void processFragments(List<WebFragment> fragmentsXml, List<WebFragment> fragmentsAnno) {
        System.out.println("processFragments called with " + fragmentsXml.size() + " xml fragments:");
        for (WebFragment f : fragmentsXml) {
            MergeUtil.dumpModel((EObject)f, 0);
            System.out.println();
        }
        System.out.println("and " + fragmentsAnno.size() + " annotation fragments:");
        for (WebFragment f : fragmentsAnno) {
            MergeUtil.dumpModel((EObject)f, 0);
            System.out.println();
        }
        for (WebFragment frag : fragmentsXml) {
            MergeUtil.mergeWeb30Fragment(this.mergedObject, (EObject)frag, this, true, true);
        }
        for (WebFragment frag : fragmentsAnno) {
            MergeUtil.mergeWeb30Fragment(this.mergedObject, (EObject)frag, this, false, true);
        }
        System.out.println("Combined models: ");
        MergeUtil.dumpModel(this.mergedObject, 0, true);
        if (!MergeUtil.webModelCorrectlyAdapted(this.mergedObject)) {
            System.out.println("XXX Model not correctly adapted!!");
        }
    }

    @Override
    Object getActiveValue(EStructuralFeature feature) {
        Object result = super.getActiveValue(feature);
        if (result == null) {
            for (EObject ob : this.xmlFragments) {
                if (!ob.eIsSet(feature)) continue;
                result = ob.eGet(feature);
                break;
            }
        }
        return result;
    }

    boolean checkForStructChange(EObject notifier) {
        if (!MergeUtil.isMergeable(notifier, this.mergedObject)) {
            List mastXMLlist;
            EObject mergedParent;
            if (debug) {
                System.out.println("XXX Web Frag test code: Stuctural change required!");
            }
            if ((mergedParent = this.mergedObject.eContainer()) == null) {
                return false;
            }
            WebMergedModelAdapter parentMMA = (WebMergedModelAdapter)EcoreUtil.getRegisteredAdapter((EObject)mergedParent, ((Object)((Object)this)).getClass());
            if (parentMMA == null) {
                JavaEEPlugin.logInfo("WebMergedModelAdapter.checkForStructChange: Missing adapter on parent");
                return false;
            }
            EStructuralFeature cFeature = this.mergedObject.eContainingFeature();
            Object mpl = mergedParent.eGet(cFeature);
            if (!(mpl instanceof List)) {
                JavaEEPlugin.logInfo("WebMergedModelAdapter.checkForStructChange: non-list. parent: " + mergedParent + "\ncFeature: " + cFeature + "\nplO: " + mpl);
                return false;
            }
            List mergedList = (List)mpl;
            for (EObject mergedO : mergedList) {
                WebMergedModelAdapter adpt = (WebMergedModelAdapter)EcoreUtil.getAdapter((List)mergedO.eAdapters(), (Object)ADAPTER_CLASS);
                adpt.disconnectAllObjects();
            }
            mergedList.clear();
            EObject parentXMLOb = parentMMA.getXmlObject();
            EObject parentAnnoOb = parentMMA.getAnnotationObject();
            if (parentXMLOb != null && parentAnnoOb != null) {
                mastXMLlist = (List)parentXMLOb.eGet(cFeature);
                List mastAnnolist = (List)parentAnnoOb.eGet(cFeature);
                MergeUtil.composeLists(mastXMLlist, mastAnnolist, mergedList, ADAPTER_CLASS);
            } else if (parentXMLOb != null) {
                mastXMLlist = (List)parentXMLOb.eGet(cFeature);
                for (EObject listOb : mastXMLlist) {
                    mergedList.add(MergeUtil.copyAndAdaptAll(listOb, true, ADAPTER_CLASS));
                }
            } else if (parentAnnoOb != null) {
                List mastAnnolist = (List)parentAnnoOb.eGet(cFeature);
                for (EObject listOb : mastAnnolist) {
                    mergedList.add(MergeUtil.copyAndAdaptAll(listOb, false, ADAPTER_CLASS));
                }
            }
            ArrayList<EObject> xmlFragments = parentMMA.getXmlFragments();
            for (EObject fragXML : xmlFragments) {
                List fragXMLlist = (List)fragXML.eGet(cFeature);
                for (EObject sourceChild : fragXMLlist) {
                    EObject destChild = MergeUtil.findMatchingXML(sourceChild, mergedList);
                    if (destChild != null) {
                        WebMergedModelAdapter destChildAdapter = MergeUtil.getWebMMAdapterFromEObject(destChild);
                        MergeUtil.mergeWeb30Fragment(destChild, sourceChild, destChildAdapter, true, true);
                        continue;
                    }
                    EObject newChild = MergeUtil.copyAndAdaptAll(sourceChild, true, true, ADAPTER_CLASS);
                    mergedList.add(newChild);
                }
            }
            ArrayList<EObject> annoFragments = parentMMA.getAnnoFragments();
            for (EObject fragAnno : annoFragments) {
                List fragAnnolist = (List)fragAnno.eGet(cFeature);
                for (EObject sourceChild : fragAnnolist) {
                    EObject destChild = MergeUtil.findMatchingXML(sourceChild, mergedList);
                    if (destChild != null) {
                        WebMergedModelAdapter destChildAdapter = MergeUtil.getWebMMAdapterFromEObject(destChild);
                        MergeUtil.mergeWeb30Fragment(destChild, sourceChild, destChildAdapter, false, true);
                        continue;
                    }
                    EObject newChild = MergeUtil.copyAndAdaptAll(sourceChild, false, true, ADAPTER_CLASS);
                    mergedList.add(newChild);
                }
            }
            return true;
        }
        return false;
    }

    public void disconnectAllObjects() {
        if (this.mergedObject != null) {
            this.mergedObject.eAdapters().remove((Object)this);
        }
        if (this.xmlObject != null) {
            this.xmlObject.eAdapters().remove((Object)this);
        }
        if (this.annotationObject != null) {
            this.annotationObject.eAdapters().remove((Object)this);
        }
        if (this.xmlFragments != null) {
            for (EObject x : this.xmlFragments) {
                x.eAdapters().remove((Object)this);
            }
        }
        if (this.annoFragments != null) {
            for (EObject x : this.annoFragments) {
                x.eAdapters().remove((Object)this);
            }
        }
        EList children = this.mergedObject.eContents();
        for (EObject child : children) {
            WebMergedModelAdapter childAdapter = (WebMergedModelAdapter)EcoreUtil.getRegisteredAdapter((EObject)child, (Object)ADAPTER_CLASS);
            childAdapter.disconnectAllObjects();
        }
    }

    public void addAnnoFragObject(EObject fragObject) {
        this.annoFragments.add(fragObject);
    }

    @Override
    void rebuildMergedObject(EObject removedObject, MMAdapter adapter, EList<EObject> mergedList, EObject mergedObject) {
        HigherOrderMergeObject hoObj = new HigherOrderMergeObject(adapter);
        hoObj.removedMergedObject(removedObject);
        EObject newMergeObject = hoObj.getHigherOrderObject(mergedObject);
        boolean isXml = hoObj.getIsXml();
        boolean isFragment = hoObj.getIsFragment();
        ContributedFrom whereFrom = hoObj.getContributor();
        ArrayList<EObject> xmlFragments = hoObj.getXmlFragments();
        ArrayList<EObject> annoFragments = hoObj.getAnnoFragments();
        EObject masterAnno = hoObj.getMasterAnno();
        if (newMergeObject != null) {
            EObject newCopy = MergeUtil.copyAndAdaptAll(newMergeObject, isXml, isFragment, ((Object)((Object)this)).getClass());
            mergedList.add((Object)newCopy);
            if (debug) {
                System.out.println("newMergedObject adapters: " + newCopy.eAdapters());
            }
            if (whereFrom == ContributedFrom.master_xml || whereFrom == ContributedFrom.master_annotation) {
                WebMergedModelAdapter destChildAdapter;
                EObject destChild;
                for (EObject fragXML : xmlFragments) {
                    destChild = MergeUtil.findMatchingXML(fragXML, mergedList);
                    if (destChild == null) continue;
                    destChildAdapter = MergeUtil.getWebMMAdapterFromEObject(destChild);
                    MergeUtil.mergeWeb30Fragment(destChild, fragXML, destChildAdapter, true, true);
                    if (!debug) continue;
                    System.out.println("merged with match in webFragments ");
                }
                if (whereFrom == ContributedFrom.master_xml && masterAnno != null) {
                    WebMergedModelAdapter destChildAdapter2 = MergeUtil.getWebMMAdapterFromEObject(newCopy);
                    MergeUtil.mergeWeb30Fragment(newCopy, masterAnno, destChildAdapter2, false, false);
                    if (debug) {
                        System.out.println("merging master_xml with with master_anno ");
                    }
                }
                for (EObject fragAnno : annoFragments) {
                    destChild = MergeUtil.findMatchingXML(fragAnno, mergedList);
                    if (destChild == null) continue;
                    destChildAdapter = MergeUtil.getWebMMAdapterFromEObject(destChild);
                    MergeUtil.mergeWeb30Fragment(destChild, fragAnno, destChildAdapter, false, true);
                    if (!debug) continue;
                    System.out.println("merged with match in annoFragments ");
                }
            } else if (whereFrom == ContributedFrom.xml_frag) {
                EObject annoDestChild;
                if (masterAnno != null) {
                    WebMergedModelAdapter destChildAdapter = MergeUtil.getWebMMAdapterFromEObject(newCopy);
                    MergeUtil.mergeWeb30Fragment(newCopy, masterAnno, destChildAdapter, false, false);
                    if (debug) {
                        System.out.println("merged with match in masterAnno ");
                    }
                }
                if ((annoDestChild = MergeUtil.findMatchingXML(newCopy, annoFragments)) != null) {
                    WebMergedModelAdapter destChildAdapter = MergeUtil.getWebMMAdapterFromEObject(newCopy);
                    MergeUtil.mergeWeb30Fragment(newCopy, annoDestChild, destChildAdapter, false, true);
                    if (debug) {
                        System.out.println("merged with match in annoFragments ");
                    }
                }
            }
        }
    }

    @Override
    public void removeAdaptersFromSpecializations(Adapter ad, EObject x) {
        if (ad instanceof WebMergedModelAdapter) {
            ArrayList<EObject> webFragments = ((WebMergedModelAdapter)ad).getXmlFragments();
            int i = 0;
            while (i < webFragments.size()) {
                EObject xmlEO = webFragments.get(i);
                if (debug && xmlEO == x) {
                    System.out.println("XXX xmlEO is the same instance as x");
                }
                if (xmlEO != null) {
                    EList xmlAdapters = xmlEO.eAdapters();
                    xmlAdapters.remove(ad);
                }
                ++i;
            }
            ArrayList<EObject> annoFragments = ((WebMergedModelAdapter)ad).getAnnoFragments();
            int i2 = 0;
            while (i2 < annoFragments.size()) {
                EObject annoEO = annoFragments.get(i2);
                if (debug && annoEO == x) {
                    System.out.println("XXX annoEO is the same instance as x");
                }
                if (annoEO != null) {
                    EList annoAdapters = annoEO.eAdapters();
                    annoAdapters.remove(ad);
                }
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addObjectToList(Object newValue, EStructuralFeature feature, boolean isXml) {
        if (debug) {
            System.out.println("addObjectToList newValue: " + newValue);
            System.out.println("  hex: " + MergeUtil.hexId(newValue));
            System.out.println("  feature: " + feature);
            System.out.println("  isXml: " + isXml);
        }
        EObject eObject = this.mergedObject;
        synchronized (eObject) {
            EList mergedList = (EList)this.mergedObject.eGet(feature);
            if (newValue instanceof String) {
                for (Object existingValue : mergedList) {
                    if (!existingValue.equals(newValue)) continue;
                    if (debug) {
                        System.out.println("String value already in list, skipping");
                    }
                    return;
                }
            }
            Object newCopy = null;
            if (!(newValue instanceof EObject)) {
                if (debug) {
                    System.out.println("Copy Block");
                }
                newCopy = newValue;
                if (debug && !(newValue instanceof String) && !(newValue instanceof AbstractEnumerator)) {
                    System.out.println("unexpected type in addObjectToList: " + newValue.getClass().getName());
                }
            } else if (newValue instanceof OrderingType) {
                List orderingTypes;
                if (((Object)((Object)this)).getClass() == WebMergedModelAdapter.class && this.mergedObject instanceof WebApp && this.target instanceof WebFragment && !(orderingTypes = (List)((EObject)this.target).eGet(feature)).contains(newValue)) {
                    OrderingAdapter orderingAdapter = new OrderingAdapter(this.xmlObject, this.annotationObject, this.mergedObject);
                    ((EObject)newValue).eAdapters().add((Object)orderingAdapter);
                    ((EObject)newValue).eContainer().eAdapters().add((Object)orderingAdapter);
                }
            } else {
                EObject notifier = ((EObject)newValue).eContainer();
                if (notifier == this.xmlObject) {
                    if (debug) {
                        System.out.println("addObjectToList: Notifier is from an xmlObject");
                    }
                    newCopy = this.mergeNewValueWithContributions((EObject)newValue, ContributedFrom.master_xml, feature, mergedList);
                } else if (this.xmlFragments.contains(notifier)) {
                    if (debug) {
                        System.out.println("addObjectToList: Notifier is from an xmlFragment");
                    }
                    newCopy = this.mergeNewValueWithContributions((EObject)newValue, ContributedFrom.xml_frag, feature, mergedList);
                } else if (notifier == this.annotationObject) {
                    if (debug) {
                        System.out.println("addObjectToList: Notifier is from an annotationObject");
                    }
                    newCopy = this.mergeNewValueWithContributions((EObject)newValue, ContributedFrom.master_annotation, feature, mergedList);
                } else {
                    if (debug) {
                        System.out.println("addObjectToList: Notifier is from an anno fragment");
                    }
                    newCopy = this.mergeNewValueWithContributions((EObject)newValue, ContributedFrom.anno_frag, feature, mergedList);
                }
            }
            if (newCopy != null) {
                mergedList.add(newCopy);
            }
        }
    }

    EObject mergeNewValueWithContributions(EObject newValue, ContributedFrom whereFrom, EStructuralFeature feature, EList mergedList) {
        EObject newCopy = null;
        ArrayList<MatchedObject> matches = this.getMatchesFromOppositeSources(this, feature, newValue, whereFrom);
        ArrayList<MatchedObject> sortedList = this.getSortedListForMerging(matches, new MatchedObject(newValue, whereFrom));
        WebMergedModelAdapter destAdapter = null;
        int i = 0;
        while (i < sortedList.size()) {
            boolean isFrag;
            boolean isXml;
            MatchedObject mo = sortedList.get(i);
            EObject mergeObj = mo.getMatchedObject();
            ContributedFrom from = mo.getContributedFrom();
            if (from == ContributedFrom.master_xml) {
                isXml = true;
                isFrag = false;
            } else if (from == ContributedFrom.master_annotation) {
                isXml = false;
                isFrag = false;
            } else if (from == ContributedFrom.xml_frag) {
                isXml = true;
                isFrag = true;
            } else {
                isXml = false;
                isFrag = true;
            }
            if (i == 0) {
                EObject matchedObj = mo.getMatchedObject();
                EObject removedObj = null;
                int j = 0;
                while (j < mergedList.size()) {
                    if (MergeUtil.isMergeable((EObject)mergedList.get(j), matchedObj)) {
                        if (debug) {
                            System.out.println("mergeNewValueWithContributions: Found match in mergedList");
                        }
                        removedObj = (EObject)mergedList.remove(j);
                        this.removeAdapters(removedObj);
                        break;
                    }
                    ++j;
                }
                newCopy = MergeUtil.copyAndAdaptAll(mo.getMatchedObject(), isXml, isFrag, ((Object)((Object)this)).getClass());
                destAdapter = MergeUtil.getWebMMAdapterFromEObject(newCopy);
            } else if (from == ContributedFrom.master_annotation) {
                MergeUtil.mergeWeb30Fragment(newCopy, mergeObj, destAdapter, isXml, isFrag);
            } else {
                MergeUtil.mergeWeb30Fragment(newCopy, mergeObj, destAdapter, isXml, isFrag);
            }
            ++i;
        }
        return newCopy;
    }

    ArrayList<MatchedObject> getMatchesFromOppositeSources(WebMergedModelAdapter wma, EStructuralFeature feature, EObject newValue, ContributedFrom from) {
        ArrayList<MatchedObject> results = new ArrayList<MatchedObject>();
        EObject masterXml = wma.xmlObject;
        EObject masterAnno = wma.annotationObject;
        ArrayList<EObject> xmlFragments = wma.getXmlFragments();
        ArrayList<EObject> annoFragments = wma.getAnnoFragments();
        ContributedFrom[] sourceContributions = new ContributedFrom[]{ContributedFrom.master_xml, ContributedFrom.xml_frag, ContributedFrom.master_annotation, ContributedFrom.anno_frag};
        Hashtable<ContributedFrom, List> sourceObjs = new Hashtable<ContributedFrom, List>();
        sourceObjs.put(ContributedFrom.xml_frag, xmlFragments);
        if (masterXml != null) {
            List masterXmlObjs = (List)masterXml.eGet(feature);
            sourceObjs.put(ContributedFrom.master_xml, masterXmlObjs);
        } else {
            sourceObjs.put(ContributedFrom.master_xml, new ArrayList());
        }
        if (masterAnno != null) {
            List masterAnnoObjs = (List)masterAnno.eGet(feature);
            sourceObjs.put(ContributedFrom.master_annotation, masterAnnoObjs);
        } else {
            sourceObjs.put(ContributedFrom.master_annotation, new ArrayList());
        }
        sourceObjs.put(ContributedFrom.anno_frag, annoFragments);
        int i = 0;
        while (i < sourceContributions.length) {
            ContributedFrom key = sourceContributions[i];
            if (key != from) {
                List sourceList;
                if (key == ContributedFrom.master_xml || key == ContributedFrom.master_annotation) {
                    sourceList = (List)sourceObjs.get((Object)key);
                    for (Object src : sourceList) {
                        if (!MergeUtil.isMergeable(newValue, (EObject)src)) continue;
                        if (debug) {
                            System.out.println("WebMergedModelAdapter.getMatches: found match in " + (Object)((Object)key));
                        }
                        results.add(new MatchedObject((EObject)src, key));
                    }
                } else {
                    sourceList = (ArrayList)sourceObjs.get((Object)key);
                    for (Object src : sourceList) {
                        List featureList = (List)((EObject)src).eGet(feature);
                        for (Object srcFeature : featureList) {
                            if (!MergeUtil.isMergeable(newValue, (EObject)srcFeature)) continue;
                            if (debug) {
                                System.out.println("WebMergedModelAdapter.getMatches: found match in " + (Object)((Object)key));
                            }
                            results.add(new MatchedObject((EObject)srcFeature, key));
                        }
                    }
                }
            }
            ++i;
        }
        sourceObjs.clear();
        return results;
    }

    ArrayList<MatchedObject> getSortedListForMerging(ArrayList<MatchedObject> matches, MatchedObject newObject) {
        ArrayList<MatchedObject> sortedList = new ArrayList<MatchedObject>();
        int masterXmlIndex = -1;
        int xmlFragIndex = -1;
        int masterAnnoIndex = -1;
        for (MatchedObject mo : matches) {
            if (mo.getContributedFrom() == ContributedFrom.master_xml) {
                sortedList.add(0, mo);
                masterXmlIndex = 0;
                continue;
            }
            if (mo.getContributedFrom() == ContributedFrom.xml_frag) {
                if (masterXmlIndex == -1) {
                    sortedList.add(++xmlFragIndex, mo);
                    continue;
                }
                if (xmlFragIndex == -1) {
                    sortedList.add(1, mo);
                    xmlFragIndex = 1;
                    continue;
                }
                sortedList.add(++xmlFragIndex, mo);
                continue;
            }
            if (mo.getContributedFrom() == ContributedFrom.master_annotation) {
                if (masterXmlIndex == -1) {
                    if (xmlFragIndex == -1) {
                        sortedList.add(++masterAnnoIndex, mo);
                        continue;
                    }
                    masterAnnoIndex = xmlFragIndex + 1;
                    sortedList.add(masterAnnoIndex, mo);
                    continue;
                }
                sortedList.add(1, mo);
                masterAnnoIndex = 1;
                continue;
            }
            sortedList.add(mo);
        }
        if (newObject.getContributedFrom() == ContributedFrom.master_xml) {
            sortedList.add(newObject);
        } else if (newObject.getContributedFrom() == ContributedFrom.master_annotation) {
            if (masterXmlIndex == -1) {
                if (xmlFragIndex == -1) {
                    sortedList.add(newObject);
                } else {
                    sortedList.add(xmlFragIndex + 1, newObject);
                }
            } else {
                sortedList.add(masterXmlIndex + 1, newObject);
            }
        } else if (newObject.getContributedFrom() == ContributedFrom.xml_frag) {
            if (masterXmlIndex == -1) {
                sortedList.add(0, newObject);
            } else {
                sortedList.add(masterXmlIndex + 1, newObject);
            }
        } else {
            sortedList.add(newObject);
        }
        return sortedList;
    }

    public static enum ContributedFrom {
        master_xml,
        master_annotation,
        xml_frag,
        anno_frag;

    }

    protected class HigherOrderMergeObject {
        EObject newMergeObject = null;
        boolean isXml = false;
        boolean isFragment = false;
        EObject masterXml;
        EObject masterAnno;
        ArrayList<EObject> xmlFragments;
        ArrayList<EObject> annoFragments;
        ContributedFrom whereFrom;

        public HigherOrderMergeObject(MMAdapter adapter) {
            this.masterXml = adapter.xmlObject;
            this.masterAnno = adapter.annotationObject;
            this.xmlFragments = ((WebMergedModelAdapter)adapter).getXmlFragments();
            this.annoFragments = ((WebMergedModelAdapter)adapter).getAnnoFragments();
        }

        public void setIsXml(boolean value) {
            this.isXml = value;
        }

        public void setIsFragment(boolean value) {
            this.isFragment = value;
        }

        public EObject getHigherOrderObject(EObject mergedObject) {
            if (debug) {
                System.out.println("XXX Finding the higher order merged object");
            }
            if (this.masterXml != null) {
                this.newMergeObject = this.masterXml;
                this.isXml = true;
                this.isFragment = false;
                this.whereFrom = ContributedFrom.master_xml;
                if (debug) {
                    System.out.println("Higher order object is from masterXml");
                }
            } else if (this.masterAnno != null) {
                this.newMergeObject = MergeUtil.findMatchingXML(mergedObject, this.xmlFragments);
                if (this.newMergeObject != null) {
                    this.isXml = true;
                    this.isFragment = true;
                    this.whereFrom = ContributedFrom.xml_frag;
                    if (debug) {
                        System.out.println("Higher order object is from xml fragment");
                    }
                } else {
                    this.newMergeObject = this.masterAnno;
                    this.isXml = false;
                    this.isFragment = false;
                    this.whereFrom = ContributedFrom.master_annotation;
                    if (debug) {
                        System.out.println("Higher order object is from masterAnno");
                    }
                }
            } else {
                this.newMergeObject = MergeUtil.findMatchingXML(mergedObject, this.xmlFragments);
                if (this.newMergeObject == null) {
                    this.newMergeObject = MergeUtil.findMatchingXML(mergedObject, this.annoFragments);
                    this.isXml = false;
                    this.isFragment = true;
                    this.whereFrom = ContributedFrom.anno_frag;
                    if (debug) {
                        System.out.println("Higher order object is from annoFragment");
                    }
                } else {
                    this.isXml = true;
                    this.isFragment = true;
                    this.whereFrom = ContributedFrom.xml_frag;
                    if (debug) {
                        System.out.println("Higher order object is from xmlFragment");
                    }
                }
            }
            return this.newMergeObject;
        }

        public boolean getIsXml() {
            return this.isXml;
        }

        public boolean getIsFragment() {
            return this.isFragment;
        }

        public void removedMergedObject(EObject removedObject) {
            if (removedObject == this.masterXml) {
                this.masterXml = null;
            } else if (removedObject == this.masterAnno) {
                this.masterAnno = null;
            } else {
                this.xmlFragments.remove(removedObject);
                this.annoFragments.remove(removedObject);
            }
        }

        public ArrayList<EObject> getXmlFragments() {
            return this.xmlFragments;
        }

        public ArrayList<EObject> getAnnoFragments() {
            return this.annoFragments;
        }

        public ContributedFrom getContributor() {
            return this.whereFrom;
        }

        public EObject getMasterAnno() {
            return this.masterAnno;
        }
    }

    protected class MatchedObject {
        EObject matchObj;
        ContributedFrom from;

        public MatchedObject(EObject matchObj, ContributedFrom from) {
            this.matchObj = matchObj;
            this.from = from;
        }

        public EObject getMatchedObject() {
            return this.matchObj;
        }

        public ContributedFrom getContributedFrom() {
            return this.from;
        }
    }
}

