/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.merge;

import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.etools.javaee.annotations.base.EMF2AnnotationModelBaseProvider;
import com.ibm.etools.javaee.core.JavaEEPlugin;
import com.ibm.etools.javaee.merge.MMAdapter;
import com.ibm.etools.javaee.merge.MergedModelAdapter2;
import com.ibm.etools.javaee.merge.OrderingAdapter;
import com.ibm.etools.javaee.merge.WebFragmentMergedModelAdapter;
import com.ibm.etools.javaee.merge.WebMergedModelAdapter;
import com.ibm.etools.javaee.merge.WebStructureChangedAdapter;
import com.ibm.etools.javaee.model.internal.IJEE5ModelProvider;
import com.ibm.etools.javaee.model.internal.WebFragmentModelProvider;
import com.ibm.etools.javaee.xml.JavaEEXMLResourceHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.jst.javaee.core.LifecycleCallback;
import org.eclipse.jst.javaee.core.Listener;
import org.eclipse.jst.javaee.core.ServiceRefHandlerChain;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.core.internal.metadata.JavaeePackage;
import org.eclipse.jst.javaee.ejb.AssemblyDescriptor;
import org.eclipse.jst.javaee.ejb.ContainerTransactionType;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.ExcludeList;
import org.eclipse.jst.javaee.ejb.InitMethodType;
import org.eclipse.jst.javaee.ejb.MethodParams;
import org.eclipse.jst.javaee.ejb.MethodPermission;
import org.eclipse.jst.javaee.ejb.MethodType;
import org.eclipse.jst.javaee.ejb.NamedMethodType;
import org.eclipse.jst.javaee.ejb.QueryMethod;
import org.eclipse.jst.javaee.ejb.RemoveMethodType;
import org.eclipse.jst.javaee.ejb.TransactionAttributeType;
import org.eclipse.jst.javaee.ejb.internal.metadata.EjbPackage;
import org.eclipse.jst.javaee.jsp.internal.metadata.JspPackage;
import org.eclipse.jst.javaee.web.AbsoluteOrderingType;
import org.eclipse.jst.javaee.web.ErrorPage;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.LocaleEncodingMapping;
import org.eclipse.jst.javaee.web.MimeMapping;
import org.eclipse.jst.javaee.web.OrderingOrderingType;
import org.eclipse.jst.javaee.web.OrderingType;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.SessionConfig;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFragment;
import org.eclipse.jst.javaee.web.internal.metadata.WebPackage;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class MergeUtil {
    private static boolean debug = false;
    private static HashMap<Integer, Integer> ejbPackageMap;
    private static HashMap<Integer, Integer> javaeePackageMap;
    private static HashMap<Integer, Integer> webPackageMap;

    static {
        try {
            String debugS = System.getProperty("com.ibm.etools.javaee.merge.DEBUG");
            if (debugS != null) {
                debug = true;
            }
        }
        catch (Throwable throwable) {}
        int[][] nArrayArray = new int[11][];
        int[] nArray = new int[2];
        nArray[0] = 3;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{8, 1};
        nArrayArray[2] = new int[]{9, 1};
        nArrayArray[3] = new int[]{15, 1};
        nArrayArray[4] = new int[]{16, 1};
        nArrayArray[5] = new int[]{18, 3};
        nArrayArray[6] = new int[]{21, 1};
        nArrayArray[7] = new int[]{24, 1};
        nArrayArray[8] = new int[]{25, 3};
        int[] nArray2 = new int[2];
        nArray2[0] = 31;
        nArrayArray[9] = nArray2;
        nArrayArray[10] = new int[]{36, 3};
        int[][] ejbPMData = nArrayArray;
        ejbPackageMap = new HashMap();
        int i = 0;
        while (i < ejbPMData.length) {
            ejbPackageMap.put(ejbPMData[i][0], ejbPMData[i][1]);
            ++i;
        }
        int[][] nArrayArray2 = new int[21][];
        nArrayArray2[0] = new int[]{3, 1};
        nArrayArray2[1] = new int[]{4, 1};
        nArrayArray2[2] = new int[]{5, 1};
        nArrayArray2[3] = new int[]{7, 1};
        nArrayArray2[4] = new int[]{6, 1};
        nArrayArray2[5] = new int[]{9, 1};
        int[] nArray3 = new int[2];
        nArray3[0] = 11;
        nArrayArray2[6] = nArray3;
        nArrayArray2[7] = new int[]{15, 3};
        nArrayArray2[8] = new int[]{17, 3};
        nArrayArray2[9] = new int[]{18, 1};
        nArrayArray2[10] = new int[]{19, 1};
        nArrayArray2[11] = new int[]{20, 1};
        int[] nArray4 = new int[2];
        nArray4[0] = 23;
        nArrayArray2[12] = nArray4;
        nArrayArray2[13] = new int[]{21, 1};
        int[] nArray5 = new int[2];
        nArray5[0] = 22;
        nArrayArray2[14] = nArray5;
        nArrayArray2[15] = new int[]{24, 1};
        nArrayArray2[16] = new int[]{25, 1};
        nArrayArray2[17] = new int[]{28, 1};
        nArrayArray2[18] = new int[]{29, 1};
        nArrayArray2[19] = new int[]{31, 3};
        nArrayArray2[20] = new int[]{30, 3};
        int[][] javaeePMData = nArrayArray2;
        javaeePackageMap = new HashMap();
        int i2 = 0;
        while (i2 < javaeePMData.length) {
            javaeePackageMap.put(javaeePMData[i2][0], javaeePMData[i2][1]);
            ++i2;
        }
        int[][] nArrayArray3 = new int[2][];
        int[] nArray6 = new int[2];
        nArray6[0] = 27;
        nArrayArray3[0] = nArray6;
        nArrayArray3[1] = new int[]{13, 1};
        int[][] webPMData = nArrayArray3;
        webPackageMap = new HashMap();
        int i3 = 0;
        while (i3 < webPMData.length) {
            webPackageMap.put(webPMData[i3][0], webPMData[i3][1]);
            ++i3;
        }
    }

    public static EJBJar compose(EJBJar xmlJar, EJBJar annotationJar) {
        if (xmlJar == null || annotationJar == null) {
            return null;
        }
        EObject result = MergeUtil.compose((EObject)xmlJar, (EObject)annotationJar, MergedModelAdapter2.class);
        Resource xmlEMFResource = ((EObject)xmlJar).eResource();
        if (xmlEMFResource != null) {
            IPath fullPath;
            final ResourceSet xmlResSet = xmlEMFResource.getResourceSet();
            IFile xmlFile = WorkbenchResourceHelper.getFile((Resource)xmlEMFResource);
            if (xmlFile != null && (fullPath = xmlFile.getFullPath()) != null) {
                String uriPath = fullPath.toString();
                ResourceImpl mixedEMFResource = new ResourceImpl(URI.createPlatformResourceURI((String)uriPath)){

                    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
                    }

                    public ResourceSet getResourceSet() {
                        return xmlResSet;
                    }
                };
                mixedEMFResource.getContents().add((Object)result);
            }
        }
        if (debug) {
            System.out.println("composed xml model: ");
            MergeUtil.dumpModel((EObject)xmlJar, 0);
            System.out.println("with annotations model: ");
            MergeUtil.dumpModel((EObject)annotationJar, 0);
            System.out.println("merged result: ");
            MergeUtil.dumpModel(result, 0);
        }
        return (EJBJar)result;
    }

    static void composeInto(EObject xmlEObject, EObject annotationEObject, EObject result) {
        MergeUtil.composeInto(xmlEObject, annotationEObject, result, MergedModelAdapter2.class);
    }

    static void composeInto(EObject xmlEObject, EObject annotationEObject, EObject result, Class adapterClass) {
        if (result instanceof AssemblyDescriptor) {
            AssemblyDescriptor xmlAD = (AssemblyDescriptor)xmlEObject;
            AssemblyDescriptor annoAD = (AssemblyDescriptor)annotationEObject;
            AssemblyDescriptor resultAD = (AssemblyDescriptor)result;
            MergeUtil.composeAssemblyDescriptors(xmlAD, annoAD, resultAD);
            return;
        }
        boolean metadataComplete = false;
        if (xmlEObject instanceof EJBJar) {
            metadataComplete = ((EJBJar)xmlEObject).isMetadataComplete();
        } else if (xmlEObject instanceof WebApp) {
            metadataComplete = ((WebApp)xmlEObject).isMetadataComplete();
        } else if (xmlEObject instanceof WebFragment) {
            metadataComplete = ((WebFragment)xmlEObject).isMetadataComplete();
        }
        EClass eClass = xmlEObject.eClass();
        EList attributes = eClass.getEAllAttributes();
        for (EAttribute attr : attributes) {
            if (attr.isMany()) {
                if (attr.getEType().getInstanceClass() != String.class) continue;
                List xmlList = (List)xmlEObject.eGet((EStructuralFeature)attr);
                UniqueEList newList = new UniqueEList((Collection)xmlList);
                if (!metadataComplete) {
                    List annList = (List)annotationEObject.eGet((EStructuralFeature)attr);
                    newList.addAll((Collection)annList);
                }
                result.eSet((EStructuralFeature)attr, (Object)newList);
                continue;
            }
            if (xmlEObject.eIsSet((EStructuralFeature)attr)) {
                Object value = xmlEObject.eGet((EStructuralFeature)attr);
                result.eSet((EStructuralFeature)attr, value);
                continue;
            }
            if (metadataComplete || !annotationEObject.eIsSet((EStructuralFeature)attr)) continue;
            Object annoValue = annotationEObject.eGet((EStructuralFeature)attr);
            result.eSet((EStructuralFeature)attr, annoValue);
        }
        LinkedList xmlContents = new LinkedList(xmlEObject.eContents());
        if (!metadataComplete) {
            EList annotationContents = annotationEObject.eContents();
            for (EObject annotationChild : annotationContents) {
                EStructuralFeature esf;
                EObject xmlChild = MergeUtil.findMatchingXML(annotationChild, xmlContents);
                if (xmlChild != null) {
                    EObject newObject = MergeUtil.compose(xmlChild, annotationChild, adapterClass);
                    esf = annotationChild.eContainingFeature();
                    MergeUtil.addChild(result, newObject, esf);
                    xmlContents.remove(xmlChild);
                    continue;
                }
                EObject newChild = MergeUtil.copyAndAdaptAll(annotationChild, false, adapterClass);
                esf = annotationChild.eContainingFeature();
                MergeUtil.addChild(result, newChild, esf);
            }
        }
        for (EObject xmlEO : xmlContents) {
            EObject copy = MergeUtil.copyAndAdaptAll(xmlEO, true, adapterClass);
            EStructuralFeature esf = xmlEO.eContainingFeature();
            MergeUtil.addChild(result, copy, esf);
        }
    }

    static EObject copyAndAdaptAll(EObject srcObject, boolean isXml, Class adapterClass) {
        return MergeUtil.copyAndAdaptAll(srcObject, isXml, false, adapterClass);
    }

    static EObject copyAndAdaptAll(EObject srcObject, boolean isXml, boolean isFragment, Class adapterClass) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        EObject result = copier.copy(srcObject);
        copier.copyReferences();
        Set keys = copier.keySet();
        for (EObject orig : keys) {
            EObject copy = (EObject)copier.get((Object)orig);
            if (isFragment) {
                if (adapterClass == WebMergedModelAdapter.class) {
                    WebMergedModelAdapter wmma = (WebMergedModelAdapter)MergeUtil.constructAdapter(adapterClass, null, null, copy);
                    if (isXml) {
                        wmma.addXmlFragObject(orig);
                    } else {
                        wmma.addAnnoFragObject(orig);
                    }
                    orig.eAdapters().add((Object)wmma);
                }
                if (adapterClass != MergedModelAdapter2.class) continue;
                MergedModelAdapter2 mma2 = (MergedModelAdapter2)MergeUtil.constructAdapter(adapterClass, null, null, copy);
                mma2.addEJBAnnoFragObject(orig);
                orig.eAdapters().add((Object)mma2);
                continue;
            }
            if (isXml) {
                MergeUtil.constructAdapter(adapterClass, orig, null, copy);
                continue;
            }
            MergeUtil.constructAdapter(adapterClass, null, orig, copy);
        }
        return result;
    }

    private static MMAdapter constructAdapter(Class adapterClass, EObject xml, EObject anno, EObject merged) {
        if (adapterClass == MergedModelAdapter2.class) {
            return new MergedModelAdapter2(xml, anno, merged);
        }
        if (adapterClass == WebMergedModelAdapter.class) {
            return new WebMergedModelAdapter(xml, anno, merged);
        }
        if (adapterClass == WebFragmentMergedModelAdapter.class) {
            return new WebFragmentMergedModelAdapter(xml, anno, merged);
        }
        try {
            Constructor con = adapterClass.getConstructor(EObject.class, EObject.class, EObject.class);
            MMAdapter result = (MMAdapter)((Object)con.newInstance(xml, anno, merged));
            return result;
        }
        catch (Exception e) {
            IProject proj = WorkbenchResourceHelper.getProject((Resource)xml.eResource());
            final Status status = new Status(4, "com.ibm.etools.javaee.core", 4, JavaEEXMLResourceHandler.getString(JavaEEXMLResourceHandler.MergeAdapter_Creation_Error, new Object[]{proj.getName()}), null);
            Job job1 = new Job("Model Adapter Creation Error Job"){

                protected IStatus run(IProgressMonitor monitor) {
                    return status;
                }
            };
            job1.schedule();
            IllegalArgumentException iae = new IllegalArgumentException("Unable to create instance of model adapter");
            iae.initCause(e);
            throw iae;
        }
    }

    static EObject findMatchingXML(EObject annotationChild, List xmlContents) {
        int i = 0;
        while (i < xmlContents.size()) {
            EObject xmlChild = (EObject)xmlContents.get(i);
            if (MergeUtil.isMergeable(xmlChild, annotationChild)) {
                return xmlChild;
            }
            ++i;
        }
        return null;
    }

    public static boolean isMergeable(EObject xmlChild, EObject annotationsChild) {
        EClass eClass = xmlChild.eClass();
        if (eClass != annotationsChild.eClass()) {
            return false;
        }
        EPackage ePackage = eClass.getEPackage();
        if (ePackage == EjbPackage.eINSTANCE) {
            switch (eClass.getClassifierID()) {
                case 6: 
                case 13: 
                case 17: 
                case 19: 
                case 22: 
                case 23: 
                case 26: 
                case 29: 
                case 32: 
                case 33: 
                case 35: {
                    return true;
                }
                case 30: {
                    EStructuralFeature esf = eClass.getEStructuralFeature(1);
                    QueryMethod xmlQM = (QueryMethod)xmlChild.eGet(esf);
                    QueryMethod annQM = (QueryMethod)annotationsChild.eGet(esf);
                    esf = eClass.getEStructuralFeature(0);
                    return MergeUtil.compareByStringFeature((EObject)xmlQM, (EObject)annQM, esf);
                }
                case 27: {
                    boolean roleNamesMatch;
                    MethodPermission xmlMPerm = (MethodPermission)xmlChild;
                    MethodPermission annMPerm = (MethodPermission)annotationsChild;
                    List xmlRoleNames = xmlMPerm.getRoleNames();
                    List annRoleNames = annMPerm.getRoleNames();
                    if (xmlRoleNames.size() != annRoleNames.size()) {
                        return false;
                    }
                    boolean bl = roleNamesMatch = xmlRoleNames.containsAll(annRoleNames) && annRoleNames.containsAll(xmlRoleNames);
                    if (!roleNamesMatch) {
                        return false;
                    }
                    List xmlMethods = xmlMPerm.getMethods();
                    List annMethods = annMPerm.getMethods();
                    if (xmlMethods == null || annMethods == null) {
                        return xmlMethods == annMethods;
                    }
                    if (xmlMethods.size() != annMethods.size()) {
                        return false;
                    }
                    ArrayList tmpList = new ArrayList(annMethods);
                    for (MethodType mtx : xmlMethods) {
                        boolean found = false;
                        for (MethodType mta : tmpList) {
                            if (!MergeUtil.compareMethodTypes(mtx, mta, false)) continue;
                            found = true;
                            tmpList.remove(mta);
                            break;
                        }
                        if (found) continue;
                        return false;
                    }
                    return true;
                }
                case 28: {
                    MethodType xmlMT = (MethodType)xmlChild;
                    MethodType annMT = (MethodType)annotationsChild;
                    return MergeUtil.compareMethodTypes(xmlMT, annMT, false);
                }
                case 20: {
                    NamedMethodType xmlBM = ((InitMethodType)xmlChild).getBeanMethod();
                    NamedMethodType annBM = ((InitMethodType)annotationsChild).getBeanMethod();
                    return MergeUtil.compareNamedMethodTypes(xmlBM, annBM);
                }
                case 34: {
                    NamedMethodType xmlBM1 = ((RemoveMethodType)xmlChild).getBeanMethod();
                    NamedMethodType annBM1 = ((RemoveMethodType)annotationsChild).getBeanMethod();
                    return MergeUtil.compareNamedMethodTypes(xmlBM1, annBM1);
                }
                case 4: {
                    EStructuralFeature esf = eClass.getEStructuralFeature(0);
                    boolean res = MergeUtil.compareByStringFeature(xmlChild, annotationsChild, esf);
                    if (!res) {
                        return false;
                    }
                    esf = eClass.getEStructuralFeature(1);
                    return MergeUtil.compareByStringFeature(xmlChild, annotationsChild, esf);
                }
                case 11: {
                    return MergeUtil.compareContainerTransactions(xmlChild, annotationsChild);
                }
            }
            Integer featureID = ejbPackageMap.get(eClass.getClassifierID());
            if (featureID != null) {
                EStructuralFeature esf = eClass.getEStructuralFeature(featureID.intValue());
                return MergeUtil.compareByStringFeature(xmlChild, annotationsChild, esf);
            }
            if (debug) {
                System.out.println(eClass + " not supported by isMergable");
            }
            return false;
        }
        if (ePackage == JavaeePackage.eINSTANCE) {
            switch (eClass.getClassifierID()) {
                case 8: 
                case 27: 
                case 33: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 32: {
                    ServiceRefHandlerChain xmlChain = (ServiceRefHandlerChain)xmlChild;
                    ServiceRefHandlerChain annChain = (ServiceRefHandlerChain)annotationsChild;
                    return MergeUtil.compareServiceRefHandlerChains(xmlChain, annChain);
                }
                case 14: {
                    LifecycleCallback xmlLC = (LifecycleCallback)xmlChild;
                    LifecycleCallback annLC = (LifecycleCallback)annotationsChild;
                    return MergeUtil.compareLifecycleCallbacks(xmlLC, annLC);
                }
                case 34: {
                    EStructuralFeature esf = eClass.getEStructuralFeature(0);
                    return MergeUtil.compareByStringFeature(xmlChild, annotationsChild, esf);
                }
                case 5: {
                    EStructuralFeature esf = eClass.getEStructuralFeature(1);
                    return MergeUtil.compareDisplayAndDescriptions(xmlChild, annotationsChild, esf, eClass.getEStructuralFeature(0));
                }
                case 4: {
                    EStructuralFeature esf = eClass.getEStructuralFeature(1);
                    return MergeUtil.compareDisplayAndDescriptions(xmlChild, annotationsChild, esf, eClass.getEStructuralFeature(0));
                }
            }
            Integer featureID = javaeePackageMap.get(eClass.getClassifierID());
            if (featureID != null) {
                EStructuralFeature esf = eClass.getEStructuralFeature(featureID.intValue());
                return MergeUtil.compareByStringFeature(xmlChild, annotationsChild, esf);
            }
            if (debug) {
                System.out.println(eClass + " not supported by isMergable");
            }
            return false;
        }
        if (ePackage == WebPackage.eINSTANCE) {
            switch (eClass.getClassifierID()) {
                case 0: 
                case 15: 
                case 24: 
                case 26: 
                case 28: {
                    return true;
                }
                case 16: 
                case 18: {
                    return false;
                }
                case 20: {
                    return MergeUtil.compareServlets(xmlChild, annotationsChild);
                }
                case 21: {
                    return MergeUtil.compareServletMappings(xmlChild, annotationsChild);
                }
                case 22: {
                    return MergeUtil.compareSessionConfig((SessionConfig)xmlChild, (SessionConfig)annotationsChild);
                }
                case 8: {
                    return MergeUtil.compareFilters(xmlChild, annotationsChild);
                }
                case 9: {
                    return MergeUtil.compareFilterMappings(xmlChild, annotationsChild);
                }
                case 7: {
                    return MergeUtil.compareErrorPages((ErrorPage)xmlChild, (ErrorPage)annotationsChild);
                }
                case 11: {
                    return MergeUtil.compareLocaleEncodingMapping((LocaleEncodingMapping)xmlChild, (LocaleEncodingMapping)annotationsChild);
                }
                case 14: {
                    return MergeUtil.compareMimeMapping((MimeMapping)xmlChild, (MimeMapping)annotationsChild);
                }
            }
            Integer featureID = webPackageMap.get(eClass.getClassifierID());
            if (featureID != null) {
                EStructuralFeature esf = eClass.getEStructuralFeature(featureID.intValue());
                return MergeUtil.compareByStringFeature(xmlChild, annotationsChild, esf);
            }
            if (debug) {
                System.out.println(eClass + " not supported by isMergable");
            }
            return false;
        }
        if (ePackage == JspPackage.eINSTANCE) {
            switch (eClass.getClassifierID()) {
                case 0: 
                case 1: 
                case 2: {
                    return false;
                }
            }
            if (debug) {
                System.out.println(eClass + " not supported by isMergable");
            }
            return false;
        }
        if (debug) {
            System.out.println(ePackage + " not supported by isMergable");
        }
        return false;
    }

    private static boolean compareErrorPages(ErrorPage page1, ErrorPage page2) {
        if (page1 == page2) {
            return true;
        }
        if (page1 == null || page2 == null) {
            return false;
        }
        BigInteger page1ErrorCode = page1.getErrorCode();
        BigInteger page2ErrorCode = page2.getErrorCode();
        if (page1ErrorCode != null && page2ErrorCode != null && page1ErrorCode.equals(page2ErrorCode)) {
            return true;
        }
        String page1ExceptionType = page1.getExceptionType();
        String page2ExceptionType = page2.getExceptionType();
        return page1ExceptionType != null && page2ExceptionType != null && page1ExceptionType.equals(page2ExceptionType);
    }

    private static boolean compareMimeMapping(MimeMapping mime1, MimeMapping mime2) {
        String mimeType1 = mime1.getMimeType();
        String mimeType2 = mime2.getMimeType();
        String ext1 = mime1.getExtension();
        String ext2 = mime2.getExtension();
        return mimeType1 != null && mimeType2 != null && ext1 != null && ext2 != null && mimeType1.equals(mimeType2) && ext1.equals(ext2);
    }

    private static boolean compareLocaleEncodingMapping(LocaleEncodingMapping lem1, LocaleEncodingMapping lem2) {
        String encoding1 = lem1.getEncoding();
        String encoding2 = lem2.getEncoding();
        String locale1 = lem1.getLocale();
        String locale2 = lem2.getLocale();
        return encoding1 != null && encoding2 != null && locale1 != null && locale2 != null && encoding1.equals(encoding2) && locale1.equals(locale2);
    }

    private static boolean compareContainerTransactions(EObject xmlChild, EObject annotationsChild) {
        ContainerTransactionType xmlCTT = (ContainerTransactionType)xmlChild;
        ContainerTransactionType annCTT = (ContainerTransactionType)annotationsChild;
        if (debug) {
            System.out.println("comparing xmlCTT: " + xmlCTT + " and annCTT: " + annCTT);
        }
        List xmlMethods = xmlCTT.getMethods();
        LinkedList annMethods = new LinkedList(annCTT.getMethods());
        if (xmlMethods == null) {
            return false;
        }
        if (xmlMethods.size() != annMethods.size()) {
            return false;
        }
        for (MethodType xmlM : xmlMethods) {
            boolean foundIt = false;
            for (MethodType annM : annMethods) {
                boolean wildCardParams;
                if (!MergeUtil.compareMethodTypes(xmlM, annM, wildCardParams = true)) continue;
                foundIt = true;
                annMethods.remove(annM);
                break;
            }
            if (foundIt) continue;
            return false;
        }
        return true;
    }

    private static boolean compareDisplayAndDescriptions(EObject a, EObject b, EStructuralFeature esf_lang, EStructuralFeature esf_value) {
        String bV;
        String aV = (String)a.eGet(esf_lang);
        if (MergeUtil.compareStrings(aV, bV = (String)b.eGet(esf_lang))) {
            String aV_value = (String)a.eGet(esf_value);
            String bV_value = (String)b.eGet(esf_value);
            return MergeUtil.compareStrings(aV_value, bV_value);
        }
        return false;
    }

    private static boolean compareLifecycleCallbacks(LifecycleCallback xmlLC, LifecycleCallback annLC) {
        boolean classMatch = MergeUtil.compareStrings(xmlLC.getLifecycleCallbackClass(), annLC.getLifecycleCallbackClass());
        if (!classMatch) {
            return false;
        }
        return MergeUtil.compareStrings(xmlLC.getLifecycleCallbackMethod(), annLC.getLifecycleCallbackMethod());
    }

    private static boolean compareServiceRefHandlerChains(ServiceRefHandlerChain xmlChain, ServiceRefHandlerChain annChain) {
        boolean res = MergeUtil.compareStrings(xmlChain.getPortNamePattern(), annChain.getPortNamePattern());
        if (!res) {
            return false;
        }
        res = MergeUtil.compareStrings(xmlChain.getServiceNamePattern(), annChain.getServiceNamePattern());
        if (!res) {
            return false;
        }
        List xmlPBs = xmlChain.getProtocolBindings();
        List annPBs = annChain.getProtocolBindings();
        if (xmlPBs == null && annPBs == null) {
            return true;
        }
        if (xmlPBs == null || annPBs == null) {
            return false;
        }
        if (xmlPBs.size() != annPBs.size()) {
            return false;
        }
        return xmlPBs.containsAll(annPBs);
    }

    private static boolean compareStrings(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private static boolean compareMethodTypes(MethodType xmlMT, MethodType annMT, boolean wildCardParams) {
        boolean methodIntfMatch;
        boolean bl = methodIntfMatch = xmlMT.getMethodIntf() == annMT.getMethodIntf();
        if (!methodIntfMatch) {
            return false;
        }
        boolean ejbNameMatch = MergeUtil.compareStrings(xmlMT.getEjbName(), annMT.getEjbName());
        if (!ejbNameMatch) {
            return false;
        }
        boolean methodNameMatch = MergeUtil.compareStrings(xmlMT.getMethodName(), annMT.getMethodName());
        if (!methodNameMatch) {
            return false;
        }
        MethodParams xmlMP = xmlMT.getMethodParams();
        if (wildCardParams && xmlMP == null) {
            return true;
        }
        MethodParams annMP = annMT.getMethodParams();
        if (xmlMP == null || annMP == null) {
            return annMP == xmlMP;
        }
        List xmlParams = xmlMP.getMethodParams();
        List annParams = annMP.getMethodParams();
        if (xmlParams.size() != annParams.size()) {
            return false;
        }
        boolean mpListMatch = xmlParams.containsAll(annParams);
        return mpListMatch;
    }

    private static boolean compareNamedMethodTypes(NamedMethodType xmlNMT, NamedMethodType annNMT) {
        boolean mpListMatch;
        if (debug) {
            System.out.println("cNMT: comparing " + xmlNMT + " with " + annNMT);
        }
        if (xmlNMT == null && annNMT == null) {
            return true;
        }
        if (xmlNMT == null || annNMT == null) {
            return false;
        }
        boolean ejbNameMatch = MergeUtil.compareStrings(xmlNMT.getMethodName(), annNMT.getMethodName());
        if (!ejbNameMatch) {
            if (debug) {
                System.out.println("cNMT: failing on name match");
            }
            return false;
        }
        MethodParams xmlMP = xmlNMT.getMethodParams();
        MethodParams annMP = annNMT.getMethodParams();
        if (xmlMP == null && annMP == null) {
            if (debug) {
                System.out.println("cNMT: both methodParams null, returning true");
            }
            return true;
        }
        if (xmlMP == null || annMP == null) {
            List pList = null;
            if (xmlMP != null) {
                pList = xmlMP.getMethodParams();
            } else if (annMP != null) {
                pList = annMP.getMethodParams();
            }
            if (pList == null || pList.size() == 0) {
                if (debug) {
                    System.out.println("cNMT: null methodParams matches empty list, returning true");
                }
                return true;
            }
            if (debug) {
                System.out.println("cNMT: null methodParams and non-empty list, returning false");
            }
            return false;
        }
        List xmlParams = xmlMP.getMethodParams();
        List annParams = annMP.getMethodParams();
        if (xmlParams.size() != annParams.size()) {
            if (debug) {
                System.out.println("cNMT: failing on param list size");
            }
            return false;
        }
        boolean bl = mpListMatch = xmlParams.containsAll(annParams) && annParams.containsAll(xmlParams);
        if (debug) {
            System.out.println("mpListMatch " + mpListMatch);
        }
        return mpListMatch;
    }

    private static boolean compareByStringFeature(EObject a, EObject b, EStructuralFeature esf) {
        String aV = (String)a.eGet(esf);
        String bV = (String)b.eGet(esf);
        return MergeUtil.compareStrings(aV, bV);
    }

    private static boolean compareServlets(EObject a, EObject b) {
        String aV = (String)a.eGet((EStructuralFeature)WebPackage.Literals.SERVLET__SERVLET_NAME);
        String bV = (String)b.eGet((EStructuralFeature)WebPackage.Literals.SERVLET__SERVLET_NAME);
        if (aV != null && bV != null) {
            int aVSize = aV.trim().length();
            int bVSize = bV.trim().length();
            if (aVSize != 0 && bVSize != 0) {
                return MergeUtil.compareByStringFeature(a, b, (EStructuralFeature)WebPackage.Literals.SERVLET__SERVLET_NAME);
            }
        }
        return false;
    }

    private static boolean compareSessionConfig(SessionConfig a, SessionConfig b) {
        BigInteger aST = a.getSessionTimeout();
        BigInteger bST = b.getSessionTimeout();
        if (aST != null && bST != null) {
            return aST.equals(bST);
        }
        return false;
    }

    private static boolean compareServletMappings(EObject a, EObject b) {
        String aV = (String)a.eGet((EStructuralFeature)WebPackage.Literals.SERVLET_MAPPING__SERVLET_NAME);
        String bV = (String)b.eGet((EStructuralFeature)WebPackage.Literals.SERVLET_MAPPING__SERVLET_NAME);
        if (aV != null && bV != null) {
            int aVSize = aV.trim().length();
            int bVSize = bV.trim().length();
            if (aVSize != 0 && bVSize != 0) {
                if (MergeUtil.compareByStringFeature(a, b, (EStructuralFeature)WebPackage.Literals.SERVLET_MAPPING__SERVLET_NAME)) {
                    EList servAUP = (EList)a.eGet((EStructuralFeature)WebPackage.Literals.SERVLET_MAPPING__URL_PATTERNS);
                    EList servBUP = (EList)b.eGet((EStructuralFeature)WebPackage.Literals.SERVLET_MAPPING__URL_PATTERNS);
                    return MergeUtil.compareURLPatterns(servAUP, servBUP);
                }
                return false;
            }
        }
        return false;
    }

    private static boolean compareURLPatterns(EList a, EList b) {
        if (a.size() == b.size()) {
            ArrayList<String> aNames = new ArrayList<String>();
            ArrayList<String> bNames = new ArrayList<String>();
            boolean matches = false;
            int i = 0;
            while (i < a.size()) {
                aNames.add(((UrlPatternType)a.get(i)).getValue());
                bNames.add(((UrlPatternType)b.get(i)).getValue());
                ++i;
            }
            i = 0;
            while (i < a.size()) {
                if (!aNames.contains(bNames.get(i))) {
                    matches = false;
                    return false;
                }
                matches = true;
                ++i;
            }
            return matches;
        }
        return false;
    }

    private static boolean compareFilters(EObject a, EObject b) {
        String aV = (String)a.eGet((EStructuralFeature)WebPackage.Literals.FILTER__FILTER_NAME);
        String bV = (String)b.eGet((EStructuralFeature)WebPackage.Literals.FILTER__FILTER_NAME);
        if (aV != null && bV != null) {
            int aVSize = aV.trim().length();
            int bVSize = bV.trim().length();
            if (aVSize != 0 && bVSize != 0) {
                return MergeUtil.compareByStringFeature(a, b, (EStructuralFeature)WebPackage.Literals.FILTER__FILTER_NAME);
            }
        }
        return false;
    }

    private static boolean compareFilterMappings(EObject a, EObject b) {
        String aV = (String)a.eGet((EStructuralFeature)WebPackage.Literals.FILTER_MAPPING__FILTER_NAME);
        String bV = (String)b.eGet((EStructuralFeature)WebPackage.Literals.FILTER_MAPPING__FILTER_NAME);
        if (aV != null && bV != null) {
            int aVSize = aV.trim().length();
            int bVSize = bV.trim().length();
            if (aVSize != 0 && bVSize != 0 && MergeUtil.compareByStringFeature(a, b, (EStructuralFeature)WebPackage.Literals.FILTER_MAPPING__FILTER_NAME)) {
                EList filterAUP = (EList)a.eGet((EStructuralFeature)WebPackage.Literals.FILTER_MAPPING__URL_PATTERNS);
                EList filterBUP = (EList)b.eGet((EStructuralFeature)WebPackage.Literals.FILTER_MAPPING__URL_PATTERNS);
                return MergeUtil.compareURLPatterns(filterAUP, filterBUP);
            }
        }
        return false;
    }

    private static void addChild(EObject parent, EObject child, EStructuralFeature esf) {
        if (esf.isMany()) {
            List l = (List)parent.eGet(esf);
            l.add(child);
        } else {
            parent.eSet(esf, (Object)child);
        }
    }

    public static void composeLists(List xmlList, List annList, List list3, Class adapterClass) {
        list3.clear();
        LinkedList copyXmlList = new LinkedList(xmlList);
        for (EObject annotationChild : annList) {
            EObject xmlChild = MergeUtil.findMatchingXML(annotationChild, copyXmlList);
            if (xmlChild != null) {
                list3.add(MergeUtil.compose(xmlChild, annotationChild, adapterClass));
                copyXmlList.remove(xmlChild);
                continue;
            }
            EObject newChild = MergeUtil.copyAndAdaptAll(annotationChild, false, adapterClass);
            list3.add(newChild);
        }
        for (EObject x : copyXmlList) {
            EObject newChild = MergeUtil.copyAndAdaptAll(x, true, adapterClass);
            list3.add(newChild);
        }
    }

    public static void clearEJBJar(EJBJar ejbJar) {
        ejbJar.setAssemblyDescriptor(null);
        ejbJar.setEjbClientJar(null);
        ejbJar.setEnterpriseBeans(null);
        ejbJar.setId(null);
        ejbJar.setInterceptors(null);
        ejbJar.setRelationships(null);
        ejbJar.unsetMetadataComplete();
        ejbJar.unsetVersion();
        ejbJar.getDescriptions().clear();
        ejbJar.getDisplayNames().clear();
        ejbJar.getIcons().clear();
    }

    public static void clearEJBinWarJar(EJBJar ejbJar) {
        ejbJar.setAssemblyDescriptor(null);
        ejbJar.setEjbClientJar(null);
        EObject eb = (EObject)ejbJar.getEnterpriseBeans();
        if (eb != null) {
            EClass eClass = eb.eClass();
            EObject newEB = eClass.getEPackage().getEFactoryInstance().create(eClass);
            MergedModelAdapter2 mma2 = MergeUtil.getAdapterFromEObject(eb);
            EList children = eb.eContents();
            for (EObject child : children) {
                mma2.removeAdapters(child);
            }
            mma2.mergedObject = newEB;
            newEB.eAdapters().add((Object)mma2);
            ejbJar.setEnterpriseBeans((EnterpriseBeans)newEB);
        }
        ejbJar.setId(null);
        ejbJar.setInterceptors(null);
        ejbJar.setRelationships(null);
        ejbJar.unsetMetadataComplete();
        ejbJar.unsetVersion();
        ejbJar.getDescriptions().clear();
        ejbJar.getDisplayNames().clear();
        ejbJar.getIcons().clear();
    }

    public static void clearWebApp(WebApp webApp) {
        webApp.setId(null);
        webApp.unsetVersion();
        webApp.unsetMetadataComplete();
        EObject eObj = (EObject)webApp;
        EClass eClass = eObj.eClass();
        EList features = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            Object objFeature = eObj.eGet(feature);
            if (!(objFeature instanceof EList)) continue;
            ((EList)objFeature).clear();
        }
    }

    public static void clearMergeObject(WebApp webApp) {
        webApp.unsetMetadataComplete();
        EObject eObj = (EObject)webApp;
        EClass eClass = eObj.eClass();
        EList features = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            Object objFeature = eObj.eGet(feature);
            if (feature == WebPackage.Literals.WEB_APP__GROUP || feature == WebPackage.Literals.WEB_APP__DISPLAY_NAMES || !(objFeature instanceof EList)) continue;
            ((EList)objFeature).clear();
        }
    }

    public static void clearWebApp(WebFragment webFragment) {
        webFragment.setId(null);
        webFragment.unsetVersion();
        webFragment.unsetMetadataComplete();
        EObject eObj = (EObject)webFragment;
        EClass eClass = eObj.eClass();
        EList features = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            Object objFeature = eObj.eGet(feature);
            if (!(objFeature instanceof EList)) continue;
            ((EList)objFeature).clear();
        }
    }

    public static void dumpModel(EObject model, int indent, boolean showContributors) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < indent) {
            sb.append(" ");
            ++i;
        }
        String prefix = sb.toString();
        EClass mClass = model.eClass();
        System.out.print(String.valueOf(prefix) + mClass.getName() + "{");
        EList attributes = mClass.getEAllAttributes();
        for (EAttribute attr : attributes) {
            System.out.print(String.valueOf(prefix) + attr.getName() + "=" + model.eGet((EStructuralFeature)attr) + ", ");
        }
        System.out.println("}");
        EList adapters = model.eAdapters();
        for (Adapter ad : adapters) {
            System.out.println(String.valueOf(prefix) + "    adapted by " + ad);
        }
        if (showContributors) {
            for (Adapter adpt : adapters) {
                if (adpt instanceof MMAdapter) {
                    EObject xmlO = ((MMAdapter)adpt).getXmlObject();
                    EObject annO = ((MMAdapter)adpt).getAnnotationObject();
                    System.out.println(String.valueOf(prefix) + "XML src object = " + MergeUtil.hexId(xmlO));
                    System.out.println(String.valueOf(prefix) + "Anno src object = " + MergeUtil.hexId(annO));
                }
                if (!(adpt instanceof WebMergedModelAdapter)) continue;
                ArrayList<EObject> xmlFrags = ((WebMergedModelAdapter)adpt).getXmlFragments();
                if (xmlFrags.size() == 0) {
                    System.out.print("No XML fragments");
                } else {
                    System.out.print("XML Fragments:");
                }
                for (EObject x : xmlFrags) {
                    System.out.print(String.valueOf(MergeUtil.hexId(x)) + " ");
                }
                System.out.println();
                ArrayList<EObject> annoFrags = ((WebMergedModelAdapter)adpt).getAnnoFragments();
                if (annoFrags.size() == 0) {
                    System.out.print("No Anno fragments");
                } else {
                    System.out.print("Anno Fragments:");
                }
                for (EObject x : annoFrags) {
                    System.out.print(String.valueOf(MergeUtil.hexId(x)) + " ");
                }
                System.out.println();
            }
        }
        EList contents = model.eContents();
        for (EObject o : contents) {
            System.out.print(String.valueOf(prefix) + o.eContainingFeature().getName() + ": ");
            MergeUtil.dumpModel(o, indent + 2, showContributors);
        }
    }

    public static void dumpModel(EObject model, int indent) {
        MergeUtil.dumpModel(model, indent, false);
    }

    public static boolean modelCorrectlyAdapted(EObject model) {
        if (debug) {
            System.out.println("Checking " + model.eClass().getName());
        }
        EList adapters = model.eAdapters();
        int nAdapter = 0;
        for (Adapter ad : adapters) {
            if (debug) {
                System.out.println("\tadapted by " + ad);
            }
            if (!(ad instanceof MergedModelAdapter2)) continue;
            ++nAdapter;
        }
        if (nAdapter != 1) {
            if (debug) {
                System.out.println("nAdapter=" + nAdapter + " on " + model);
            }
            return false;
        }
        EList contents = model.eContents();
        for (EObject o : contents) {
            if (MergeUtil.modelCorrectlyAdapted(o)) continue;
            return false;
        }
        return true;
    }

    private static ContainerTransactionType findExistingCTT(List<ContainerTransactionType> cttList, String ejbName, TransactionAttributeType transType) {
        ContainerTransactionType result = null;
        for (ContainerTransactionType ctt : cttList) {
            MethodType firstMethod;
            if (ctt.getTransAttribute() != transType || !(firstMethod = (MethodType)ctt.getMethods().get(0)).getEjbName().equals(ejbName)) continue;
            result = ctt;
            break;
        }
        return result;
    }

    private static void composeAssemblyDescriptors(AssemblyDescriptor xmlAD, AssemblyDescriptor annoAD, AssemblyDescriptor result) {
        ContainerTransactionType newCTT;
        MergeUtil.composeLists(xmlAD.getApplicationExceptions(), annoAD.getApplicationExceptions(), result.getApplicationExceptions(), MergedModelAdapter2.class);
        List xmlCTs = xmlAD.getContainerTransactions();
        List annoCTs = annoAD.getContainerTransactions();
        List resultCTs = result.getContainerTransactions();
        HashMap<MethodType, AttributeMapEntry> xmlMethodMap = new HashMap<MethodType, AttributeMapEntry>();
        for (ContainerTransactionType ctt : xmlCTs) {
            TransactionAttributeType tat = ctt.getTransAttribute();
            List methods = ctt.getMethods();
            for (MethodType m : methods) {
                xmlMethodMap.put(m, new AttributeMapEntry(tat, ctt));
            }
        }
        HashMap<MethodType, AttributeMapEntry> annoMethodMap = new HashMap<MethodType, AttributeMapEntry>();
        for (ContainerTransactionType ctt : annoCTs) {
            TransactionAttributeType tat = ctt.getTransAttribute();
            List methods = ctt.getMethods();
            for (MethodType m : methods) {
                annoMethodMap.put(m, new AttributeMapEntry(tat, ctt));
            }
        }
        resultCTs.clear();
        for (MethodType annoMethod : annoMethodMap.keySet()) {
            MethodType xmlMatchM = null;
            for (MethodType xmlMethod : xmlMethodMap.keySet()) {
                if (!xmlMethod.getEjbName().equals(annoMethod.getEjbName()) || xmlMethod.getMethodIntf() != annoMethod.getMethodIntf()) continue;
                if ("*".equals(xmlMethod.getMethodName())) {
                    if (xmlMatchM != null) continue;
                    xmlMatchM = xmlMethod;
                    continue;
                }
                if (!xmlMethod.getMethodName().equals(annoMethod.getMethodName())) continue;
                MethodParams xmlMPs = xmlMethod.getMethodParams();
                if (xmlMPs == null) {
                    xmlMatchM = xmlMethod;
                    continue;
                }
                if (!MergeUtil.methodParamsEqual(xmlMethod.getMethodParams(), annoMethod.getMethodParams())) continue;
                xmlMatchM = xmlMethod;
                break;
            }
            if (debug) {
                System.out.println("annoMethod: " + annoMethod + ", xmlMatchM: " + xmlMatchM);
            }
            ContainerTransactionType annoCTT = ((AttributeMapEntry)annoMethodMap.get((Object)annoMethod)).cttRef;
            if (xmlMatchM == null) {
                newCTT = MergeUtil.findExistingCTT(resultCTs, annoMethod.getEjbName(), annoCTT.getTransAttribute());
                if (newCTT == null) {
                    newCTT = EjbFactory.eINSTANCE.createContainerTransactionType();
                    newCTT.getDescriptions().addAll(annoCTT.getDescriptions());
                    if (annoCTT.isSetTransAttribute()) {
                        newCTT.setTransAttribute(annoCTT.getTransAttribute());
                    }
                    resultCTs.add(newCTT);
                }
                newCTT.getMethods().add((MethodType)MergeUtil.copyAndAdaptAll((EObject)annoMethod, false, MergedModelAdapter2.class));
                new MergedModelAdapter2(null, (EObject)annoCTT, (EObject)newCTT);
                continue;
            }
            AttributeMapEntry xmlAME = (AttributeMapEntry)xmlMethodMap.get(xmlMatchM);
            ContainerTransactionType xmlCTT = xmlAME.cttRef;
            ContainerTransactionType newCTT2 = MergeUtil.findExistingCTT(resultCTs, xmlMatchM.getEjbName(), xmlCTT.getTransAttribute());
            if (newCTT2 == null) {
                newCTT2 = EjbFactory.eINSTANCE.createContainerTransactionType();
                newCTT2.getDescriptions().addAll(xmlCTT.getDescriptions());
                if (xmlCTT.isSetTransAttribute()) {
                    newCTT2.setTransAttribute(xmlCTT.getTransAttribute());
                }
                resultCTs.add(newCTT2);
            }
            newCTT2.getMethods().add((MethodType)MergeUtil.copyAndAdaptAll((EObject)annoMethod, false, MergedModelAdapter2.class));
            new MergedModelAdapter2((EObject)xmlCTT, (EObject)annoCTT, (EObject)newCTT2);
            if ("*".equals(xmlMatchM.getMethodName()) || xmlMatchM.getMethodParams() == null && annoMethod.getMethodParams() != null) continue;
            xmlAME.entryUsed = true;
        }
        for (MethodType xmlMethod : xmlMethodMap.keySet()) {
            AttributeMapEntry xmlAME = (AttributeMapEntry)xmlMethodMap.get(xmlMethod);
            if (xmlAME.entryUsed) continue;
            if (debug) {
                System.out.println("adding xmlMethod: " + xmlMethod);
            }
            ContainerTransactionType xmlCTT = xmlAME.cttRef;
            newCTT = MergeUtil.findExistingCTT(resultCTs, xmlMethod.getEjbName(), xmlCTT.getTransAttribute());
            if (newCTT == null) {
                newCTT = EjbFactory.eINSTANCE.createContainerTransactionType();
                newCTT.getDescriptions().addAll(xmlCTT.getDescriptions());
                if (xmlCTT.isSetTransAttribute()) {
                    newCTT.setTransAttribute(xmlCTT.getTransAttribute());
                }
                resultCTs.add(newCTT);
            }
            newCTT.getMethods().add((MethodType)MergeUtil.copyAndAdaptAll((EObject)xmlMethod, true, MergedModelAdapter2.class));
            new MergedModelAdapter2((EObject)xmlCTT, null, (EObject)newCTT);
        }
        ExcludeList xmlXL = xmlAD.getExcludeList();
        ExcludeList annoXL = annoAD.getExcludeList();
        if (xmlXL == null && annoXL == null) {
            result.setExcludeList(null);
        } else if (xmlXL == null || annoXL == null) {
            ExcludeList rXL = (ExcludeList)(xmlXL == null ? MergeUtil.copyAndAdaptAll((EObject)annoXL, false, MergedModelAdapter2.class) : MergeUtil.copyAndAdaptAll((EObject)xmlXL, true, MergedModelAdapter2.class));
            result.setExcludeList(rXL);
        } else {
            result.setExcludeList((ExcludeList)MergeUtil.compose((EObject)xmlXL, (EObject)annoXL, MergedModelAdapter2.class));
        }
        MergeUtil.composeLists(xmlAD.getInterceptorBindings(), annoAD.getInterceptorBindings(), result.getInterceptorBindings(), MergedModelAdapter2.class);
        MergeUtil.composeLists(xmlAD.getMessageDestinations(), annoAD.getMessageDestinations(), result.getMessageDestinations(), MergedModelAdapter2.class);
        MergeUtil.composeLists(xmlAD.getMethodPermissions(), annoAD.getMethodPermissions(), result.getMethodPermissions(), MergedModelAdapter2.class);
        MergeUtil.composeLists(xmlAD.getSecurityRoles(), annoAD.getSecurityRoles(), result.getSecurityRoles(), MergedModelAdapter2.class);
    }

    private static boolean methodParamsEqual(MethodParams mp1, MethodParams mp2) {
        List list1 = mp1.getMethodParams();
        List list2 = mp2.getMethodParams();
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        return list1.containsAll(list2);
    }

    public static TransactionAttributeType getAnnotationTransactionAttribute(MethodType m) {
        MergedModelAdapter2 mtAdapter = MergeUtil.getAdapterFromEObject((EObject)m);
        if (mtAdapter == null) {
            return null;
        }
        EObject annoMT = mtAdapter.getAnnotationObject();
        if (annoMT == null) {
            return null;
        }
        EObject container = annoMT.eContainer();
        if (container == null) {
            return null;
        }
        if (!(container instanceof ContainerTransactionType)) {
            return null;
        }
        return ((ContainerTransactionType)container).getTransAttribute();
    }

    public static MergedModelAdapter2 getAdapterFromEObject(EObject x) {
        if (x == null) {
            return null;
        }
        EList adapters = x.eAdapters();
        for (Adapter a : adapters) {
            if (!(a instanceof MergedModelAdapter2)) continue;
            return (MergedModelAdapter2)a;
        }
        return null;
    }

    public static WebMergedModelAdapter getWebMMAdapterFromEObject(EObject x) {
        if (x == null) {
            return null;
        }
        EList adapters = x.eAdapters();
        for (Adapter a : adapters) {
            if (!(a instanceof WebMergedModelAdapter)) continue;
            return (WebMergedModelAdapter)a;
        }
        return null;
    }

    public static WebFragmentMergedModelAdapter getWebFragmentMMAdapterFromEObject(EObject x) {
        if (x == null) {
            return null;
        }
        EList adapters = x.eAdapters();
        for (Adapter a : adapters) {
            if (!(a instanceof WebFragmentMergedModelAdapter)) continue;
            return (WebFragmentMergedModelAdapter)a;
        }
        return null;
    }

    public static EObject compose(EObject xmlEObject, EObject annotationEObject, Class adapterClass) {
        EClass eClass = xmlEObject.eClass();
        EObject result = eClass.getEPackage().getEFactoryInstance().create(eClass);
        MergeUtil.composeInto(xmlEObject, annotationEObject, result, adapterClass);
        try {
            Constructor con = adapterClass.getConstructor(EObject.class, EObject.class, EObject.class);
            con.newInstance(xmlEObject, annotationEObject, result);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Unable to create instance of model adapter");
            iae.initCause(e);
            throw iae;
        }
        return result;
    }

    public static WebApp compose(WebApp xmlWebApp, WebApp annotationWebApp, List xmlFragments, List annoFragments) {
        Resource xmlEMFResource;
        EObject newCopy = null;
        WebMergedModelAdapter wwma = null;
        if (xmlWebApp != null) {
            newCopy = MergeUtil.copyAndAdaptAll((EObject)xmlWebApp, true, WebMergedModelAdapter.class);
            wwma = MergeUtil.getWebMMAdapterFromEObject(newCopy);
            for (Object xmlFrag : xmlFragments) {
                MergeUtil.mergeWeb30Fragment(newCopy, (EObject)xmlFrag, wwma, true, true);
            }
            if (annotationWebApp != null) {
                MergeUtil.mergeWeb30Fragment(newCopy, (EObject)annotationWebApp, wwma, false, false);
            }
            for (Object annoFrag : annoFragments) {
                MergeUtil.mergeWeb30Fragment(newCopy, (EObject)annoFrag, wwma, false, true);
            }
        } else if (xmlFragments.size() > 0) {
            newCopy = MergeUtil.copyAndAdaptAll((EObject)xmlFragments.get(0), true, true, WebMergedModelAdapter.class);
            wwma = MergeUtil.getWebMMAdapterFromEObject(newCopy);
            int i = 1;
            while (i < xmlFragments.size()) {
                MergeUtil.mergeWeb30Fragment(newCopy, (EObject)xmlFragments.get(i), wwma, true, true);
                ++i;
            }
            if (annotationWebApp != null) {
                MergeUtil.mergeWeb30Fragment(newCopy, (EObject)annotationWebApp, wwma, false, false);
            }
            for (Object annoFrag : annoFragments) {
                MergeUtil.mergeWeb30Fragment(newCopy, (EObject)annoFrag, wwma, false, true);
            }
        } else if (annotationWebApp != null) {
            newCopy = MergeUtil.copyAndAdaptAll((EObject)annotationWebApp, false, WebMergedModelAdapter.class);
            wwma = MergeUtil.getWebMMAdapterFromEObject(newCopy);
            for (Object annoFrag : annoFragments) {
                MergeUtil.mergeWeb30Fragment(newCopy, (EObject)annoFrag, wwma, false, true);
            }
        } else {
            if (annoFragments.size() > 0) {
                newCopy = MergeUtil.copyAndAdaptAll((EObject)xmlFragments.get(0), true, false, WebMergedModelAdapter.class);
                wwma = MergeUtil.getWebMMAdapterFromEObject(newCopy);
            }
            int i = 1;
            while (i < annoFragments.size()) {
                MergeUtil.mergeWeb30Fragment(newCopy, (EObject)annoFragments.get(i), wwma, false, true);
                ++i;
            }
        }
        if (xmlWebApp != null && (xmlEMFResource = ((EObject)xmlWebApp).eResource()) != null) {
            IPath fullPath;
            final ResourceSet xmlResSet = xmlEMFResource.getResourceSet();
            IFile xmlFile = WorkbenchResourceHelper.getFile((Resource)xmlEMFResource);
            if (xmlFile != null && (fullPath = xmlFile.getFullPath()) != null) {
                String uriPath = fullPath.toString();
                ResourceImpl mixedEMFResource = new ResourceImpl(URI.createPlatformResourceURI((String)uriPath)){

                    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
                    }

                    public ResourceSet getResourceSet() {
                        return xmlResSet;
                    }
                };
                mixedEMFResource.getContents().add((Object)newCopy);
            }
        }
        if (debug) {
            System.out.println("merged result for mainMerged model: ");
            MergeUtil.dumpModel(newCopy, 0, true);
        }
        return (WebApp)newCopy;
    }

    public static WebApp compose(WebApp xmlWebApp, WebApp annotationWebApp) {
        if (xmlWebApp == null || annotationWebApp == null) {
            return null;
        }
        EObject result = MergeUtil.compose((EObject)xmlWebApp, (EObject)annotationWebApp, WebMergedModelAdapter.class);
        Resource xmlEMFResource = ((EObject)xmlWebApp).eResource();
        if (xmlEMFResource != null) {
            IPath fullPath;
            final ResourceSet xmlResSet = xmlEMFResource.getResourceSet();
            IFile xmlFile = WorkbenchResourceHelper.getFile((Resource)xmlEMFResource);
            if (xmlFile != null && (fullPath = xmlFile.getFullPath()) != null) {
                String uriPath = fullPath.toString();
                ResourceImpl mixedEMFResource = new ResourceImpl(URI.createPlatformResourceURI((String)uriPath)){

                    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
                    }

                    public ResourceSet getResourceSet() {
                        return xmlResSet;
                    }
                };
                mixedEMFResource.getContents().add((Object)result);
            }
        }
        if (debug) {
            System.out.println("composed xml web app model: ");
            MergeUtil.dumpModel((EObject)xmlWebApp, 0);
            System.out.println("with annotations web app model: ");
            MergeUtil.dumpModel((EObject)annotationWebApp, 0);
            System.out.println("merged result: ");
            MergeUtil.dumpModel(result, 0);
        }
        return (WebApp)result;
    }

    public static WebFragment compose(WebFragment xmlWebFragment, WebFragment annotationWebFragment) {
        Resource xmlEMFResource;
        if (xmlWebFragment == null || annotationWebFragment == null) {
            return null;
        }
        EObject result = MergeUtil.compose((EObject)xmlWebFragment, (EObject)annotationWebFragment, WebMergedModelAdapter.class);
        List orderings = (List)((EObject)xmlWebFragment).eGet((EStructuralFeature)WebPackage.Literals.WEB_FRAGMENT__ORDERING);
        if (orderings != null && orderings.size() > 0) {
            EList adapters = ((EObject)xmlWebFragment).eAdapters();
            OrderingAdapter orderingAdapter = null;
            for (Object adapter : adapters) {
                if (!(adapter instanceof WebMergedModelAdapter)) continue;
                WebMergedModelAdapter wmma = (WebMergedModelAdapter)((Object)adapter);
                if (!(wmma.xmlObject instanceof WebApp)) continue;
                orderingAdapter = new OrderingAdapter(wmma.xmlObject, null, wmma.mergedObject);
                EObject ordering = (EObject)orderings.get(0);
                MergeUtil.setOrderingAdapter(ordering, orderingAdapter);
                break;
            }
            if (orderingAdapter != null) {
                for (Object adapter : adapters) {
                    if (!(adapter instanceof OrderingAdapter)) continue;
                    adapters.remove(adapter);
                    break;
                }
                adapters.add(orderingAdapter);
            }
        }
        if ((xmlEMFResource = ((EObject)xmlWebFragment).eResource()) != null) {
            IPath fullPath;
            final ResourceSet xmlResSet = xmlEMFResource.getResourceSet();
            IFile xmlFile = WorkbenchResourceHelper.getFile((Resource)xmlEMFResource);
            if (xmlFile != null && (fullPath = xmlFile.getFullPath()) != null) {
                String uriPath = fullPath.toString();
                ResourceImpl mixedEMFResource = new ResourceImpl(URI.createPlatformResourceURI((String)uriPath)){

                    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
                    }

                    public ResourceSet getResourceSet() {
                        return xmlResSet;
                    }
                };
                mixedEMFResource.getContents().add((Object)result);
            }
        }
        if (debug) {
            System.out.println("composed xml web app model: ");
            MergeUtil.dumpModel((EObject)xmlWebFragment, 0);
            System.out.println("with annotations web app model: ");
            MergeUtil.dumpModel((EObject)annotationWebFragment, 0);
            System.out.println("merged result: ");
            MergeUtil.dumpModel(result, 0);
        }
        return (WebFragment)result;
    }

    public static boolean webModelCorrectlyAdapted(EObject model) {
        EObject annoObject;
        if (debug) {
            System.out.println("Checking " + model.eClass().getName());
        }
        EList adapters = model.eAdapters();
        MMAdapter adapter = null;
        for (Adapter a : adapters) {
            if (!(a instanceof WebMergedModelAdapter)) continue;
            adapter = (WebMergedModelAdapter)a;
            break;
        }
        if (adapter == null) {
            if (debug) {
                System.out.println("adapter not found on merged object");
            }
            return false;
        }
        EObject xmlObject = adapter.getXmlObject();
        if (xmlObject != null) {
            EList xmlAdapters = xmlObject.eAdapters();
            boolean adapterFound = false;
            for (Adapter a : xmlAdapters) {
                if (a != adapter) continue;
                adapterFound = true;
                break;
            }
            if (!adapterFound) {
                if (debug) {
                    System.out.println("adapter not found on xml object");
                }
                return false;
            }
        }
        if ((annoObject = adapter.getAnnotationObject()) != null) {
            EList annoAdapters = annoObject.eAdapters();
            boolean adapterFound = false;
            for (Adapter a : annoAdapters) {
                if (a != adapter) continue;
                adapterFound = true;
                break;
            }
            if (!adapterFound) {
                if (debug) {
                    System.out.println("adapter not found on anno object");
                }
                return false;
            }
        }
        ArrayList<EObject> xmlFragments = ((WebMergedModelAdapter)adapter).getXmlFragments();
        for (EObject fragO : xmlFragments) {
            EList fragAdapters = fragO.eAdapters();
            boolean adapterFound = false;
            for (Adapter a : fragAdapters) {
                if (a != adapter) continue;
                adapterFound = true;
                break;
            }
            if (adapterFound) continue;
            if (debug) {
                System.out.println("adapter not found on frag object " + fragO);
            }
            return false;
        }
        EList contents = model.eContents();
        for (EObject o : contents) {
            if (MergeUtil.webModelCorrectlyAdapted(o)) continue;
            return false;
        }
        return true;
    }

    static String hexId(Object x) {
        if (x == null) {
            return "NULL";
        }
        return Integer.toHexString(System.identityHashCode(x));
    }

    public static MMAdapter getAdapterFromRemovedObject(EObject removedObject, EList<EObject> mergedList, MMAdapter currentAdapter) {
        MMAdapter adapter = null;
        CopyOnWriteArrayList<EObject> mergedListCopy = new CopyOnWriteArrayList<EObject>((Collection<EObject>)mergedList);
        block0: for (EObject eo : mergedListCopy) {
            MMAdapter mma = (MMAdapter)EcoreUtil.getRegisteredAdapter((EObject)eo, ((Object)((Object)currentAdapter)).getClass());
            if (mma == null) continue;
            EObject xmlObj = mma.getXmlObject();
            if (xmlObj != null && xmlObj == removedObject) {
                if (debug) {
                    System.out.println("Found an adapter that points to removedObject: " + MergeUtil.hexId((Object)mma));
                }
                adapter = mma;
                break;
            }
            if (!(mma instanceof WebMergedModelAdapter)) continue;
            WebMergedModelAdapter wma = (WebMergedModelAdapter)mma;
            ArrayList<EObject> xmlFrags = wma.getXmlFragments();
            int i = 0;
            while (i < xmlFrags.size()) {
                if (xmlFrags.get(i) == removedObject) {
                    if (debug) {
                        System.out.println("Found an adapter in the main merge model that points to removedObject: " + MergeUtil.hexId((Object)wma));
                    }
                    adapter = wma;
                    continue block0;
                }
                ++i;
            }
        }
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void mergeWeb30Fragment(EObject destObject, EObject fragObject, WebMergedModelAdapter wmmAdapter, boolean isXml, boolean isFrag) {
        if (!destObject.eAdapters().contains((Object)wmmAdapter)) {
            JavaEEPlugin.logInfo("MergeUtil.mergeWeb30Fragment: ERROR: wmmAdapter must be an adapter of destObject");
        }
        if (isFrag) {
            if (isXml) {
                wmmAdapter.addXmlFragObject(fragObject);
            } else {
                wmmAdapter.addAnnoFragObject(fragObject);
            }
        } else if (isXml) {
            wmmAdapter.xmlObject = fragObject;
            EClass eClass = fragObject.eClass();
            EList attributes = eClass.getEAllAttributes();
            for (EAttribute attr : attributes) {
                if (eClass != WebPackage.eINSTANCE.getWebApp()) continue;
                if (attr.isMany()) {
                    if (attr.getEType().getInstanceClass() != String.class) continue;
                    List xmlList = (List)fragObject.eGet((EStructuralFeature)attr);
                    UniqueEList newList = new UniqueEList((Collection)xmlList);
                    destObject.eSet((EStructuralFeature)attr, (Object)newList);
                    continue;
                }
                if (!fragObject.eIsSet((EStructuralFeature)attr)) continue;
                Object value = fragObject.eGet((EStructuralFeature)attr);
                destObject.eSet((EStructuralFeature)attr, value);
            }
        } else {
            wmmAdapter.annotationObject = fragObject;
        }
        EList adapters = fragObject.eAdapters();
        if (!adapters.contains((Object)wmmAdapter)) {
            fragObject.eAdapters().add((Object)wmmAdapter);
        }
        EClass eClass = destObject.eClass();
        EList attributes = eClass.getEAllAttributes();
        if (debug) {
            System.out.println("processing eClass: " + eClass);
        }
        for (EAttribute attr : attributes) {
            Object srcValue;
            if (debug) {
                System.out.println("processing attr: " + attr);
            }
            if (eClass == WebPackage.eINSTANCE.getWebApp() && attr == WebPackage.eINSTANCE.getWebApp_Group()) break;
            if (attr.isMany()) {
                if (attr.getEType().getInstanceClass() == String.class) {
                    List destList = (List)destObject.eGet((EStructuralFeature)attr);
                    List sourceList = (List)fragObject.eGet((EStructuralFeature)attr);
                    for (String valS : sourceList) {
                        if (destList.contains(valS)) continue;
                        destList.add(valS);
                    }
                    continue;
                }
                if (attr == WebPackage.eINSTANCE.getFilterMapping_Group()) break;
                if (!debug) continue;
                throw new RuntimeException("XXX Support needed for lists of " + attr.getEType().getInstanceClass());
            }
            if (!fragObject.eIsSet((EStructuralFeature)attr)) {
                if (!debug) continue;
                System.out.println("attribute not set on source object, nothing to do");
                continue;
            }
            if (destObject.eIsSet((EStructuralFeature)attr)) {
                EObject masterXmlOb = wmmAdapter.getXmlObject();
                EObject masterAnnoOb = wmmAdapter.getAnnotationObject();
                if (masterXmlOb != null && masterXmlOb.eIsSet((EStructuralFeature)attr)) {
                    Object masterXmlValue = masterXmlOb.eGet((EStructuralFeature)attr);
                    if (!destObject.eGet((EStructuralFeature)attr).equals(masterXmlValue)) {
                        if (debug) {
                            System.out.println("XXX ERROR CASE - why isn't the master value set on the dest object?");
                            System.out.println("Existing dest value: " + destObject.eGet((EStructuralFeature)attr));
                            System.out.println("master xml Ob: " + masterXmlOb + "\nmaster value: " + masterXmlValue);
                        }
                        JavaEEPlugin.logError(new IllegalStateException("model in an unexpected state"));
                    }
                    if (!debug) continue;
                    System.out.println("Keeping value from master web.xml");
                    continue;
                }
                if (masterAnnoOb != null && masterAnnoOb.eIsSet((EStructuralFeature)attr)) {
                    Object masterAnnoValue = masterAnnoOb.eGet((EStructuralFeature)attr);
                    if (!destObject.eGet((EStructuralFeature)attr).equals(masterAnnoValue) && wmmAdapter.getXmlFragments().size() == 0) {
                        if (debug) {
                            System.out.println("XXX ERROR CASE - why isn't the master value set on the dest object?");
                            System.out.println("Existing dest value: " + destObject.eGet((EStructuralFeature)attr));
                            System.out.println("master anno Ob: " + masterAnnoOb + "\nmaster value: " + masterAnnoValue);
                        }
                        JavaEEPlugin.logError(new IllegalStateException("model in an unexpected state"));
                    }
                    if (!debug) continue;
                    System.out.println("Keeping value from master annotations");
                    continue;
                }
                if (!debug) continue;
                System.out.println("Posssible conflict, keeping existing value");
                continue;
            }
            if (debug) {
                System.out.println("copying source to dest");
            }
            if ((srcValue = fragObject.eGet((EStructuralFeature)attr)) instanceof EObject) {
                JavaEEPlugin.logError(new RuntimeException("attribute is EObject, need copy & adapt code"));
            }
            destObject.eSet((EStructuralFeature)attr, srcValue);
        }
        EList sourceContents = fragObject.eContents();
        EList destContents = destObject.eContents();
        int i = 0;
        while (i < sourceContents.size()) {
            EObject sourceChild = (EObject)sourceContents.get(i);
            if (debug) {
                System.out.println("contained source object: " + sourceChild);
            }
            EList eList = destContents;
            synchronized (eList) {
                EObject destChild = MergeUtil.findMatchingXML(sourceChild, (List)destContents);
                if (destChild != null) {
                    WebMergedModelAdapter destChildAdapter;
                    if (debug) {
                        System.out.println("merging with " + destChild);
                    }
                    if ((destChildAdapter = MergeUtil.getWebMMAdapterFromEObject(destChild)) != null) {
                        MergeUtil.mergeWeb30Fragment(destChild, sourceChild, destChildAdapter, isXml, isFrag);
                    }
                } else {
                    if (debug) {
                        System.out.println("adding copy of sourceChild: " + sourceChild);
                    }
                    EObject newChild = MergeUtil.copyAndAdaptAll(sourceChild, isXml, true, WebMergedModelAdapter.ADAPTER_CLASS);
                    EStructuralFeature esf = sourceChild.eContainingFeature();
                    if (!(newChild instanceof OrderingType)) {
                        MergeUtil.addChild(destObject, newChild, esf);
                    }
                }
            }
            ++i;
        }
    }

    public static void mergeMappedEJBModule(EObject destObject, EObject sourceObject, MergedModelAdapter2 mmadapter2, boolean isXml, boolean isMappedEJB) {
        boolean metadataComplete = false;
        EList adapters = sourceObject.eAdapters();
        if (!adapters.contains((Object)mmadapter2)) {
            sourceObject.eAdapters().add((Object)mmadapter2);
        }
        if (destObject instanceof EJBJar) {
            metadataComplete = ((EJBJar)destObject).isMetadataComplete();
        }
        EClass eClass = destObject.eClass();
        EList attributes = eClass.getEAllAttributes();
        for (EAttribute attr : attributes) {
            if (attr.isMany()) {
                if (attr.getEType().getInstanceClass() != String.class) continue;
                List xmlList = (List)destObject.eGet((EStructuralFeature)attr);
                UniqueEList newList = new UniqueEList((Collection)xmlList);
                if (!metadataComplete) {
                    List annList = (List)sourceObject.eGet((EStructuralFeature)attr);
                    newList.addAll((Collection)annList);
                }
                destObject.eSet((EStructuralFeature)attr, (Object)newList);
                continue;
            }
            if (destObject.eIsSet((EStructuralFeature)attr)) {
                Object value = destObject.eGet((EStructuralFeature)attr);
                destObject.eSet((EStructuralFeature)attr, value);
                continue;
            }
            if (metadataComplete || !sourceObject.eIsSet((EStructuralFeature)attr)) continue;
            Object annoValue = sourceObject.eGet((EStructuralFeature)attr);
            destObject.eSet((EStructuralFeature)attr, annoValue);
        }
        LinkedList destContents = new LinkedList(destObject.eContents());
        if (!metadataComplete) {
            EList sourceContents = sourceObject.eContents();
            for (EObject sourceChild : sourceContents) {
                EObject destChild = MergeUtil.findMatchingXML(sourceChild, destContents);
                if (destChild != null) {
                    if (debug) {
                        System.out.println("merging with " + destChild);
                    }
                    MergedModelAdapter2 destChildAdapter = MergeUtil.getAdapterFromEObject(destChild);
                    if (isMappedEJB) {
                        destChildAdapter.addEJBAnnoFragObject(sourceChild);
                    }
                    MergeUtil.mergeMappedEJBModule(destChild, sourceChild, destChildAdapter, isXml, isMappedEJB);
                    destContents.remove(destChild);
                    continue;
                }
                EObject newChild = MergeUtil.copyAndAdaptAll(sourceChild, isXml, isMappedEJB, MergedModelAdapter2.class);
                EStructuralFeature esf = sourceChild.eContainingFeature();
                MergeUtil.addChild(destObject, newChild, esf);
            }
        }
        if (debug && destObject instanceof EJBJar) {
            System.out.println("merged results for EJBInWar model");
            MergeUtil.dumpModel(destObject, 0);
        }
    }

    public static List<List> getOrderedLists(IProject proj, WebApp xmlRoot) {
        List<List> orderedFragmentsList = new ArrayList<List>();
        IVirtualComponent webComponent = ComponentCore.createComponent((IProject)proj);
        if (webComponent != null) {
            List webFragmentComponents = WebUtilities.getWebFragments((IVirtualComponent)webComponent, (boolean)true);
            ArrayList<WebFragment> fragmentsXml = new ArrayList<WebFragment>();
            ArrayList<WebFragment> fragmentsAnno = new ArrayList<WebFragment>();
            OrderingTypeEnum orderingType = MergeUtil.getOrderingType(xmlRoot, webFragmentComponents);
            if (debug) {
                System.out.println("----------------ORDERING-----------------------");
            }
            if (orderingType == OrderingTypeEnum.none) {
                if (debug) {
                    System.out.println("WebApp has no specified orderings");
                }
                for (IVirtualComponent webFragmentComponent : webFragmentComponents) {
                    WebFragment xmlFrag = MergeUtil.getWebFragmentDDObject(webFragmentComponent);
                    if (debug) {
                        System.out.println("NO ORDER: XML FRAG ADDED " + MergeUtil.hexId(xmlFrag));
                    }
                    fragmentsXml.add(xmlFrag);
                    if (!xmlFrag.isMetadataComplete()) {
                        WebFragment annoFrag = MergeUtil.getAnnotatedWebFragment(webFragmentComponent);
                        if (annoFrag == null) continue;
                        fragmentsAnno.add(annoFrag);
                        continue;
                    }
                    if (!debug) continue;
                    System.out.println("NO ORDER: METADATA=TRUE, ANNOTATION FRAG EXCLUDED ");
                }
                orderedFragmentsList.add(fragmentsXml);
                orderedFragmentsList.add(fragmentsAnno);
                if (debug) {
                    System.out.println("----------------ORDERING-----------------------");
                }
                return orderedFragmentsList;
            }
            orderedFragmentsList = orderingType == OrderingTypeEnum.absolute ? MergeUtil.processAbsoluteOrdering(xmlRoot, webFragmentComponents) : MergeUtil.processRelativeOrdering(webFragmentComponents);
            if (debug) {
                System.out.println("----------------ORDERING-----------------------");
            }
        }
        return orderedFragmentsList;
    }

    public static void composeInto(EObject xmlEJBJar, EObject annoEJBJar, List ejbAnnoLib, EObject result, MergedModelAdapter2 resultAdapter) {
        if (xmlEJBJar != null) {
            MergeUtil.mergeMappedEJBModule(result, xmlEJBJar, resultAdapter, true, false);
            if (annoEJBJar != null) {
                MergeUtil.mergeMappedEJBModule(result, annoEJBJar, resultAdapter, false, false);
            }
        } else if (annoEJBJar != null) {
            MergeUtil.mergeMappedEJBModule(result, annoEJBJar, resultAdapter, false, false);
        }
        for (Object ejbAnno : ejbAnnoLib) {
            resultAdapter.addEJBAnnoFragObject((EObject)ejbAnno);
            MergeUtil.mergeMappedEJBModule(result, (EObject)ejbAnno, resultAdapter, false, true);
        }
    }

    public static void composeInto(EObject xmlWebApp, EObject annotationWebApp, List xmlFragments, List annoFragments, EObject result, WebMergedModelAdapter resultAdapter) {
        resultAdapter.getAnnoFragments().clear();
        resultAdapter.getXmlFragments().clear();
        WebMergedModelAdapter wwma = resultAdapter;
        if (xmlWebApp != null) {
            MergeUtil.mergeWeb30Fragment(result, xmlWebApp, wwma, true, false);
            for (Object xmlFrag : xmlFragments) {
                MergeUtil.mergeWeb30Fragment(result, (EObject)xmlFrag, wwma, true, true);
            }
            if (annotationWebApp != null) {
                MergeUtil.mergeWeb30Fragment(result, annotationWebApp, wwma, false, false);
            }
            for (Object annoFrag : annoFragments) {
                MergeUtil.mergeWeb30Fragment(result, (EObject)annoFrag, wwma, false, true);
            }
        } else if (xmlFragments.size() > 0) {
            int i = 0;
            while (i < xmlFragments.size()) {
                MergeUtil.mergeWeb30Fragment(result, (EObject)xmlFragments.get(i), wwma, true, true);
                ++i;
            }
            if (annotationWebApp != null) {
                MergeUtil.mergeWeb30Fragment(result, annotationWebApp, wwma, false, false);
            }
            for (Object annoFrag : annoFragments) {
                MergeUtil.mergeWeb30Fragment(result, (EObject)annoFrag, wwma, false, true);
            }
        } else if (annotationWebApp != null) {
            MergeUtil.mergeWeb30Fragment(result, annotationWebApp, wwma, false, false);
            for (Object annoFrag : annoFragments) {
                MergeUtil.mergeWeb30Fragment(result, (EObject)annoFrag, wwma, false, true);
            }
        } else {
            int i = 0;
            while (i < annoFragments.size()) {
                MergeUtil.mergeWeb30Fragment(result, (EObject)annoFragments.get(i), wwma, false, true);
                ++i;
            }
        }
        if (debug) {
            System.out.println("merged result for mainMerged model: ");
            MergeUtil.dumpModel(result, 0, true);
        }
    }

    static OrderingTypeEnum getOrderingType(WebApp xmlRoot, List<IVirtualComponent> webFragmentComponents) {
        List absOrdering = xmlRoot.getAbsoluteOrdering();
        if (absOrdering.size() > 0) {
            return OrderingTypeEnum.absolute;
        }
        for (IVirtualComponent webFragmentComponent : webFragmentComponents) {
            WebFragment wf = MergeUtil.getWebFragmentDDObject(webFragmentComponent);
            List wfOrderings = wf.getOrdering();
            if (wfOrderings.size() <= 0) continue;
            return OrderingTypeEnum.relative;
        }
        return OrderingTypeEnum.none;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static WebFragment getWebFragmentDDObject(IVirtualComponent webFragmentComponent) {
        WebFragment wf = null;
        if (webFragmentComponent.isBinary()) {
            JavaEEBinaryComponentHelper helper = null;
            try {
                helper = new JavaEEBinaryComponentHelper(webFragmentComponent);
                EObject binaryModule = helper.getPrimaryRootObject();
                if (binaryModule == null) return wf;
                wf = (WebFragment)binaryModule;
                return wf;
            }
            finally {
                if (helper != null) {
                    helper.dispose();
                }
            }
        } else {
            WebFragmentModelProvider wfmp = (WebFragmentModelProvider)ModelProviderManager.getModelProvider((IVirtualComponent)webFragmentComponent);
            return (WebFragment)wfmp.getXMLModel(IJEE5ModelProvider.WEBFRAGMENT_DD_MODEL_XML_NODEVICE);
        }
    }

    private static List<List> processAbsoluteOrdering(WebApp xmlRoot, List<IVirtualComponent> webFragmentComponents) {
        if (debug) {
            System.out.println("WebApp has absolute orderings: " + xmlRoot);
        }
        List absOrdering = xmlRoot.getAbsoluteOrdering();
        Iterator aoIter = absOrdering.iterator();
        ArrayList<WebFragment> fragmentsXml = new ArrayList<WebFragment>();
        ArrayList<WebFragment> fragmentsAnno = new ArrayList<WebFragment>();
        HashMap<Integer, IVirtualComponent> orderedFrags = new HashMap<Integer, IVirtualComponent>();
        while (aoIter.hasNext()) {
            WebFragment wf;
            AbsoluteOrderingType absType = (AbsoluteOrderingType)aoIter.next();
            List names = absType.getName();
            List others = absType.getOthers();
            int namedIndex = 0;
            int othersIndex = names.size();
            ArrayList<IVirtualComponent> excludedFragments = new ArrayList<IVirtualComponent>();
            if (names.size() == 0 && others.size() == 0) {
                for (IVirtualComponent webFrag : webFragmentComponents) {
                    orderedFrags.put(othersIndex++, webFrag);
                }
            } else {
                for (IVirtualComponent webFragmentComponent : webFragmentComponents) {
                    wf = MergeUtil.getWebFragmentDDObject(webFragmentComponent);
                    String wfName = null;
                    Iterator iterator = wf.getName().iterator();
                    while (iterator.hasNext()) {
                        String name;
                        wfName = name = (String)iterator.next();
                    }
                    if (wfName != null && names.contains(wfName)) {
                        namedIndex = names.indexOf(wfName);
                        orderedFrags.put(namedIndex, webFragmentComponent);
                        continue;
                    }
                    if (others.size() > 0) {
                        orderedFrags.put(othersIndex, webFragmentComponent);
                        ++othersIndex;
                        continue;
                    }
                    if (!webFragmentComponent.isBinary()) continue;
                    excludedFragments.add(webFragmentComponent);
                }
            }
            int i = 0;
            while (i < othersIndex) {
                IVirtualComponent webFragmentComponent = (IVirtualComponent)orderedFrags.get(i);
                if (webFragmentComponent != null) {
                    wf = MergeUtil.getWebFragmentDDObject(webFragmentComponent);
                    fragmentsXml.add(wf);
                    if (debug) {
                        System.out.println("NAMED: XML FRAGMENT ADDED: " + MergeUtil.hexId(wf));
                    }
                    if (!wf.isMetadataComplete()) {
                        WebFragment annoFrag = MergeUtil.getAnnotatedWebFragment(webFragmentComponent);
                        if (annoFrag != null) {
                            fragmentsAnno.add(annoFrag);
                        }
                    } else if (debug) {
                        System.out.println("NAMED: METADATA=TRUE, ANNO FRAGMENT EXCLUDED");
                    }
                }
                ++i;
            }
            if (excludedFragments.size() <= 0) continue;
            fragmentsAnno.addAll(MergeUtil.getExcludedFragments(xmlRoot.getServlets(), excludedFragments));
            fragmentsAnno.addAll(MergeUtil.getExcludedFragments(xmlRoot.getFilters(), excludedFragments));
            fragmentsAnno.addAll(MergeUtil.getExcludedFragments(xmlRoot.getListeners(), excludedFragments));
        }
        ArrayList<List> orderedFragmentsList = new ArrayList<List>();
        orderedFragmentsList.add(fragmentsXml);
        orderedFragmentsList.add(fragmentsAnno);
        return orderedFragmentsList;
    }

    private static List<WebFragment> getExcludedFragments(List<Object> modelObjects, List<IVirtualComponent> webFragments) {
        ArrayList<WebFragment> referencedWebFragments = new ArrayList<WebFragment>();
        Path path = null;
        for (IVirtualComponent webFragment : webFragments) {
            try {
                IArchive archive = JavaEEArchiveUtilities.INSTANCE.openArchive(webFragment);
                String qualifiedClassName = new String();
                if (archive != null) {
                    for (Object modelObj : modelObjects) {
                        WebFragment xmlFrag;
                        qualifiedClassName = modelObj instanceof Servlet ? ((Servlet)modelObj).getServletClass() : (modelObj instanceof Filter ? ((Filter)modelObj).getFilterClass() : ((Listener)modelObj).getListenerClass());
                        path = new Path(String.valueOf(MergeUtil.convertPathDelimiters(qualifiedClassName)) + ".class");
                        if (!archive.containsArchiveResource((IPath)path) || (xmlFrag = MergeUtil.getWebFragmentDDObject(webFragment)).isMetadataComplete()) continue;
                        JavaEEBinaryComponentHelper helper = new JavaEEBinaryComponentHelper(webFragment);
                        IJavaProject jProj = JavaCore.create((IProject)webFragment.getProject());
                        try {
                            IPackageFragmentRoot root = jProj.findPackageFragmentRoot(helper.getAbsolutePath());
                            IJavaElement[] pkgFragments = root.getChildren();
                            String pkgName = new String();
                            String qualifiedName = new String();
                            int i = 0;
                            while (i < pkgFragments.length) {
                                pkgName = pkgFragments[i].getElementName();
                                IJavaElement[] classes = ((IPackageFragment)pkgFragments[i]).getChildren();
                                int j = 0;
                                while (j < classes.length) {
                                    qualifiedName = pkgName.length() > 0 ? String.valueOf(pkgName) + "." + classes[j].getElementName() : classes[j].getElementName();
                                    if (qualifiedName.equals(String.valueOf(qualifiedClassName) + ".class")) {
                                        WebFragment annoWebFragment = (WebFragment)EMF2AnnotationModelBaseProvider.getInstance().getAnnotationWebFragmentObject(classes[j]);
                                        referencedWebFragments.add(annoWebFragment);
                                        if (debug) {
                                            MergeUtil.dumpModel((EObject)annoWebFragment, 0);
                                        }
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                        }
                        catch (JavaModelException e) {
                            JavaEEPlugin.logError((CoreException)((Object)e));
                        }
                    }
                }
                JavaEEArchiveUtilities.INSTANCE.closeArchive(archive);
            }
            catch (ArchiveOpenFailureException e) {
                JavaEEPlugin.logError(e);
            }
        }
        return referencedWebFragments;
    }

    private static String convertPathDelimiters(String name) {
        StringTokenizer st;
        int numTokens;
        StringBuffer convertedString = new StringBuffer(0);
        if (name != null && (numTokens = (st = new StringTokenizer(name, ".")).countTokens()) > 0) {
            int i = 0;
            while (i < numTokens - 1) {
                convertedString.append(String.valueOf(st.nextToken()) + "/");
                ++i;
            }
            convertedString.append(st.nextToken());
        }
        return convertedString.toString();
    }

    private static List<List> processRelativeOrdering(List webFragProjects) {
        if (debug) {
            System.out.println("WebApp has relative orderings: ");
        }
        List<List> sortedRules = MergeUtil.sortRelativeOrderingRules(webFragProjects);
        return MergeUtil.getSortedFragmentsForRelativeOrderings(sortedRules, webFragProjects);
    }

    private static List<List> getSortedFragmentsForRelativeOrderings(List<List> sortedRules, List webFragmentComponents) {
        ArrayList<WebFragment> fragmentsXml = new ArrayList<WebFragment>();
        ArrayList<WebFragment> fragmentsAnno = new ArrayList<WebFragment>();
        ArrayList<List> orderedList = new ArrayList<List>();
        ArrayList<RelativeOrderingObject> relativeOrderings = new ArrayList<RelativeOrderingObject>();
        relativeOrderings.addAll(sortedRules.get(0));
        relativeOrderings.addAll(sortedRules.get(1));
        relativeOrderings.addAll(sortedRules.get(2));
        ArrayList complexFragments = (ArrayList)sortedRules.get(3);
        if (debug) {
            System.out.println("------------------------RELATIVE ORDERING-------------------------------");
        }
        if (complexFragments.size() > 0) {
            MergeUtil.sortComplexRules((RelativeOrderingObject)complexFragments.remove(0), complexFragments, relativeOrderings);
        }
        for (RelativeOrderingObject obj : relativeOrderings) {
            IVirtualComponent wfComponent = obj.getWebFragmentComponent();
            WebFragment xmlFrag = MergeUtil.getWebFragmentDDObject(wfComponent);
            fragmentsXml.add(xmlFrag);
            if (!xmlFrag.isMetadataComplete()) {
                WebFragment annoFrag = MergeUtil.getAnnotatedWebFragment(obj.getWebFragmentComponent());
                if (annoFrag == null) continue;
                fragmentsAnno.add(annoFrag);
                continue;
            }
            if (!debug) continue;
            System.out.println("RELATIVE ORDERING: METADATA=TRUE, ANNO FRAGMENT EXCLUDED");
        }
        orderedList.add(fragmentsXml);
        orderedList.add(fragmentsAnno);
        if (debug) {
            System.out.println("Ordering for WebFragments: " + fragmentsXml);
            System.out.println("Ordering for Annotation Fragments: " + fragmentsAnno);
            System.out.println("------------------------RELATIVE ORDERING-------------------------------");
        }
        return orderedList;
    }

    private static void sortComplexRules(RelativeOrderingObject rule, List<RelativeOrderingObject> complexRules, List<RelativeOrderingObject> relativeOrderings) {
        RelativeOrderingObject complexObj = rule;
        List orderingList = complexObj.getFragment().getOrdering();
        int beforeIndex = -1;
        int afterIndex = -1;
        OrderingType order = (OrderingType)orderingList.get(0);
        afterIndex = MergeUtil.getBeforeOrAfterIndex(order, true, complexRules, relativeOrderings);
        beforeIndex = MergeUtil.getBeforeOrAfterIndex(order, false, complexRules, relativeOrderings);
        if (afterIndex >= 0 && beforeIndex == -1) {
            relativeOrderings.add(++afterIndex, complexObj);
        } else if (beforeIndex >= 0 && afterIndex == -1) {
            relativeOrderings.add(beforeIndex, complexObj);
        } else if (afterIndex < beforeIndex) {
            relativeOrderings.add(++afterIndex, complexObj);
        } else if ((afterIndex > beforeIndex || afterIndex == beforeIndex) && debug) {
            System.out.println("Ordering position is undetermined for Fragment " + complexObj.getWebFragmentName());
            System.out.println("Rule could not be processed.  Check for cyclic dependency or for a non existent web fragment");
        }
        if (complexRules.size() <= 0) {
            return;
        }
        MergeUtil.sortComplexRules(complexRules.remove(0), complexRules, relativeOrderings);
    }

    private static int getBeforeOrAfterIndex(OrderingType order, boolean isAfter, List<RelativeOrderingObject> complexRules, List<RelativeOrderingObject> relativeOrderings) {
        int ootIndex = -1;
        OrderingOrderingType oot = isAfter ? order.getAfter() : order.getBefore();
        if (oot != null) {
            List names = oot.getName();
            if (names.size() > 0) {
                for (String name : names) {
                    int curIndex = MergeUtil.getIndexForName(name, relativeOrderings);
                    if (curIndex == 0) {
                        ootIndex = 0;
                        continue;
                    }
                    if (curIndex == -1) {
                        int depIndex = MergeUtil.getIndexForName(name, complexRules);
                        if (depIndex != -1) {
                            MergeUtil.sortComplexRules(complexRules.remove(depIndex), complexRules, relativeOrderings);
                            continue;
                        }
                        ootIndex = -1;
                        continue;
                    }
                    if (isAfter) {
                        if (ootIndex != -1) {
                            if (curIndex <= ootIndex) continue;
                            ootIndex = curIndex;
                            continue;
                        }
                        ootIndex = curIndex;
                        continue;
                    }
                    if (ootIndex != -1) {
                        if (curIndex >= ootIndex) continue;
                        ootIndex = curIndex;
                        continue;
                    }
                    ootIndex = curIndex;
                }
            } else if (oot.getOthers() != null) {
                ootIndex = isAfter ? relativeOrderings.size() - 1 : 0;
            }
        }
        return ootIndex;
    }

    private static int getIndexForName(String name, List<RelativeOrderingObject> relativeOrderingList) {
        int i = 0;
        while (i < relativeOrderingList.size()) {
            if (name.equals(relativeOrderingList.get(i).getWebFragmentName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static List<List> sortRelativeOrderingRules(List<IVirtualComponent> webFragProjects) {
        ArrayList<RelativeOrderingObject> noOrderFragments = new ArrayList<RelativeOrderingObject>();
        ArrayList<RelativeOrderingObject> beforeFragments = new ArrayList<RelativeOrderingObject>();
        ArrayList<RelativeOrderingObject> afterFragments = new ArrayList<RelativeOrderingObject>();
        ArrayList<RelativeOrderingObject> complexFragments = new ArrayList<RelativeOrderingObject>();
        for (IVirtualComponent webProj : webFragProjects) {
            WebFragment wf = MergeUtil.getWebFragmentDDObject(webProj);
            List orderings = wf.getOrdering();
            if (orderings == null || orderings.size() == 0) {
                noOrderFragments.add(new RelativeOrderingObject(wf, webProj));
                continue;
            }
            for (OrderingType ordering : orderings) {
                OrderingOrderingType before = ordering.getBefore();
                OrderingOrderingType after = ordering.getAfter();
                if (before != null && after == null) {
                    if (before.getName().isEmpty()) {
                        if (before.getOthers() != null) {
                            beforeFragments.add(new RelativeOrderingObject(wf, webProj));
                            continue;
                        }
                        noOrderFragments.add(new RelativeOrderingObject(wf, webProj));
                        continue;
                    }
                    complexFragments.add(new RelativeOrderingObject(wf, webProj));
                    continue;
                }
                if (after != null && before == null) {
                    if (after.getName().isEmpty()) {
                        if (after.getOthers() != null) {
                            afterFragments.add(new RelativeOrderingObject(wf, webProj));
                            continue;
                        }
                        noOrderFragments.add(new RelativeOrderingObject(wf, webProj));
                        continue;
                    }
                    complexFragments.add(new RelativeOrderingObject(wf, webProj));
                    continue;
                }
                if (after == null && before == null) {
                    if (orderings.size() != 1) continue;
                    noOrderFragments.add(new RelativeOrderingObject(wf, webProj));
                    continue;
                }
                if (after == null || before == null) continue;
                if (after.getName().isEmpty() && after.getOthers() == null && before.getName().isEmpty() && before.getOthers() == null) {
                    noOrderFragments.add(new RelativeOrderingObject(wf, webProj));
                }
                complexFragments.add(new RelativeOrderingObject(wf, webProj));
            }
        }
        ArrayList<List> sortedLists = new ArrayList<List>();
        sortedLists.add(beforeFragments);
        sortedLists.add(noOrderFragments);
        sortedLists.add(afterFragments);
        sortedLists.add(complexFragments);
        return sortedLists;
    }

    public static void setOrderingAdapter(EObject ordering, OrderingAdapter orderingAdapter) {
        OrderingOrderingType before;
        ordering.eAdapters().add((Object)orderingAdapter);
        OrderingOrderingType after = ((OrderingType)ordering).getAfter();
        if (after != null) {
            ((EObject)after).eAdapters().add((Object)orderingAdapter);
        }
        if ((before = ((OrderingType)ordering).getBefore()) != null) {
            ((EObject)before).eAdapters().add((Object)orderingAdapter);
        }
    }

    public static void setStructureChangeListenersOnWebFragments(WebStructureChangedAdapter wscAdapter, List<IVirtualComponent> webFragmentComponents) {
        for (IVirtualComponent webFragComponent : webFragmentComponents) {
            if (webFragComponent.isBinary()) continue;
            ModelProviderManager.getModelProvider((IVirtualComponent)webFragComponent).addListener((IModelProviderListener)wscAdapter);
        }
    }

    private static WebFragment getAnnotatedWebFragment(IVirtualComponent webFragmentComponent) {
        if (webFragmentComponent.isBinary()) {
            JavaEEBinaryComponentHelper helper = new JavaEEBinaryComponentHelper(webFragmentComponent);
            IJavaProject jProj = JavaCore.create((IProject)webFragmentComponent.getProject());
            try {
                IPackageFragmentRoot root = jProj.findPackageFragmentRoot(helper.getAbsolutePath());
                if (root != null) {
                    WebFragment binAnnoFrag;
                    WebFragment webFragment = binAnnoFrag = (WebFragment)EMF2AnnotationModelBaseProvider.getInstance().getAnnotationWebFragmentObject((IJavaElement)root);
                    return webFragment;
                }
                return null;
            }
            catch (JavaModelException e) {
                JavaEEPlugin.logError((CoreException)((Object)e));
                return null;
            }
            finally {
                helper.dispose();
            }
        }
        WebFragmentModelProvider wfmp = (WebFragmentModelProvider)ModelProviderManager.getModelProvider((IVirtualComponent)webFragmentComponent);
        WebFragment annoFrag = (WebFragment)wfmp.getAnnotationsModel();
        return annoFrag;
    }

    public static ArrayList<IModelProviderListener> removeAdaptersOnProjectClose(MMAdapter adapter, EObject mergedModel, Object[] listeners) {
        Resource xmlRes = adapter.getXmlObject().eResource();
        ArrayList<IModelProviderListener> removeListenerList = new ArrayList<IModelProviderListener>();
        if (xmlRes != null) {
            Object wsca = null;
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] instanceof WebStructureChangedAdapter) {
                    removeListenerList.add((IModelProviderListener)listeners[i]);
                }
                ++i;
            }
            if (removeListenerList.size() > 0) {
                IVirtualComponent webComponent = ComponentCore.createComponent((IProject)WorkbenchResourceHelper.getProject((Resource)xmlRes));
                List webFragmentComponents = WebUtilities.getWebFragments((IVirtualComponent)webComponent);
                for (IVirtualComponent webFragComponent : webFragmentComponents) {
                    if (webFragComponent.isBinary()) continue;
                    WebFragmentModelProvider wfmp = (WebFragmentModelProvider)ModelProviderManager.getModelProvider((IVirtualComponent)webFragComponent);
                    for (IModelProviderListener listener : removeListenerList) {
                        wfmp.removeListener(listener);
                    }
                }
            }
            mergedModel.eAdapters().remove(wsca);
        }
        adapter.dispose();
        return removeListenerList;
    }

    public static List<IVirtualComponent> getEJBLibModules(IVirtualReference[] refs) {
        ArrayList<IVirtualComponent> ejbLibs = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < refs.length) {
            IVirtualComponent comp = refs[i].getReferencedComponent();
            if (JavaEEProjectUtilities.isEJBComponent((IVirtualComponent)comp) && !JavaEEProjectUtilities.isLegacyJ2EEComponent((IVirtualComponent)comp)) {
                ejbLibs.add(comp);
            }
            ++i;
        }
        return ejbLibs;
    }

    public static void waitForAnnotationModelUpdateJobs(EObject mergedModel) {
        if (mergedModel != null) {
            EObject xmlObj;
            MergedModelAdapter2 adapter = MergeUtil.getAdapterFromEObject(mergedModel);
            IProject project = null;
            int projectType = -1;
            if (adapter != null && (xmlObj = adapter.getXmlObject()) != null && xmlObj.eResource() != null) {
                project = WorkbenchResourceHelper.getProject((Resource)xmlObj.eResource());
                if (mergedModel instanceof EJBJar) {
                    projectType = 1;
                } else if (mergedModel instanceof WebApp) {
                    projectType = 2;
                } else if (mergedModel instanceof WebFragment) {
                    projectType = 2;
                }
            }
            IJobManager jobManager = Job.getJobManager();
            Job updateJob = AnnotationUtils.findAnnotationModelUpdateJob(jobManager, project, projectType);
            while (updateJob != null) {
                try {
                    updateJob.join();
                }
                catch (InterruptedException interruptedException) {}
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                updateJob = AnnotationUtils.findAnnotationModelUpdateJob(jobManager, project, projectType);
            }
        }
    }

    public static void removeStaleAdapters(EObject object) {
        EList adapters = object.eAdapters();
        Iterator annoAdapterIter = adapters.iterator();
        ArrayList<Adapter> adaptersToRemove = new ArrayList<Adapter>();
        while (annoAdapterIter.hasNext()) {
            EObject xml;
            Adapter annoAdapter = (Adapter)annoAdapterIter.next();
            if (!(annoAdapter instanceof MMAdapter) || (xml = ((MMAdapter)annoAdapter).getXmlObject()).eResource() != null) continue;
            adaptersToRemove.add(annoAdapter);
        }
        if (!adaptersToRemove.isEmpty()) {
            for (Adapter adpt : adaptersToRemove) {
                adapters.remove(adpt);
                ((MMAdapter)adpt).dispose();
            }
        }
    }

    static class AttributeMapEntry {
        TransactionAttributeType transactionAtttribute;
        ContainerTransactionType cttRef;
        boolean entryUsed = false;

        AttributeMapEntry(TransactionAttributeType tat, ContainerTransactionType ctt) {
            this.transactionAtttribute = tat;
            this.cttRef = ctt;
        }
    }

    static enum OrderingTypeEnum {
        absolute,
        relative,
        none;

    }

    static class RelativeOrderingObject {
        WebFragment xmlFrag;
        IVirtualComponent wfComponent;

        RelativeOrderingObject(WebFragment xmlFrag, IVirtualComponent webFragmentComponent) {
            this.xmlFrag = xmlFrag;
            this.wfComponent = webFragmentComponent;
        }

        public WebFragment getFragment() {
            return this.xmlFrag;
        }

        public IVirtualComponent getWebFragmentComponent() {
            return this.wfComponent;
        }

        public String getWebFragmentName() {
            List names = this.xmlFrag.getName();
            if (names.size() > 0) {
                return (String)names.get(0);
            }
            return null;
        }
    }
}

