/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.merge;

import com.ibm.etools.javaee.core.JavaEEPlugin;
import com.ibm.etools.javaee.merge.MergeUtil;
import com.ibm.etools.javaee.merge.MergedModelAdapter2;
import com.ibm.etools.javaee.merge.OrderingAdapter;
import com.ibm.etools.javaee.merge.WebMergedModelAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.jst.javaee.core.internal.metadata.JavaeePackage;
import org.eclipse.jst.javaee.ejb.internal.metadata.EjbPackage;
import org.eclipse.jst.javaee.web.AbsoluteOrderingType;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.internal.metadata.WebPackage;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public abstract class MMAdapter
extends AdapterImpl {
    private static String tid;
    static boolean debug;
    static int debugLevel;
    EObject xmlObject = null;
    EObject annotationObject = null;
    EObject mergedObject = null;

    static {
        block4: {
            tid = null;
            debug = false;
            try {
                String debugS = System.getProperty("com.ibm.etools.javaee.merge.DEBUG");
                if (debugS == null) break block4;
                debug = true;
                try {
                    debugLevel = Integer.parseInt(debugS);
                }
                catch (Throwable throwable) {
                    debugLevel = 1;
                }
                System.out.println("debugLevel: " + debugLevel);
            }
            catch (Throwable throwable) {}
        }
    }

    public abstract boolean getMetadataComplete();

    abstract void rebuildMergedModel();

    void reorderAndRebuildMergedModel(Resource res) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MMAdapter(EObject xml, EObject annotation, EObject merged) {
        EList eList;
        EClass annotationClass;
        if (xml != null && annotation != null) {
            EClass xmlClass = xml.eClass();
            if (!xmlClass.equals(annotationClass = annotation.eClass())) {
                throw new IllegalArgumentException();
            }
            EClass mergedClass = merged.eClass();
            if (!mergedClass.equals(annotationClass)) {
                throw new IllegalArgumentException();
            }
        }
        this.xmlObject = xml;
        this.annotationObject = annotation;
        this.mergedObject = merged;
        EList mergedEAdapters = merged.eAdapters();
        annotationClass = mergedEAdapters;
        synchronized (annotationClass) {
            mergedEAdapters.add((Object)this);
        }
        if (xml != null) {
            EList xmlEAdapters;
            eList = xmlEAdapters = xml.eAdapters();
            synchronized (eList) {
                xmlEAdapters.add((Object)this);
            }
        }
        if (annotation != null) {
            EList annotationEAdapters;
            eList = annotationEAdapters = annotation.eAdapters();
            synchronized (eList) {
                annotationEAdapters.add((Object)this);
            }
        }
    }

    void removeAdapters(List<EObject> mergedList) {
        for (EObject x : mergedList) {
            this.removeAdapters(x);
        }
    }

    void removeAdapters(EObject x) {
        EList adapters = x.eAdapters();
        ArrayList<Adapter> removeList = new ArrayList<Adapter>();
        CopyOnWriteArrayList adp = new CopyOnWriteArrayList(adapters);
        for (Adapter ad : adp) {
            if (!(ad instanceof MMAdapter)) continue;
            EObject xmlEO = ((MMAdapter)ad).getXmlObject();
            if (debug && xmlEO == x) {
                System.out.println("XXX xmlEO is the same instance as x");
            }
            if (xmlEO != null) {
                EList xmlAdapters = xmlEO.eAdapters();
                xmlAdapters.remove(ad);
            }
            EObject annEO = ((MMAdapter)ad).getAnnotationObject();
            if (debug && annEO == x) {
                System.out.println("XXX annEO is the same instance as x");
            }
            if (annEO != null) {
                EList annAdapters = annEO.eAdapters();
                annAdapters.remove(ad);
            }
            this.removeAdaptersFromSpecializations(ad, x);
            removeList.add(ad);
        }
        adapters.removeAll(removeList);
        EList children = x.eContents();
        for (EObject child : children) {
            this.removeAdapters(child);
        }
    }

    public void removeAdaptersFromSpecializations(Adapter ad, EObject x) {
    }

    EObject getModelRoot(EObject model) {
        EObject parent = model;
        while (parent.eContainer() != null) {
            parent = parent.eContainer();
        }
        return parent;
    }

    public DataFrom getDerivation() {
        if (this.xmlObject != null && this.annotationObject != null) {
            return DataFrom.mixed;
        }
        return this.xmlObject == null ? DataFrom.annotation : DataFrom.xml;
    }

    public EObject getXmlObject() {
        return this.xmlObject;
    }

    public EObject getAnnotationObject() {
        return this.annotationObject;
    }

    public EObject getAttributeSource(String strValue) {
        Object value;
        EList attributes;
        if (this.xmlObject != null) {
            attributes = this.xmlObject.eClass().getEAttributes();
            for (EAttribute att : attributes) {
                value = this.xmlObject.eGet((EStructuralFeature)att);
                if (strValue != value) continue;
                return this.xmlObject;
            }
        }
        if (this.annotationObject != null) {
            attributes = this.annotationObject.eClass().getEAttributes();
            for (EAttribute att : attributes) {
                value = this.annotationObject.eGet((EStructuralFeature)att);
                if (strValue != value) continue;
                return this.annotationObject;
            }
        }
        return null;
    }

    public EObject getAttributeSource(EAttribute attribute) {
        if (this.xmlObject != null && this.xmlObject.eIsSet((EStructuralFeature)attribute)) {
            return this.xmlObject;
        }
        if (this.annotationObject != null && this.annotationObject.eIsSet((EStructuralFeature)attribute)) {
            return this.annotationObject;
        }
        return null;
    }

    void processAddManyEvents(EObject notifier, EStructuralFeature feature, Object newValue) {
        if (debug) {
            System.out.println("============= ADD MANY =============");
        }
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            if (debug) {
                System.out.println("Change to featureMap, ignoring");
            }
            return;
        }
        boolean isXml = notifier == this.xmlObject;
        for (Object foo : (List)newValue) {
            this.addObjectToList(foo, feature, isXml);
        }
    }

    public Object getOverriddenValue(String featureName) {
        if (featureName == null) {
            return null;
        }
        if (this.xmlObject == null || this.annotationObject == null) {
            return null;
        }
        EList attrs = this.xmlObject.eClass().getEAttributes();
        for (EAttribute a : attrs) {
            if (!featureName.equals(a.getName())) continue;
            return this.getOverriddenValue((EStructuralFeature)a);
        }
        throw new IllegalArgumentException("featureName not found in object attributes: " + featureName);
    }

    public Object getOverriddenValue(EStructuralFeature feature) {
        boolean annSet;
        if (feature == null) {
            return null;
        }
        boolean xmlSet = this.xmlObject == null ? false : this.xmlObject.eIsSet(feature);
        boolean bl = annSet = this.annotationObject == null ? false : this.annotationObject.eIsSet(feature);
        if (xmlSet && annSet) {
            return this.annotationObject.eGet(feature);
        }
        return null;
    }

    public Object getOverriddenValue(int featureID) {
        EStructuralFeature feature = this.xmlObject.eClass().getEStructuralFeature(featureID);
        return this.getOverriddenValue(feature);
    }

    public boolean isAdapterForType(Object type) {
        return ((Object)((Object)this)).getClass() == type;
    }

    boolean checkForNewMerge() {
        Object plO;
        EObject srcObject;
        if (this.xmlObject != null && this.annotationObject != null) {
            return false;
        }
        EObject mergedParent = this.mergedObject.eContainer();
        if (mergedParent == null) {
            return false;
        }
        MMAdapter parentMMA = (MMAdapter)EcoreUtil.getRegisteredAdapter((EObject)mergedParent, ((Object)((Object)this)).getClass());
        if (parentMMA == null) {
            JavaEEPlugin.logInfo("MMAdapter.checkForNewMerge: Missing adapter on parent");
            return false;
        }
        EObject parentXML = parentMMA.getXmlObject();
        EObject parentAnn = parentMMA.getAnnotationObject();
        if (parentXML == null || parentAnn == null) {
            return false;
        }
        EObject eObject = srcObject = this.xmlObject != null ? this.xmlObject : this.annotationObject;
        if (srcObject == null) {
            System.out.println("No toplevel data, must be web-frag only node. What to do?");
            return false;
        }
        EStructuralFeature cFeature = this.mergedObject.eContainingFeature();
        Object object = plO = this.xmlObject != null ? parentAnn.eGet(cFeature) : parentXML.eGet(cFeature);
        if (plO == null) {
            return false;
        }
        if (!(plO instanceof List)) {
            JavaEEPlugin.logInfo("MMAdapter.checkForNewMerge: non-list. parent: " + mergedParent + "\ncFeature: " + cFeature + "\nplO: " + plO);
            return false;
        }
        List potentialMatchList = (List)plO;
        for (EObject potentialMatch : potentialMatchList) {
            EObject annotationIn;
            EObject xmlIn;
            if (!MergeUtil.isMergeable(srcObject, potentialMatch)) continue;
            if (srcObject == this.xmlObject) {
                xmlIn = srcObject;
                annotationIn = potentialMatch;
            } else {
                annotationIn = srcObject;
                xmlIn = potentialMatch;
            }
            List mergedParentList = (List)mergedParent.eGet(cFeature);
            EObject matchingCopy = null;
            EList adapters = potentialMatch.eAdapters();
            for (Adapter ad : adapters) {
                if (!(ad instanceof MMAdapter)) continue;
                MMAdapter mma = (MMAdapter)ad;
                EObject eob = mma.mergedObject;
                if (!mergedParentList.contains(eob)) continue;
                if (debug) {
                    System.out.println("matching object found using MMA " + ad);
                }
                matchingCopy = eob;
                break;
            }
            if (matchingCopy == null) {
                JavaEEPlugin.logError("MMAdapter.checkForNewMerge: Failed to locate copy of matching object in merged model");
                return false;
            }
            if (debug) {
                System.out.println("mergedParentList before removes:");
                for (EObject e : mergedParentList) {
                    System.out.println(e);
                }
            }
            boolean mor = mergedParentList.remove(this.mergedObject);
            boolean mcr = mergedParentList.remove(matchingCopy);
            if (debug) {
                System.out.println("mor: " + mor + ", mcr: " + mcr);
            }
            this.removeAdapters(this.mergedObject);
            this.removeAdapters(matchingCopy);
            EObject newObject = MergeUtil.compose(xmlIn, annotationIn, ((Object)((Object)this)).getClass());
            mergedParentList.add(newObject);
            return true;
        }
        return false;
    }

    boolean removeEObjectFromList(EObject removedObject, EList<EObject> mergedList) {
        MMAdapter adapter = (MMAdapter)EcoreUtil.getRegisteredAdapter((EObject)removedObject, ((Object)((Object)this)).getClass());
        if (adapter == null) {
            adapter = MergeUtil.getAdapterFromRemovedObject(removedObject, mergedList, this);
        }
        if (adapter == null) {
            return false;
        }
        EObject outputObject = adapter.mergedObject;
        if (outputObject == null) {
            JavaEEPlugin.logError("MMAdapter.removeEObjectFromList() mergedObject not set");
            return false;
        }
        mergedList.remove((Object)outputObject);
        this.removeAdapters(outputObject);
        return true;
    }

    void addObjectToList(Object newValue, EStructuralFeature feature, boolean isXml) {
        if (debug) {
            System.out.println("addObjectToList newValue: " + newValue);
            System.out.println("  hex: " + MergeUtil.hexId(newValue));
            System.out.println("  feature: " + feature);
            System.out.println("  isXml: " + isXml);
        }
        Object valueToSet = null;
        EList mergedList = (EList)this.mergedObject.eGet(feature);
        if (newValue instanceof String) {
            for (Object existingValue : mergedList) {
                if (!existingValue.equals(newValue)) continue;
                if (debug) {
                    System.out.println("String value already in list, skipping");
                }
                return;
            }
        }
        if (this.xmlObject == null || this.annotationObject == null || !(newValue instanceof EObject)) {
            if (debug) {
                System.out.println("Copy Block");
            }
            if (newValue instanceof EObject) {
                valueToSet = MergeUtil.copyAndAdaptAll((EObject)newValue, isXml, ((Object)((Object)this)).getClass());
            } else {
                valueToSet = newValue;
                if (debug && !(newValue instanceof String) && !(newValue instanceof AbstractEnumerator)) {
                    System.out.println("unexpected type in addObjectToList: " + newValue.getClass().getName());
                }
            }
        } else {
            List objects = (List)(isXml ? this.annotationObject.eGet(feature) : this.xmlObject.eGet(feature));
            boolean found = false;
            for (Object possibleMatch : objects) {
                if (debug) {
                    System.out.println("checking " + possibleMatch);
                }
                if (!MergeUtil.isMergeable((EObject)newValue, (EObject)possibleMatch)) continue;
                if (debug) {
                    System.out.println("found match");
                }
                this.removeEObjectFromList((EObject)possibleMatch, (EList<EObject>)mergedList);
                valueToSet = isXml ? MergeUtil.compose((EObject)newValue, (EObject)possibleMatch, ((Object)((Object)this)).getClass()) : MergeUtil.compose((EObject)possibleMatch, (EObject)newValue, ((Object)((Object)this)).getClass());
                found = true;
                break;
            }
            if (!found) {
                if (debug) {
                    System.out.println("no match, copying");
                }
                valueToSet = MergeUtil.copyAndAdaptAll((EObject)newValue, isXml, ((Object)((Object)this)).getClass());
            }
        }
        mergedList.add(valueToSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeObjectFromList(Object x, EStructuralFeature feature, boolean isXml) {
        EObject eObject = this.mergedObject;
        synchronized (eObject) {
            EList mergedList = (EList)this.mergedObject.eGet(feature);
            List oppositeList = null;
            if (isXml) {
                if (this.annotationObject != null) {
                    oppositeList = (List)this.annotationObject.eGet(feature);
                }
            } else if (this.xmlObject != null) {
                oppositeList = (List)this.xmlObject.eGet(feature);
            }
            if (oppositeList == null || !oppositeList.contains(x)) {
                mergedList.remove(x);
            }
        }
    }

    boolean removeAndReplaceEObjectFromList(EObject removedObject, EList<EObject> mergedList) {
        MMAdapter adapter = (MMAdapter)EcoreUtil.getRegisteredAdapter((EObject)removedObject, ((Object)((Object)this)).getClass());
        if (debug) {
            System.out.println("removedObject: " + MergeUtil.hexId(removedObject) + "Object: " + removedObject);
            System.out.println("adapter: " + MergeUtil.hexId((Object)adapter));
        }
        if (adapter == null && (adapter = MergeUtil.getAdapterFromRemovedObject(removedObject, mergedList, this)) == null) {
            return false;
        }
        EObject outputObject = adapter.mergedObject;
        if (debug) {
            System.out.println("mergedObject: " + MergeUtil.hexId(this.mergedObject));
            System.out.println("mergedObject parent: " + outputObject.eContainer());
        }
        if (outputObject == null) {
            JavaEEPlugin.logError("MMAdapter.removeObjectFromList() mergedObject not set");
            return false;
        }
        boolean result = mergedList.remove((Object)outputObject);
        if (debug) {
            System.out.println("remove(oo)=" + result);
        }
        if (!result) {
            if (debug) {
                System.out.println("object not found in merged list, bailing out");
            }
            return false;
        }
        this.removeAdapters(outputObject);
        this.rebuildMergedObject(removedObject, adapter, mergedList, outputObject);
        return true;
    }

    void rebuildMergedObject(EObject removedObject, MMAdapter adapter, EList<EObject> mergedList, EObject outputObject) {
        boolean otherObIsXml;
        EObject otherObject = null;
        if (removedObject == adapter.xmlObject) {
            adapter.xmlObject = null;
            otherObject = adapter.annotationObject;
            otherObIsXml = false;
        } else {
            adapter.annotationObject = null;
            otherObject = adapter.xmlObject;
            otherObIsXml = true;
        }
        if (otherObject != null) {
            EObject newCopy = MergeUtil.copyAndAdaptAll(otherObject, otherObIsXml, ((Object)((Object)this)).getClass());
            mergedList.add((Object)newCopy);
        }
    }

    public void dispose() {
        if (debug) {
            System.out.println("WebMergedModelAdapter.dispose() started for " + MergeUtil.hexId(this.mergedObject));
        }
        this.removeAdapters(this.mergedObject);
        if (this.mergedObject != null) {
            EList mergedAdapters = this.mergedObject.eAdapters();
            mergedAdapters.clear();
        }
        EcoreUtil.remove((EObject)this.mergedObject);
        if (debug) {
            System.out.println("MMA2.dispose() finished for " + MergeUtil.hexId(this.mergedObject));
        }
    }

    void processSetEvents(EObject notifier, EStructuralFeature feature, Object oldValue, Object oldMergedValue, Object value, boolean metadataComplete, String LOG_PREFIX) {
        if (feature == EcorePackage.eINSTANCE.getEClass_EIDAttribute()) {
            if (debug) {
                System.out.println("ignoring notification for EIDAttribute");
            }
            return;
        }
        if (this instanceof WebMergedModelAdapter ? ((WebMergedModelAdapter)this).checkForStructChange(notifier) : this.checkForNewMerge()) {
            return;
        }
        boolean removeAdapters = true;
        if (feature == EjbPackage.Literals.EJB_JAR__ENTERPRISE_BEANS && notifier == this.annotationObject && this.mergedObject.eIsSet(feature)) {
            removeAdapters = false;
        }
        if (oldMergedValue instanceof EObject && removeAdapters) {
            this.removeAdapters((EObject)oldMergedValue);
        }
        Object valueToSet = value;
        if (value == null) {
            if (oldValue != null) {
                if (notifier == this.xmlObject) {
                    valueToSet = this.annotationObject != null ? this.annotationObject.eGet(feature) : null;
                } else {
                    Object object = valueToSet = this.xmlObject != null ? this.xmlObject.eGet(feature) : null;
                }
                if (valueToSet instanceof EObject) {
                    valueToSet = MergeUtil.copyAndAdaptAll((EObject)valueToSet, true, ((Object)((Object)this)).getClass());
                }
                this.mergedObject.eSet(feature, valueToSet);
            } else if (debug) {
                System.out.println("ignoring change from null to null for feature " + feature);
            }
            return;
        }
        if (value instanceof EObject) {
            EObject annValue;
            EObject xmlValue = this.xmlObject != null ? (EObject)this.xmlObject.eGet(feature) : null;
            EObject eObject = annValue = this.annotationObject != null ? (EObject)this.annotationObject.eGet(feature) : null;
            if (xmlValue != null && annValue != null) {
                valueToSet = MergeUtil.compose(xmlValue, annValue, ((Object)((Object)this)).getClass());
                this.mergedObject.eSet(feature, valueToSet);
                return;
            }
        }
        if (this.mergedObject.eGet(feature) instanceof List) {
            List listA = this.xmlObject == null ? new ArrayList() : (List)this.xmlObject.eGet(feature);
            List listB = this.annotationObject == null ? new ArrayList() : (List)this.annotationObject.eGet(feature);
            if (value instanceof EObject) {
                if (debug) {
                    System.out.println(String.valueOf(LOG_PREFIX) + "List SET for EObject in WebMergedModelAdapter");
                }
                List mergedList2 = (List)this.mergedObject.eGet(feature);
                this.removeAdapters(mergedList2);
                MergeUtil.composeLists(listA, listB, mergedList2, ((Object)((Object)this)).getClass());
            } else {
                UniqueEList newList = new UniqueEList(listA);
                if (!metadataComplete) {
                    newList.addAll(listB);
                }
                this.mergedObject.eSet(feature, (Object)newList);
            }
        } else if (notifier == this.xmlObject) {
            if (value instanceof EObject) {
                valueToSet = MergeUtil.copyAndAdaptAll((EObject)value, true, ((Object)((Object)this)).getClass());
            }
            try {
                this.mergedObject.eSet(feature, valueToSet);
            }
            catch (Exception e) {
                JavaEEPlugin.logInfo(String.valueOf(LOG_PREFIX) + "eSet failed for feature " + feature + " exception was " + e);
            }
        } else if (notifier == this.annotationObject) {
            if (this.xmlObject == null || !this.xmlObject.eIsSet(feature)) {
                if (feature == EjbPackage.Literals.EJB_JAR__ENTERPRISE_BEANS && this.mergedObject.eIsSet(feature)) {
                    EObject mergedEB = (EObject)this.mergedObject.eGet(feature);
                    MergeUtil.mergeMappedEJBModule(mergedEB, (EObject)value, MergeUtil.getAdapterFromEObject(mergedEB), false, false);
                    return;
                }
                if (value instanceof EObject) {
                    valueToSet = MergeUtil.copyAndAdaptAll((EObject)value, false, ((Object)((Object)this)).getClass());
                }
                this.mergedObject.eSet(feature, valueToSet);
            }
        } else {
            if (debug) {
                System.out.println("XXX trying out new getActiveValue() method");
            }
            Object activeValue = this.getActiveValue(feature);
            if (feature == EjbPackage.Literals.EJB_JAR__ENTERPRISE_BEANS) {
                if (activeValue != null) {
                    valueToSet = MergeUtil.copyAndAdaptAll((EObject)activeValue, false, ((Object)((Object)this)).getClass());
                    ((EObject)notifier.eGet(feature)).eAdapters().add((Object)MergeUtil.getAdapterFromEObject((EObject)valueToSet));
                } else if (valueToSet != null) {
                    activeValue = MergeUtil.copyAndAdaptAll((EObject)valueToSet, true, ((Object)((Object)this)).getClass());
                    this.mergedObject.eSet(feature, activeValue);
                    return;
                }
            } else {
                valueToSet = activeValue instanceof EObject ? MergeUtil.copyAndAdaptAll((EObject)activeValue, false, ((Object)((Object)this)).getClass()) : activeValue;
            }
            this.mergedObject.eSet(feature, valueToSet);
        }
    }

    void processUnsetEvents(EObject notifier, EStructuralFeature feature, Object oldMergedValue) {
        boolean removeAdapters = false;
        if (notifier == this.xmlObject) {
            removeAdapters = true;
            if (this.annotationObject != null && this.annotationObject.eIsSet(feature)) {
                Object value = this.annotationObject.eGet(feature);
                Object valueToSet = value instanceof EObject ? MergeUtil.copyAndAdaptAll((EObject)value, true, ((Object)((Object)this)).getClass()) : value;
                this.mergedObject.eSet(feature, valueToSet);
            } else {
                this.mergedObject.eUnset(feature);
            }
        } else if (this.xmlObject == null || !this.xmlObject.eIsSet(feature)) {
            removeAdapters = true;
            this.mergedObject.eUnset(feature);
        }
        if (removeAdapters && oldMergedValue instanceof EObject) {
            this.removeAdapters((EObject)oldMergedValue);
        }
    }

    boolean complexKeyListRemerge(EObject notifier) {
        EObject owningMethod = notifier.eContainer();
        if (owningMethod == null) {
            return false;
        }
        EObject beanObj = owningMethod.eContainer();
        if (beanObj == null) {
            return false;
        }
        MMAdapter beanMMA = (MMAdapter)EcoreUtil.getRegisteredAdapter((EObject)beanObj, ((Object)((Object)this)).getClass());
        if (beanMMA == null) {
            return false;
        }
        EObject annoBean = beanMMA.getAnnotationObject();
        EObject xmlBean = beanMMA.getXmlObject();
        if (annoBean == null || xmlBean == null) {
            return false;
        }
        EStructuralFeature listFeature = notifier.eContainer().eContainingFeature();
        EObject mergedBean = beanMMA.mergedObject;
        List xmlList = (List)xmlBean.eGet(listFeature);
        List annList = (List)annoBean.eGet(listFeature);
        List mergedList = (List)mergedBean.eGet(listFeature);
        this.removeAdapters(mergedList);
        MergeUtil.composeLists(xmlList, annList, mergedList, ((Object)((Object)this)).getClass());
        return true;
    }

    Object getActiveValue(EStructuralFeature feature) {
        Object result = null;
        if (this.xmlObject != null && this.xmlObject.eIsSet(feature)) {
            result = this.xmlObject.eGet(feature);
        } else if (this.annotationObject != null && this.annotationObject.eIsSet(feature)) {
            result = this.annotationObject.eGet(feature);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processRemoveEvents(EObject notifier, EStructuralFeature feature, Object oldValue) {
        EObject eObject = this.mergedObject;
        synchronized (eObject) {
            if (oldValue instanceof EObject) {
                if (debug) {
                    System.out.println("Calling remove and replace for an EObject");
                }
                EList mergedList = (EList)this.mergedObject.eGet(feature);
                this.removeAndReplaceEObjectFromList((EObject)oldValue, (EList<EObject>)mergedList);
            } else if (oldValue instanceof FeatureMap.Entry) {
                if (debug) {
                    System.out.println("Calling remove and replace for an Entry");
                }
                FeatureMap.Entry en = (FeatureMap.Entry)oldValue;
                EStructuralFeature ef = en.getEStructuralFeature();
                if (en.getValue() instanceof EObject) {
                    EObject x = (EObject)en.getValue();
                    EList mList = (EList)this.mergedObject.eGet(ef);
                    this.removeAndReplaceEObjectFromList(x, (EList<EObject>)mList);
                } else {
                    this.removeObjectFromList(oldValue, feature, notifier == this.xmlObject);
                }
            } else {
                if (debug) {
                    System.out.println("Calling remove for non-Entry/EObject");
                }
                this.removeObjectFromList(oldValue, feature, notifier == this.xmlObject);
            }
        }
    }

    void processRemoveManyEvents(EObject notifier, EStructuralFeature feature, Object oldValue, String LOG_PREFIX) {
        block8: {
            block9: {
                block7: {
                    if (!(oldValue instanceof EList)) break block7;
                    EList removedValues = (EList)oldValue;
                    for (Object x : removedValues) {
                        EList mergedList;
                        if (x instanceof FeatureMap.Entry) {
                            FeatureMap.Entry en = (FeatureMap.Entry)x;
                            EStructuralFeature f = en.getEStructuralFeature();
                            Object v = en.getValue();
                            mergedList = (EList)this.mergedObject.eGet(f);
                            this.removeAndReplaceEObjectFromList((EObject)v, (EList<EObject>)mergedList);
                            continue;
                        }
                        if (x instanceof EObject) {
                            mergedList = (EList)this.mergedObject.eGet(feature);
                            this.removeAndReplaceEObjectFromList((EObject)x, (EList<EObject>)mergedList);
                            continue;
                        }
                        this.removeObjectFromList(x, feature, notifier == this.xmlObject);
                    }
                    break block8;
                }
                if (oldValue != Collections.EMPTY_LIST) break block9;
                if (!debug) break block8;
                System.out.println("ignoring remove_many with EMPTY_LIST");
                break block8;
            }
            if (oldValue == null) {
                JavaEEPlugin.logInfo(String.valueOf(LOG_PREFIX) + "ignoring REMOVE_MANY with null oldValue");
            } else {
                try {
                    JavaEEPlugin.logInfo(String.valueOf(LOG_PREFIX) + "ignoring REMOVE_MANY with non-EList:");
                    JavaEEPlugin.logInfo(String.valueOf(LOG_PREFIX) + "  oldValue" + oldValue + " type: " + oldValue.getClass().getName());
                    String where = notifier.eClass().getName();
                    String which = feature.getName();
                    JavaEEPlugin.logInfo(String.valueOf(LOG_PREFIX) + "  Notifier: " + where + ", feature: " + which);
                }
                catch (Throwable t) {
                    JavaEEPlugin.logInfo(String.valueOf(LOG_PREFIX) + "exception during logging: " + t);
                }
            }
        }
    }

    void processAddEvents(EObject notifier, EStructuralFeature feature, Object newValue) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            if (debug) {
                System.out.println("Change to featureMap, ignoring");
            }
            return;
        }
        boolean isXml = notifier == this.xmlObject;
        this.addObjectToList(newValue, feature, isXml);
    }

    public MMAdapter getRootAdapter() {
        MMAdapter result = null;
        EObject rootObject = this.getModelRoot(this.mergedObject);
        result = (MMAdapter)EcoreUtil.getRegisteredAdapter((EObject)rootObject, ((Object)((Object)this)).getClass());
        return result;
    }

    public void notifyChanged(Notification msg) {
        EObject mergedModel = null;
        Object notifierO = msg.getNotifier();
        if (notifierO == null || notifierO == this.mergedObject) {
            return;
        }
        EObject notifier = (EObject)notifierO;
        Object tmpF = msg.getFeature();
        if (tmpF == null) {
            return;
        }
        if (!(tmpF instanceof EStructuralFeature)) {
            JavaEEPlugin.logInfo("MMAdapter.notifyChanged: feature not ESF:" + tmpF);
            return;
        }
        EStructuralFeature feature = (EStructuralFeature)tmpF;
        try {
            Object oldMergedValue;
            Object oldValue;
            Object newValue;
            block104: {
                boolean listRecreated;
                EClass containerClass;
                List orderings;
                EList absOrderingList;
                newValue = msg.getNewValue();
                oldValue = msg.getOldValue();
                if (debug) {
                    mergedModel = this.getModelRoot(this.mergedObject);
                    String where = notifier == this.annotationObject ? "annotation " : (notifier == this.xmlObject ? "xml " : "UNKNOWN ");
                    where = String.valueOf(where) + notifier.eClass().getName();
                    where = String.valueOf(where) + ":" + Integer.toHexString(System.identityHashCode(notifier));
                    int eventType = msg.getEventType();
                    String which = feature.getName();
                    String adapterID = Integer.toHexString(System.identityHashCode((Object)this));
                    String newTid = Long.toHexString(Thread.currentThread().getId());
                    newTid = String.valueOf(newTid) + "(" + Thread.currentThread().getName() + ")";
                    if (tid != null && !tid.equals(newTid)) {
                        System.out.println(String.valueOf(newTid) + " XXXXX Thread collision XXXXX " + tid);
                    }
                    tid = newTid;
                    System.out.println("AID " + adapterID + " TID " + newTid + " event: " + eventType + " what=" + which + ", where=" + where);
                    System.out.println("feature: " + feature + " id " + feature.getFeatureID());
                    if (debugLevel >= 1) {
                        System.out.println("change value from " + oldValue + " to " + newValue);
                    }
                }
                if (EjbPackage.Literals.EJB_JAR__METADATA_COMPLETE == feature || WebPackage.Literals.WEB_APP__METADATA_COMPLETE == feature || WebPackage.Literals.WEB_FRAGMENT__METADATA_COMPLETE == feature) {
                    boolean metadataComplete = (Boolean)newValue;
                    if (!metadataComplete && feature == WebPackage.Literals.WEB_APP__METADATA_COMPLETE) {
                        this.reorderAndRebuildMergedModel(notifier.eResource());
                        return;
                    }
                    if (feature == WebPackage.Literals.WEB_FRAGMENT__METADATA_COMPLETE && this.mergedObject instanceof WebApp) {
                        if (this.xmlObject != null) {
                            this.reorderAndRebuildMergedModel(this.xmlObject.eResource());
                        }
                        return;
                    }
                    if (feature == EjbPackage.Literals.EJB_JAR__METADATA_COMPLETE && ((Object)((Object)this)).getClass() == MergedModelAdapter2.class) {
                        MergedModelAdapter2 mma2 = (MergedModelAdapter2)this;
                        List<IVirtualComponent> ejbLibs = MergeUtil.getEJBLibModules(WebUtilities.getLibModules((IProject)WorkbenchResourceHelper.getProject((Resource)this.xmlObject.eResource())));
                        if (ejbLibs.size() > 0) {
                            mma2.rebuildAndReuseMergedModel(this.xmlObject.eResource());
                        } else {
                            this.rebuildMergedModel();
                        }
                        return;
                    }
                    this.rebuildMergedModel();
                    return;
                }
                if (notifier.eClass() == WebPackage.Literals.WEB_FRAGMENT && feature == WebPackage.Literals.WEB_FRAGMENT__NAME && this.xmlObject instanceof WebApp && (absOrderingList = (EList)this.xmlObject.eGet((EStructuralFeature)WebPackage.Literals.WEB_APP__ABSOLUTE_ORDERING)) != null && absOrderingList.size() > 0) {
                    this.reorderAndRebuildMergedModel(this.xmlObject.eResource());
                    EList notifierAdapters = notifier.eAdapters();
                    notifierAdapters.remove((Object)this);
                    WebMergedModelAdapter newAdapter = MergeUtil.getWebMMAdapterFromEObject(this.mergedObject);
                    if (!notifierAdapters.contains((Object)newAdapter)) {
                        notifier.eAdapters().add((Object)newAdapter);
                    }
                }
                if (notifier.eClass() == WebPackage.Literals.SERVLET) {
                    if (feature == WebPackage.Literals.SERVLET__SERVLET_CLASS && this.mergedObject instanceof WebApp && (orderings = (List)this.xmlObject.eGet((EStructuralFeature)WebPackage.Literals.WEB_APP__ABSOLUTE_ORDERING)) != null && orderings.size() > 0) {
                        this.reorderAndRebuildMergedModel(this.xmlObject.eResource());
                    }
                } else if (notifier.eClass() == WebPackage.Literals.FILTER) {
                    if (feature == WebPackage.Literals.FILTER__FILTER_CLASS && this.mergedObject instanceof WebApp && (orderings = (List)this.xmlObject.eGet((EStructuralFeature)WebPackage.Literals.WEB_APP__ABSOLUTE_ORDERING)) != null && orderings.size() > 0) {
                        this.reorderAndRebuildMergedModel(this.xmlObject.eResource());
                    }
                } else if (notifier.eClass() == JavaeePackage.Literals.LISTENER && feature == JavaeePackage.Literals.LISTENER__LISTENER_CLASS && this.mergedObject instanceof WebApp && (orderings = (List)this.xmlObject.eGet((EStructuralFeature)WebPackage.Literals.WEB_APP__ABSOLUTE_ORDERING)) != null && orderings.size() > 0) {
                    this.reorderAndRebuildMergedModel(this.xmlObject.eResource());
                }
                if (notifier.eClass() == EjbPackage.Literals.NAMED_METHOD_TYPE && ((containerClass = notifier.eContainer().eClass()) == EjbPackage.Literals.INIT_METHOD_TYPE || containerClass == EjbPackage.Literals.INTERCEPTOR_BINDING_TYPE || containerClass == EjbPackage.Literals.REMOVE_METHOD_TYPE) && (listRecreated = this.complexKeyListRemerge(notifier))) {
                    return;
                }
                if (this.xmlObject != null && this.annotationObject != null && !MergeUtil.isMergeable(this.xmlObject, this.annotationObject)) {
                    EObject xmlParent = this.xmlObject.eContainer();
                    EObject annParent = this.annotationObject.eContainer();
                    if (xmlParent == null || annParent == null) {
                        throw new IllegalStateException("Missing parent on merged objects");
                    }
                    EStructuralFeature cFeature = this.xmlObject.eContainingFeature();
                    List xmlList = (List)xmlParent.eGet(cFeature);
                    List annList = (List)annParent.eGet(cFeature);
                    EList mergedList = (EList)this.mergedObject.eContainer().eGet(cFeature);
                    this.removeAdapters((List<EObject>)mergedList);
                    MergeUtil.composeLists(xmlList, annList, (List)mergedList, ((Object)((Object)this)).getClass());
                    return;
                }
                oldMergedValue = null;
                try {
                    oldMergedValue = this.mergedObject.eGet(feature);
                }
                catch (Exception e) {
                    if (feature == EcorePackage.eINSTANCE.getEClass_EIDAttribute() && !debug) break block104;
                    JavaEEPlugin.logInfo("MMAdapter.notifyChanged: eGet failed for feature " + feature + " exception was " + e);
                }
            }
            Object value = msg.getNewValue();
            if (oldValue instanceof FeatureMap.Entry) {
                FeatureMap.Entry en;
                if (debug) {
                    System.out.println("checking for attribute before processing events");
                }
                if ((en = (FeatureMap.Entry)oldValue).getEStructuralFeature() == WebPackage.Literals.WEB_FRAGMENT__NAME) {
                    return;
                }
            }
            int et = msg.getEventType();
            switch (et) {
                case 1: {
                    if (((Object)((Object)this)).getClass() == OrderingAdapter.class) {
                        if (notifier.eClass() == WebPackage.Literals.ORDERING_TYPE) {
                            if (feature == WebPackage.Literals.ORDERING_TYPE__BEFORE || feature == WebPackage.Literals.ORDERING_TYPE__AFTER) {
                                ((EObject)newValue).eAdapters().add((Object)this);
                            }
                        } else if (notifier.eClass() == WebPackage.Literals.ORDERING_ORDERING_TYPE && feature == WebPackage.Literals.ORDERING_ORDERING_TYPE__OTHERS && this.xmlObject instanceof WebApp) {
                            if (debug) {
                                System.out.println("rebuilding MergeModel for OrderingOrderingType event");
                            }
                            this.removeAdapters(notifier);
                            notifier.eAdapters().add((Object)this);
                            this.reorderAndRebuildMergedModel(this.xmlObject.eResource());
                        }
                        break;
                    }
                    boolean metadataComplete = this.getMetadataComplete();
                    this.processSetEvents(notifier, feature, oldValue, oldMergedValue, value, metadataComplete, "MMAdapter.notifyChanged: ");
                    break;
                }
                case 2: {
                    this.processUnsetEvents(notifier, feature, oldMergedValue);
                    break;
                }
                case 4: {
                    if (((Object)((Object)this)).getClass() == OrderingAdapter.class) {
                        if (notifier.eClass() == WebPackage.Literals.WEB_FRAGMENT && feature == WebPackage.Literals.WEB_FRAGMENT__ORDERING) {
                            List orderingList = (List)notifier.eGet((EStructuralFeature)WebPackage.Literals.WEB_FRAGMENT__ORDERING);
                            if (orderingList.size() == 0) {
                                notifier.eAdapters().remove((Object)this);
                                this.mergedObject.eAdapters().remove((Object)this);
                                this.reorderAndRebuildMergedModel(this.xmlObject.eResource());
                                break;
                            }
                            MergeUtil.setOrderingAdapter((EObject)orderingList.get(0), (OrderingAdapter)this);
                            this.reorderAndRebuildMergedModel(this.xmlObject.eResource());
                            break;
                        }
                        if (notifier.eClass() == WebPackage.Literals.ORDERING_ORDERING_TYPE && this.mergedObject instanceof WebApp && (feature == WebPackage.Literals.ORDERING_ORDERING_TYPE__NAME || feature == WebPackage.Literals.ORDERING_ORDERING_TYPE__OTHERS)) {
                            this.removeAdapters(notifier);
                            notifier.eAdapters().add((Object)this);
                            this.reorderAndRebuildMergedModel(this.xmlObject.eResource());
                        }
                        break;
                    }
                    if (notifier instanceof AbsoluteOrderingType) {
                        if (feature == WebPackage.Literals.ABSOLUTE_ORDERING_TYPE__GROUP) {
                            if (this.mergedObject instanceof AbsoluteOrderingType) {
                                notifier.eContainer().eNotify(msg);
                                break;
                            }
                            if (this.mergedObject instanceof WebApp) {
                                this.removeAdapters(notifier);
                                this.reorderAndRebuildMergedModel(notifier.eResource());
                            }
                        }
                        break;
                    }
                    if (notifier instanceof WebApp && feature == WebPackage.Literals.WEB_APP__ABSOLUTE_ORDERING) {
                        this.removeAdapters(notifier);
                        this.reorderAndRebuildMergedModel(notifier.eResource());
                        break;
                    }
                    this.processRemoveEvents(notifier, feature, oldValue);
                    break;
                }
                case 6: {
                    if (notifier instanceof AbsoluteOrderingType) {
                        if (feature == WebPackage.Literals.ABSOLUTE_ORDERING_TYPE__GROUP) {
                            if (this.mergedObject instanceof AbsoluteOrderingType) {
                                notifier.eContainer().eNotify(msg);
                                break;
                            }
                            if (this.mergedObject instanceof WebApp) {
                                this.removeAdapters(notifier);
                                this.reorderAndRebuildMergedModel(notifier.eResource());
                            }
                        }
                        break;
                    }
                    if (notifier instanceof WebApp && feature == WebPackage.Literals.WEB_APP__ABSOLUTE_ORDERING) {
                        this.removeAdapters(notifier);
                        this.reorderAndRebuildMergedModel(notifier.eResource());
                        break;
                    }
                    this.processRemoveManyEvents(notifier, feature, oldValue, "MMAdapter.notifyChanged: ");
                    break;
                }
                case 3: {
                    if (((Object)((Object)this)).getClass() == OrderingAdapter.class) {
                        if (notifier.eClass() == WebPackage.Literals.ORDERING_ORDERING_TYPE && (feature == WebPackage.Literals.ORDERING_ORDERING_TYPE__NAME || feature == WebPackage.Literals.ORDERING_ORDERING_TYPE__OTHERS)) {
                            this.removeAdapters(notifier);
                            notifier.eAdapters().add((Object)this);
                            this.reorderAndRebuildMergedModel(this.xmlObject.eResource());
                        }
                        break;
                    }
                    if (feature == WebPackage.Literals.WEB_FRAGMENT__ORDERING) {
                        boolean hasOrderingAdapter = false;
                        EList adapters = notifier.eAdapters();
                        for (Object adapter : adapters) {
                            if (!(adapter instanceof OrderingAdapter)) continue;
                            hasOrderingAdapter = true;
                            break;
                        }
                        if (!hasOrderingAdapter) {
                            this.processAddEvents(notifier, feature, newValue);
                        }
                        break;
                    }
                    if (notifier.eClass() == WebPackage.Literals.ABSOLUTE_ORDERING_TYPE) {
                        if (this.mergedObject instanceof AbsoluteOrderingType) {
                            notifier.eContainer().eNotify(msg);
                        } else if (this.mergedObject instanceof WebApp) {
                            this.removeAdapters(notifier);
                            this.reorderAndRebuildMergedModel(notifier.eResource());
                        }
                        return;
                    }
                    this.processAddEvents(notifier, feature, newValue);
                    break;
                }
                case 5: {
                    this.processAddManyEvents(notifier, feature, newValue);
                    break;
                }
                case 7: {
                    if (debug) {
                        System.out.println("Ignoring MOVE event: " + msg);
                    }
                    break;
                }
                default: {
                    JavaEEPlugin.logError("MMAdapter.notifyChanged: Unhandled event type " + et + ": " + msg);
                    break;
                }
            }
        }
        finally {
            if (debug && debugLevel >= 1) {
                try {
                    System.out.println("merged model " + MergeUtil.hexId(mergedModel) + " after notifyChanged:");
                    MergeUtil.dumpModel(mergedModel, 0);
                    MMAdapter rootAdapter = this.getRootAdapter();
                    if (debugLevel >= 2 && rootAdapter != null) {
                        EObject annModel;
                        EObject xmlModel = rootAdapter.getXmlObject();
                        if (xmlModel != null) {
                            System.out.println("xml model:");
                            MergeUtil.dumpModel(xmlModel, 0);
                        }
                        if ((annModel = rootAdapter.getAnnotationObject()) != null) {
                            System.out.println("anno model:");
                            MergeUtil.dumpModel(annModel, 0);
                        }
                    }
                }
                catch (Throwable t) {
                    System.out.println("error during debug: " + t);
                }
            }
            tid = null;
        }
    }

    public static enum DataFrom {
        xml,
        annotation,
        mixed,
        all;

    }
}

