/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.annotations.jcdi.utils;

import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.data.AnnotatedProjectInfo;
import com.ibm.etools.annotations.core.data.AnnotatedProjectInfosRepository;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.javaee.annotations.ejb.utils.CodeUtils;
import com.ibm.etools.javaee.core.JavaEEPlugin;
import com.ibm.etools.javaee.model.internal.IJEE5ModelProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.core.ResolvedBinaryType;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;

public class JCDIUtils {
    private static final String VETOED_ANNO = "Vetoed";
    private static final String vetoedPackage = "javax.enterprise.inject.";
    private static final String MANAGED_BEAN_ANNO = "ManagedBean";
    private static final String DECORATOR_ANNO = "Decorator";
    private static final String decPackage = "javax.decorator.";
    private static final String EXTENSION = "javax.enterprise.inject.spi.Extension";
    private static final String INJECT_ANNO = "Inject";
    private static final String injectPackage = "javax.inject.";
    private static final String cdiManagedBeanPackage = "javax.annotation.";
    private static final String facesManagedBeanPackage = "javax.faces.bean.";
    private static final String STATELESS_ANNO = "Stateless";
    private static final String STATEFUL_ANNO = "Stateful";
    private static final String SINGLETON_ANNO = "Singleton";
    private static final String MESSAGE_DRIVEN_ANNO = "MessageDriven";
    private static final String EJB_ANNO = "EJB";
    private static final String EJBS_ANNO = "EJBs";
    private static final String ejbPackage = "javax.ejb.";

    public static List<TypeDeclaration> getManagedBeans(ASTNode cu) {
        ManagedBeanASTNodeVisitor visitor = new ManagedBeanASTNodeVisitor();
        cu.accept((ASTVisitor)visitor);
        return visitor.getManagedBeans();
    }

    public static boolean isSessionBeanVetoed(ASTNode cu) {
        SessionBeanASTNodeVisitor visitor = new SessionBeanASTNodeVisitor();
        cu.accept((ASTVisitor)visitor);
        return visitor.isVetoed();
    }

    public static Hashtable<List<String>, String> getBeanTypesForManagedBeans(IProject project) {
        List<String> mbAnnoList = Arrays.asList("javax.annotation.ManagedBean", "javax.faces.bean.ManagedBean");
        Hashtable<List<String>, String> managedBeanHT = new Hashtable<List<String>, String>();
        ArrayList<String> managedBeanType = new ArrayList<String>();
        AnnotatedClassInfo[] jcdiAci = JCDIUtils.getAnnotatedClassInfoFromProject(project);
        int i = 0;
        while (i < jcdiAci.length) {
            List<AnnotationInfo> ai = jcdiAci[i].getAnnotationInfos(true);
            Iterator<AnnotationInfo> aiIter = ai.iterator();
            managedBeanType.clear();
            while (aiIter.hasNext()) {
                AnnotationInfo jcdiAi = aiIter.next();
                String mbAnnoName = jcdiAi.getFullyQualifiedName();
                if (!mbAnnoList.contains(mbAnnoName)) continue;
                String mbName = mbAnnoName.equals(mbAnnoList.get(0)) ? CodeUtils.getSingleValueAttributeFromAnnotation(jcdiAi, "value") : CodeUtils.getSingleValueAttributeFromAnnotation(jcdiAi, "name");
                IType type = JCDIUtils.getJavaType(jcdiAi);
                ITypeHierarchy hierarchy = null;
                try {
                    hierarchy = type.newSupertypeHierarchy(null);
                    IType[] types = hierarchy.getAllSupertypes(type);
                    if (types != null) {
                        int j = 0;
                        while (j < types.length) {
                            managedBeanType.add(types[j].getElementName());
                            ++j;
                        }
                    }
                    managedBeanHT.put(managedBeanType, mbName);
                }
                catch (JavaModelException e) {
                    JavaEEPlugin.logError((CoreException)((Object)e));
                }
            }
            ++i;
        }
        return managedBeanHT;
    }

    protected static IType getJavaType(AnnotationInfo aInfo) {
        IJavaElement el = aInfo.getParentJavaElementInfo().getJavaElement();
        while (el != null && el.getElementType() != 7) {
            el = el.getParent();
        }
        return (IType)el;
    }

    private static AnnotatedClassInfo[] getAnnotatedClassInfoFromProject(IProject proj) {
        AnnotatedProjectInfo jcdiApi = AnnotatedProjectInfosRepository.getInstance().getAnnotatedProjectInfoForEJB(proj, false, false);
        AnnotatedClassInfo[] jcdiAci = jcdiApi.getAnnotatedClassInfos();
        return jcdiAci;
    }

    protected static String getPackageNameForJavaElementInfo(IJavaElement jel) {
        IJavaElement parentEL = jel.getParent();
        if (parentEL != null && parentEL instanceof IPackageFragment) {
            return parentEL.getElementName();
        }
        return "";
    }

    public static boolean isPackageVetoed(String packageName, IProject proj) {
        AnnotatedClassInfo[] jcdiAci = JCDIUtils.getAnnotatedClassInfoFromProject(proj);
        String pkgName = "";
        int i = 0;
        while (i < jcdiAci.length) {
            pkgName = JCDIUtils.getPackageNameForJavaElementInfo(jcdiAci[i].getJavaElement());
            if (pkgName.equals(packageName) && jcdiAci[i].getDisplayName().equals("package-info.java")) {
                List<AnnotationInfo> ai = jcdiAci[i].getAnnotationInfos(true);
                for (AnnotationInfo jcdiAi : ai) {
                    if (!jcdiAi.isPackageAnnotation() || !jcdiAi.getFullyQualifiedName().equals("javax.enterprise.inject.Vetoed")) continue;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static class ManagedBeanASTNodeVisitor
    extends ASTVisitor {
        private List<TypeDeclaration> _managedBeanDecls = new ArrayList<TypeDeclaration>();
        private ArrayList<ContextState> stateStack = new ArrayList();
        private static IProject proj = null;
        private static String _packageName = "";

        public boolean visit(TypeDeclaration md) {
            ContextState stateObj = new ContextState();
            this.stateStack.add(stateObj);
            ITypeBinding binding = md.resolveBinding();
            proj = binding.getJavaElement().getResource().getProject();
            if (ManagedBeanASTNodeVisitor.isEJBClassinXML(binding.getBinaryName(), proj)) {
                stateObj.setIsEJBInXML(true);
            }
            if ((binding.getModifiers() & 0x400) != 0) {
                stateObj.setIsAbstractClass(true);
            }
            MethodDeclaration[] methods = md.getMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].isConstructor()) {
                    if (methods[i].parameters().size() == 0) {
                        stateObj.setHasZeroArgConstructor(true);
                        break;
                    }
                    stateObj.setHasParamConstructor(true);
                }
                ++i;
            }
            ITypeBinding[] interfaceTypes = binding.getInterfaces();
            int i2 = 0;
            while (i2 < interfaceTypes.length) {
                IJavaElement jElem = interfaceTypes[i2].getJavaElement();
                if (jElem instanceof ResolvedBinaryType && ((ResolvedBinaryType)jElem).getFullyQualifiedName().equals(JCDIUtils.EXTENSION)) {
                    stateObj.setImplementsExtension(true);
                }
                ++i2;
            }
            if (binding.isNested()) {
                stateObj.setIsNestedClass(true);
                if ((binding.getModifiers() & 8) != 0) {
                    stateObj.setIsStaticNestedClass(true);
                }
            }
            return super.visit(md);
        }

        public boolean visit(PackageDeclaration node) {
            _packageName = node.getName().toString();
            return super.visit(node);
        }

        public void endVisit(TypeDeclaration node) {
            super.endVisit(node);
            if (this.isManagedBean()) {
                this._managedBeanDecls.add(node);
            }
            this.stateStack.remove(this.stateStack.size() - 1);
        }

        public boolean visit(NormalAnnotation node) {
            ContextState currStateObj = this.stateStack.get(this.stateStack.size() - 1);
            ASTNode parentNode = node.getParent();
            if (parentNode instanceof TypeDeclaration) {
                Name typeName = node.getTypeName();
                String fullQName = node.getTypeName().getFullyQualifiedName();
                if (typeName.isSimpleName()) {
                    if (fullQName.equals(JCDIUtils.MANAGED_BEAN_ANNO)) {
                        currStateObj.setIsAnnotatedManagedBean(true);
                    } else if (fullQName.equals(JCDIUtils.EJB_ANNO)) {
                        currStateObj.setHasComponentDefiningEJB(true);
                    }
                } else if (fullQName.equals("javax.annotation.ManagedBean") || fullQName.equals("javax.faces.bean.ManagedBean")) {
                    currStateObj.setIsAnnotatedManagedBean(true);
                } else if (fullQName.equals("javax.ejb.EJB")) {
                    currStateObj.setHasComponentDefiningEJB(true);
                }
            }
            return true;
        }

        public boolean visit(SingleMemberAnnotation node) {
            ContextState currStateObj = this.stateStack.get(this.stateStack.size() - 1);
            ASTNode parentNode = node.getParent();
            if (parentNode instanceof TypeDeclaration) {
                Name typeName = node.getTypeName();
                String fullQName = node.getTypeName().getFullyQualifiedName();
                if (typeName.isSimpleName()) {
                    if (fullQName.equals(JCDIUtils.MANAGED_BEAN_ANNO)) {
                        currStateObj.setIsAnnotatedManagedBean(true);
                    } else if (fullQName.equals(JCDIUtils.EJBS_ANNO)) {
                        currStateObj.setHasComponentDefiningEJB(true);
                    }
                } else if (fullQName.equals("javax.annotation.ManagedBean") || fullQName.equals("javax.faces.bean.ManagedBean")) {
                    currStateObj.setIsAnnotatedManagedBean(true);
                } else if (fullQName.equals("javax.ejb.EJBs")) {
                    currStateObj.setHasComponentDefiningEJB(true);
                }
            }
            return true;
        }

        public boolean visit(MarkerAnnotation node) {
            ContextState currStateObj = this.stateStack.get(this.stateStack.size() - 1);
            ASTNode parentNode = node.getParent();
            if (parentNode instanceof TypeDeclaration) {
                Name typeName = node.getTypeName();
                String fullQName = node.getTypeName().getFullyQualifiedName();
                if (typeName.isSimpleName()) {
                    if (fullQName.equals(JCDIUtils.MANAGED_BEAN_ANNO)) {
                        currStateObj.setIsAnnotatedManagedBean(true);
                    } else if (fullQName.equals(JCDIUtils.STATELESS_ANNO) || fullQName.equals(JCDIUtils.STATEFUL_ANNO) || fullQName.equals(JCDIUtils.SINGLETON_ANNO) || fullQName.equals(JCDIUtils.MESSAGE_DRIVEN_ANNO) || fullQName.equals(JCDIUtils.EJB_ANNO) || fullQName.equals(JCDIUtils.EJBS_ANNO)) {
                        currStateObj.setHasComponentDefiningEJB(true);
                    } else if (fullQName.equals(JCDIUtils.DECORATOR_ANNO)) {
                        currStateObj.setIsDecorator(true);
                    }
                    if (fullQName.equals(JCDIUtils.VETOED_ANNO)) {
                        currStateObj.setIsVetoed(true);
                    }
                } else {
                    if (fullQName.equals("javax.annotation.ManagedBean") || fullQName.equals("javax.faces.bean.ManagedBean")) {
                        currStateObj.setIsAnnotatedManagedBean(true);
                    } else if (fullQName.equals("javax.ejb.Stateless") || fullQName.equals("javax.ejb.Stateful") || fullQName.equals("javax.ejb.Singleton") || fullQName.equals("javax.ejb.MessageDriven") || fullQName.equals("javax.ejb.EJB") || fullQName.equals("javax.ejb.EJBs")) {
                        currStateObj.setHasComponentDefiningEJB(true);
                    } else if (fullQName.equals("javax.decorator.Decorator")) {
                        currStateObj.setIsDecorator(true);
                    }
                    if (fullQName.equals("javax.enterprise.inject.Vetoed")) {
                        currStateObj.setIsDecorator(true);
                    }
                }
            } else if (parentNode instanceof MethodDeclaration && ((MethodDeclaration)parentNode).isConstructor()) {
                Name typeName = node.getTypeName();
                String fullQName = node.getTypeName().getFullyQualifiedName();
                if (typeName.isSimpleName()) {
                    if (fullQName.equals(JCDIUtils.INJECT_ANNO)) {
                        currStateObj.setHasAnnoInjectedConstructor(true);
                    }
                } else if (typeName.isQualifiedName() && fullQName.equals("javax.inject.Inject")) {
                    currStateObj.setHasAnnoInjectedConstructor(true);
                }
            }
            return true;
        }

        public List<TypeDeclaration> getManagedBeans() {
            return this._managedBeanDecls;
        }

        public boolean isManagedBean() {
            ContextState currStateObj = this.stateStack.get(this.stateStack.size() - 1);
            if (currStateObj.isVetoed()) {
                return false;
            }
            if (JCDIUtils.isPackageVetoed(_packageName, proj)) {
                return false;
            }
            if (currStateObj.isAnnotatedManagedBean()) {
                return true;
            }
            if (currStateObj.isNestedClass() && !currStateObj.isStaticNestedClass()) {
                return false;
            }
            if (!(currStateObj.isAbstractclass() && !currStateObj.isDecorator() || currStateObj.hasComponentDefiningEJB() || currStateObj.isEJBInXML() || currStateObj.getImplementsExtension())) {
                if (currStateObj.hasZeroArgConstructor()) {
                    return true;
                }
                if (currStateObj.hasAnnoInjectedConstructor()) {
                    return true;
                }
                if (!currStateObj.hasParamConstructor()) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isEJBClassinXML(String qName, IProject proj) {
            EJBJar ejbJar = null;
            if (JavaEEProjectUtilities.isDynamicWebProject((IProject)proj)) {
                ejbJar = (EJBJar)ModelProviderManager.getModelProvider((IProject)proj).getModelObject(IJEE5ModelProvider.EJB_IN_WAR_DD_MODEL_XML);
            } else if (JavaEEProjectUtilities.isEJBProject((IProject)proj)) {
                ejbJar = (EJBJar)ModelProviderManager.getModelProvider((IProject)proj).getModelObject(IJEE5ModelProvider.EJB_DD_MODEL_XML);
            }
            if (ejbJar == null) {
                return false;
            }
            EnterpriseBeans eb = ejbJar.getEnterpriseBeans();
            if (eb != null) {
                List entityBeans = eb.getEntityBeans();
                int i = 0;
                while (i < entityBeans.size()) {
                    if (qName.equals(((EntityBean)entityBeans.get(i)).getEjbClass())) {
                        return true;
                    }
                    ++i;
                }
                List mdbs = eb.getMessageDrivenBeans();
                int i2 = 0;
                while (i2 < mdbs.size()) {
                    if (qName.equals(((MessageDrivenBean)mdbs.get(i2)).getEjbClass())) {
                        return true;
                    }
                    ++i2;
                }
                List sessionBeans = eb.getSessionBeans();
                int i3 = 0;
                while (i3 < sessionBeans.size()) {
                    if (qName.equals(((SessionBean)sessionBeans.get(i3)).getEjbClass())) {
                        return true;
                    }
                    ++i3;
                }
            }
            return false;
        }

        public class ContextState {
            private boolean _isAnnotatedManagedBean = false;
            private boolean _hasComponentDefiningEJB = false;
            private boolean _isDecorator = false;
            private boolean _hasAnnoInjectedConstructor = false;
            private boolean _hasZeroArgConstructor = false;
            private boolean _isAbstractClass = false;
            private boolean _implementsExtension = false;
            private boolean _isEJBinXML = false;
            private boolean _isStaticNestedClass = false;
            private boolean _isNestedClass = false;
            private boolean _hasParamConstructor = false;
            private boolean _isVetoed = false;

            public void setIsAnnotatedManagedBean(boolean value) {
                this._isAnnotatedManagedBean = value;
            }

            public boolean isAnnotatedManagedBean() {
                return this._isAnnotatedManagedBean;
            }

            public void setHasComponentDefiningEJB(boolean value) {
                this._hasComponentDefiningEJB = value;
            }

            public boolean hasComponentDefiningEJB() {
                return this._hasComponentDefiningEJB;
            }

            public void setHasAnnoInjectedConstructor(boolean value) {
                this._hasAnnoInjectedConstructor = value;
            }

            public boolean hasAnnoInjectedConstructor() {
                return this._hasAnnoInjectedConstructor;
            }

            public void setIsDecorator(boolean value) {
                this._isDecorator = value;
            }

            public boolean isDecorator() {
                return this._isDecorator;
            }

            public void setHasZeroArgConstructor(boolean value) {
                this._hasZeroArgConstructor = value;
            }

            public boolean hasZeroArgConstructor() {
                return this._hasZeroArgConstructor;
            }

            public void setHasParamConstructor(boolean value) {
                this._hasParamConstructor = value;
            }

            public boolean hasParamConstructor() {
                return this._hasParamConstructor;
            }

            public void setIsAbstractClass(boolean value) {
                this._isAbstractClass = value;
            }

            public boolean isAbstractclass() {
                return this._isAbstractClass;
            }

            public void setImplementsExtension(boolean value) {
                this._implementsExtension = value;
            }

            public boolean getImplementsExtension() {
                return this._implementsExtension;
            }

            public void setIsEJBInXML(boolean value) {
                this._isEJBinXML = value;
            }

            public boolean isEJBInXML() {
                return this._isEJBinXML;
            }

            public void setIsStaticNestedClass(boolean value) {
                this._isStaticNestedClass = value;
            }

            public boolean isStaticNestedClass() {
                return this._isStaticNestedClass;
            }

            public void setIsNestedClass(boolean value) {
                this._isNestedClass = value;
            }

            public boolean isNestedClass() {
                return this._isNestedClass;
            }

            public void setIsVetoed(boolean value) {
                this._isVetoed = value;
            }

            public boolean isVetoed() {
                return this._isVetoed;
            }
        }
    }

    public static class SessionBeanASTNodeVisitor
    extends ASTVisitor {
        boolean _isClassVetoed = false;
        String _packageName = "";
        IProject _proj;

        public boolean visit(TypeDeclaration md) {
            ITypeBinding tb = md.resolveBinding();
            this._proj = tb.getJavaElement().getResource().getProject();
            return super.visit(md);
        }

        public boolean visit(MarkerAnnotation node) {
            ASTNode parentNode = node.getParent();
            if (parentNode instanceof TypeDeclaration) {
                Name typeName = node.getTypeName();
                String fullQName = typeName.getFullyQualifiedName();
                if (typeName.isSimpleName()) {
                    if (fullQName.equals(JCDIUtils.VETOED_ANNO)) {
                        this._isClassVetoed = true;
                    }
                } else if (fullQName.equals("javax.enterprise.inject.Vetoed")) {
                    this._isClassVetoed = true;
                }
            }
            return false;
        }

        public boolean visit(PackageDeclaration node) {
            this._packageName = node.getName().toString();
            return super.visit(node);
        }

        public boolean isVetoed() {
            if (this._isClassVetoed) {
                return true;
            }
            return JCDIUtils.isPackageVetoed(this._packageName, this._proj);
        }
    }
}

