/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.annotations.internal.utils;

import com.ibm.etools.javaee.core.JavaEEPlugin;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class BaseReflectionUtils {
    private Hashtable<String, Class> ePackageClasses = new Hashtable();
    private Hashtable<String, Object> ePackageInstances = new Hashtable();
    private Hashtable<String, String> tokenToClassNameMap;

    public BaseReflectionUtils(Hashtable<String, String> tokenToClassNameMap) {
        this.tokenToClassNameMap = tokenToClassNameMap;
    }

    public Hashtable<String, String> getTokenToClassNameMap() {
        return this.tokenToClassNameMap;
    }

    public Object executeMethod(String method) {
        try {
            int iDot;
            method = method.trim();
            if (method.endsWith("()")) {
                method = method.substring(0, method.length() - 2);
            }
            if ((iDot = method.indexOf(".")) > 0) {
                String token = method.substring(0, iDot);
                String methodName = method.substring(iDot + 1, method.length());
                Class cl = this.ePackageClasses.get(token);
                if (cl == null) {
                    this.updateHashtables(token);
                    cl = this.ePackageClasses.get(token);
                }
                if (cl != null) {
                    Method m = cl.getMethod(methodName, null);
                    Object instance = this.ePackageInstances.get(token);
                    if (instance != null) {
                        Object o = m.invoke(instance, null);
                        return o;
                    }
                }
            }
        }
        catch (Exception e) {
            JavaEEPlugin.logError(e);
        }
        return null;
    }

    private void updateHashtables(String token) {
        try {
            String className = this.tokenToClassNameMap.get(token);
            if (className != null) {
                Class<?> cl = Class.forName(className);
                this.ePackageClasses.put(token, cl);
                Field f = cl.getField("eINSTANCE");
                Object instance = f.get(null);
                this.ePackageInstances.put(token, instance);
            }
        }
        catch (Exception e) {
            JavaEEPlugin.logError(e);
        }
    }
}

