/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.annotations.internal.utils;

import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.javaee.annotations.base.EMF2AnnotationBaseAdapterImpl;
import com.ibm.etools.javaee.annotations.ejb.converter.EMF2AnnotationAdapterImpl;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;

public class BaseModelUtils {
    private static BaseModelUtils modelUtils = null;

    private BaseModelUtils() {
    }

    public static BaseModelUtils getInstance() {
        if (modelUtils == null) {
            modelUtils = new BaseModelUtils();
        }
        return modelUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cleanUpModel(AnnotatedClassInfo aci, EObject eo1, String fullyQualifiedOriginatorName) {
        ArrayList alTemp = new ArrayList(eo1.eContents());
        int p = 0;
        while (p < alTemp.size()) {
            EList adaps;
            EObject eo = (EObject)alTemp.get(p);
            EList eList = adaps = eo.eAdapters();
            synchronized (eList) {
                int counter = 0;
                ArrayList<Adapter> allClAd = new ArrayList<Adapter>();
                int r = 0;
                while (r < adaps.size()) {
                    String orig;
                    Adapter adp = (Adapter)adaps.get(r);
                    if (adp instanceof EMF2AnnotationBaseAdapterImpl) {
                        ++counter;
                        orig = ((EMF2AnnotationBaseAdapterImpl)adp).getFullyQualifiedOriginatorName();
                        if (orig != null && orig.equals(fullyQualifiedOriginatorName)) {
                            allClAd.add(adp);
                        }
                    } else if (adp instanceof EMF2AnnotationAdapterImpl) {
                        ++counter;
                        orig = ((EMF2AnnotationAdapterImpl)adp).getFullyQualifiedOriginatorName();
                        if (orig != null && orig.equals(fullyQualifiedOriginatorName)) {
                            allClAd.add(adp);
                        }
                    }
                    ++r;
                }
                if (allClAd.size() > 0) {
                    if (counter == allClAd.size() && !(eo instanceof EnterpriseBeans)) {
                        EcoreUtil.delete((EObject)eo);
                    } else {
                        eo.eAdapters().removeAll(allClAd);
                        this.cleanUpModel(aci, eo, fullyQualifiedOriginatorName);
                    }
                } else {
                    this.cleanUpModel(aci, eo, fullyQualifiedOriginatorName);
                }
            }
            ++p;
        }
    }

    public List<EObject> getAllEObjectsForAnnotation(AnnotatedClassInfo aci, EObject eo1, AnnotationInfo info) {
        ArrayList<EObject> allClAd = new ArrayList<EObject>();
        ArrayList alTemp = new ArrayList(eo1.eContents());
        int p = 0;
        while (p < alTemp.size()) {
            EObject eo = (EObject)alTemp.get(p);
            EList adaps = eo.eAdapters();
            int r = 0;
            while (r < adaps.size()) {
                AnnotationInfo orig;
                Adapter adp = (Adapter)adaps.get(r);
                if (adp instanceof EMF2AnnotationBaseAdapterImpl) {
                    orig = ((EMF2AnnotationBaseAdapterImpl)adp).getAnnotationInfo();
                    if (orig != null && orig.equals(info)) {
                        allClAd.add(eo);
                    }
                } else if (adp instanceof EMF2AnnotationAdapterImpl && (orig = ((EMF2AnnotationAdapterImpl)adp).getAnnotationInfo()).equals(info)) {
                    allClAd.add(eo);
                }
                ++r;
            }
            allClAd.addAll(this.getAllEObjectsForAnnotation(aci, eo, info));
            ++p;
        }
        return allClAd;
    }

    public IType resoveJavaType(String name, IJavaProject pr) {
        IType type = null;
        try {
            type = pr.findType(name);
            if (type == null) {
                type = this.getType(name, pr);
            }
            if (type == null) {
                type = this.resolveTypeInAnotherProject(name, pr);
            }
        }
        catch (Exception exception) {}
        return type;
    }

    public IType resolveTypeInAnotherProject(String typeName, IJavaProject currentProject) {
        IType type = null;
        try {
            String[] requiredProjects = currentProject.getRequiredProjectNames();
            int i = 0;
            while (i < requiredProjects.length) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(requiredProjects[i]);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                type = javaProject.findType(typeName);
                if (type == null) {
                    type = this.getType(typeName, javaProject);
                }
                if (type == null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return type;
    }

    public IJavaElement getICUfromJavaElementInfo(JavaElementInfo jei) {
        if (jei == null) {
            return null;
        }
        IJavaElement javaEl = jei.getJavaElement();
        if (javaEl instanceof ICompilationUnit || javaEl instanceof IClassFile) {
            return javaEl;
        }
        JavaElementInfo parentJEI = jei.getParentJavaElementInfo();
        return this.getICUfromJavaElementInfo(parentJEI);
    }

    public IType getType(String typeName, IJavaProject project) {
        IType type = null;
        try {
            IPackageFragmentRoot srcPackage = this.getSourcePackage(project);
            IJavaElement[] elements = srcPackage.getChildren();
            int i = 0;
            while (i < elements.length) {
                IPackageFragment fragment;
                StringBuffer name;
                if (!(elements[i] instanceof IPackageFragment) || (type = project.findType((name = new StringBuffer((fragment = (IPackageFragment)elements[i]).getElementName())).append(".").append(typeName).toString())) == null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return type;
    }

    public IPackageFragmentRoot getSourcePackage(IJavaProject javaProject) throws JavaModelException {
        if (javaProject == null) {
            return null;
        }
        IPackageFragmentRoot[] fragmentRoots = javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < fragmentRoots.length) {
            if (fragmentRoots[i].getKind() == 1) {
                return fragmentRoots[i];
            }
            ++i;
        }
        return javaProject.getPackageFragmentRoot(javaProject.getCorrespondingResource());
    }
}

