/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.annotations.ejb.utils;

import com.ibm.etools.javaee.annotations.datastructures.TriggerContextInfo;
import com.ibm.etools.javaee.annotations.datastructures.TriggerInfo;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.AnnotationMapping;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.ContextInfo;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.EAttributeInfo;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.EObjectInfo;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.MappingInfo;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.TriggerAnnotationInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    public static Document parserXML(File file) throws Exception {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
    }

    public static Document parseXML(IFile file) throws Exception {
        File f = file.getRawLocation().toFile();
        return XMLUtils.parserXML(f);
    }

    public static Document parseXML(String sAbsolute) throws Exception {
        Path p = new Path(sAbsolute);
        File f = p.toFile();
        return XMLUtils.parserXML(f);
    }

    public static String getStringFromLeafElementBody(Element el) {
        NodeList nl_temp_1 = el.getChildNodes();
        String s1 = "";
        int j = 0;
        while (j < nl_temp_1.getLength()) {
            Node n_temp = nl_temp_1.item(j);
            if (n_temp instanceof Text) {
                s1 = String.valueOf(s1) + ((Text)n_temp).getTextContent();
            }
            ++j;
        }
        s1 = s1.trim();
        return s1;
    }

    public static MappingInfo getMappingInfoFromElement(Element el) {
        MappingInfo res = null;
        String targetName = el.getAttribute("targetName");
        String targetType = el.getAttribute("targetType");
        if (el.getNodeName().equals("mapping")) {
            NodeList nl = el.getChildNodes();
            EObjectInfo info = null;
            int i = 0;
            while (i < nl.getLength()) {
                Element ne;
                String sN;
                Node n = nl.item(i);
                if (n instanceof Element && (sN = (ne = (Element)n).getNodeName()).equals("eObject")) {
                    info = XMLUtils.getEObjectFeatureFromElement(ne);
                }
                ++i;
            }
            return new MappingInfo(targetType, targetName, info);
        }
        return res;
    }

    public static AnnotationMapping getAnnotationMappingFromElement(Element el) {
        AnnotationMapping res = null;
        String tagName = el.getNodeName();
        if ("AnnotationMapping".equals(tagName) || "TriggerMapping".equals(tagName)) {
            int ind;
            String sName = null;
            String sTargetFeature = null;
            ContextInfo[] contexts = null;
            ArrayList<ContextInfo> alC = new ArrayList<ContextInfo>();
            EObjectInfo info = null;
            ArrayList<MappingInfo> maps = new ArrayList<MappingInfo>();
            ArrayList<TriggerAnnotationInfo> trigAnnotationsList = new ArrayList<TriggerAnnotationInfo>();
            sName = el.getAttribute("name");
            sTargetFeature = el.getAttribute("eFeatureName");
            NodeList nl = el.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (n instanceof Element) {
                    TriggerAnnotationInfo inf;
                    Element ne = (Element)n;
                    String sN = ne.getNodeName();
                    if (sN.equals("mapping")) {
                        MappingInfo mi = XMLUtils.getMappingInfoFromElement(ne);
                        maps.add(mi);
                    } else if (sN.equals("requiredTopEObject")) {
                        info = XMLUtils.getRequiredEObjectFromElement(ne);
                    } else if (sN.equals("context")) {
                        ContextInfo val = XMLUtils.getContextInfoFromElement(ne);
                        alC.add(val);
                    } else if (sN.equals("triggerAnnotation")) {
                        inf = XMLUtils.getTriggerAnnotationInfoFromElement(ne);
                        trigAnnotationsList.add(inf);
                    } else if (sN.equals("trigger")) {
                        inf = XMLUtils.getTriggerAnnotationInfoFromElement(ne);
                        trigAnnotationsList.add(inf);
                    }
                }
                ++i;
            }
            contexts = new ContextInfo[alC.size()];
            contexts = alC.toArray(contexts);
            TriggerAnnotationInfo[] triggers = new TriggerAnnotationInfo[trigAnnotationsList.size()];
            triggers = trigAnnotationsList.toArray(triggers);
            String shortName = null;
            String packageName = null;
            if (sName != null && (ind = sName.lastIndexOf(".")) > 0) {
                shortName = sName.substring(ind + 1, sName.length());
                packageName = sName.substring(0, ind);
            }
            return new AnnotationMapping(shortName, packageName, sTargetFeature, contexts, triggers, maps, info);
        }
        return res;
    }

    public static List<AnnotationMapping> getAnnotationMappings(Document doc) {
        ArrayList<AnnotationMapping> aL = new ArrayList<AnnotationMapping>();
        NodeList nl = doc.getElementsByTagName("AnnotationMapping");
        int i = 0;
        while (i < nl.getLength()) {
            AnnotationMapping am = XMLUtils.getAnnotationMappingFromElement((Element)nl.item(i));
            aL.add(am);
            ++i;
        }
        return aL;
    }

    public static List getTriggerMappings(Document doc) {
        ArrayList<AnnotationMapping> aL = new ArrayList<AnnotationMapping>();
        NodeList nl = doc.getElementsByTagName("TriggerMapping");
        int i = 0;
        while (i < nl.getLength()) {
            AnnotationMapping am = XMLUtils.getAnnotationMappingFromElement((Element)nl.item(i));
            aL.add(am);
            ++i;
        }
        return aL;
    }

    public static String[] getTriggerAnnotationNames(Document doc) {
        String[] sAr = null;
        ArrayList<String> tempL = new ArrayList<String>();
        NodeList nl = doc.getElementsByTagName("triggerAnnotations");
        Node trA = nl.item(0);
        Element el = (Element)trA;
        NodeList names = el.getElementsByTagName("Name");
        int i = 0;
        while (i < names.getLength()) {
            Element name = (Element)names.item(i);
            String s1 = XMLUtils.getStringFromLeafElementBody(name);
            tempL.add(s1);
            ++i;
        }
        sAr = new String[tempL.size()];
        sAr = tempL.toArray(sAr);
        return sAr;
    }

    public static TriggerInfo[] getTriggerInfos(Document doc) {
        ArrayList<TriggerInfo> tempL = new ArrayList<TriggerInfo>(3);
        NodeList nl = doc.getElementsByTagName("Triggers");
        int i = 0;
        while (i < nl.getLength()) {
            NodeList tsnl = ((Element)nl.item(i)).getChildNodes();
            int m = 0;
            while (m < tsnl.getLength()) {
                Element te;
                Node n = tsnl.item(m);
                if (n instanceof Element && (te = (Element)n).getNodeName().equals("Trigger")) {
                    String tName = te.getAttribute("name");
                    String tType = te.getAttribute("type");
                    ArrayList<String> tDrivenAnnotationList = new ArrayList<String>(6);
                    ArrayList<TriggerContextInfo> tContextList = new ArrayList<TriggerContextInfo>(3);
                    NodeList tnl = te.getChildNodes();
                    int j = 0;
                    while (j < tnl.getLength()) {
                        Node tn = tnl.item(j);
                        if (tn instanceof Element) {
                            Node context;
                            int k;
                            NodeList cnl;
                            Element ne = (Element)tn;
                            String sN = ne.getNodeName();
                            if ("DrivenAnnotations".equals(sN)) {
                                cnl = ne.getChildNodes();
                                k = 0;
                                while (k < cnl.getLength()) {
                                    context = cnl.item(k);
                                    if (context instanceof Element) {
                                        String cValue = XMLUtils.getStringFromLeafElementBody((Element)context);
                                        tDrivenAnnotationList.add(cValue);
                                    }
                                    ++k;
                                }
                            } else if ("Context".equals(sN)) {
                                cnl = ne.getChildNodes();
                                k = 0;
                                while (k < cnl.getLength()) {
                                    context = cnl.item(k);
                                    if (context instanceof Element) {
                                        Element cElement = (Element)context;
                                        String cType = cElement.getNodeName();
                                        String cValue = XMLUtils.getStringFromLeafElementBody(cElement);
                                        tContextList.add(new TriggerContextInfo(cType, cValue));
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                    String[] drivenAnnotations = null;
                    if (tDrivenAnnotationList.size() > 0) {
                        drivenAnnotations = tDrivenAnnotationList.toArray(new String[tDrivenAnnotationList.size()]);
                    }
                    TriggerContextInfo[] tContexts = null;
                    if (tContextList.size() > 0) {
                        tContexts = tContextList.toArray(new TriggerContextInfo[tContextList.size()]);
                    }
                    tempL.add(new TriggerInfo(tName, tType, drivenAnnotations, tContexts));
                }
                ++m;
            }
            ++i;
        }
        TriggerInfo[] infos = tempL.toArray(new TriggerInfo[tempL.size()]);
        return infos;
    }

    private static ContextInfo getContextInfoFromElement(Element el) {
        ContextInfo cInfo = null;
        if (el.getNodeName().equals("context")) {
            NodeList nl = el.getChildNodes();
            String sContextTarget = el.getAttribute("target");
            String sContextType = el.getAttribute("targetType");
            boolean bV = false;
            String bS = el.getAttribute("notOneOfContextValidValues");
            if (bS.trim().equals("true")) {
                bV = true;
            }
            ArrayList<String> values = new ArrayList<String>();
            int i = 0;
            while (i < nl.getLength()) {
                Element ne;
                String sN;
                Node n = nl.item(i);
                if (n instanceof Element && (sN = (ne = (Element)n).getNodeName()).equals("value")) {
                    String st = XMLUtils.getStringFromLeafElementBody(ne);
                    values.add(st);
                }
                ++i;
            }
            String[] sVals = new String[values.size()];
            sVals = values.toArray(sVals);
            return new ContextInfo(sContextType, sContextTarget, sVals, bV);
        }
        return cInfo;
    }

    private static EObjectInfo getEObjectFeatureFromElement(Element el) {
        EObjectInfo eofi = null;
        String sName = el.getAttribute("eFeatureName");
        NodeList nl = el.getChildNodes();
        EObjectInfo child = null;
        EAttributeInfo[] ti = null;
        ArrayList<EAttributeInfo> tiList = new ArrayList<EAttributeInfo>();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof Element) {
                Element ne = (Element)n;
                if (ne.getNodeName().equals("eObject")) {
                    if (ne != el) {
                        child = XMLUtils.getEObjectFeatureFromElement(ne);
                    }
                } else if (ne.getNodeName().equals("eAttribute")) {
                    EAttributeInfo titemp = XMLUtils.getEAttributeInfoFromElement(ne);
                    tiList.add(titemp);
                }
            }
            ++i;
        }
        ti = new EAttributeInfo[tiList.size()];
        ti = tiList.toArray(ti);
        eofi = new EObjectInfo(sName, ti, child);
        return eofi;
    }

    private static EAttributeInfo getEAttributeInfoFromElement(Element el) {
        EAttributeInfo ti = null;
        String sName = el.getAttribute("targetName");
        String sType = el.getAttribute("targetType");
        String eFeatureName = el.getAttribute("eFeatureName");
        Hashtable hash = null;
        NodeList nl = el.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element ne;
            Node n = nl.item(i);
            if (n instanceof Element && (ne = (Element)n).getNodeName().equals("validValuesMap")) {
                hash = XMLUtils.getValidValuesMapFromElement(ne);
            }
            ++i;
        }
        ti = new EAttributeInfo(sName, sType, eFeatureName, hash);
        return ti;
    }

    private static Hashtable getValidValuesMapFromElement(Element el) {
        Hashtable<String, String> res = new Hashtable<String, String>();
        NodeList nl = el.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element ne;
            Node n = nl.item(i);
            if (n instanceof Element && (ne = (Element)n).getNodeName().equals("mapEntry")) {
                String key = ne.getAttribute("key");
                String value = ne.getAttribute("value");
                res.put(key, value);
            }
            ++i;
        }
        return res;
    }

    private static TriggerAnnotationInfo getTriggerAnnotationInfoFromElement(Element el) {
        int ind;
        String eFeatureName = el.getAttribute("eFeatureName");
        String name = XMLUtils.getStringFromLeafElementBody(el);
        String shortName = null;
        String packageName = null;
        if (name != null && (ind = name.lastIndexOf(".")) > 0) {
            shortName = name.substring(ind + 1, name.length());
            packageName = name.substring(0, ind);
        }
        TriggerAnnotationInfo inf = new TriggerAnnotationInfo(shortName, packageName, eFeatureName);
        return inf;
    }

    private static EObjectInfo getRequiredEObjectFromElement(Element el) {
        EObjectInfo info = null;
        NodeList nl = el.getChildNodes();
        if (nl.getLength() > 0) {
            int i = 0;
            while (i < nl.getLength()) {
                Element ne;
                Node n = nl.item(i);
                if (n instanceof Element && (ne = (Element)n).getNodeName().equals("eObject")) {
                    info = XMLUtils.getEObjectFeatureFromElement(ne);
                    break;
                }
                ++i;
            }
        }
        return info;
    }
}

