/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.annotations.ejb.converter;

import com.ibm.etools.annotations.core.data.AnnotatedProjectInfo;
import com.ibm.etools.annotations.core.data.AnnotatedProjectInfosRepository;
import com.ibm.etools.javaee.annotations.ejb.converter.AnnotationToEMFMapper;
import com.ibm.etools.javaee.annotations.ejb.converter.EMF2AnnotationAdapterImpl;
import com.ibm.etools.javaee.annotations.ejb.utils.EMFUtils;
import com.ibm.etools.javaee.annotations.ejb.utils.ReflectionUtils;
import com.ibm.etools.javaee.annotations.ejb.utils.XMLUtils;
import com.ibm.etools.javaee.core.JavaEEPlugin;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class EMF2AnnotationModelProvider
implements IResourceChangeListener {
    private static EMF2AnnotationModelProvider instance = new EMF2AnnotationModelProvider();
    private HashMap<IProject, SoftReference<EMF2AnnotationAdapterImpl>> localCache = new HashMap();
    private ArrayList<IProject> projectAboutToBeDeletedOrClosed = new ArrayList();

    public static EMF2AnnotationModelProvider getInstance() {
        return instance;
    }

    private EMF2AnnotationModelProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 7);
    }

    public EObject getTopLevelAnnotationObject(IProject project) {
        return this.getTopLevelAnnotationObject(project, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EObject getTopLevelAnnotationObject(IProject project, IProgressMonitor monitor) {
        HashMap<IProject, SoftReference<EMF2AnnotationAdapterImpl>> hashMap = this.localCache;
        synchronized (hashMap) {
            EMF2AnnotationAdapterImpl adap = null;
            SoftReference<EMF2AnnotationAdapterImpl> softAdapt = this.localCache.get(project);
            if (softAdapt != null) {
                adap = softAdapt.get();
            }
            if (adap == null) {
                if (!this.projectAboutToBeDeletedOrClosed.contains(project) && (adap = this.init(project, monitor)) != null) {
                    softAdapt = new SoftReference<EMF2AnnotationAdapterImpl>(adap);
                    this.localCache.put(project, softAdapt);
                    return adap.getTopObject();
                }
            } else {
                return adap.getTopObject();
            }
            return null;
        }
    }

    private EMF2AnnotationAdapterImpl init(IProject project, IProgressMonitor monitor) {
        EObject topEObject;
        AnnotationToEMFMapper m2;
        AnnotatedProjectInfo api;
        block7: {
            ReflectionUtils rUtils;
            block6: {
                block5: {
                    try {
                        api = JavaEEProjectUtilities.isDynamicWebProject((IProject)project) ? AnnotatedProjectInfosRepository.getInstance().getAnnotatedProjectInfoForWeb(project, false, false, monitor) : AnnotatedProjectInfosRepository.getInstance().getAnnotatedProjectInfoForEJB(project, false, false, monitor);
                        if (monitor == null || !monitor.isCanceled()) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        JavaEEPlugin.logError(e);
                        return null;
                    }
                }
                Hashtable<String, String> newH = new Hashtable<String, String>();
                newH.put("EJBPACKAGE", "org.eclipse.jst.javaee.ejb.internal.metadata.EjbPackage");
                newH.put("JAVAEEPACKAGE", "org.eclipse.jst.javaee.core.internal.metadata.JavaeePackage");
                rUtils = new ReflectionUtils(newH);
                if (JavaEEPlugin.getDefault() != null) break block6;
                return null;
            }
            Bundle bundle = JavaEEPlugin.getDefault().getBundle();
            URL starterURL = bundle.getEntry("EJBMappings.xml");
            URL fU = FileLocator.toFileURL((URL)starterURL);
            String fullpath = fU.getFile();
            Document doc = XMLUtils.parseXML(fullpath);
            m2 = new AnnotationToEMFMapper(doc);
            String clN = m2.getEClassName();
            EClass topEClass = (EClass)rUtils.executeMethod(clN);
            topEObject = EMFUtils.createEMFObject(topEClass);
            if (monitor == null || !monitor.isCanceled()) break block7;
            return null;
        }
        EMF2AnnotationAdapterImpl adapter1 = new EMF2AnnotationAdapterImpl(topEObject, api, m2, monitor);
        return adapter1;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        int deltaKind;
        IResource deltaRes = event.getResource();
        if (deltaRes != null && deltaRes.getType() == 4) {
            SoftReference<EMF2AnnotationAdapterImpl> softRef;
            if ((event.getType() == 2 || event.getType() == 4) && (softRef = this.localCache.get(deltaRes)) != null) {
                this.projectAboutToBeDeletedOrClosed.add((IProject)deltaRes);
                this.localCache.remove(deltaRes);
            }
            return;
        }
        if (this.projectAboutToBeDeletedOrClosed.size() > 0 && ((deltaKind = (delta = event.getDelta()).getKind()) == 4 || deltaKind == 2)) {
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource res = delta.getResource();
                    if (res != null && res.getType() == 4) {
                        EMF2AnnotationModelProvider.this.projectAboutToBeDeletedOrClosed.remove(res);
                        return false;
                    }
                    return true;
                }
            };
            try {
                delta.accept(visitor);
            }
            catch (CoreException e) {
                JavaEEPlugin.logError(e);
            }
        }
    }
}

