/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.annotations.base;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.ArrayAnnotationArgumentProperty;
import com.ibm.etools.annotations.core.properties.SingleAnnotationArgumentProperty;
import com.ibm.etools.javaee.annotations.base.CustomAnnotationBaseMapper;
import com.ibm.etools.javaee.annotations.base.EMF2AnnotationBaseAdapterFactory;
import com.ibm.etools.javaee.annotations.datastructures.TriggerInfo;
import com.ibm.etools.javaee.annotations.ejb.utils.CodeUtils;
import com.ibm.etools.javaee.annotations.ejb.utils.XMLUtils;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.AnnotationMapping;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.ContextInfo;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.EAttributeInfo;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.EObjectInfo;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.MappingInfo;
import com.ibm.etools.javaee.annotations.ejb.xml.datastructures.TriggerAnnotationInfo;
import com.ibm.etools.javaee.annotations.internal.utils.BaseEMFUtils;
import com.ibm.etools.javaee.annotations.internal.utils.BaseReflectionUtils;
import com.ibm.etools.javaee.core.JavaEEPlugin;
import com.ibm.propertygroup.spi.BaseMultiValuedProperty;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AnnotationToEMFBaseMapper {
    public static final int MAPPER_KIND_EJB = 1;
    public static final int MAPPER_KIND_WEB = 2;
    public static final int MAPPER_KIND_WEB_FRAGMENT = 3;
    protected Document doc_;
    protected Hashtable<String, ArrayList<AnnotationMapping>> annotationMappingsMap_ = new Hashtable();
    protected Hashtable<String, ArrayList<AnnotationMapping>> triggerMappingsMap_ = new Hashtable();
    protected BaseReflectionUtils rUtils_;
    protected String[] triggerAnnotations_ = null;
    protected TriggerInfo[] triggers_ = null;
    protected CustomAnnotationBaseMapper customMapper_ = null;
    protected int mapperKind_ = 1;

    protected AnnotationToEMFBaseMapper(Document doc) {
        this.doc_ = doc;
        this.init();
    }

    public EObject createTopEObject() {
        String clN = this.getEClassName();
        EClass topEClass = (EClass)this.rUtils_.executeMethod(clN);
        return BaseEMFUtils.createEMFObject(topEClass);
    }

    protected void init() {
        ArrayList<AnnotationMapping> aL;
        String sName;
        AnnotationMapping am;
        int n;
        List LL;
        if (!this.annotationMappingsMap_.keys().hasMoreElements()) {
            LL = XMLUtils.getAnnotationMappings(this.doc_);
            n = 0;
            while (n < LL.size()) {
                am = (AnnotationMapping)LL.get(n);
                sName = am.getFullyQualifiedName();
                aL = this.annotationMappingsMap_.get(sName);
                if (aL == null) {
                    aL = new ArrayList();
                    this.annotationMappingsMap_.put(sName, aL);
                }
                aL.add(am);
                ++n;
            }
        }
        if (!this.triggerMappingsMap_.keys().hasMoreElements()) {
            LL = XMLUtils.getTriggerMappings(this.doc_);
            n = 0;
            while (n < LL.size()) {
                am = (AnnotationMapping)LL.get(n);
                sName = am.getFullyQualifiedName();
                aL = this.triggerMappingsMap_.get(sName);
                if (aL == null) {
                    aL = new ArrayList();
                    this.triggerMappingsMap_.put(sName, aL);
                }
                aL.add(am);
                ++n;
            }
        }
        if (this.triggerAnnotations_ == null) {
            this.triggerAnnotations_ = XMLUtils.getTriggerAnnotationNames(this.doc_);
        }
        if (this.triggers_ == null) {
            this.triggers_ = XMLUtils.getTriggerInfos(this.doc_);
        }
    }

    protected Hashtable<String, ArrayList<String>> getDependencyMap() {
        if (this.customMapper_ != null) {
            return this.customMapper_.getDependencyMap();
        }
        return null;
    }

    public EObject handleAnnotation(AnnotationInfo info, String trigger, EObject top, List dependentAnnotations, String parentEfetName, boolean adaptNeeded) {
        EObject newTop = this.handleSingleLevelAnnotation(info, trigger, top, dependentAnnotations, parentEfetName, adaptNeeded);
        if (newTop != null) {
            if (newTop.equals(top)) {
                this.handleAttributeAnnotations(info, trigger, top, parentEfetName, adaptNeeded);
            } else {
                this.handleAttributeAnnotations(info, info.getFullyQualifiedName(), newTop, parentEfetName, adaptNeeded);
            }
        } else {
            newTop = top;
        }
        return newTop;
    }

    public EObject handleAnnotation(IJavaElement je, String triggerName, EObject top, List dependentAnnotations, String parentEfetName, boolean adaptNeeded) {
        EObject newTop = this.handleSingleLevelAnnotation(je, triggerName, top, dependentAnnotations, parentEfetName, adaptNeeded);
        if (newTop == null) {
            newTop = top;
        }
        return newTop;
    }

    protected EObject handleSingleLevelAnnotation(AnnotationInfo info, String trigger, EObject top, List dependentAnnotations, String parentEfetName, boolean adaptNeeded) {
        Object currVal;
        EStructuralFeature sF;
        if (this.isFullyCustomAnnotationHandling(info)) {
            return this.customMapper_.handleFullyCustomAnnotation(info, top, adaptNeeded);
        }
        AnnotationMapping aM = this.findAnnotationMapping(info, trigger, parentEfetName);
        if (aM == null) {
            if (trigger != null && trigger.length() > 0) {
                return null;
            }
            return top;
        }
        EObjectInfo efInf = aM.getEFeatureInfo();
        EObject newTop = top;
        String annEFname = null;
        String sFName = annEFname = aM.getTargetEFeatureName();
        ParentChild parChild = this.createEObjectForEObjectFeature(annEFname, efInf, top, parentEfetName, (Object)info, adaptNeeded);
        newTop = parChild.getChild();
        if (annEFname == null || annEFname.trim().length() == 0) {
            annEFname = parentEfetName;
        }
        List listMaps = aM.getListOfMappingInfos();
        int v = 0;
        while (v < listMaps.size()) {
            MappingInfo mi = (MappingInfo)listMaps.get(v);
            this.handleMapping(info, mi, newTop, annEFname, adaptNeeded);
            ++v;
        }
        if (this.isPartiallyCustomAnnotationHandling(info)) {
            newTop = this.customMapper_.handlePartiallyCustomAnnotation(info, newTop, top, adaptNeeded);
        }
        if (dependentAnnotations != null) {
            String sAnName = info.getFullyQualifiedName();
            int m = 0;
            while (m < dependentAnnotations.size()) {
                AnnotationInfo anInf = (AnnotationInfo)((Object)dependentAnnotations.get(m));
                this.handleAnnotation(anInf, sAnName, newTop, null, annEFname, true);
                ++m;
            }
        }
        if (parChild.getParent() != null && (sF = this.getEStructuralFeature(sFName)) != null && (currVal = parChild.getParent().eGet(sF)) != newTop) {
            BaseEMFUtils.setMOFValue((Notifier)parChild.getParent(), (Object)newTop, sF);
        }
        return newTop;
    }

    protected EObject handleSingleLevelAnnotation(IJavaElement je, String triggerName, EObject top, List dependentAnnotations, String parentEfetName, boolean adaptNeeded) {
        Object currVal;
        EStructuralFeature sF;
        if (this.isFullyCustomAnnotationHandling(triggerName)) {
            return this.customMapper_.handleFullyCustomAnnotation(je, triggerName, top, adaptNeeded);
        }
        ArrayList<AnnotationMapping> arList = this.triggerMappingsMap_.get(triggerName);
        if (arList == null || arList.isEmpty()) {
            return top;
        }
        AnnotationMapping aM = arList.get(0);
        EObjectInfo efInf = aM.getEFeatureInfo();
        EObject newTop = top;
        String annEFname = null;
        String sFName = annEFname = aM.getTargetEFeatureName();
        ParentChild parChild = this.createEObjectForEObjectFeature(annEFname, efInf, top, parentEfetName, je, adaptNeeded);
        newTop = parChild.getChild();
        if (annEFname == null || annEFname.trim().length() == 0) {
            annEFname = parentEfetName;
        }
        List listMaps = aM.getListOfMappingInfos();
        int v = 0;
        while (v < listMaps.size()) {
            this.handleEObjectCreation(je, ((MappingInfo)listMaps.get(v)).getParentEObjectFeature(), newTop, adaptNeeded);
            ++v;
        }
        if (this.isPartiallyCustomAnnotationHandling(triggerName)) {
            newTop = this.customMapper_.handlePartiallyCustomAnnotation(je, triggerName, newTop, top, adaptNeeded);
        }
        if (dependentAnnotations != null) {
            int m = 0;
            while (m < dependentAnnotations.size()) {
                AnnotationInfo anInf = (AnnotationInfo)((Object)dependentAnnotations.get(m));
                this.handleAnnotation(anInf, triggerName, newTop, null, annEFname, true);
                ++m;
            }
        }
        if (parChild.getParent() != null && (sF = this.getEStructuralFeature(sFName)) != null && (currVal = parChild.getParent().eGet(sF)) != newTop) {
            BaseEMFUtils.setMOFValue((Notifier)parChild.getParent(), (Object)newTop, sF);
        }
        return newTop;
    }

    protected AnnotationMapping findAnnotationMapping(AnnotationInfo info, String trigger, String parentEfetName) {
        AnnotationMapping aM = null;
        String sAnName = info.getFullyQualifiedName();
        ArrayList<AnnotationMapping> arList = this.annotationMappingsMap_.get(sAnName);
        if (arList == null || arList.isEmpty()) {
            return null;
        }
        if (trigger != null && arList.size() == 1 && this.isTrigerAnnotation(sAnName) && parentEfetName != null) {
            return null;
        }
        int k = 0;
        while (k < arList.size()) {
            AnnotationMapping anM = arList.get(k);
            boolean rightMapping = true;
            TriggerAnnotationInfo[] triggerInfos = anM.getTriggerAnnotations();
            String contextSensitiveEfeatureName = null;
            if (trigger != null) {
                rightMapping = false;
                int h = 0;
                while (h < triggerInfos.length) {
                    String name = triggerInfos[h].getFullyQualifiedName();
                    if (name != null && name.equals(trigger)) {
                        contextSensitiveEfeatureName = triggerInfos[h].getEFeatureName();
                        rightMapping = true;
                        break;
                    }
                    ++h;
                }
            }
            if (rightMapping) {
                ContextInfo[] arContexts = anM.getContexts();
                int c = 0;
                while (c < arContexts.length) {
                    if (arContexts[c].getContextType().equals("Attribute")) {
                        String attrName = arContexts[c].getContextTarget();
                        String val = CodeUtils.getSingleValueAttributeFromAnnotation(info, attrName);
                        if (val != null) {
                            int n;
                            boolean tempB;
                            String[] sVals = arContexts[c].getValidContextValues();
                            if (!arContexts[c].isNotOneOfContextValues()) {
                                tempB = false;
                                n = 0;
                                while (n < sVals.length) {
                                    if (sVals[n].equals(val)) {
                                        tempB = true;
                                        break;
                                    }
                                    ++n;
                                }
                                if (!tempB) {
                                    rightMapping = false;
                                    break;
                                }
                            } else {
                                tempB = true;
                                n = 0;
                                while (n < sVals.length) {
                                    if (sVals[n].equals(val)) {
                                        tempB = false;
                                        break;
                                    }
                                    ++n;
                                }
                                if (!tempB) {
                                    rightMapping = false;
                                    break;
                                }
                            }
                        } else {
                            rightMapping = false;
                        }
                    } else {
                        rightMapping = false;
                    }
                    ++c;
                }
                if (rightMapping) {
                    aM = anM;
                    if (contextSensitiveEfeatureName == null || contextSensitiveEfeatureName.trim().length() <= 0) break;
                    aM.setTargetEFeatureName(contextSensitiveEfeatureName);
                    break;
                }
            }
            ++k;
        }
        return aM;
    }

    protected boolean isFullyCustomAnnotationHandling(AnnotationInfo info) {
        if (this.customMapper_ != null) {
            return this.customMapper_.isFullyCustomAnnotationHandling(info);
        }
        return false;
    }

    protected boolean isFullyCustomAnnotationHandling(String fullName) {
        if (this.customMapper_ != null) {
            return this.customMapper_.isFullyCustomAnnotationHandling(fullName);
        }
        return false;
    }

    protected boolean isPartiallyCustomAnnotationHandling(AnnotationInfo info) {
        if (this.customMapper_ != null) {
            return this.customMapper_.isPartiallyCustomAnnotationHandling(info);
        }
        return false;
    }

    protected boolean isPartiallyCustomAnnotationHandling(String fullName) {
        if (this.customMapper_ != null) {
            return this.customMapper_.isPartiallyCustomAnnotationHandling(fullName);
        }
        return false;
    }

    protected void handleAttributeAnnotations(AnnotationInfo anInf, String trigger, EObject top, String parentEfetName, boolean adaptNeeded) {
        List<IAnnotationAttributeProperty> attributes = anInf.getDeclaredAttributes();
        if (attributes != null && attributes.size() > 0) {
            int i = 0;
            while (i < attributes.size()) {
                IAnnotationAttributeProperty attribute = attributes.get(i);
                if (attribute instanceof ArrayAnnotationArgumentProperty) {
                    Object[] values = ((ArrayAnnotationArgumentProperty)attribute).getValues();
                    int j = 0;
                    while (j < values.length) {
                        this.handleAnnotation((AnnotationInfo)((Object)values[j]), trigger, top, null, parentEfetName, adaptNeeded);
                        ++j;
                    }
                } else if (attribute instanceof SingleAnnotationArgumentProperty && ((SingleAnnotationArgumentProperty)attribute).getValue() != null) {
                    this.handleAnnotation((AnnotationInfo)((Object)((SingleAnnotationArgumentProperty)attribute).getValue()), trigger, top, null, parentEfetName, adaptNeeded);
                }
                ++i;
            }
        }
    }

    public String[] getTriggerAnnotationNames() {
        return this.triggerAnnotations_;
    }

    public TriggerInfo[] getTriggerInfos() {
        return this.triggers_;
    }

    protected boolean isTrigerAnnotation(String sAnName) {
        String[] stringArray = this.triggerAnnotations_;
        int n = this.triggerAnnotations_.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(sAnName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getEClassName() {
        NodeList nl = this.doc_.getElementsByTagName("eClass");
        return ((Element)nl.item(0)).getAttribute("name");
    }

    protected EObject createUpperObjects(EObjectInfo inf, EObject top, Object ai, boolean adaptNeeded) {
        EObject currentObject = top;
        if (inf != null) {
            EObjectInfo iterOb = inf;
            while (iterOb != null) {
                currentObject = this.getEObjectForEObjectFeature(iterOb.getName(), currentObject, ai, adaptNeeded, true);
                iterOb = iterOb.getChild();
            }
        }
        return currentObject;
    }

    protected ParentChild createEObjectForEObjectFeature(String featureName, EObjectInfo info, EObject top, String sEFName, Object ai, boolean adaptNeeded) {
        EObjectInfo newInfo = info;
        if (newInfo != null && sEFName != null && newInfo.getName().equals(sEFName)) {
            newInfo = newInfo.getChild();
        }
        ParentChild parChild = new ParentChild();
        parChild.setParent(this.createUpperObjects(newInfo, top, ai, adaptNeeded));
        parChild.setChild(this.getEObjectForEObjectFeature(featureName, parChild.getParent(), ai, adaptNeeded, false));
        return parChild;
    }

    public EStructuralFeature getEStructuralFeature(String featureName) {
        String fName = featureName;
        Object o1 = this.rUtils_.executeMethod(fName);
        EStructuralFeature feature = o1 instanceof EStructuralFeature ? (EStructuralFeature)o1 : null;
        return feature;
    }

    protected EObject getEObjectForEObjectFeature(String featureName, EObject top, Object ai, boolean adaptNeeded, boolean setFeatureIfNew) {
        EObject res = top;
        String fName = featureName;
        EStructuralFeature feature = this.getEStructuralFeature(fName);
        if (feature != null) {
            Object obj = BaseEMFUtils.getMOFValue(top, feature);
            if (obj == null || obj instanceof EMap || obj instanceof EList) {
                if (top != null) {
                    res = setFeatureIfNew ? BaseEMFUtils.createAndSet((Notifier)top, feature) : BaseEMFUtils.createEMFObject(feature);
                    if (adaptNeeded) {
                        this.getEMF2AnnotationAdapterFactoryInstance().adapt((Notifier)res, ai);
                    }
                }
            } else if (obj instanceof EObject) {
                res = (EObject)obj;
                if (adaptNeeded) {
                    this.getEMF2AnnotationAdapterFactoryInstance().adapt((Notifier)res, ai);
                }
            }
        }
        return res;
    }

    protected void handleAttribute(AnnotationInfo info, String sAnnotFeatureName, EObject annotTopObject, EAttributeInfo attrMapping, boolean adaptNeeded) {
        String sAttrName = attrMapping.getTargetName();
        IAnnotationAttributeProperty aP = info.getAttribute(sAttrName);
        if (aP != null) {
            String v;
            Object attrValue = "";
            if (aP instanceof BaseSingleValuedProperty) {
                attrValue = CodeUtils.getSingleValueAttributeFromAnnotation(info, sAttrName);
            } else if (aP instanceof BaseMultiValuedProperty) {
                attrValue = ((BaseMultiValuedProperty)aP).getValues();
            }
            Hashtable hash = attrMapping.getValidValuesMap();
            if (hash != null && (v = (String)hash.get(attrValue)) != null) {
                attrValue = v;
            }
            this.handleSetValue(sAnnotFeatureName, annotTopObject, attrValue, (Object)info, adaptNeeded);
        }
    }

    protected void handleJavaElement(Object info, String sAnnotFeatureName, EObject annotTopObject, EAttributeInfo attrMapping, boolean adaptNeeded) {
        String sJavaElName = attrMapping.getTargetName();
        IJavaElement parEl = null;
        if (info instanceof AnnotationInfo) {
            IAnnotation oA = ((AnnotationInfo)((Object)info)).getAnnotation();
            parEl = oA.getParent();
        } else if (info instanceof IJavaElement) {
            parEl = (IJavaElement)info;
        }
        String value = null;
        if (parEl != null) {
            if (sJavaElName.equals("className")) {
                IJavaElement parent;
                if (parEl.getElementType() == 7) {
                    value = ((IType)parEl).getFullyQualifiedName();
                } else if ((parEl.getElementType() == 9 || parEl.getElementType() == 8) && (parent = parEl.getParent()).getElementType() == 7) {
                    value = ((IType)parent).getFullyQualifiedName();
                }
            } else if (sJavaElName.equals("typeName")) {
                IJavaElement parent;
                if (parEl.getElementType() == 7) {
                    value = ((IType)parEl).getElementName();
                } else if ((parEl.getElementType() == 9 || parEl.getElementType() == 8) && (parent = parEl.getParent()).getElementType() == 7) {
                    value = ((IType)parent).getElementName();
                }
            } else if (parEl.getElementType() == 9 && sJavaElName.equals("methodName")) {
                value = ((IMethod)parEl).getElementName();
            } else if (parEl.getElementType() == 8 && sJavaElName.equals("fieldName")) {
                value = ((IField)parEl).getElementName();
            } else if (parEl.getElementType() == 9 && sJavaElName.equals("methodParameters")) {
                this.handleSetValue(sAnnotFeatureName, annotTopObject, ((IMethod)parEl).getParameterTypes(), info, adaptNeeded);
                return;
            }
        }
        if (value != null) {
            this.handleSetValue(sAnnotFeatureName, annotTopObject, value, info, adaptNeeded);
        }
    }

    protected void handleANYElement(Object info, String sAnnotFeatureName, EObject annotTopObject, EAttributeInfo attrMapping, boolean adaptNeeded) {
        String value = attrMapping.getTargetName();
        if (value != null) {
            this.handleSetValue(sAnnotFeatureName, annotTopObject, value, info, adaptNeeded);
        }
    }

    protected void handleSetValue(String featureName, EObject annotTopObject, Object value, Object ai, boolean adaptNeeded) {
        EStructuralFeature feature = this.getEStructuralFeature(featureName);
        if (feature != null) {
            BaseEMFUtils.handleSetValue(feature, annotTopObject, value, ai, adaptNeeded, this.mapperKind_);
        }
    }

    protected EMF2AnnotationBaseAdapterFactory getEMF2AnnotationAdapterFactoryInstance() {
        return EMF2AnnotationBaseAdapterFactory.getInstance();
    }

    protected void handleMapping(AnnotationInfo info, MappingInfo mi, EObject newTop, String annEFname, boolean adaptNeeded) {
        String targetName;
        String targetType = mi.getTargetType();
        if (targetType != null && targetType.equals("AnnotationAttribute") && (targetName = mi.getTargetName()) != null && info.getAttribute(targetName) == null) {
            return;
        }
        this.handleEObjectCreation((Object)info, mi.getParentEObjectFeature(), newTop, adaptNeeded);
    }

    protected void handleEObjectCreation(Object info, EObjectInfo eoInf, EObject top, boolean adaptNeeded) {
        EObjectInfo child;
        String sFName = eoInf.getName();
        EAttributeInfo[] tis = eoInf.getTargetInfos();
        EObject newTop = top;
        boolean newTopObject = false;
        if (sFName != null && sFName.trim().length() != 0) {
            newTop = this.getEObjectForEObjectFeature(sFName, top, info, adaptNeeded, false);
            newTopObject = true;
        }
        if (tis != null) {
            int b = 0;
            while (b < tis.length) {
                EAttributeInfo ti = tis[b];
                String sType = ti.getTargetType();
                String annEFname = ti.getTargetEFeatureName();
                if (sType.equals("AnnotationAttribute") && info instanceof AnnotationInfo) {
                    this.handleAttribute((AnnotationInfo)((Object)info), annEFname, newTop, ti, adaptNeeded);
                } else if (sType.equals("JavaElement")) {
                    this.handleJavaElement(info, annEFname, newTop, ti, adaptNeeded);
                } else if (sType.equals("ANY")) {
                    this.handleANYElement(info, annEFname, newTop, ti, adaptNeeded);
                }
                ++b;
            }
        }
        if ((child = eoInf.getChild()) != null) {
            this.handleEObjectCreation(info, child, newTop, adaptNeeded);
        }
        if (newTopObject && sFName != null && sFName.trim().length() != 0) {
            EStructuralFeature sF = this.getEStructuralFeature(sFName);
            if (sF != null) {
                BaseEMFUtils.setMOFValue((Notifier)top, (Object)newTop, sF);
            } else {
                JavaEEPlugin.logError("Couldn't create structural feature for string '" + sFName + "'.");
            }
        }
    }

    protected class ParentChild {
        protected EObject parent;
        protected EObject child;

        protected ParentChild() {
        }

        public EObject getParent() {
            return this.parent;
        }

        public void setParent(EObject parent) {
            this.parent = parent;
        }

        public EObject getChild() {
            return this.child;
        }

        public void setChild(EObject child) {
            this.child = child;
        }
    }
}

