/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.reference;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.reference.ReferenceDataModel;
import com.ibm.etools.j2ee.reference.ServiceReferenceCreationOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceExtManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceHelper;
import org.eclipse.jst.j2ee.internal.webservices.WebServicesClientDataHelper;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class ServiceReferenceDataModel
extends ReferenceDataModel
implements WebServicesClientDataHelper {
    public static final String TARGET_WEB_SERVICE = "ServiceReferenceDataModel.TARGET_WEB_SERVICE";
    public static final String WSDL_FILE = "ServiceReferenceDataModel.WSDL_FILE";
    public static final String JAX_RPC_MAPPING_FILE = "ServiceReferenceDataModel.JAX_RPC_MAPPING_FILE";
    public static final String QNAME_NAMESPACE_URI = "ServiceReferenceDataModel.QNAME_NAMESPACE_URI";
    public static final String QNAME_lOCAL_PART = "ServiceReferenceDataModel.QNAME_lOCAL_PART";
    public static final String WSDL_URL = "ServiceReferenceDataModel.WSDL_URL";
    public static final String QNAME = "ServiceReferenceDataModel.QNAME";
    public static final String LINKS = "ServiceReferenceDataModel.LINK";
    private String[] serviceEndpointInterfaceNames = null;
    private String serviceInterfaceName = null;
    private boolean didGenDescriptor = false;

    @Override
    protected void initValidBaseProperties() {
        this.addValidBaseProperty(TARGET_WEB_SERVICE);
        this.addValidBaseProperty(WSDL_FILE);
        this.addValidBaseProperty(JAX_RPC_MAPPING_FILE);
        this.addValidBaseProperty(QNAME_NAMESPACE_URI);
        this.addValidBaseProperty(QNAME_lOCAL_PART);
        this.addValidBaseProperty(WSDL_URL);
        this.addValidBaseProperty(QNAME);
        this.addValidBaseProperty(LINKS);
        super.initValidBaseProperties();
    }

    @Override
    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean doSet = super.doSetProperty(propertyName, propertyValue);
        if (propertyName.equals(TARGET_WEB_SERVICE)) {
            this.notifyDefaultChange("ReferenceDataModel.REF_NAME");
            this.notifyDefaultChange(WSDL_FILE);
            this.notifyDefaultChange(WSDL_URL);
            this.notifyDefaultChange(QNAME);
            this.notifyDefaultChange(QNAME_NAMESPACE_URI);
            this.notifyDefaultChange(QNAME_lOCAL_PART);
        }
        return doSet;
    }

    protected Object getLocationForServiceFromWSIL(EObject wsdl) {
        IFile wsdlFile;
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        if (wsdl.eResource() == null) {
            return serviceHelper.getServiceDefinitionLocation(wsdl);
        }
        URI uri = wsdl.eResource().getURI();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath rootPath = root.getLocation();
        Path wsdlPath = new Path(uri.toFileString());
        if (wsdlPath.matchingFirstSegments(rootPath) == rootPath.segmentCount() && (wsdlFile = root.getFile(wsdlPath.removeFirstSegments(rootPath.segmentCount()))).exists()) {
            return wsdlFile.getProjectRelativePath().removeFirstSegments(1).toString();
        }
        return null;
    }

    @Override
    protected Object getDefaultProperty(String propertyName) {
        Object qName;
        EObject wsdl;
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        if (propertyName.equals("ReferenceDataModel.REF_NAME")) {
            Object wsdl2 = this.getProperty(TARGET_WEB_SERVICE);
            if (wsdl2 != null) {
                return "service/" + serviceHelper.getServiceLocalPart(wsdl2);
            }
        } else if (propertyName.equals(WSDL_FILE)) {
            EObject wsdl3 = (EObject)this.getProperty(TARGET_WEB_SERVICE);
            if (wsdl3 != null) {
                boolean isInternal;
                boolean bl = isInternal = WorkbenchResourceHelper.getFile((EObject)wsdl3) != null && WorkbenchResourceHelper.getFile((EObject)wsdl3).exists();
                if (isInternal) {
                    return WorkbenchResourceHelper.getFile((EObject)wsdl3).getProjectRelativePath().removeFirstSegments(1).toString();
                }
                Object location = this.getLocationForServiceFromWSIL(wsdl3);
                if (location != null) {
                    return location;
                }
            }
        } else if (propertyName.equals(WSDL_URL)) {
            EObject wsdl4 = (EObject)this.getProperty(TARGET_WEB_SERVICE);
            if (wsdl4 != null) {
                boolean isInternal;
                boolean bl = isInternal = WorkbenchResourceHelper.getFile((EObject)wsdl4) != null && WorkbenchResourceHelper.getFile((EObject)wsdl4).exists();
                if (isInternal) {
                    String rawLocation = WorkbenchResourceHelper.getFile((EObject)wsdl4).getRawLocation().toString();
                    if (Platform.getOS().equals("linux")) {
                        return "file://" + rawLocation;
                    }
                    return "file:/" + rawLocation;
                }
                return serviceHelper.getServiceDefinitionLocation(wsdl4);
            }
        } else if (propertyName.equals(QNAME)) {
            EObject wsdl5 = (EObject)this.getProperty(TARGET_WEB_SERVICE);
            if (wsdl5 != null) {
                return serviceHelper.getServiceQName((Object)wsdl5);
            }
        } else if (propertyName.equals(QNAME_NAMESPACE_URI)) {
            Object qName2;
            EObject wsdl6 = (EObject)this.getProperty(TARGET_WEB_SERVICE);
            if (wsdl6 != null && (qName2 = serviceHelper.getServiceQName((Object)wsdl6)) != null) {
                return serviceHelper.getServiceNamespaceURI((Object)wsdl6);
            }
        } else if (propertyName.equals(QNAME_lOCAL_PART) && (wsdl = (EObject)this.getProperty(TARGET_WEB_SERVICE)) != null && (qName = serviceHelper.getServiceQName((Object)wsdl)) != null) {
            return serviceHelper.getServiceLocalPart((Object)wsdl);
        }
        return super.getDefaultProperty(propertyName);
    }

    @Override
    protected IStatus doValidateProperty(String propertyName) {
        IStatus stat = super.doValidateProperty(propertyName);
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        if (!serviceHelper.isService(this.getProperty(TARGET_WEB_SERVICE))) {
            return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.ServiceReferenceDataModel_ERROR_8);
        }
        return stat;
    }

    @Override
    public WTPOperation getDefaultOperation() {
        return new ServiceReferenceCreationOperation(this);
    }

    public String getWSDLUrl() {
        return this.getStringProperty(WSDL_URL);
    }

    public String getServiceQName() {
        return String.valueOf(this.getStringProperty(QNAME_NAMESPACE_URI)) + ":" + this.getStringProperty(QNAME_lOCAL_PART);
    }

    public String getServiceInterfaceName() {
        return this.serviceInterfaceName;
    }

    public String[] getServiceEndpointInterfaceNames() {
        return this.serviceEndpointInterfaceNames;
    }

    public void setServiceInterfaceName(String name) {
        this.serviceInterfaceName = name;
    }

    public void setServiceEndpointInterfaceNames(String[] names) {
        this.serviceEndpointInterfaceNames = names;
    }

    public String getProjectName() {
        Object owner = this.getProperty("ReferenceDataModel.OWNER");
        String name = ProjectUtilities.getProject((Object)owner).getName();
        return name;
    }

    public String getOutputWSDLFileName() {
        String subStringtoRemove;
        String wsdlFileOriginalLocation = this.getStringProperty(WSDL_FILE);
        StringBuffer buffer = null;
        boolean bModified = false;
        if (wsdlFileOriginalLocation.startsWith("META-INF", 0)) {
            buffer = new StringBuffer(wsdlFileOriginalLocation);
            subStringtoRemove = "META-INF";
            buffer.delete(0, subStringtoRemove.length());
            bModified = true;
        } else if (wsdlFileOriginalLocation.startsWith("WEB-INF", 0)) {
            buffer = new StringBuffer(wsdlFileOriginalLocation);
            subStringtoRemove = "WEB-INF";
            buffer.delete(0, subStringtoRemove.length());
            bModified = true;
        }
        if (bModified && buffer != null) {
            boolean bufferFixed = false;
            switch (this.getDeploymentDescriptorType()) {
                case 1: 
                case 3: {
                    bufferFixed = true;
                    buffer.insert(0, "META-INF");
                    break;
                }
                case 4: {
                    bufferFixed = true;
                    buffer.insert(0, "WEB-INF");
                }
            }
            if (bufferFixed) {
                return buffer.toString();
            }
            return this.getStringProperty(WSDL_FILE);
        }
        return this.getStringProperty(WSDL_FILE);
    }

    public boolean shouldDeploy() {
        return false;
    }

    public boolean shouldGenDescriptors() {
        return false;
    }

    public void setDidGenDescriptors(boolean b) {
        this.didGenDescriptor = b;
    }

    public boolean didGenDescriptors() {
        return this.didGenDescriptor;
    }

    @Override
    protected boolean isResultProperty(String propertyName) {
        if (propertyName.equals(JAX_RPC_MAPPING_FILE)) {
            return true;
        }
        return super.isResultProperty(propertyName);
    }
}

