/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.project;

import com.ibm.etools.j2ee.J2eePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class BinaryProjectVirtualComponent
extends J2EEModuleVirtualComponent {
    public static boolean isBinaryProject(IProject aProject) {
        return BinaryProjectVirtualComponent.getJarEntry(aProject) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IClasspathEntry getJarEntry(IProject aProject) {
        try {
            if (!aProject.isAccessible() || !aProject.hasNature("org.eclipse.jdt.core.javanature")) {
                return null;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)aProject);
        if (javaProject == null) {
            return null;
        }
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            IClasspathEntry libEntry = null;
            int i = 0;
            while (true) {
                if (i >= entries.length) {
                    return libEntry;
                }
                switch (entries[i].getEntryKind()) {
                    case 1: {
                        if (libEntry != null) {
                            return null;
                        }
                        libEntry = entries[i];
                        break;
                    }
                    case 3: {
                        return null;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            J2eePlugin.logError((CoreException)((Object)e));
            return null;
        }
    }

    public IVirtualComponent createComponent(IProject aProject) {
        if (ModuleCoreNature.isFlexibleProject((IProject)aProject)) {
            return new VirtualComponent(aProject, (IPath)new Path("/"));
        }
        IClasspathEntry entry = BinaryProjectVirtualComponent.getJarEntry(aProject);
        if (entry == null) {
            return null;
        }
        String archiveLocation = "lib/" + entry.getPath().toString();
        return this.createArchiveComponent(aProject, archiveLocation);
    }

    public IVirtualComponent createArchiveComponent(IProject aProject, String archiveLocation) {
        return new J2EEModuleVirtualArchiveComponent(aProject, archiveLocation, null);
    }
}

