/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.java.codegen;

import com.ibm.etools.j2ee.internal.codegen.GenerationException;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMemberGenerator;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMergeStrategy;
import com.ibm.etools.j2ee.internal.java.codegen.JavaTypeGenerator;
import com.ibm.etools.j2ee.internal.java.codegen.MergeException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class JavaBatchMergeStrategy
extends JavaMergeStrategy {
    protected void gatherChildGenerators(JavaMemberGenerator memberGen, List typeChildGens) {
        Iterator childGenIter = memberGen.getChildren().iterator();
        JavaMemberGenerator childGen = null;
        while (childGenIter.hasNext()) {
            childGen = (JavaMemberGenerator)childGenIter.next();
            if (childGen.isGroup()) {
                this.gatherChildGenerators(childGen, typeChildGens);
                continue;
            }
            if (childGen.getTargetElement() == null) continue;
            typeChildGens.add(childGen);
        }
    }

    @Override
    public boolean isBatchGeneration() {
        return true;
    }

    @Override
    public boolean isTagGenerated() {
        return false;
    }

    @Override
    public void postProcess(JavaTypeGenerator typeGen) throws MergeException {
        if (typeGen.getMergeResults().getOldMember() == null && typeGen.getMergeResults().getCollisionMember() == null) {
            return;
        }
        ArrayList typeChildGens = new ArrayList();
        this.gatherChildGenerators(typeGen, typeChildGens);
        try {
            boolean isPrepared = typeGen.isPrepared();
            IMember[] children = new IMember[typeChildGens.size()];
            Iterator childGenIter = typeChildGens.iterator();
            JavaMemberGenerator childGen = null;
            int i = 0;
            while (childGenIter.hasNext()) {
                childGen = (JavaMemberGenerator)childGenIter.next();
                children[i] = (IMember)childGen.getTargetElement();
                if (isPrepared && !children[i].getCompilationUnit().isWorkingCopy()) {
                    children[i] = childGen.reaccess(children[i]);
                }
                ++i;
            }
            boolean needToDelete = false;
            IJavaElement[] dangerousDoNotTouch = ((IType)typeGen.getTargetElement()).getChildren();
            IJavaElement[] deleteCandidates = new IJavaElement[dangerousDoNotTouch.length];
            System.arraycopy(dangerousDoNotTouch, 0, deleteCandidates, 0, dangerousDoNotTouch.length);
            int i2 = 0;
            while (i2 < deleteCandidates.length) {
                if (!this.isTagGenerated() || this.wasGenerated((IMember)deleteCandidates[i2])) {
                    boolean found = false;
                    int j = 0;
                    while (!found && j < children.length) {
                        if (children[j] != null && (found = deleteCandidates[i2].equals(children[j]))) {
                            deleteCandidates[i2] = null;
                            children[j] = null;
                        }
                        ++j;
                    }
                } else {
                    deleteCandidates[i2] = null;
                }
                needToDelete |= deleteCandidates[i2] != null;
                ++i2;
            }
            if (needToDelete) {
                if (!isPrepared) {
                    typeGen.prepare();
                }
                IType type = typeGen.getType();
                int i3 = 0;
                while (i3 < deleteCandidates.length) {
                    if (deleteCandidates[i3] != null) {
                        if (!isPrepared) {
                            deleteCandidates[i3] = this.reaccess((IMember)deleteCandidates[i3], type);
                        }
                        ((IMember)deleteCandidates[i3]).delete(false, null);
                    }
                    ++i3;
                }
            }
        }
        catch (GenerationException exc) {
            throw new MergeException(exc);
        }
        catch (JavaModelException exc) {
            throw new MergeException((Exception)((Object)exc));
        }
    }

    protected IMember reaccess(IMember oldMember, IType type) throws GenerationException {
        IField result = null;
        if (oldMember != null) {
            if (type != null) {
                switch (oldMember.getElementType()) {
                    case 8: {
                        result = type.getField(oldMember.getElementName());
                        break;
                    }
                    case 7: {
                        result = type.getType(oldMember.getElementName());
                        break;
                    }
                    case 9: {
                        result = type.getMethod(oldMember.getElementName(), ((IMethod)oldMember).getParameterTypes());
                    }
                }
            }
            if (result != null && !result.exists()) {
                result = null;
            }
        }
        return result;
    }
}

