/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.AddSecurityRoleOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.internal.java.codegen.JavaCodeGenResourceHandler;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.web.IWebCommon;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class AddSecurityRoleOperationDataModel
extends J2EEModelModifierOperationDataModel {
    private EObject ddRoot;
    public static final String ROLE_NAME = "AddSecurityRoleOperationDataModel.ROLE_NAME";
    public static final String ROLE_DESCRIPTION = "AddSecurityRoleOperationDataModel.ROLE_DESCRIPTION";

    @Override
    public WTPOperation getDefaultOperation() {
        return new AddSecurityRoleOperation(this);
    }

    @Override
    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(ROLE_NAME);
        this.addValidBaseProperty(ROLE_DESCRIPTION);
    }

    @Override
    protected IStatus doValidateProperty(String propertyName) {
        IStatus status = this.validateEE5Project();
        if (!status.isOK() && !this.isJavaEE6Project()) {
            return status;
        }
        if (propertyName.equals(ROLE_NAME)) {
            return this.validateRoleName(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    protected IStatus validateEE5Project() {
        EObject app = this.getDeploymentDescriptorRoot();
        IProject selectedProj = JavaEEProjectUtilities.getProject((String)this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
        if (app == null && !JavaEEProjectUtilities.isWebFragmentProject((IProject)selectedProj)) {
            String msg = MessageFormat.format(JavaCodeGenResourceHandler.AddSecurityRoleOperationDataModel_This_wizard_is_not_applicable_on_pr_, new Object[1]);
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateRoleName(String roleName) {
        boolean exists;
        if (roleName.length() == 0) {
            String msg = J2EECommonMessages.ERR_SECURITY_ROLE_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (this.ddRoot == null) {
            this.ddRoot = this.getDeploymentDescriptorRoot();
        }
        if (exists = this.roleExists(roleName)) {
            String msg = J2EECommonMessages.getResourceString((String)J2EECommonMessages.ERR_SECURITY_ROLE_EXIST, (Object[])new String[]{roleName});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private boolean roleExists(String roleName) {
        switch (this.getDeploymentDescriptorType()) {
            case 2: {
                return this.roleExists(roleName, (Application)this.ddRoot);
            }
            case 3: {
                return this.roleExists(roleName, (EJBJar)this.ddRoot);
            }
            case 4: {
                return this.roleExists(roleName, (WebApp)this.ddRoot);
            }
        }
        return false;
    }

    private boolean roleExists(String roleName, EJBJar jar) {
        AssemblyDescriptor descriptor = jar.getAssemblyDescriptor();
        return descriptor != null && descriptor.getSecurityRoleNamed(roleName) != null;
    }

    private boolean roleExists(String roleName, Application application) {
        return application.getSecurityRoleNamed(roleName) != null;
    }

    private boolean roleExists(String roleName, WebApp webApp) {
        if (webApp != null) {
            return webApp.getSecurityRoleNamed(roleName) != null;
        }
        IProject selectedProj = JavaEEProjectUtilities.getProject((String)this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
        IWebCommon webCommon = (IWebCommon)ModelProviderManager.getModelProvider((IProject)selectedProj).getModelObject();
        List secRoles = webCommon.getSecurityRoles();
        for (SecurityRole secRole : secRoles) {
            if (!secRole.getRoleName().equals(webCommon)) continue;
            return true;
        }
        return false;
    }

    public boolean isJavaEE6Project() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
        if (project != null && project.isAccessible()) {
            try {
                return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)WebFacetUtils.WEB_FACET.getId(), (String)WebFacetUtils.WEB_30.getVersionString()) || FacetedProjectFramework.hasProjectFacet((IProject)project, (String)WebFacetUtils.WEBFRAGMENT_FACET.getId(), (String)WebFacetUtils.WEBFRAGMENT_30.getVersionString());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

