/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.frameworks.internal.datamodel;

import com.ibm.etools.common.frameworks.FrameworksPlugin;
import com.ibm.etools.common.frameworks.internal.datamodel.ComposedExtendedOperationHolder;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementManager;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtension;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtensionReader;

public class OperationExtensionRegistry {
    protected static OperationExtensionRegistry instance = null;

    public static String[] getRegisteredOperations(String className) {
        Collection ext = (Collection)OperationExtensionReader.getExtensionPoints().get(className);
        if (ext != null) {
            return OperationExtensionRegistry.getClassNames(ext.toArray());
        }
        return null;
    }

    private static String[] getClassNames(Object[] opExt) {
        ArrayList<String> classNames = new ArrayList<String>();
        OperationExtension currentExt = null;
        int i = 0;
        while (i < opExt.length) {
            currentExt = (OperationExtension)opExt[i];
            if (EnablementManager.INSTANCE.getIdentifier(currentExt.getExtensionId(), null).isEnabled()) {
                String className = currentExt.getPreOperationClass();
                if (className != null) {
                    classNames.add(className);
                }
                if ((className = currentExt.getPostOperationClass()) != null) {
                    classNames.add(className);
                }
            }
            ++i;
        }
        String[] array = new String[classNames.size()];
        classNames.toArray(array);
        return array;
    }

    public static ComposedExtendedOperationHolder getExtensions(WTPOperation op) {
        Collection ext = (Collection)OperationExtensionReader.getExtensionPoints().get(op.getClass().getName());
        if (ext != null) {
            try {
                return OperationExtensionRegistry.calculateOperationHolder(ext);
            }
            catch (CoreException ex) {
                FrameworksPlugin.logError(ex);
            }
        }
        return null;
    }

    private static ComposedExtendedOperationHolder calculateOperationHolder(Collection ext) throws CoreException {
        Object[] opExt = ext.toArray();
        ComposedExtendedOperationHolder extOperationHolder = new ComposedExtendedOperationHolder();
        WTPOperation preOp = null;
        WTPOperation postOp = null;
        OperationExtension currentExt = null;
        int i = 0;
        while (i < opExt.length) {
            currentExt = (OperationExtension)opExt[i];
            if (EnablementManager.INSTANCE.getIdentifier(currentExt.getExtensionId(), null).isEnabled()) {
                if (currentExt.getPreOperationClass() != null && (preOp = (WTPOperation)currentExt.getBaseElement().createExecutableExtension("preOperationClass")) != null) {
                    extOperationHolder.addPreOperation(preOp);
                }
                if (currentExt.getPostOperationClass() != null && (postOp = (WTPOperation)currentExt.getBaseElement().createExecutableExtension("postOperationClass")) != null) {
                    extOperationHolder.addPostOperation(postOp);
                }
            }
            ++i;
        }
        return extOperationHolder;
    }

    public static OperationExtensionRegistry getInstance() {
        if (instance == null) {
            instance = new OperationExtensionRegistry();
        }
        return instance;
    }
}

