/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.frameworks.internal.datamodel;

import com.ibm.etools.common.frameworks.internal.datamodel.DataObjectGenerator;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DataObjectGeneratorModel
extends WTPOperationDataModel {
    public static final String PROJECT = "DataObjectGeneratorModel.project";
    public static final String XSD_FILES = "DataObjectGeneratorModel.xsdFiles";
    public static final String ECORE_FILES = "DataObjectGeneratorModel.ecoreFiles";
    public static final String WSDL_FILES = "DataObjectGeneratorModel.wsdlFiles";
    public static final String JAVA_FILES = "DataObjectGeneratorModel.javaFiles";
    public static final String MODEL_DIR = "DataObjectGeneratorModel.modelDirectory";
    public static final String DYNAMIC_TEMPLATES = "DataObjectGeneratorModel.dynamicTemplates";
    public static final String FORCE_OVERWRITE = "DataObjectGeneratorModel.forceOverwrite";
    public static final String CAN_GENERATE = "DataObjectGeneratorModel.canGenerate";
    public static final String UPDATE_CLASSPATH = "DataObjectGeneratorModel.updateClasspath";
    public static final String GENERATE_SCHEMA = "DataObjectGeneratorModel.generateSchema";
    public static final String NON_NLS_MARKERS = "DataObjectGeneratorModel.nonNLSMarkers";

    @Override
    public WTPOperation getDefaultOperation() {
        return new DataObjectGenerator(this);
    }

    @Override
    protected void initValidBaseProperties() {
        this.addValidBaseProperty(PROJECT);
        this.addValidBaseProperty(XSD_FILES);
        this.addValidBaseProperty(ECORE_FILES);
        this.addValidBaseProperty(WSDL_FILES);
        this.addValidBaseProperty(JAVA_FILES);
        this.addValidBaseProperty(MODEL_DIR);
        this.addValidBaseProperty(DYNAMIC_TEMPLATES);
        this.addValidBaseProperty(FORCE_OVERWRITE);
        this.addValidBaseProperty(CAN_GENERATE);
        this.addValidBaseProperty(UPDATE_CLASSPATH);
        this.addValidBaseProperty(GENERATE_SCHEMA);
        this.addValidBaseProperty(NON_NLS_MARKERS);
    }

    @Override
    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(MODEL_DIR)) {
            return this.getDefaultModelDirectory();
        }
        if (propertyName.equals(FORCE_OVERWRITE) || propertyName.equals(CAN_GENERATE)) {
            return Boolean.TRUE;
        }
        if (propertyName.equals(XSD_FILES) || propertyName.equals(ECORE_FILES) || propertyName.equals(WSDL_FILES) || propertyName.equals(JAVA_FILES)) {
            return Collections.EMPTY_LIST;
        }
        return super.getDefaultProperty(propertyName);
    }

    protected Object getDefaultModelDirectory() {
        IProject project = (IProject)this.getProperty(PROJECT);
        if (project == null) {
            return null;
        }
        return project.getFolder((IPath)new Path("gen/src"));
    }

    private void addFile(String propertyName, IFile file) {
        if (file != null) {
            List<IFile> files;
            if (!this.isSet(propertyName)) {
                files = new ArrayList();
                this.setProperty(propertyName, files);
            } else {
                files = (List)this.getProperty(propertyName);
            }
            files.add(file);
        }
    }

    public void addXSDFile(IFile file) {
        this.addFile(XSD_FILES, file);
    }

    public void addEcoreFile(IFile file) {
        this.addFile(ECORE_FILES, file);
    }

    public void addWSDLFile(IFile file) {
        this.addFile(WSDL_FILES, file);
    }

    public void addJavaFile(IFile file) {
        this.addFile(JAVA_FILES, file);
    }
}

