/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.frameworks.internal.datamodel;

import com.ibm.etools.common.frameworks.FrameworksPlugin;
import com.ibm.etools.common.frameworks.internal.datamodel.DataObjectGeneratorModel;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.importer.java.JavaImporter;
import org.eclipse.emf.importer.java.JavaImporterPlugin;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;

public class DataObjectGenerator
extends WTPOperation {
    protected IProject project;
    protected List xmiPackages;
    protected List javaModels;
    protected XSDEcoreBuilder xsdECoreBuilder;
    protected List ePackages;

    public DataObjectGenerator(DataObjectGeneratorModel operationDataModel) {
        super(operationDataModel);
    }

    public static void setStaticPackageNsURI(EPackage ePackage, String fullyQualifiedPackageInterfaceName) {
        if (ePackage != null && fullyQualifiedPackageInterfaceName != null) {
            ePackage.setNsURI("java://" + fullyQualifiedPackageInterfaceName);
        }
    }

    protected IProject getProject() {
        if (this.project == null) {
            this.project = (IProject)this.operationDataModel.getProperty("DataObjectGeneratorModel.project");
        }
        return this.project;
    }

    protected XSDEcoreBuilder getXSDEcoreBuilder() {
        if (this.xsdECoreBuilder == null) {
            this.xsdECoreBuilder = new XSDEcoreBuilder();
        }
        return this.xsdECoreBuilder;
    }

    protected boolean prepareGenerate() {
        this.ePackages = new ArrayList();
        if (this.xsdECoreBuilder != null) {
            this.ePackages.addAll(this.xsdECoreBuilder.getTargetNamespaceToEPackageMap().values());
        }
        if (this.xmiPackages != null) {
            this.ePackages.addAll(this.xmiPackages);
        }
        if (this.javaModels != null) {
            this.prepareEPackagesFromJavaModels();
        }
        return !this.ePackages.isEmpty();
    }

    protected void prepareEPackagesFromJavaModels() {
        JavaImporter javaImporter = new JavaImporter();
        javaImporter.setGenModelFileName("sdo.genmodel");
        javaImporter.setGenModelContainerPath(this.getProject().getFullPath());
        Diagnostic localStatus = null;
        try {
            localStatus = javaImporter.computeEPackages((Monitor)new BasicMonitor());
        }
        catch (Exception e) {
            FrameworksPlugin.logError(e);
        }
        if (localStatus != null && localStatus.getSeverity() != 4) {
            List ePackages = javaImporter.getEPackages();
            this.processGenPackagesFromJavaModels(ePackages);
        } else {
            this.processGenPackages(localStatus);
            this.logProblems(localStatus);
        }
    }

    protected void processGenPackages(Diagnostic statusArg) {
        Diagnostic child;
        List children;
        if (statusArg != null && statusArg.getSeverity() == 4 && (children = statusArg.getChildren()).size() == 1 && this.isNoModelFoundError(child = (Diagnostic)statusArg.getChildren().get(0))) {
            this.processGenPackagesFromJavaModels(Collections.EMPTY_LIST);
        }
    }

    private boolean isNoModelFoundError(Diagnostic child) {
        return child.getSeverity() == 4 && child.getMessage().equals(JavaImporterPlugin.INSTANCE.getString("_UI_NoModelElementsInJava_message"));
    }

    private void logProblems(Diagnostic statusArg) {
        FrameworksPlugin.logError("Problems detected generating SDO objects.");
        this.log(statusArg);
    }

    private void log(Diagnostic statusArg) {
        this.doLog(statusArg);
        if (!statusArg.getChildren().isEmpty()) {
            List children = statusArg.getChildren();
            for (Diagnostic element : children) {
                this.log(element);
            }
        }
    }

    private void doLog(Diagnostic statusArg) {
        switch (statusArg.getSeverity()) {
            case 4: {
                FrameworksPlugin.logError(statusArg.getMessage());
                break;
            }
            case 2: {
                FrameworksPlugin.logWarning(statusArg.getMessage());
                break;
            }
            case 1: {
                FrameworksPlugin.logError(statusArg.getMessage());
            }
        }
    }

    protected void processGenPackagesFromJavaModels(List ePackages) {
        if (ePackages.isEmpty()) {
            return;
        }
        for (EPackage ePackage : ePackages) {
            this.updateEPackageFromJavaModel(ePackage);
            this.ePackages.add(ePackage);
        }
    }

    protected void updateEPackageFromJavaModel(EPackage ePackage) {
        this.setStaticPackageNsURI(ePackage);
        ePackage.setName(ePackage.getNsPrefix());
    }

    protected void setStaticPackageNsURI(EPackage ePackage) {
        StringBuffer b = new StringBuffer();
        b.append("java://");
        b.append(CodeGenUtil.safeName((String)ePackage.getNsPrefix()));
        b.append('.');
        b.append(CodeGenUtil.capName((String)ePackage.getName()));
        b.append("Package");
        ePackage.setNsURI(b.toString());
    }

    protected void generate(IProgressMonitor progressMonitor) throws CoreException {
        GenModel genModel = null;
        try {
            progressMonitor.beginTask(this.getProject().getFullPath().toString(), 100);
            genModel = GenModelFactory.eINSTANCE.createGenModel();
            this.initializeGenModel(genModel);
            this.setPackagesOnGenModel(genModel);
            IStatus localStatus = genModel.validate();
            if (!localStatus.isOK()) {
                throw new CoreException(localStatus);
            }
            this.doGenerate(progressMonitor, genModel);
            progressMonitor.worked(100);
        }
        finally {
            ResourceSet set;
            Resource res;
            if (genModel != null && (res = genModel.eResource()) != null && (set = res.getResourceSet()) != null) {
                set.getResources().remove((Object)res);
            }
            progressMonitor.done();
        }
    }

    protected void doGenerate(IProgressMonitor progressMonitor, GenModel genModel) {
        try {
            genModel.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 50));
        }
        catch (Throwable e) {
            FrameworksPlugin.logError(e);
        }
    }

    protected void setPackagesOnGenModel(GenModel genModel) {
        genModel.initialize((Collection)this.ePackages);
        for (GenPackage genPackage : genModel.getGenPackages()) {
            genPackage.setLoadInitialization(false);
            String prefix = genPackage.getInterfacePackageName();
            prefix = prefix.substring(prefix.lastIndexOf(46) + 1);
            prefix = prefix.length() > 1 ? String.valueOf(prefix.substring(0, 1).toUpperCase()) + prefix.substring(1) : prefix.toUpperCase();
            genPackage.setPrefix(prefix);
        }
    }

    protected void initializeGenModel(GenModel genModel) {
        this.setSDODefaults(genModel);
        genModel.setDynamicTemplates(this.operationDataModel.getBooleanProperty("DataObjectGeneratorModel.dynamicTemplates"));
        genModel.setForceOverwrite(this.operationDataModel.getBooleanProperty("DataObjectGeneratorModel.forceOverwrite"));
        genModel.setCanGenerate(this.operationDataModel.getBooleanProperty("DataObjectGeneratorModel.canGenerate"));
        genModel.setUpdateClasspath(this.operationDataModel.getBooleanProperty("DataObjectGeneratorModel.updateClasspath"));
        genModel.setGenerateSchema(this.operationDataModel.getBooleanProperty("DataObjectGeneratorModel.generateSchema"));
        genModel.setNonNLSMarkers(this.operationDataModel.getBooleanProperty("DataObjectGeneratorModel.nonNLSMarkers"));
        IFolder modelDir = (IFolder)this.operationDataModel.getProperty("DataObjectGeneratorModel.modelDirectory");
        genModel.setModelDirectory(modelDir.getFullPath().toOSString());
        ResourceSet resourceSet = WorkbenchResourceHelperBase.getResourceSet((IProject)modelDir.getProject());
        Resource resource = resourceSet.createResource(URI.createURI((String)genModel.toString()));
        resource.getContents().add((Object)genModel);
    }

    protected void setSDODefaults(GenModel genModel) {
        genModel.setRootExtendsInterface("");
        genModel.setRootImplementsInterface("org.eclipse.emf.ecore.sdo.InternalEDataObject");
        genModel.setRootExtendsClass("org.eclipse.emf.ecore.sdo.impl.EDataObjectImpl");
        genModel.setFeatureMapWrapperInterface("commonj.sdo.Sequence");
        genModel.setFeatureMapWrapperInternalInterface("org.eclipse.emf.ecore.sdo.util.ESequence");
        genModel.setFeatureMapWrapperClass("org.eclipse.emf.ecore.sdo.util.BasicESequence");
        genModel.setSuppressEMFTypes(true);
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.loadModelFiles(monitor);
        if (this.prepareGenerate()) {
            this.generate(monitor);
        }
    }

    protected void loadModelFiles(IProgressMonitor monitor) {
        this.loadXSDFiles(monitor);
        this.loadEcoreFiles(monitor);
        this.loadJavaFiles(monitor);
    }

    protected void loadXSDFiles(IProgressMonitor monitor) {
        if (this.operationDataModel.isSet("DataObjectGeneratorModel.xsdFiles")) {
            List files = (List)this.operationDataModel.getProperty("DataObjectGeneratorModel.xsdFiles");
            int i = 0;
            while (i < files.size()) {
                IFile file = (IFile)files.get(i);
                Resource resource = WorkbenchResourceHelperBase.load((IFile)file);
                Collection xsdSchemas = EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)XSDPackage.eINSTANCE.getXSDSchema());
                Iterator j = xsdSchemas.iterator();
                while (j.hasNext()) {
                    this.getXSDEcoreBuilder().generate((XSDSchema)j.next());
                }
                ++i;
            }
        }
    }

    protected void loadEcoreFiles(IProgressMonitor monitor) {
        if (this.operationDataModel.isSet("DataObjectGeneratorModel.ecoreFiles")) {
            List files = (List)this.operationDataModel.getProperty("DataObjectGeneratorModel.ecoreFiles");
            int i = 0;
            while (i < files.size()) {
                IFile file = (IFile)files.get(i);
                Resource resource = WorkbenchResourceHelperBase.getResource((IFile)file, (boolean)true);
                this.addXmiPackages((List)resource.getContents());
                ++i;
            }
        }
    }

    protected void addXmiPackages(List packages) {
        if (this.xmiPackages == null) {
            this.xmiPackages = new ArrayList();
        }
        this.xmiPackages.addAll(packages);
    }

    protected void loadWSDLFiles(IProgressMonitor monitor) {
    }

    protected void loadJavaFiles(IProgressMonitor monitor) {
        this.javaModels = (List)this.operationDataModel.getProperty("DataObjectGeneratorModel.javaFiles");
    }
}

