/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.properties;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.properties.SingleValueArgumentProperty;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;

public class SingleAnnotationArgumentProperty
extends SingleValueArgumentProperty {
    public static final String id_ = "com.ibm.etools.annotations.core.properties.SingleAnnotationArgumentProperty";

    public SingleAnnotationArgumentProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, AnnotationInfo parentAnno, IMemberValuePair pair) throws CoreException {
        super(propertyName, displayName, propertyDescription, AnnotationInfo.class, parentGroup, parentAnno, pair);
        this.assignID(id_);
    }

    public SingleAnnotationArgumentProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, AnnotationInfo parentAnno, IType resolvedType) throws CoreException {
        super(propertyName, displayName, propertyDescription, AnnotationInfo.class, parentGroup, parentAnno, resolvedType);
        this.assignID(id_);
    }

    public SingleAnnotationArgumentProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, AnnotationInfo parentAnno, Object value) throws CoreException {
        super(propertyName, displayName, propertyDescription, AnnotationInfo.class, parentGroup, parentAnno, value);
        this.assignID(id_);
    }

    public String getValueAsString() {
        if (this.value != null) {
            return new StringBuffer("@").append(((AnnotationInfo)((Object)this.value)).getName()).toString();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValueAsString(String newValue) throws CoreException {
        if (this.isEnabled() && newValue != null) {
            try {
                int pkgIndex;
                String value = newValue.trim();
                if (newValue.startsWith("@")) {
                    value = newValue.substring(1);
                }
                if ((pkgIndex = value.lastIndexOf(" - ")) != -1) {
                    String[] names = value.split(" - ", 2);
                    StringBuffer fullName = new StringBuffer(names[0]);
                    if (names.length > 1) {
                        fullName.insert(0, ".");
                        fullName.insert(0, names[1]);
                        value = fullName.toString();
                    }
                }
                JavaElementInfo jeInfo = InternalUtils.getParentJavaElementInfo4Attribute(this);
                IJavaElement je = null;
                if (jeInfo != null) {
                    je = jeInfo.getJavaElement();
                }
                if (je == null) return;
                IType type = InternalUtils.resoveJavaType(value, je.getJavaProject(), true);
                IAnnotation anno = type != null ? type.getAnnotation(value) : null;
                AnnotationInfo annoInfo = null;
                annoInfo = anno != null ? InternalUtils.createNestedAnnotationInfo(anno, this) : InternalUtils.createNestedAnnotationInfo(value, this);
                if (annoInfo == null) return;
                this.setValue((Object)annoInfo);
                return;
            }
            catch (Throwable e) {
                Status status = new Status(4, "com.ibm.adapter.j2c.codegen", 4, e.getLocalizedMessage() == null ? e.toString() : e.getLocalizedMessage(), e);
                throw new CoreException((IStatus)status);
            }
        } else {
            super.setValueAsString(newValue);
        }
    }

    public void setValue(Object newValue) throws CoreException {
        AnnotationInfo annoInfo = (AnnotationInfo)((Object)this.value);
        super.setValue(newValue);
        if (annoInfo != null) {
            annoInfo.setParentElementInfo(null);
        }
        if (newValue != null) {
            ((AnnotationInfo)((Object)newValue)).setParentElementInfo(this);
        }
    }

    @Override
    public String toCUString() {
        String res = this.getValueAsString();
        if (this.value != null && res != null && res.length() > 0) {
            AnnotationInfo annoInfo = (AnnotationInfo)((Object)this.value);
            return annoInfo.annotToString();
        }
        return super.toCUString();
    }
}

