/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal.utils;

import com.ibm.etools.annotations.core.AnnotationsCoreConstants;
import com.ibm.etools.annotations.core.api.AnnotationCustomization;
import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.annotations.core.internal.AnnotationParser;
import com.ibm.etools.annotations.core.internal.registry.AnnotationCustomizationInfo;
import com.ibm.etools.annotations.core.internal.registry.AnnotationExtensionPointRegistry;
import com.ibm.etools.annotations.core.internal.search.JavaSearchUtils;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.SingleValueArgumentProperty;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.propertygroup.IPropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class InternalUtils {
    public static String[] getTriggerAnnotationsFromExtensionPoint() {
        ArrayList<String> resList = new ArrayList<String>();
        IConfigurationElement[] annoConfigExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.j2c.codegen.TriggerAnnotations");
        int i = 0;
        while (i < annoConfigExtensionPoints.length) {
            IConfigurationElement confEl = annoConfigExtensionPoints[i];
            String sName = confEl.getAttribute("name");
            String sPack = confEl.getAttribute("package");
            if (sPack != null && sPack.length() > 0) {
                sName = String.valueOf(sPack) + "." + sName;
            }
            resList.add(sName);
            ++i;
        }
        String[] resA = new String[resList.size()];
        resA = resList.toArray(resA);
        return resA;
    }

    public static String getUniqueNameForJavaElement(IJavaElement jEl) {
        int type = jEl.getElementType();
        if (type == 5) {
            return InternalUtils.getFullUniqueNameForCU(jEl);
        }
        if (jEl instanceof IMember) {
            IMember meth = (IMember)jEl;
            String res = meth.getElementName();
            if (res.length() == 0) {
                res = InternalUtils.getJavaElementName(jEl);
            }
            try {
                StringBuffer sb = new StringBuffer(res);
                sb.append(meth.getFlags()).toString();
                if (type == 9) {
                    sb.append(((IMethod)meth).getSignature()).toString();
                }
                res = sb.toString();
            }
            catch (Exception exception) {}
            return res;
        }
        return jEl.getElementName();
    }

    public static String getJavaElementName(IJavaElement je) {
        String name = je.getElementName();
        if (name != null && name.length() > 0) {
            return name;
        }
        if (name != null && je.getElementType() == 7) {
            try {
                if (je.getParent() instanceof IField && ((IType)je).isEnum()) {
                    name = "{...}";
                } else {
                    String[] superInterfaceSignatures = ((IType)je).getSuperInterfaceTypeSignatures();
                    name = superInterfaceSignatures.length > 0 ? Signature.getSimpleName((String)Signature.toString((String)superInterfaceSignatures[0])) : Signature.getSimpleName((String)Signature.toString((String)((IType)je).getSuperclassTypeSignature()));
                    if (name != null) {
                        name = new StringBuffer("new ").append(name).append("() {...}").toString();
                    }
                }
            }
            catch (Exception exception) {}
        }
        return name;
    }

    public static String getFullUniqueNameForCU(IJavaElement icu) {
        String sNa = icu.getElementName();
        IPackageFragment parent = (IPackageFragment)icu.getParent();
        String packageName = parent.getElementName();
        IJavaProject jPr = parent.getJavaProject();
        String projName = jPr.getElementName();
        return new StringBuffer(projName).append(".").append(packageName).append(".").append(sNa).toString();
    }

    public static IJavaElement getJavaElementForAnnotation(IAnnotation ann) {
        try {
            return ann.getParent();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getTypeName(Type type) {
        String res = null;
        if (type.isSimpleType()) {
            res = ((SimpleType)type).getName().toString();
        } else if (type.isPrimitiveType()) {
            res = ((PrimitiveType)type).getPrimitiveTypeCode().toString();
        } else if (type.isQualifiedType()) {
            res = ((QualifiedType)type).getName().toString();
        } else if (type.isArrayType()) {
            Type elType = ((ArrayType)type).getElementType();
            res = InternalUtils.getTypeName(elType);
        }
        return res;
    }

    public static IType resoveJavaType(String name, IJavaProject pr, boolean isAnnotation) {
        return JavaSearchUtils.getInstance().findTypeDeclaration(name, pr, isAnnotation, null);
    }

    public static IType getPrimaryType(IJavaElement javaEl) {
        IType res = null;
        if (javaEl == null) {
            return null;
        }
        if (javaEl instanceof IType) {
            return (IType)javaEl;
        }
        if (javaEl instanceof IPackageDeclaration) {
            IPackageDeclaration packDec = (IPackageDeclaration)javaEl;
            IJavaElement par = packDec.getParent();
            if (par instanceof IClassFile) {
                return ((IClassFile)par).findPrimaryType();
            }
            if (par instanceof ICompilationUnit) {
                return ((ICompilationUnit)par).findPrimaryType();
            }
        } else {
            if (javaEl instanceof ICompilationUnit || javaEl instanceof IClassFile) {
                return null;
            }
            return InternalUtils.getPrimaryType(javaEl.getParent());
        }
        return res;
    }

    public static IJavaElement getCUorClassFile(IJavaElement javaEl) {
        if (javaEl == null) {
            return null;
        }
        if (javaEl instanceof ICompilationUnit || javaEl instanceof IClassFile) {
            return javaEl;
        }
        return InternalUtils.getCUorClassFile(javaEl.getParent());
    }

    public static IJavaProject getParentJavaProject(IJavaElement javaEl) {
        if (javaEl == null) {
            return null;
        }
        if (javaEl instanceof IJavaProject) {
            return (IJavaProject)javaEl;
        }
        return InternalUtils.getParentJavaProject(javaEl.getParent());
    }

    public static AnnotationInfo getAnnotationInfo(AnnotatedClassInfo classInfo, IAnnotation annotation) {
        if (annotation == null) {
            return null;
        }
        List<AnnotationInfo> infos = AnnotationUtils.getAnnotationInfosForJavaElementInfo(classInfo, false);
        if (infos != null) {
            int i = 0;
            while (i < infos.size()) {
                AnnotationInfo info = infos.get(i);
                IAnnotation iAnn = info.getAnnotation();
                if (iAnn != null && iAnn.equals(annotation)) {
                    return info;
                }
                ++i;
            }
        }
        return null;
    }

    public static List<IJavaElement> getIJavaElementHierachy(IJavaElement el) {
        ArrayList<IJavaElement> res = new ArrayList<IJavaElement>();
        if (el == null) {
            return res;
        }
        res.add(0, el);
        if (el instanceof ICompilationUnit || el instanceof IClassFile) {
            return res;
        }
        res.addAll(0, InternalUtils.getIJavaElementHierachy(el.getParent()));
        return res;
    }

    public static List<String> getIJavaElementFullNamesHierachy(IJavaElement el) {
        ArrayList<String> res = new ArrayList<String>();
        if (el == null) {
            return res;
        }
        String sT = el.getElementName();
        if (sT != null && sT.length() > 0) {
            res.add(el.getElementName());
        }
        res.addAll(0, InternalUtils.getIJavaElementFullNamesHierachy(el.getParent()));
        return res;
    }

    public static List<IJavaElement> getIJavaElementFullHierachy(IJavaElement el) {
        ArrayList<IJavaElement> res = new ArrayList<IJavaElement>();
        if (el == null) {
            return res;
        }
        String sT = el.getElementName();
        if (sT != null && sT.length() > 0) {
            res.add(el);
        }
        res.addAll(0, InternalUtils.getIJavaElementFullHierachy(el.getParent()));
        return res;
    }

    public static JavaElementInfo createJavaElementsHierachy(JavaElementInfo jeInf, List list) {
        IPropertyDescriptor[] childs = jeInf.getJavaElementInfoPG().getProperties();
        JavaElementInfo foundElement = null;
        int m = 0;
        while (m < childs.length) {
            JavaElementInfo elInf;
            IJavaElement el;
            IPropertyDescriptor prop = childs[m];
            if (prop instanceof JavaElementInfo && (el = (IJavaElement)list.get(0)).equals((elInf = (JavaElementInfo)prop).getJavaElement())) {
                foundElement = elInf;
                break;
            }
            ++m;
        }
        if (foundElement != null) {
            if (list.size() == 1) {
                return foundElement;
            }
            list.remove(0);
            return InternalUtils.createJavaElementsHierachy(foundElement, list);
        }
        IJavaElement el = (IJavaElement)list.get(0);
        try {
            foundElement = new JavaElementInfo(el, jeInf.getJavaElementInfoPG());
            jeInf.getJavaElementInfoPG().addProperty((IPropertyDescriptor)foundElement);
            foundElement.setParentJavaElementInfo(jeInf);
        }
        catch (Exception exception) {}
        if (foundElement != null) {
            if (list.size() == 1) {
                return foundElement;
            }
            list.remove(0);
            return InternalUtils.createJavaElementsHierachy(foundElement, list);
        }
        return null;
    }

    public static List<IJavaElementDelta> getLeafDeltas(IJavaElementDelta delta) {
        if (delta == null) {
            return new ArrayList<IJavaElementDelta>(0);
        }
        if (delta.getAffectedChildren().length == 0) {
            ArrayList<IJavaElementDelta> resList = new ArrayList<IJavaElementDelta>(1);
            resList.add(delta);
            return resList;
        }
        ArrayList<IJavaElementDelta> resList = new ArrayList<IJavaElementDelta>();
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta delt = iJavaElementDeltaArray[n2];
            if (delt.getAffectedChildren().length > 0) {
                resList.addAll(InternalUtils.getLeafDeltas(delt));
            } else {
                resList.add(delt);
            }
            ++n2;
        }
        return resList;
    }

    public static void addAnnotationToCU(ICompilationUnit cu, String sAnnPackName, String sAnnotationRep, IJavaElement el, boolean commit) {
        if (cu == null || sAnnPackName == null || sAnnotationRep == null || el == null) {
            return;
        }
        if (!sAnnotationRep.startsWith("@")) {
            return;
        }
        String annoName = sAnnotationRep.trim();
        int indx = annoName.indexOf("(");
        annoName = indx > 0 ? annoName.substring(1, indx) : annoName.substring(1, annoName.length());
        InternalUtils.addAnnotationToCU(cu, annoName, sAnnPackName, sAnnotationRep, el, commit, false);
    }

    @Deprecated
    public static void addAnnotationToCU(ICompilationUnit cu, String sAnnPackName, String sAnnotationRep, IJavaElement el, boolean commit, boolean performReconcile) {
        if (cu == null || sAnnPackName == null || sAnnotationRep == null || el == null) {
            return;
        }
        if (!sAnnotationRep.startsWith("@")) {
            return;
        }
        String annoName = sAnnotationRep.trim();
        int indx = annoName.indexOf("(");
        annoName = indx > 0 ? annoName.substring(1, indx) : annoName.substring(1, annoName.length());
        InternalUtils.addAnnotationToCU(cu, annoName, sAnnPackName, sAnnotationRep, el, commit, performReconcile);
    }

    public static void addAnnotationToCU(ICompilationUnit cu, String annoName, String sAnnPackName, String sAnnotationRep, IJavaElement el, boolean commit, boolean performReconcile) {
        if (cu == null || sAnnPackName == null || sAnnotationRep == null || el == null || annoName == null) {
            return;
        }
        if (!sAnnotationRep.startsWith("@")) {
            return;
        }
        try {
            if (!cu.isWorkingCopy()) {
                cu = cu.getWorkingCopy(null);
            }
            Document doc = new Document(cu.getSource());
            if (el instanceof ISourceReference && ((ISourceReference)el).getSourceRange() != null) {
                int iStart = ((ISourceReference)el).getSourceRange().getOffset();
                int iLine = doc.getLineOfOffset(iStart);
                int iOffOfLine = doc.getLineOffset(iLine);
                String sDiff = doc.get(iOffOfLine, iStart - iOffOfLine);
                String del = doc.getDefaultLineDelimiter();
                if (del == null || del.isEmpty()) {
                    String[] dels;
                    int i = doc.getNumberOfLines() - 1;
                    while (i >= 0) {
                        try {
                            String curr = doc.getLineDelimiter(i);
                            if (curr != null) {
                                del = curr;
                                break;
                            }
                        }
                        catch (Exception exception) {}
                        --i;
                    }
                    if (del == null && (dels = doc.getLegalLineDelimiters()) != null && dels.length > 0) {
                        del = dels[dels.length - 1];
                    }
                }
                if (del != null) {
                    if (el instanceof ILocalVariable) {
                        doc.replace(iStart, 0, new StringBuffer(String.valueOf(sAnnotationRep) + " ").toString());
                    } else {
                        doc.replace(iOffOfLine, 0, new StringBuffer(sDiff).append(sAnnotationRep).append(del).toString());
                    }
                    cu.getBuffer().setContents(doc.get());
                }
            }
            ASTParser parser = null;
            parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(true);
            parser.setSource(cu);
            CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
            if (astCU == null) {
                return;
            }
            List imports = astCU.imports();
            String packName = sAnnPackName;
            String annRep = annoName.trim();
            String sFullName = new StringBuffer(packName).append(".").append(annRep).toString();
            String packAll = new StringBuffer(packName).append(".*").toString();
            boolean bImportFound = false;
            int b = 0;
            while (b < imports.size()) {
                ImportDeclaration impDec = (ImportDeclaration)imports.get(b);
                String sIN = impDec.getName().toString();
                if (sIN.equals(sFullName) || sIN.equals(packAll)) {
                    bImportFound = true;
                    break;
                }
                ++b;
            }
            if (!bImportFound) {
                ImportDeclaration imD = astCU.getAST().newImportDeclaration();
                Name nFullName = astCU.getAST().newName(sFullName);
                imD.setName(nFullName);
                ASTRewrite rewrite1 = ASTRewrite.create((AST)astCU.getAST());
                ListRewrite lrw1 = rewrite1.getListRewrite((ASTNode)astCU, CompilationUnit.IMPORTS_PROPERTY);
                lrw1.insertLast((ASTNode)imD, null);
                TextEdit edits1 = rewrite1.rewriteAST((IDocument)doc, null);
                edits1.apply((IDocument)doc);
                cu.getBuffer().setContents(doc.get());
            }
            if (commit) {
                cu.commitWorkingCopy(true, null);
            } else if (performReconcile) {
                cu.reconcile(3, 7, null, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addAnnotationToCUafterJavaDoc(ICompilationUnit cu, String sAnnPackName, String sAnnotationRep, IJavaElement el, boolean commit) {
        if (cu == null || sAnnPackName == null || sAnnotationRep == null || el == null) {
            return;
        }
        if (!sAnnotationRep.startsWith("@")) {
            return;
        }
        try {
            if (!cu.isWorkingCopy()) {
                cu = cu.getWorkingCopy(null);
            }
            Document doc = new Document(cu.getSource());
            if (el instanceof ISourceReference && ((ISourceReference)el).getSourceRange() != null) {
                int iStart = ((ISourceReference)el).getSourceRange().getOffset();
                int iModifierStart = ((ISourceReference)el).getSource().indexOf("public");
                int iLine2 = doc.getLineOfOffset(iStart + iModifierStart);
                int iOffOfLine2 = doc.getLineOffset(iLine2);
                String del = null;
                String[] dels = doc.getLegalLineDelimiters();
                if (dels != null && dels.length > 0) {
                    del = dels[0];
                } else {
                    int i = doc.getNumberOfLines() - 1;
                    while (i >= 0) {
                        try {
                            String curr = doc.getLineDelimiter(i);
                            if (curr != null) {
                                del = curr;
                                break;
                            }
                        }
                        catch (Exception exception) {}
                        --i;
                    }
                }
                if (del != null) {
                    String sToInsert = String.valueOf(sAnnotationRep) + del;
                    doc.replace(iOffOfLine2, 0, sToInsert);
                    cu.getBuffer().setContents(doc.get());
                }
            }
            ASTParser parser = null;
            parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(true);
            parser.setSource(cu);
            CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
            if (astCU == null) {
                return;
            }
            List imports = astCU.imports();
            String packName = sAnnPackName;
            String annRep = sAnnotationRep.trim();
            annRep = annRep.substring(1, annRep.length());
            int indx = annRep.indexOf("(");
            String sFullName = String.valueOf(packName) + "." + annRep;
            if (indx > 0) {
                sFullName = String.valueOf(packName) + "." + annRep.substring(0, indx);
            }
            boolean bImportFound = false;
            int b = 0;
            while (b < imports.size()) {
                ImportDeclaration impDec = (ImportDeclaration)imports.get(b);
                String sIN = impDec.getName().toString();
                if (sIN.equals(sFullName) || sIN.equals(String.valueOf(packName) + ".*")) {
                    bImportFound = true;
                    break;
                }
                ++b;
            }
            if (!bImportFound) {
                ImportDeclaration imD = astCU.getAST().newImportDeclaration();
                Name nFullName = astCU.getAST().newName(sFullName);
                imD.setName(nFullName);
                ASTRewrite rewrite1 = ASTRewrite.create((AST)astCU.getAST());
                ListRewrite lrw1 = rewrite1.getListRewrite((ASTNode)astCU, CompilationUnit.IMPORTS_PROPERTY);
                lrw1.insertLast((ASTNode)imD, null);
                TextEdit edits1 = rewrite1.rewriteAST((IDocument)doc, null);
                edits1.apply((IDocument)doc);
                cu.getBuffer().setContents(doc.get());
            }
            if (commit) {
                cu.commitWorkingCopy(true, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addImportStatement(ICompilationUnit cu, AnnotationInfo inf) {
        try {
            String sName = inf.getName();
            if (sName == null) {
                return;
            }
            String sPack = inf.getPackageName();
            if (sPack == null) {
                IType defType = null;
                IType[] defTypes = cu.getTypes();
                if (defTypes.length > 0) {
                    defType = defTypes[0];
                }
                if (defType != null) {
                    int ind = sName.lastIndexOf(".");
                    if (ind < 0) {
                        String[][] typeNames = defType.resolveType(sName);
                        if (typeNames != null && typeNames.length > 0) {
                            sPack = typeNames[0][0];
                        }
                    } else {
                        sPack = sName.substring(0, ind);
                    }
                }
            }
            if (sPack != null) {
                InternalUtils.addImportStatement(cu, sPack, sName, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addImportStatement(ICompilationUnit cu, String sAnnPackName, String sAnnotShortName, boolean commit) {
        try {
            ASTParser parser = null;
            parser = ASTParser.newParser((int)3);
            parser.setSource(cu);
            CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
            if (astCU == null) {
                return;
            }
            List imports = astCU.imports();
            String packName = sAnnPackName;
            String sFullName = String.valueOf(packName) + "." + sAnnotShortName;
            boolean bImportFound = false;
            int b = 0;
            while (b < imports.size()) {
                ImportDeclaration impDec = (ImportDeclaration)imports.get(b);
                String sIN = impDec.getName().toString();
                if (sIN.equals(sFullName) || sIN.equals(String.valueOf(packName) + ".*")) {
                    bImportFound = true;
                    break;
                }
                ++b;
            }
            if (!bImportFound) {
                ImportDeclaration imD = astCU.getAST().newImportDeclaration();
                Name nFullName = astCU.getAST().newName(sFullName);
                imD.setName(nFullName);
                ASTRewrite rewrite1 = ASTRewrite.create((AST)astCU.getAST());
                ListRewrite lrw1 = rewrite1.getListRewrite((ASTNode)astCU, CompilationUnit.IMPORTS_PROPERTY);
                lrw1.insertLast((ASTNode)imD, null);
                Document doc = new Document(cu.getSource());
                TextEdit edits1 = rewrite1.rewriteAST((IDocument)doc, null);
                edits1.apply((IDocument)doc);
                cu.getBuffer().setContents(doc.get());
            }
            if (commit) {
                cu.commitWorkingCopy(true, null);
            }
        }
        catch (Exception exception) {}
    }

    public static void applyExternalCustomization(AnnotationInfo aInfo) {
        AnnotationCustomizationInfo acInfo;
        String pkgName = aInfo.getPackageName();
        String tagName = aInfo.getName();
        if (pkgName != null && tagName != null && (acInfo = AnnotationExtensionPointRegistry.instance().getAnnotationCustomizationInfo(pkgName, tagName)) != null) {
            try {
                List<IAnnotationAttributeProperty> attributes;
                AnnotationCustomization ac = null;
                Object ee = acInfo.getExecutableExtension();
                if (ee != null && ee instanceof AnnotationCustomization) {
                    ac = (AnnotationCustomization)ee;
                    ac.updateAnnotationState(aInfo);
                }
                if (ac != null && acInfo.listenToAttributeChange() && (attributes = aInfo.getAllAttributes()) != null && !attributes.isEmpty()) {
                    int i = 0;
                    while (i < attributes.size()) {
                        attributes.get(i).addPropertyChangeListener(ac);
                        ++i;
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public static AnnotationInfo createNestedAnnotationInfo(Object para, IAnnotationAttributeProperty parentInfo) throws Exception {
        AnnotationInfo annoInfo = null;
        if (para != null) {
            if (para instanceof IAnnotation) {
                IAnnotation annotation = (IAnnotation)para;
                annoInfo = AnnotationParser.getAnnotationInfo(annotation, 0);
            } else if (para instanceof String) {
                annoInfo = new AnnotationInfo((String)para, 0, null);
            }
            if (annoInfo != null) {
                annoInfo.setParentElementInfo(parentInfo);
                InternalUtils.applyExternalCustomization(annoInfo);
            }
        }
        return annoInfo;
    }

    public static JavaElementInfo getParentJavaElementInfo4Attribute(IAnnotationAttributeProperty aap) {
        AnnotationInfo annoInfo = aap.getParentAnnotation();
        if (annoInfo != null) {
            JavaElementInfo jeInfo = annoInfo.getParentJavaElementInfo();
            if (jeInfo != null) {
                return jeInfo;
            }
            Object parentInfo = annoInfo.getParentElementInfo();
            if (parentInfo != null && parentInfo instanceof IAnnotationAttributeProperty) {
                return InternalUtils.getParentJavaElementInfo4Attribute((IAnnotationAttributeProperty)parentInfo);
            }
        }
        return null;
    }

    public static JavaElementInfo getParentJavaElementInfo4Annotation(AnnotationInfo annoInfo) {
        JavaElementInfo jeInfo = annoInfo.getParentJavaElementInfo();
        if (jeInfo != null) {
            return jeInfo;
        }
        Object parentInfo = annoInfo.getParentElementInfo();
        if (parentInfo != null && parentInfo instanceof IAnnotationAttributeProperty) {
            return InternalUtils.getParentJavaElementInfo4Attribute((IAnnotationAttributeProperty)parentInfo);
        }
        return null;
    }

    public static List<IAnnotation> getIAnnotationsForSpecificProject(List<IAnnotation> annList, String projectName) {
        ArrayList<IAnnotation> resList = new ArrayList<IAnnotation>();
        int i = 0;
        while (i < annList.size()) {
            IAnnotation ann = annList.get(i);
            IJavaProject jp = InternalUtils.getParentJavaProject((IJavaElement)ann);
            if (jp != null && jp.getElementName().equals(projectName)) {
                resList.add(ann);
            }
            ++i;
        }
        return resList;
    }

    public static IAnnotationAttributeProperty getIncompleteAttribute(AnnotationInfo annInfo) {
        IAnnotation ann = annInfo.getAnnotation();
        if (ann != null) {
            try {
                IAnnotationAttributeProperty attribute;
                IMemberValuePair[] members = ann.getMemberValuePairs();
                if (members != null && members.length > 0 && members[members.length - 1].getValueKind() == 14 && (attribute = annInfo.getAttribute(members[members.length - 1].getMemberName())) != null && attribute instanceof SingleValueArgumentProperty && "com.ibm.etools.annotations.ui.javaClassProperty".equals(attribute.getID())) {
                    return attribute;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static String trimDot(String str) {
        int last;
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] value = str.toCharArray();
        int start = 0;
        int end = last = str.length() - 1;
        while (start <= end && value[start] <= '.') {
            ++start;
        }
        while (end >= start && value[end] <= '.') {
            --end;
        }
        if (start == 0 && end == last) {
            return str;
        }
        return new String(value, start, end - start + 1);
    }

    public static String escapeCharacters(String str) {
        if (str == null || str.length() < 1) {
            return str;
        }
        StringBuffer newStr = null;
        int size = str.length();
        boolean skipping = false;
        int i = 0;
        while (i < size) {
            char c = str.charAt(i);
            boolean process = false;
            if (!skipping) {
                switch (c) {
                    case '\\': {
                        if (i != size - 1) {
                            char nextC = str.charAt(i + 1);
                            if (nextC != 'n' && nextC != 'r' && nextC != 't' && nextC != 'b' && nextC != 'f' && nextC != '\\' && nextC != '\"') {
                                process = true;
                                break;
                            }
                            skipping = true;
                            break;
                        }
                        process = true;
                        break;
                    }
                    case '\"': {
                        process = true;
                    }
                }
            } else {
                skipping = false;
            }
            if (process) {
                if (newStr == null) {
                    newStr = new StringBuffer(str.substring(0, i));
                }
                newStr.append('\\').append(c);
            } else if (newStr != null) {
                newStr.append(c);
            }
            ++i;
        }
        return newStr == null ? str : newStr.toString();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static boolean isValidJARFile(IPackageFragmentRoot ipfr) {
        if (!ipfr.isArchive() || !AnnotationsCoreConstants.stopSCanningContainers_ && AnnotationsCoreConstants.excludedContainers_ == null) {
            return true;
        }
        jp = ipfr.getJavaProject();
        container = null;
        try {
            var7_4 /* !! */  = entries = jp.getRawClasspath();
            var6_5 = entries.length;
            var5_6 = 0;
            while (var5_6 < var6_5) {
                ice = var7_4 /* !! */ [var5_6];
                if (ice.getEntryKind() == 5) {
                    sPath = ice.getPath().toOSString();
                    if (sPath.indexOf("org.eclipse.jst.server.core.container") < 0 && sPath.indexOf("JRE_CONTAINER") < 0) {
                        var13_13 = roots = jp.findPackageFragmentRoots(ice);
                        var12_12 = roots.length;
                        var11_11 = 0;
                        while (var11_11 < var12_12) {
                            root = var13_13[var11_11];
                            if (ipfr.equals(root)) {
                                container = ice;
                                ** break;
                            }
                            ++var11_11;
                        }
                    }
                } else if (container != null) break;
                ++var5_6;
            }
        }
        catch (Exception v0) {}
        if (container == null) {
            return true;
        }
        if (AnnotationsCoreConstants.stopSCanningContainers_) {
            return false;
        }
        if (AnnotationsCoreConstants.excludedContainers_ != null) {
            sPath = container.getPath().toOSString();
            var7_4 /* !! */  = AnnotationsCoreConstants.excludedContainers_;
            var6_5 = AnnotationsCoreConstants.excludedContainers_.length;
            var5_6 = 0;
            while (var5_6 < var6_5) {
                excludedContainer = var7_4 /* !! */ [var5_6];
                if (sPath.indexOf((String)excludedContainer) != -1) {
                    return false;
                }
                ++var5_6;
            }
        }
        return true;
    }

    public static boolean isPackageInfoJava(IJavaElement el) {
        IResource res;
        boolean isPackageInfoJava = false;
        if (el != null && el instanceof IPackageDeclaration && (res = el.getResource()) != null && res.getName().equals("package-info.java")) {
            isPackageInfoJava = true;
        }
        return isPackageInfoJava;
    }
}

