/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal.search;

import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeReferenceMatch;

public class SearchAllAnnotationedClassesRequestor2
extends SearchRequestor {
    private Hashtable<IJavaElement, ArrayList> resList = new Hashtable();
    private String shortName;
    private String fullName;

    protected SearchAllAnnotationedClassesRequestor2(String fullName, String shortName) {
        this.shortName = shortName;
        this.fullName = fullName;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        TypeReferenceMatch refM = (TypeReferenceMatch)match;
        IJavaElement localEl = refM.getLocalElement();
        if (localEl != null) {
            this.handleResult(localEl);
        } else {
            localEl = (IJavaElement)refM.getElement();
            if (localEl != null) {
                this.handleResult(localEl);
            }
        }
    }

    public Hashtable<IJavaElement, ArrayList> getResults() {
        return this.resList;
    }

    private void handleResult(IJavaElement localEl) {
        if (localEl instanceof IAnnotation) {
            IAnnotation anno = (IAnnotation)localEl;
            localEl = anno.getParent();
        }
        if (localEl instanceof IAnnotatable) {
            IJavaElement resEl = InternalUtils.getCUorClassFile(localEl);
            try {
                if (resEl != null) {
                    IAnnotation[] anns = ((IAnnotatable)localEl).getAnnotations();
                    int v = 0;
                    while (v < anns.length) {
                        String annName = anns[v].getElementName();
                        if (annName.equals(this.fullName) || annName.equals(this.shortName)) {
                            ArrayList<IAnnotation> ll = this.resList.get(resEl);
                            if (ll == null) {
                                ll = new ArrayList<IAnnotation>();
                                this.resList.put(resEl, ll);
                            }
                            ll.add(anns[v]);
                        }
                        ++v;
                    }
                }
            }
            catch (Exception exception) {}
        }
    }
}

