/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal.search;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.etools.annotations.core.AnnotationsCoreConstants;
import com.ibm.etools.annotations.core.internal.search.SearchAllAnnotatedClassesForAnnotationsRequestor2;
import com.ibm.etools.annotations.core.internal.search.SearchAllAnnotationedClassesRequestor;
import com.ibm.etools.annotations.core.internal.search.SearchAllAnnotationedClassesRequestor2;
import com.ibm.etools.annotations.core.internal.search.SearchAllAnnotationsInstancesRequestor;
import com.ibm.etools.annotations.core.internal.search.SearchUtilRequestor;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.utils.ResourceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.JavaProject;

public class JavaSearchUtils {
    private SearchEngine searchEngine;
    private static JavaSearchUtils instance;

    private JavaSearchUtils() {
    }

    public static JavaSearchUtils getInstance() {
        if (instance == null) {
            instance = new JavaSearchUtils();
        }
        return instance;
    }

    @Deprecated
    public IType findTypeDeclaration(String typeName, IJavaElement el) {
        return this.findTypeDeclaration(typeName, el, null);
    }

    public IType findTypeDeclaration(String typeName, IJavaElement el, IProgressMonitor monitor) {
        if (typeName == null || el == null) {
            return null;
        }
        if (typeName.indexOf(46) > 0) {
            return this.findTypeDeclaration(typeName, el.getJavaProject(), false, monitor);
        }
        String[] typeNames = this.resolveJavaElementName(typeName, el, null);
        if (typeNames != null && typeNames[0] != null && typeNames[1] != null) {
            return this.findTypeDeclaration(new StringBuffer(typeNames[0]).append(".").append(typeNames[1]).toString(), el.getJavaProject(), false, monitor);
        }
        return null;
    }

    public String[] resolveJavaElementName(String typeName, IJavaElement el) {
        return this.resolveJavaElementName(typeName, el, null);
    }

    private String[] getResolvedTypes(IType type, String typeName) throws JavaModelException {
        String[][] typeNames;
        String[] res = new String[2];
        if (type != null && (typeNames = type.resolveType(typeName)) != null && typeNames.length > 0) {
            res[0] = typeNames[0][0];
            res[1] = typeNames[0][1];
        }
        return res;
    }

    private String[] resolveFromImports(String typeName, IType primType, IJavaElement el, Hashtable<String, List<String>> preDefinedTypes) throws JavaModelException {
        IImportDeclaration[] iids;
        String[] res = new String[2];
        ICompilationUnit icu = null;
        if (primType != null) {
            icu = primType.getCompilationUnit();
        } else if (InternalUtils.isPackageInfoJava(el)) {
            icu = (ICompilationUnit)el.getParent();
        }
        if (icu != null && (iids = icu.getImports()) != null) {
            IImportDeclaration[] iImportDeclarationArray = iids;
            int n = iids.length;
            int n2 = 0;
            while (n2 < n) {
                String tName;
                int index;
                IImportDeclaration iid = iImportDeclarationArray[n2];
                String name = iid.getElementName();
                if (name.endsWith(typeName) && (index = name.lastIndexOf(46)) > -1 && index < name.length() && (tName = name.substring(index + 1, name.length())).equals(typeName)) {
                    res[0] = name.substring(0, index);
                    res[1] = tName;
                    break;
                }
                ++n2;
            }
        }
        if (res[0] == null || res[1] == null) {
            String packageName = null;
            IJavaProject jProj = el.getJavaProject();
            if (primType != null) {
                packageName = primType.getPackageFragment().getElementName();
            } else if (InternalUtils.isPackageInfoJava(el)) {
                packageName = el.getElementName();
            }
            if (packageName != null) {
                StringBuffer fullName = new StringBuffer(packageName);
                fullName.append(".").append(typeName);
                if (jProj.findType(fullName.toString()) != null) {
                    res[0] = packageName;
                    res[1] = typeName;
                }
            }
        }
        if ((res[0] == null || res[1] == null) && preDefinedTypes != null) {
            Enumeration<String> e1 = preDefinedTypes.keys();
            while (e1.hasMoreElements()) {
                String key = e1.nextElement();
                List<String> types = preDefinedTypes.get(key);
                if (types == null || !types.contains(typeName)) continue;
                res[0] = key;
                res[1] = typeName;
                break;
            }
        }
        return res;
    }

    public String[] resolveJavaElementName(String typeName, IJavaElement el, Hashtable<String, List<String>> preDefinedTypes) {
        if (typeName == null || el == null) {
            return null;
        }
        String[] res = new String[2];
        try {
            IType primType = InternalUtils.getPrimaryType(el);
            IJavaProject jProj = el.getJavaProject();
            IProject proj = jProj.getProject();
            if (JavaProject.hasJavaNature((IProject)proj) && proj.exists() && proj.isAccessible()) {
                int idx = typeName.lastIndexOf(46);
                if (idx > 0 && idx < typeName.length() && jProj.findType(typeName) != null) {
                    res[0] = typeName.substring(0, idx);
                    res[1] = typeName.substring(idx + 1, typeName.length());
                } else {
                    res = this.resolveFromImports(typeName, primType, el, preDefinedTypes);
                }
                if (res[0] == null || res[1] == null) {
                    if (primType != null) {
                        res = this.getResolvedTypes(primType, typeName);
                    } else if (InternalUtils.isPackageInfoJava(el)) {
                        IType resolvedType = InternalUtils.resoveJavaType(typeName, jProj, true);
                        res = this.getResolvedTypes(resolvedType, typeName);
                    }
                }
            } else {
                CodegenPlugin.log("Project " + jProj.getProject().getName() + "does not have a Java Nature or is inaccessible");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res[0] != null && res[1] != null ? res : null;
    }

    @Deprecated
    public IType findTypeDeclaration(String typeName, IJavaProject pr, boolean isAnnotation) {
        return this.findTypeDeclaration(typeName, pr, isAnnotation, null);
    }

    public IType findTypeDeclaration(String typeName, IJavaProject pr, boolean isAnnotation, IProgressMonitor monitor) {
        IType res = null;
        try {
            res = pr.findType(typeName);
        }
        catch (Exception exception) {}
        if (res != null) {
            return res;
        }
        if (!isAnnotation) {
            return this.findTypeDeclaration(typeName, 0, pr, monitor);
        }
        return this.findTypeDeclaration(typeName, 8, pr, monitor);
    }

    @Deprecated
    public List findAnnotationDeclarations2(List<String> filterOutStartString, IJavaProject pr) {
        return this.findAnnotationDeclarations2(filterOutStartString, pr, null);
    }

    public List findAnnotationDeclarations2(List<String> filterOutStartString, IJavaProject pr, IProgressMonitor monitor) {
        ArrayList resLst = new ArrayList();
        if (this.searchEngine == null) {
            this.searchEngine = new SearchEngine();
        }
        IJavaElement[] jEls = new IJavaElement[]{pr};
        IJavaSearchScope scope = null;
        try {
            ArrayList<Object> ar = new ArrayList();
            ar = this.getIJavaElementsForClassPathEntries(pr);
            if (ar.size() > 0) {
                IJavaElement[] arEls = new IJavaElement[ar.size()];
                arEls = ar.toArray(arEls);
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])arEls);
            } else {
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])jEls, (boolean)false);
            }
        }
        catch (Exception exception) {}
        SearchAllAnnotationedClassesRequestor requestor = new SearchAllAnnotationedClassesRequestor();
        SearchPattern pattern = SearchPattern.createPattern((String)"*", (int)8, (int)65536, (int)2);
        if (pattern != null) {
            try {
                this.searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, monitor);
            }
            catch (Exception e) {
                CodegenPlugin.log("Search failed:", e);
                return Collections.emptyList();
            }
            return requestor.getResults();
        }
        return resLst;
    }

    public List<IJavaElement> findAnnotationDeclarations2(IJavaProject pr, String[] lookingAnnotations) {
        return this.findAnnotationDeclarations2(pr, lookingAnnotations, null);
    }

    public List<IJavaElement> findAnnotationDeclarations2(IJavaProject pr, String[] lookingAnnotations, IProgressMonitor monitor) {
        ArrayList<IJavaElement> resLst = new ArrayList<IJavaElement>();
        if (this.searchEngine == null) {
            this.searchEngine = new SearchEngine();
        }
        IJavaSearchScope scope = null;
        try {
            ArrayList<Object> ar = new ArrayList();
            ar = this.getIJavaElementsForClassPathEntries(pr);
            if (ar.size() > 0) {
                IJavaElement[] arEls = new IJavaElement[ar.size()];
                arEls = ar.toArray(arEls);
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])arEls);
            } else {
                IJavaElement[] jEls = new IJavaElement[]{pr};
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])jEls, (boolean)false);
            }
        }
        catch (Exception exception) {}
        SearchPattern pattern = null;
        if (lookingAnnotations != null && lookingAnnotations.length > 0) {
            String[] stringArray = lookingAnnotations;
            int n = lookingAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                String fullyQualifiedAnnotationName = stringArray[n2];
                SearchPattern pattern1 = SearchPattern.createPattern((String)fullyQualifiedAnnotationName, (int)8, (int)65536, (int)0);
                pattern = pattern != null ? SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)pattern1) : pattern1;
                ++n2;
            }
        } else {
            pattern = SearchPattern.createPattern((String)"*", (int)8, (int)65536, (int)2);
        }
        SearchAllAnnotatedClassesForAnnotationsRequestor2 requestor = new SearchAllAnnotatedClassesForAnnotationsRequestor2();
        if (pattern != null) {
            try {
                this.searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, monitor);
            }
            catch (Exception e) {
                CodegenPlugin.log("Search failed:", e);
                return Collections.emptyList();
            }
            return requestor.getResults();
        }
        return resLst;
    }

    @Deprecated
    public List<IJavaElement> findAnnotationDeclarations2(IJavaElement javaElement, String[] lookingAnnotations) {
        return this.findAnnotationDeclarations2(javaElement, lookingAnnotations, null);
    }

    public List<IJavaElement> findAnnotationDeclarations2(IJavaElement javaElement, String[] lookingAnnotations, IProgressMonitor monitor) {
        IJavaElement[] jEls = new IJavaElement[]{javaElement};
        return this.findAnnotationDeclarations2(SearchEngine.createJavaSearchScope((IJavaElement[])jEls, (boolean)false), lookingAnnotations, monitor);
    }

    @Deprecated
    public List<IJavaElement> findAnnotationDeclarations2(IJavaSearchScope scope, String[] lookingAnnotations) {
        return this.findAnnotationDeclarations2(scope, lookingAnnotations, null);
    }

    public List<IJavaElement> findAnnotationDeclarations2(IJavaSearchScope scope, String[] lookingAnnotations, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (this.searchEngine == null) {
            this.searchEngine = new SearchEngine();
        }
        SearchPattern pattern = null;
        if (lookingAnnotations != null && lookingAnnotations.length > 0) {
            String[] stringArray = lookingAnnotations;
            int n = lookingAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                String fullyQualifiedAnnotationName = stringArray[n2];
                SearchPattern pattern1 = SearchPattern.createPattern((String)fullyQualifiedAnnotationName, (int)8, (int)65536, (int)0);
                pattern = pattern != null ? SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)pattern1) : pattern1;
                ++n2;
            }
        } else {
            pattern = SearchPattern.createPattern((String)"*", (int)8, (int)65536, (int)2);
        }
        if (monitor != null && monitor.isCanceled()) {
            return Collections.emptyList();
        }
        SearchAllAnnotatedClassesForAnnotationsRequestor2 requestor = new SearchAllAnnotatedClassesForAnnotationsRequestor2();
        try {
            this.searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, monitor);
        }
        catch (Exception e) {
            CodegenPlugin.log("Search failed:", e);
            return Collections.emptyList();
        }
        return requestor.getResults();
    }

    @Deprecated
    public Hashtable<IJavaElement, ArrayList> findAnnotatedTypesForAnnotation(IJavaSearchScope scope, String fullyQualifiedAnnotationName) {
        return this.findAnnotatedTypesForAnnotation(scope, fullyQualifiedAnnotationName, null);
    }

    public Hashtable<IJavaElement, ArrayList> findAnnotatedTypesForAnnotation(IJavaSearchScope scope, String fullyQualifiedAnnotationName, IProgressMonitor monitor) {
        if (this.searchEngine == null) {
            this.searchEngine = new SearchEngine();
        }
        String shortName = null;
        int indx = fullyQualifiedAnnotationName.lastIndexOf(".");
        if (indx > 0) {
            shortName = fullyQualifiedAnnotationName.substring(indx + 1, fullyQualifiedAnnotationName.length());
        }
        SearchAllAnnotationedClassesRequestor2 requestor2 = new SearchAllAnnotationedClassesRequestor2(fullyQualifiedAnnotationName, shortName);
        SearchPattern pattern1 = SearchPattern.createPattern((String)fullyQualifiedAnnotationName, (int)8, (int)65536, (int)2);
        try {
            this.searchEngine.search(pattern1, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor2, monitor);
        }
        catch (Exception e) {
            CodegenPlugin.log("Search failed:", e);
            return new Hashtable<IJavaElement, ArrayList>();
        }
        return requestor2.getResults();
    }

    private IType findTypeDeclaration(String typeName, int searchType, IJavaProject pr, IProgressMonitor monitor) {
        IType[] retTypes = this.findTypeDeclarations(typeName, searchType, pr, monitor);
        if (retTypes != null && retTypes.length > 0) {
            return retTypes[0];
        }
        return null;
    }

    private IType[] findTypeDeclarations(String typeName, int searchType, IJavaProject pr, IProgressMonitor monitor) {
        IJavaElement[] jEls = new IJavaElement[]{pr};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])jEls);
        SearchPattern pattern = SearchPattern.createPattern((String)typeName, (int)searchType, (int)0, (int)2);
        SearchUtilRequestor requestor = new SearchUtilRequestor();
        if (this.searchEngine == null) {
            this.searchEngine = new SearchEngine();
        }
        try {
            this.searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, monitor);
        }
        catch (Exception e) {
            CodegenPlugin.log("Search failed:", e);
            return null;
        }
        List<SearchMatch> resLst = requestor.getSearchMatches();
        if (resLst != null && !resLst.isEmpty()) {
            IType[] retTypes = new IType[resLst.size()];
            int i = 0;
            while (i < resLst.size()) {
                retTypes[i] = (IType)resLst.get(i).getElement();
                ++i;
            }
            return retTypes;
        }
        return null;
    }

    public ArrayList<IJavaElement> getIJavaElementsForClassPathEntriesForWorkspace() {
        ArrayList<IJavaElement> masterList = new ArrayList<IJavaElement>();
        IProject[] wProjects = ResourceUtils.getWorkspace().getRoot().getProjects();
        if (wProjects != null) {
            CodegenPlugin.debug("Getting elements for Classpathentries in workspace...");
            int v = 0;
            while (v < wProjects.length) {
                block9: {
                    IProject proj = wProjects[v];
                    if (proj.isOpen()) {
                        IJavaProject jProj;
                        block8: {
                            CodegenPlugin.debug("   Checking: " + proj.getName());
                            try {
                                IProjectNature javaNature = proj.getNature("org.eclipse.jdt.core.javanature");
                                if (javaNature != null) break block8;
                                CodegenPlugin.debug("   Skipping: " + proj.getName());
                                break block9;
                            }
                            catch (CoreException coreException) {}
                        }
                        if ((jProj = JavaCore.create((IProject)proj)) != null) {
                            block10: {
                                String projectComplianceLevel = jProj.getOption("org.eclipse.jdt.core.compiler.compliance", true);
                                try {
                                    float compLevel = Float.parseFloat(projectComplianceLevel);
                                    if (!((double)compLevel < 1.5)) break block10;
                                    break block9;
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                            ArrayList<IJavaElement> entrList = this.getIJavaElementsForClassPathEntries(jProj);
                            masterList.addAll(entrList);
                        }
                    }
                }
                ++v;
            }
        }
        return masterList;
    }

    public ArrayList<IJavaElement> getIJavaElementsForClassPathEntries(IJavaProject pr) {
        ArrayList<IJavaElement> ar = new ArrayList<IJavaElement>();
        try {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = pr.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                block16: {
                    IPackageFragmentRoot[] roots;
                    IClasspathEntry ice;
                    block17: {
                        String sPath;
                        block15: {
                            ice = iClasspathEntryArray[n2];
                            if (ice.getEntryKind() != 1 && ice.getEntryKind() != 3) break block15;
                            IPath path = ice.getPath();
                            IPackageFragmentRoot root = pr.findPackageFragmentRoot(path.makeAbsolute());
                            if (root != null) {
                                ar.add((IJavaElement)root);
                            } else {
                                IJavaElement newEl;
                                IResource ir = ResourceUtils.getWorkspace().getRoot().findMember(path);
                                if (ir != null && (newEl = JavaCore.create((IResource)ir)) != null) {
                                    if (newEl instanceof IJavaProject) {
                                        IPackageFragmentRoot[] packFragRoots = pr.findPackageFragmentRoots(ice);
                                        CodegenPlugin.debug("      Adding package fragments for project where root folder is marked as source");
                                        ar.addAll(Arrays.asList(packFragRoots));
                                    } else {
                                        CodegenPlugin.debug("      Adding: " + path.toOSString());
                                        ar.add(newEl);
                                    }
                                }
                            }
                            break block16;
                        }
                        if (ice.getEntryKind() != 5 || AnnotationsCoreConstants.stopSCanningContainers_ || (sPath = ice.getPath().toOSString()).indexOf("org.eclipse.jst.server.core.container") >= 0 || sPath.indexOf("JRE_CONTAINER") >= 0) break block16;
                        if (AnnotationsCoreConstants.excludedContainers_ == null) break block17;
                        boolean shouldBeIgnored = false;
                        String[] stringArray = AnnotationsCoreConstants.excludedContainers_;
                        int n3 = AnnotationsCoreConstants.excludedContainers_.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String excludedContainer = stringArray[n4];
                            if (sPath.indexOf(excludedContainer) != -1) {
                                shouldBeIgnored = true;
                                break;
                            }
                            ++n4;
                        }
                        if (shouldBeIgnored) break block16;
                    }
                    if ((roots = pr.findPackageFragmentRoots(ice)) != null && roots.length > 0) {
                        ar.addAll(Arrays.asList(roots));
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ar;
    }

    public IJavaElement[] turnListToArray(List<IJavaElement> list) {
        IJavaElement[] resA = null;
        if (list != null) {
            resA = new IJavaElement[list.size()];
            resA = list.toArray(resA);
        }
        return resA;
    }

    public List<IAnnotation> findAnnotations(IJavaSearchScope scope, Enumeration fullyQualifiedAnnotationNames, IProgressMonitor monitor) {
        if (this.searchEngine == null) {
            this.searchEngine = new SearchEngine();
        }
        ArrayList<String> tempA = new ArrayList<String>();
        SearchPattern searchPattern = null;
        while (fullyQualifiedAnnotationNames.hasMoreElements()) {
            String fullyQualifiedAnnotationName = (String)fullyQualifiedAnnotationNames.nextElement();
            String shortName = null;
            int indx = fullyQualifiedAnnotationName.lastIndexOf(".");
            if (indx > 0) {
                shortName = fullyQualifiedAnnotationName.substring(indx + 1, fullyQualifiedAnnotationName.length());
            }
            tempA.add(shortName);
            tempA.add(fullyQualifiedAnnotationName);
            SearchPattern pattern1 = SearchPattern.createPattern((String)fullyQualifiedAnnotationName, (int)8, (int)65536, (int)0);
            searchPattern = searchPattern != null ? SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)pattern1) : pattern1;
        }
        SearchAllAnnotationsInstancesRequestor requestor2 = new SearchAllAnnotationsInstancesRequestor(tempA);
        try {
            this.searchEngine.search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor2, monitor);
        }
        catch (Exception e) {
            CodegenPlugin.log("Search failed:", e);
            return Collections.emptyList();
        }
        return requestor2.getResults();
    }

    public List<IAnnotation> findAnnotations(IJavaSearchScope scope, String fullyQualifiedAnnotationName, IProgressMonitor monitor) {
        if (this.searchEngine == null) {
            this.searchEngine = new SearchEngine();
        }
        String shortName = null;
        int indx = fullyQualifiedAnnotationName.lastIndexOf(".");
        if (indx > 0) {
            shortName = fullyQualifiedAnnotationName.substring(indx + 1, fullyQualifiedAnnotationName.length());
        }
        ArrayList<String> tempA = new ArrayList<String>();
        tempA.add(shortName);
        tempA.add(fullyQualifiedAnnotationName);
        SearchAllAnnotationsInstancesRequestor requestor2 = new SearchAllAnnotationsInstancesRequestor(tempA);
        SearchPattern pattern1 = SearchPattern.createPattern((String)fullyQualifiedAnnotationName, (int)8, (int)65536, (int)0);
        try {
            this.searchEngine.search(pattern1, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor2, monitor);
        }
        catch (Exception e) {
            CodegenPlugin.log("Search failed:", e);
            return Collections.emptyList();
        }
        return requestor2.getResults();
    }

    public boolean checkAnnotationForClass(IJavaElement je, String[] lookingAnnotations_) {
        try {
            IJavaElement[] childs = null;
            if (je instanceof ICompilationUnit) {
                childs = ((ICompilationUnit)je).getChildren();
            } else if (je instanceof IClassFile) {
                childs = ((IClassFile)je).getChildren();
            }
            if (childs != null) {
                return this.checkAnnotationForJE(childs, lookingAnnotations_);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkAnnotationForJE(IJavaElement[] jes, String[] lookingAnnotations_) {
        try {
            IJavaElement[] iJavaElementArray = jes;
            int n = jes.length;
            int n2 = 0;
            while (n2 < n) {
                boolean status;
                IAnnotation[] annotations;
                IJavaElement je = iJavaElementArray[n2];
                if (je instanceof IAnnotatable && (annotations = ((IAnnotatable)je).getAnnotations()) != null && annotations.length > 0) {
                    IAnnotation[] iAnnotationArray = annotations;
                    int n3 = annotations.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAnnotation annotation = iAnnotationArray[n4];
                        String elementName = annotation.getElementName();
                        String[] stringArray = lookingAnnotations_;
                        int n5 = lookingAnnotations_.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String annotationName = stringArray[n6];
                            if (annotationName.endsWith(elementName)) {
                                return true;
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
                if (je instanceof IMember && (status = this.checkAnnotationForJE(((IMember)je).getChildren(), lookingAnnotations_))) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

