/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal.scope;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;

public class ScopeForSpecificType
implements IJavaSearchScope {
    private IJavaProject[] searchTypes_;
    private ArrayList elements_;
    private boolean needsRefresh_;
    private IPath[] enclosingProjectsAndJars_;

    public ScopeForSpecificType(ArrayList types) throws JavaModelException {
        this.searchTypes_ = new IJavaProject[types.size()];
        types.toArray(this.searchTypes_);
        this.needsRefresh_ = true;
        this.enclosingProjectsAndJars_ = this.computeProjectsAndJars(types);
    }

    private IPath[] computeProjectsAndJars(ArrayList projects) throws JavaModelException {
        ArrayList<IPath> returnPaths = new ArrayList<IPath>();
        int i = 0;
        while (i < projects.size()) {
            IPath[] paths = this.computeProjectsAndJars((IJavaProject)projects.get(i));
            int j = 0;
            while (j < paths.length) {
                if (returnPaths.indexOf(paths[j]) == -1) {
                    returnPaths.add(paths[j]);
                }
                ++j;
            }
            ++i;
        }
        IPath[] result = new IPath[returnPaths.size()];
        returnPaths.toArray(result);
        return result;
    }

    private IPath[] computeProjectsAndJars(IJavaProject project) throws JavaModelException {
        HashSet<IPath> set = new HashSet<IPath>();
        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot pkgFragmentRoot = roots[i];
            set.add(pkgFragmentRoot.getPath());
            ++i;
        }
        this.computeDependents(project, set, new HashSet());
        IPath[] result = new IPath[set.size()];
        set.toArray(result);
        return result;
    }

    private void computeDependents(IJavaProject project, HashSet set, HashSet visited) {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        IProject[] dependents = project.getProject().getReferencingProjects();
        int i = 0;
        while (i < dependents.length) {
            try {
                IJavaProject dependent = JavaCore.create((IProject)dependents[i]);
                IPackageFragmentRoot[] roots = dependent.getPackageFragmentRoots();
                set.add(dependent.getPath());
                int j = 0;
                while (j < roots.length) {
                    IPackageFragmentRoot pkgFragmentRoot = roots[j];
                    if (pkgFragmentRoot.isArchive()) {
                        set.add(pkgFragmentRoot.getPath());
                    }
                    ++j;
                }
                this.computeDependents(dependent, set, visited);
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
    }

    public boolean encloses(String resourcePath) {
        try {
            this.initialize();
        }
        catch (Exception exception) {}
        return this.elements_.indexOf(resourcePath) != -1;
    }

    public boolean encloses(IJavaElement element) {
        return false;
    }

    public IPath[] enclosingProjectsAndJars() {
        if (this.needsRefresh_) {
            try {
                this.refresh();
            }
            catch (JavaModelException javaModelException) {
                return new IPath[0];
            }
        }
        return this.enclosingProjectsAndJars_;
    }

    protected void initialize() throws JavaModelException {
        if (this.searchTypes_ == null || !this.needsRefresh_) {
            return;
        }
        this.needsRefresh_ = false;
        this.elements_ = new ArrayList();
        int i = 0;
        while (i < this.searchTypes_.length) {
            IPackageFragmentRoot[] roots = this.searchTypes_[i].getAllPackageFragmentRoots();
            int j = 0;
            while (j < roots.length) {
                IJavaElement[] elements = roots[j].getChildren();
                int ii = 0;
                while (ii < elements.length) {
                    IPackageFragment fragment;
                    ICompilationUnit[] cUs;
                    if (elements[ii] instanceof IPackageFragment && (cUs = (fragment = (IPackageFragment)elements[ii]).getCompilationUnits()).length > 0) {
                        this.parseAllAnnotationsOnClassPath(cUs[0]);
                    }
                    ++ii;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void refresh() throws JavaModelException {
        this.initialize();
    }

    public boolean includesBinaries() {
        return true;
    }

    public boolean includesClasspaths() {
        return true;
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }

    private void parseAllAnnotationsOnClassPath(ICompilationUnit cu) {
        SearchPattern pattern = SearchPattern.createPattern((String)"java.lang.annotation.Annotation", (int)8, (int)1, (int)8);
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IType t = (IType)match.getElement();
                String path = t.getPath().toOSString();
                IJavaElement el = t.getParent();
                if (el instanceof IClassFile) {
                    String name = t.getFullyQualifiedName().replace('.', '/');
                    path = String.valueOf(path) + "|" + name + ".class";
                }
                ScopeForSpecificType.this.elements_.add(path);
            }
        };
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        try {
            SearchEngine se = new SearchEngine();
            se.search(pattern, participants, SearchEngine.createWorkspaceScope(), requestor, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

