/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.core.internal.listeners;

import com.ibm.adapter.j2c.internal.CodegenPlugin;
import com.ibm.etools.annotations.core.AnnotationsCoreConstants;
import com.ibm.etools.annotations.core.api.TriggerAnnotationListener;
import com.ibm.etools.annotations.core.api.TriggerAnnotationNamesListProvider;
import com.ibm.etools.annotations.core.internal.jobs.AnnotationJob;
import com.ibm.etools.annotations.core.internal.jobs.AnnotationJobManager;
import com.ibm.etools.annotations.core.internal.listeners.InMemoryIndex;
import com.ibm.etools.annotations.core.internal.listeners.IndexingJobListener;
import com.ibm.etools.annotations.core.internal.messages.AnnotationCoreMessages;
import com.ibm.etools.annotations.core.internal.search.JavaSearchUtils;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;

public class TriggerAnnotationListenerImpl
implements IElementChangedListener {
    private boolean isInit = false;
    private Hashtable<String, TriggerAnnotationListenerProxy> annotationListeners = new Hashtable();
    private Hashtable<String, TriggerAnnotationListenerProxy> postReconcileAnnotationListeners = new Hashtable();
    private ArrayList<TriggerAnnotationListener> additionalPostReconcileListeners = new ArrayList(6);
    private ArrayList<TriggerAnnotationListener> additionalPostResourceChangeListeners = new ArrayList(6);
    private Hashtable<IJavaElement, List<IJavaElementDelta>> annotationsForModifiedResource = new Hashtable();
    private Hashtable<String, String> fullAnnotationNames = new Hashtable();
    private InMemoryIndex inMemoryIndex = InMemoryIndex.getInstance();
    private Hashtable<String, String> fullToShortName = new Hashtable();
    private Hashtable<String, String> shortToFullName = new Hashtable();
    private InvokeChangeListenersJob _latestDelayedJob = null;
    private boolean setAsSystemJob = System.getenv("annoSetAsSystemJob") != null;
    private Object syncObject = new Object();
    private IndexingJobListener listener_ = new IndexingJobListener();

    protected TriggerAnnotationListenerImpl() {
    }

    public void elementChanged(ElementChangedEvent event) {
        if (!this.isInit) {
            this.init(this.listener_);
        }
        this.handleEvent(event);
    }

    boolean isJava15orGreater(IJavaElement javaElement) {
        IJavaProject jp;
        IJavaProject iJavaProject = jp = javaElement != null ? javaElement.getJavaProject() : null;
        if (jp != null) {
            String projectComplianceLevel = jp.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            try {
                float compLevel = Float.parseFloat(projectComplianceLevel);
                if ((double)compLevel < 1.5) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEvent(ElementChangedEvent event) {
        if (event.getType() == 4) {
            IJavaElementDelta topDelta = event.getDelta();
            AnnotationDeltas annoDeltas = new AnnotationDeltas();
            this.getAllAnnotationDeltas(topDelta, annoDeltas);
            this.invokeListeners(annoDeltas, true);
        } else if (event.getType() == 1) {
            List<Object> list;
            IJavaElementDelta topDelta1 = event.getDelta();
            List<IJavaElementDelta> leafDeltas = InternalUtils.getLeafDeltas(topDelta1);
            ArrayList<IJavaElementDelta> delsList = new ArrayList<IJavaElementDelta>();
            ArrayList<InternalJavaElementDelta> internalDelList = new ArrayList<InternalJavaElementDelta>(6);
            block12: for (IJavaElementDelta del : leafDeltas) {
                int kind;
                List<IJavaElementDelta> existingDeltaList;
                IJavaElement delEl = del.getElement();
                if (!this.isJava15orGreater(delEl)) continue;
                IJavaElementDelta[] annDeltas = del.getAnnotationDeltas();
                if (annDeltas != null && annDeltas.length > 0) {
                    List<IJavaElementDelta> tempL = Arrays.asList(annDeltas);
                    this.updateIndexWithListOfAnnotationDeltas(tempL);
                    this.invokeListeners(tempL, false);
                }
                if ((existingDeltaList = this.annotationsForModifiedResource.get(delEl)) != null && !existingDeltaList.isEmpty()) {
                    this.updateIndexWithListOfAnnotationDeltas(existingDeltaList);
                    this.annotationsForModifiedResource.remove(delEl);
                    this.invokeListeners(existingDeltaList, false);
                }
                if ((kind = del.getKind()) == 4) {
                    int flags = del.getFlags();
                    int elementType = del.getElement().getElementType();
                    if (elementType == 2) {
                        if ((flags & 0x20000) != 0) {
                            delsList.add(del);
                            continue;
                        }
                        IResourceDelta[] deltas = del.getResourceDeltas();
                        if (deltas == null) continue;
                        ArrayList<IJavaElementDelta> changedList = new ArrayList<IJavaElementDelta>(6);
                        IResourceDelta[] iResourceDeltaArray = deltas;
                        int n = deltas.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResourceDelta rd = iResourceDeltaArray[n2];
                            if (rd.getProjectRelativePath().toString().equals(".classpath")) {
                                changedList.add(del);
                                continue block12;
                            }
                            ++n2;
                        }
                        continue;
                    }
                    if (elementType == 5 || elementType == 6) {
                        if ((flags & 0x10000) != 0 || (flags & 0x40000) != 0) continue;
                        delsList.add(del);
                        continue;
                    }
                    if ((flags & 0x40) == 0 && (flags & 0x80) == 0 || elementType != 3) continue;
                    delsList.add(del);
                    continue;
                }
                if (kind != 1 && kind != 2) continue;
                delsList.add(del);
            }
            if (delsList.isEmpty() && internalDelList.isEmpty()) {
                return;
            }
            if (AnnotationsCoreConstants.stopTriggerAnnotationFramework_) {
                return;
            }
            InvokeChangeListenersJob latestJobToAddTo = this._latestDelayedJob;
            if (latestJobToAddTo != null) {
                Object object = this.syncObject;
                synchronized (object) {
                    CodegenPlugin.debug("Job to try and add to is" + (latestJobToAddTo.getState() != 4 ? " not running" : " running"));
                    CodegenPlugin.debug(latestJobToAddTo.getResult() == null ? "  job.getResult() == null" : "   job.getResult() != null");
                    if (latestJobToAddTo.getState() != 4 && latestJobToAddTo.getResult() == null) {
                        list = latestJobToAddTo.getDeltas();
                        synchronized (list) {
                            CodegenPlugin.debug("Adding to existing delta");
                            latestJobToAddTo.addDeltas(delsList);
                        }
                        if (!internalDelList.isEmpty()) {
                            list = latestJobToAddTo.getInternalJavaElementDeltas();
                            synchronized (list) {
                                CodegenPlugin.debug("Adding to existing internal delta");
                                latestJobToAddTo.addInternalDeltas(internalDelList);
                            }
                        }
                        CodegenPlugin.debug("!!!reuse job " + (Object)((Object)latestJobToAddTo));
                        return;
                    }
                }
            }
            InvokeChangeListenersJob jb = new InvokeChangeListenersJob(delsList);
            if (!internalDelList.isEmpty()) {
                jb.addInternalDeltas(internalDelList);
            }
            CodegenPlugin.debug("*New index job created" + (Object)((Object)jb));
            list = this.syncObject;
            synchronized (list) {
                this._latestDelayedJob = jb;
            }
            AnnotationJobManager.getInstance().startJob(jb);
        }
    }

    private void getAllAnnotationDeltas(IJavaElementDelta topDelta, AnnotationDeltas annoDeltas) {
        IJavaElementDelta[] annDeltas = topDelta.getAnnotationDeltas();
        int i = 0;
        while (i < annDeltas.length) {
            annoDeltas.getAnnElementDeltas().add(annDeltas[i]);
            ++i;
        }
        if (topDelta.getElement() instanceof IAnnotatable) {
            IAnnotatable annotatable = (IAnnotatable)topDelta.getElement();
            try {
                IAnnotation[] annotations = annotatable.getAnnotations();
                if (annotations.length > 0) {
                    if (topDelta.getKind() == 1) {
                        annoDeltas.getAnnAddedImplicitly().addAll(Arrays.asList(annotations));
                    } else if (topDelta.getKind() == 2) {
                        annoDeltas.getAnnRemovedImplicitly().addAll(Arrays.asList(annotations));
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        IJavaElementDelta[] affectedChilds = topDelta.getAffectedChildren();
        int n = 0;
        while (n < affectedChilds.length) {
            this.getAllAnnotationDeltas(affectedChilds[n], annoDeltas);
            ++n;
        }
    }

    private void init(IndexingJobListener listener) {
        IConfigurationElement[] annoConfigExtensionPoints2;
        IConfigurationElement[] annoConfigExtensionPoints;
        this.isInit = true;
        IConfigurationElement[] iConfigurationElementArray = annoConfigExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.j2c.codegen.TriggerAnnotations");
        int n = annoConfigExtensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement annoConfigExtensionPoint = iConfigurationElementArray[n2];
            String aTag = annoConfigExtensionPoint.getAttribute("name");
            String aPack = annoConfigExtensionPoint.getAttribute("package");
            String fullName = new StringBuffer(aPack).append(".").append(aTag).toString();
            this.fullAnnotationNames.put(fullName, fullName);
            this.fullToShortName.put(fullName, aTag);
            this.shortToFullName.put(aTag, fullName);
            String aClassName = annoConfigExtensionPoint.getAttribute("classListener");
            String postReconcile = annoConfigExtensionPoint.getAttribute("reconcileEvent");
            if (aClassName != null && !aClassName.isEmpty()) {
                if (postReconcile != null && postReconcile.trim().equalsIgnoreCase("true")) {
                    this.addListenerToHashtable(fullName, annoConfigExtensionPoint, true);
                } else if (postReconcile != null && postReconcile.trim().equalsIgnoreCase("both")) {
                    this.addListenerToHashtable(fullName, annoConfigExtensionPoint, true);
                    this.addListenerToHashtable(fullName, annoConfigExtensionPoint, false);
                } else {
                    this.addListenerToHashtable(fullName, annoConfigExtensionPoint, false);
                }
            }
            ++n2;
        }
        IConfigurationElement[] iConfigurationElementArray2 = annoConfigExtensionPoints2 = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.adapter.j2c.codegen.TriggerAnnotations2");
        int n3 = annoConfigExtensionPoints2.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement annoConfigExtensionPoint2 = iConfigurationElementArray2[n];
            String aClassName = annoConfigExtensionPoint2.getAttribute("classListener");
            String namesProvider = annoConfigExtensionPoint2.getAttribute("namesProvider");
            String postReconcile = annoConfigExtensionPoint2.getAttribute("reconcileEvent");
            if (aClassName != null && aClassName.length() > 0 && namesProvider != null && namesProvider.length() > 0) {
                try {
                    ArrayList<String> names;
                    Object namesProviderObject = annoConfigExtensionPoint2.createExecutableExtension("namesProvider");
                    if (namesProviderObject instanceof TriggerAnnotationNamesListProvider && (names = ((TriggerAnnotationNamesListProvider)namesProviderObject).getTriggerAnnotationNames()) != null) {
                        for (String fullName : names) {
                            this.fullAnnotationNames.put(fullName, fullName);
                            int ind1 = fullName.lastIndexOf(".");
                            if (ind1 > 0) {
                                String sATagName = fullName.substring(ind1 + 1, fullName.length());
                                this.fullToShortName.put(fullName, sATagName);
                                this.shortToFullName.put(sATagName, fullName);
                            }
                            if (postReconcile != null && postReconcile.trim().equalsIgnoreCase("true")) {
                                this.addListenerToHashtable(fullName, annoConfigExtensionPoint2, true);
                                continue;
                            }
                            if (postReconcile != null && postReconcile.trim().equalsIgnoreCase("both")) {
                                this.addListenerToHashtable(fullName, annoConfigExtensionPoint2, true);
                                this.addListenerToHashtable(fullName, annoConfigExtensionPoint2, false);
                                continue;
                            }
                            this.addListenerToHashtable(fullName, annoConfigExtensionPoint2, false);
                        }
                    }
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        if (!AnnotationsCoreConstants.stopTriggerAnnotationFramework_) {
            IndexingJob job = new IndexingJob(AnnotationCoreMessages.ANNOTATIONS_CORE_JOB_ANNOTATION_INDEXING);
            if (listener != null) {
                job.addJobChangeListener(listener);
            }
            AnnotationJobManager.getInstance().startJob(job);
        } else {
            listener.done = true;
        }
    }

    public void addAdditionalPostReconcileListener(TriggerAnnotationListener listener) {
        if (!this.additionalPostReconcileListeners.contains(listener)) {
            this.additionalPostReconcileListeners.add(listener);
        }
    }

    public void removeAdditionalPostReconcileListener(TriggerAnnotationListener listener) {
        this.additionalPostReconcileListeners.remove(listener);
    }

    public void addAdditionalPostResourceChangeListener(TriggerAnnotationListener listener) {
        if (!this.additionalPostResourceChangeListeners.contains(listener)) {
            this.additionalPostResourceChangeListeners.add(listener);
        }
    }

    public void removeAdditionalPostResourceChangeListener(TriggerAnnotationListener listener) {
        this.additionalPostResourceChangeListeners.remove(listener);
    }

    private List<TriggerAnnotationListener> getListeners(boolean postReconcile, String name) {
        TriggerAnnotationListenerProxy proxy = postReconcile ? this.postReconcileAnnotationListeners.get(name) : this.annotationListeners.get(name);
        if (proxy != null) {
            return proxy.getListeners();
        }
        String fullName = this.shortToFullName.get(name);
        if (fullName != null && (proxy = postReconcile ? this.postReconcileAnnotationListeners.get(fullName) : this.annotationListeners.get(fullName)) != null) {
            return proxy.getListeners();
        }
        return null;
    }

    private void invokeListener(TriggerAnnotationListener lis, int kind, IAnnotation annotation) {
        if (lis != null) {
            try {
                if (kind == 1) {
                    lis.annotationAdded(annotation);
                    lis.annotationAdded(new IAnnotation[]{annotation});
                } else if (kind == 2) {
                    lis.annotationRemoved(annotation);
                    lis.annotationRemoved(new IAnnotation[]{annotation});
                } else if (kind == 4) {
                    lis.annotationChanged(annotation);
                    lis.annotationChanged(new IAnnotation[]{annotation});
                }
            }
            catch (Exception e) {
                CodegenPlugin.log("Invoke trigger annotation listener: ", e);
            }
        }
    }

    private void invokeListeners(AnnotationDeltas annoDeltas, boolean postReconcile) {
        this.invokeListeners(annoDeltas.getAnnElementDeltas(), postReconcile);
        this.invokeListenersForImplicitAnnotationDelta(annoDeltas.getAnnAddedImplicitly(), 1, postReconcile);
        this.invokeListenersForImplicitAnnotationDelta(annoDeltas.getAnnRemovedImplicitly(), 2, postReconcile);
    }

    private void invokeListeners(List<IAnnotation> anns, int kind, boolean postReconcile) {
        Hashtable<TriggerAnnotationListener, ArrayList<IAnnotation>> listeners = new Hashtable<TriggerAnnotationListener, ArrayList<IAnnotation>>(6);
        for (IAnnotation annotation : anns) {
            String annName = annotation.getElementName();
            if (annName == null) continue;
            List<TriggerAnnotationListener> listOfListeners = this.getListeners(postReconcile, annName);
            ArrayList<TriggerAnnotationListener> additionalListeners = !postReconcile ? this.additionalPostResourceChangeListeners : this.additionalPostReconcileListeners;
            if (listOfListeners == null) {
                if (!additionalListeners.isEmpty()) {
                    listOfListeners = new ArrayList<TriggerAnnotationListener>(additionalListeners);
                }
            } else {
                listOfListeners.addAll(additionalListeners);
            }
            if (listOfListeners == null) continue;
            for (TriggerAnnotationListener listener : listOfListeners) {
                ArrayList<IAnnotation> annoList = (ArrayList<IAnnotation>)listeners.get(listener);
                if (annoList == null) {
                    annoList = new ArrayList<IAnnotation>(6);
                    listeners.put(listener, annoList);
                }
                annoList.add(annotation);
            }
        }
        Enumeration keys = listeners.keys();
        while (keys.hasMoreElements()) {
            TriggerAnnotationListener listener = (TriggerAnnotationListener)keys.nextElement();
            List annotations = (List)listeners.get(listener);
            try {
                if (kind == 4) {
                    listener.annotationChanged(annotations.toArray(new IAnnotation[annotations.size()]));
                    continue;
                }
                if (kind == 1) {
                    listener.annotationAdded(annotations.toArray(new IAnnotation[annotations.size()]));
                    continue;
                }
                if (kind != 2) continue;
                listener.annotationRemoved(annotations.toArray(new IAnnotation[annotations.size()]));
            }
            catch (Exception e) {
                CodegenPlugin.log("Invoke trigger annotation listener: ", e);
            }
        }
    }

    private void invokeListenersForImplicitAnnotationDelta(List<IAnnotation> annDeltaImplicitList, int kind, boolean postReconcile) {
        for (IAnnotation annotation : annDeltaImplicitList) {
            String annName = annotation.getElementName();
            if (annName == null) continue;
            List<TriggerAnnotationListener> listOfListeners = this.getListeners(postReconcile, annName);
            if (listOfListeners != null) {
                for (TriggerAnnotationListener lis : listOfListeners) {
                    this.invokeListener(lis, kind, annotation);
                }
            }
            if (postReconcile) {
                for (TriggerAnnotationListener lis : this.additionalPostReconcileListeners) {
                    this.invokeListener(lis, kind, annotation);
                }
                continue;
            }
            for (TriggerAnnotationListener lis : this.additionalPostResourceChangeListeners) {
                this.invokeListener(lis, kind, annotation);
            }
        }
    }

    private void handleAnnotationForDeferedNotification(IJavaElement el, IJavaElementDelta delta) {
        IJavaElement newEl = InternalUtils.getCUorClassFile(el);
        List<IJavaElementDelta> existingDeltaList = this.annotationsForModifiedResource.get(newEl);
        if (existingDeltaList == null) {
            existingDeltaList = new ArrayList<IJavaElementDelta>(1);
            existingDeltaList.add(delta);
            this.annotationsForModifiedResource.put(newEl, existingDeltaList);
        } else if (delta.getKind() == 1) {
            int i = 0;
            while (i < existingDeltaList.size()) {
                IJavaElementDelta de = existingDeltaList.get(i);
                if (de.getElement().equals(delta.getElement()) && de.getKind() == 2) {
                    existingDeltaList.remove(de);
                    return;
                }
                ++i;
            }
            existingDeltaList.add(delta);
        } else if (delta.getKind() == 2) {
            int i = 0;
            while (i < existingDeltaList.size()) {
                IJavaElementDelta de = existingDeltaList.get(i);
                if (de.getElement().equals(delta.getElement())) {
                    existingDeltaList.remove(de);
                    return;
                }
                ++i;
            }
            existingDeltaList.add(delta);
        } else if (delta.getKind() == 4) {
            int i = 0;
            while (i < existingDeltaList.size()) {
                IJavaElementDelta de = existingDeltaList.get(i);
                if (de.getElement().equals(delta.getElement())) {
                    existingDeltaList.remove(de);
                    existingDeltaList.add(delta);
                    return;
                }
                ++i;
            }
            existingDeltaList.add(delta);
        }
    }

    private void invokeListeners(List<IJavaElementDelta> annotDeltas, boolean postReconcile) {
        for (IJavaElementDelta delta : annotDeltas) {
            IJavaElement el;
            if (postReconcile) {
                this.handleAnnotationForDeferedNotification(delta.getElement().getParent(), delta);
            }
            if (!((el = delta.getElement()) instanceof IAnnotation)) continue;
            IAnnotation annotation = (IAnnotation)el;
            String annName = el.getElementName();
            if (annName == null) continue;
            List<TriggerAnnotationListener> listOfListeners = this.getListeners(postReconcile, annName);
            if (listOfListeners != null) {
                for (TriggerAnnotationListener lis : listOfListeners) {
                    this.invokeListener(lis, delta.getKind(), annotation);
                }
            }
            if (postReconcile) {
                for (TriggerAnnotationListener lis : this.additionalPostReconcileListeners) {
                    this.invokeListener(lis, delta.getKind(), annotation);
                }
                continue;
            }
            for (TriggerAnnotationListener lis : this.additionalPostResourceChangeListeners) {
                this.invokeListener(lis, delta.getKind(), annotation);
            }
        }
    }

    private void addListenerToHashtable(String tagName, IConfigurationElement ice, boolean postReconcile) {
        TriggerAnnotationListenerProxy proxy = postReconcile ? this.postReconcileAnnotationListeners.get(tagName) : this.annotationListeners.get(tagName);
        if (proxy != null) {
            proxy.addListenerProxy(ice);
        } else {
            proxy = new TriggerAnnotationListenerProxy();
            proxy.addListenerProxy(ice);
            if (postReconcile) {
                this.postReconcileAnnotationListeners.put(tagName, proxy);
            } else {
                this.annotationListeners.put(tagName, proxy);
            }
        }
    }

    private List<IAnnotation> getAnnotationsForJavaElementDelta(IJavaElementDelta delta) {
        ArrayList<IAnnotation> res = new ArrayList<IAnnotation>();
        List<IJavaElementDelta> deltas = InternalUtils.getLeafDeltas(delta);
        for (IJavaElementDelta de : deltas) {
            IJavaElement el = de.getElement();
            if (el == null) continue;
            res.addAll(this.inMemoryIndex.getAnnotationsFromInMemoryIndex(el, true));
            if (delta.getKind() != 2 && (delta.getFlags() & 0x400) == 0) continue;
            this.inMemoryIndex.updateInMemoryIndex(el, null, 1);
        }
        return res;
    }

    private void updateIndexWithListOfAnnotationDeltas(List<IJavaElementDelta> existingDeltaList) {
        ArrayList<IAnnotation> addedList = new ArrayList<IAnnotation>();
        ArrayList<IAnnotation> removedList = new ArrayList<IAnnotation>();
        for (IJavaElementDelta del : existingDeltaList) {
            if (del.getKind() == 1) {
                addedList.add((IAnnotation)del.getElement());
                continue;
            }
            if (del.getKind() != 2) continue;
            removedList.add((IAnnotation)del.getElement());
        }
        if (addedList.size() > 0) {
            this.inMemoryIndex.updateInMemoryIndex(addedList, 0);
        }
        if (removedList.size() > 0) {
            this.inMemoryIndex.updateInMemoryIndex(removedList, 1);
        }
    }

    public List<IAnnotation> getAllAnnotationInstances(String fullAnnotationName, boolean forSavedResources) {
        ArrayList<IAnnotation> res = new ArrayList<IAnnotation>();
        if (!this.isInit) {
            this.init(this.listener_);
        }
        int counter = 0;
        while (!this.listener_.isDone() && counter < 100) {
            try {
                Thread.sleep(500L);
                ++counter;
            }
            catch (Exception exception) {}
        }
        String shortName = this.fullToShortName.get(fullAnnotationName);
        if (forSavedResources) {
            if (!AnnotationsCoreConstants.stopTriggerAnnotationFramework_) {
                ArrayList<String> l1 = new ArrayList<String>(2);
                l1.add(fullAnnotationName);
                l1.add(shortName);
                res.addAll(this.inMemoryIndex.getAllAnnotationInstancesFromIndex(l1));
            }
        } else {
            Enumeration<List<IJavaElementDelta>> e1 = this.annotationsForModifiedResource.elements();
            while (e1.hasMoreElements()) {
                List<IJavaElementDelta> nextEl = e1.nextElement();
                if (!(nextEl instanceof List)) continue;
                List<IJavaElementDelta> lst = nextEl;
                int c = 0;
                while (c < lst.size()) {
                    String name;
                    IJavaElement jEl;
                    IJavaElementDelta delta = lst.get(c);
                    if (delta != null && (jEl = delta.getElement()) != null && ((name = jEl.getElementName()).equals(fullAnnotationName) || name.equals(shortName))) {
                        res.add((IAnnotation)jEl);
                    }
                    ++c;
                }
            }
        }
        return res;
    }

    public boolean isInitialized(boolean startInit) {
        if (!this.isInit && startInit) {
            this.init(this.listener_);
        }
        return this.isInit && this.listener_.isDone();
    }

    private class AnnotationDeltas {
        private List<IJavaElementDelta> annElementDeltas = new ArrayList<IJavaElementDelta>(6);
        private List<IAnnotation> annAddedImplicitly = new ArrayList<IAnnotation>(6);
        private List<IAnnotation> annRemovedImplicitly = new ArrayList<IAnnotation>(6);

        private AnnotationDeltas() {
        }

        public List<IAnnotation> getAnnAddedImplicitly() {
            return this.annAddedImplicitly;
        }

        public List<IAnnotation> getAnnRemovedImplicitly() {
            return this.annRemovedImplicitly;
        }

        public List<IJavaElementDelta> getAnnElementDeltas() {
            return this.annElementDeltas;
        }
    }

    private class IndexingJob
    extends AnnotationJob {
        private IJavaElement[] scopeEls;

        public IndexingJob(String name) {
            super(name);
            this.scopeEls = null;
            this.setPriority(40);
            this.setSystem(TriggerAnnotationListenerImpl.this.setAsSystemJob);
        }

        public IndexingJob(String name, IJavaElement[] scopeEls) {
            super(name);
            this.scopeEls = null;
            this.scopeEls = scopeEls;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IJavaSearchScope scope = null;
            if (monitor.isCanceled() || this.isCancelRequested()) {
                return Status.CANCEL_STATUS;
            }
            if (this.scopeEls == null) {
                ArrayList<IJavaElement> elList = JavaSearchUtils.getInstance().getIJavaElementsForClassPathEntriesForWorkspace();
                IJavaElement[] scopes = JavaSearchUtils.getInstance().turnListToArray(elList);
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])scopes, (boolean)false);
            } else {
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])this.scopeEls, (boolean)false);
            }
            Enumeration e1 = TriggerAnnotationListenerImpl.this.fullAnnotationNames.keys();
            monitor.beginTask(AnnotationCoreMessages.ANNOTATIONS_CORE_WAITING_FOR_JAVA_SEARCH, TriggerAnnotationListenerImpl.this.fullAnnotationNames.size());
            List<IAnnotation> annotations = JavaSearchUtils.getInstance().findAnnotations(scope, e1, null);
            int i = 0;
            while (i < annotations.size()) {
                IAnnotation ann = annotations.get(i);
                ArrayList<IAnnotation> tempList = new ArrayList<IAnnotation>();
                tempList.add(ann);
                TriggerAnnotationListenerImpl.this.inMemoryIndex.updateInMemoryIndex(ann.getParent(), tempList, 0);
                ++i;
            }
            return Status.OK_STATUS;
        }
    }

    private class InternalJavaElementDelta {
        protected IJavaElement element_;
        protected int kind_;

        private InternalJavaElementDelta() {
        }
    }

    private class InvokeChangeListenersJob
    extends AnnotationJob {
        private List<List<IJavaElementDelta>> dels_;
        private List<InternalJavaElementDelta> internalDels_;

        public InvokeChangeListenersJob(List<IJavaElementDelta> dels) {
            super(AnnotationCoreMessages.ANNOTATIONS_CORE_JOB_ANNOTATION_INVOKING_EL_CHANGE_LISTS);
            this.dels_ = null;
            this.internalDels_ = new ArrayList<InternalJavaElementDelta>(6);
            this.dels_ = new ArrayList<List<IJavaElementDelta>>(3);
            this.dels_.add(new ArrayList(6));
            this.dels_.add(new ArrayList(6));
            this.dels_.add(new ArrayList(6));
            this.addDeltas(dels);
            this.setPriority(40);
            this.setSystem(TriggerAnnotationListenerImpl.this.setAsSystemJob);
        }

        public List<List<IJavaElementDelta>> getDeltas() {
            return this.dels_;
        }

        public List<InternalJavaElementDelta> getInternalJavaElementDeltas() {
            return this.internalDels_;
        }

        public void addDeltas(List<IJavaElementDelta> newDeltas) {
            List<IJavaElementDelta> changedList = this.dels_.get(0);
            List<IJavaElementDelta> addedList = this.dels_.get(1);
            List<IJavaElementDelta> removedList = this.dels_.get(2);
            for (IJavaElementDelta delta : newDeltas) {
                int kind = delta.getKind();
                int flag = delta.getFlags();
                if (kind == 1 || (flag & 0x40) != 0) {
                    if (addedList.contains(delta)) continue;
                    addedList.add(delta);
                    continue;
                }
                if (kind == 2 || (flag & 0x80) != 0) {
                    if (removedList.contains(delta)) continue;
                    removedList.add(delta);
                    continue;
                }
                IJavaElement affectedElement = delta.getElement();
                if (affectedElement != null && affectedElement.getElementType() == 2) {
                    if ((delta.getFlags() & 0x400) != 0) {
                        if (removedList.contains(delta)) continue;
                        removedList.add(delta);
                        continue;
                    }
                    if ((delta.getFlags() & 0x200) != 0) {
                        if (addedList.contains(delta)) continue;
                        addedList.add(delta);
                        continue;
                    }
                    if (changedList.contains(delta)) continue;
                    changedList.add(delta);
                    continue;
                }
                if (changedList.contains(delta)) continue;
                changedList.add(delta);
            }
        }

        public void addInternalDeltas(List<InternalJavaElementDelta> newDeltas) {
            this.internalDels_.addAll(newDeltas);
        }

        private IJavaSearchScope getJavaSearchScope() {
            ArrayList<IJavaElement> jEls = new ArrayList<IJavaElement>();
            List<IJavaElementDelta> dels = this.dels_.get(1);
            for (IJavaElementDelta del : dels) {
                IJavaElement el1 = del.getElement();
                if (!el1.exists()) continue;
                if (el1.getElementType() == 2) {
                    jEls.addAll(JavaSearchUtils.getInstance().getIJavaElementsForClassPathEntries((IJavaProject)el1));
                    continue;
                }
                if (el1.getElementType() == 3) {
                    if (!InternalUtils.isValidJARFile((IPackageFragmentRoot)el1)) continue;
                    jEls.add(el1);
                    continue;
                }
                jEls.add(el1);
            }
            int i = 0;
            while (i < this.internalDels_.size()) {
                InternalJavaElementDelta ijed = this.internalDels_.get(i);
                if (ijed.kind_ == 1) {
                    if (ijed.element_.getElementType() == 3) {
                        if (InternalUtils.isValidJARFile((IPackageFragmentRoot)ijed.element_)) {
                            jEls.add(ijed.element_);
                        }
                    } else {
                        jEls.add(ijed.element_);
                    }
                    this.internalDels_.remove(i--);
                }
                ++i;
            }
            if (!jEls.isEmpty()) {
                IJavaElement[] elAr1 = new IJavaElement[jEls.size()];
                elAr1 = jEls.toArray(elAr1);
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elAr1, (boolean)false);
                return scope;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            CodegenPlugin.debug("running elementchange job from: " + this.getFamily() + (Object)((Object)this));
            int counter = 0;
            while (TriggerAnnotationListenerImpl.this.listener_ != null && !TriggerAnnotationListenerImpl.this.listener_.isDone() && counter < 100) {
                try {
                    Thread.sleep(500L);
                    ++counter;
                }
                catch (Exception exception) {}
            }
            List<List<IJavaElementDelta>> list = this.dels_;
            synchronized (list) {
                IJavaSearchScope scope;
                if (monitor.isCanceled() || this.isCancelRequested()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.beginTask(AnnotationCoreMessages.ANNOTATIONS_CORE_WAITING_FOR_JAVA_SEARCH, TriggerAnnotationListenerImpl.this.fullAnnotationNames.size());
                if (!(this.dels_.get(1).size() <= 0 && this.internalDels_.isEmpty() || (scope = this.getJavaSearchScope()) == null)) {
                    List<IAnnotation> annotations = JavaSearchUtils.getInstance().findAnnotations(scope, TriggerAnnotationListenerImpl.this.fullAnnotationNames.keys(), null);
                    IJavaElement lastParent = null;
                    for (IAnnotation ann : annotations) {
                        IJavaElement currentParent = ann.getParent();
                        if (currentParent.equals(lastParent)) continue;
                        lastParent = currentParent;
                        ArrayList<IAnnotation> tempList = new ArrayList<IAnnotation>(1);
                        tempList.add(ann);
                        TriggerAnnotationListenerImpl.this.inMemoryIndex.updateInMemoryIndex(currentParent, tempList, 0);
                    }
                    if (!annotations.isEmpty()) {
                        TriggerAnnotationListenerImpl.this.invokeListeners(annotations, 1, false);
                    }
                }
                if (this.dels_.get(2).size() > 0 || !this.internalDels_.isEmpty()) {
                    List<IAnnotation> anns;
                    IJavaElement ele;
                    ArrayList<IAnnotation> affectedAnnotations = new ArrayList<IAnnotation>();
                    List<IJavaElementDelta> removedList = this.dels_.get(2);
                    for (IJavaElementDelta delta : removedList) {
                        ele = delta.getElement();
                        if (ele.getElementType() == 3 && !InternalUtils.isValidJARFile((IPackageFragmentRoot)ele)) {
                            ele = null;
                        }
                        if (ele == null || (anns = TriggerAnnotationListenerImpl.this.inMemoryIndex.getAnnotationsFromInMemoryIndex(ele, false)).isEmpty()) continue;
                        affectedAnnotations.addAll(anns);
                        TriggerAnnotationListenerImpl.this.inMemoryIndex.updateInMemoryIndex(ele, null, 1);
                    }
                    int i = 0;
                    while (i < this.internalDels_.size()) {
                        InternalJavaElementDelta ijed = this.internalDels_.get(i);
                        if (ijed.kind_ == 2) {
                            ele = ijed.element_;
                            if (ele.getElementType() == 3 && !InternalUtils.isValidJARFile((IPackageFragmentRoot)ele)) {
                                ele = null;
                            }
                            if (ele != null && !(anns = TriggerAnnotationListenerImpl.this.inMemoryIndex.getAnnotationsFromInMemoryIndex(ele, false)).isEmpty()) {
                                affectedAnnotations.addAll(anns);
                                TriggerAnnotationListenerImpl.this.inMemoryIndex.updateInMemoryIndex(ele, null, 1);
                            }
                            this.internalDels_.remove(i--);
                        }
                        ++i;
                    }
                    if (!affectedAnnotations.isEmpty()) {
                        TriggerAnnotationListenerImpl.this.invokeListeners(affectedAnnotations, 2, false);
                    }
                }
                ArrayList dels = new ArrayList();
                dels.addAll(this.dels_.get(0));
                dels.addAll(this.dels_.get(1));
                dels.addAll(this.dels_.get(2));
                for (IJavaElementDelta del : dels) {
                    if (monitor.isCanceled() || this.isCancelRequested()) {
                        return Status.CANCEL_STATUS;
                    }
                    List resL = TriggerAnnotationListenerImpl.this.getAnnotationsForJavaElementDelta(del);
                    for (IAnnotation annN : resL) {
                        String sAnnName = annN.getElementName();
                        List listOfListeners = TriggerAnnotationListenerImpl.this.getListeners(false, sAnnName);
                        if (listOfListeners == null) continue;
                        for (TriggerAnnotationListener l : listOfListeners) {
                            l.affectedElement(del.getElement(), del, sAnnName);
                        }
                    }
                    if (resL.size() <= 0) continue;
                    for (TriggerAnnotationListener l : TriggerAnnotationListenerImpl.this.additionalPostResourceChangeListeners) {
                        l.affectedElement(del.getElement(), del, null);
                    }
                }
                dels.clear();
            }
            return Status.OK_STATUS;
        }
    }

    private class TriggerAnnotationListenerProxy {
        List<?> container_ = new ArrayList(6);
        boolean isResolved_;

        private TriggerAnnotationListenerProxy() {
        }

        void addListenerProxy(IConfigurationElement ice) {
            if (!this.container_.contains(ice)) {
                this.container_.add(ice);
            }
        }

        List<TriggerAnnotationListener> getListeners() {
            if (this.isResolved_) {
                return this.container_;
            }
            ArrayList<TriggerAnnotationListener> listeners = new ArrayList<TriggerAnnotationListener>(6);
            int i = 0;
            while (i < this.container_.size()) {
                IConfigurationElement proxy = (IConfigurationElement)this.container_.get(i);
                try {
                    Object obj = proxy.createExecutableExtension("classListener");
                    if (obj instanceof TriggerAnnotationListener) {
                        listeners.add((TriggerAnnotationListener)obj);
                    }
                }
                catch (Exception e) {
                    String className = proxy.getAttribute("classListener");
                    CodegenPlugin.log(MessageFormat.format(AnnotationCoreMessages.TRIGGER_ANNOTATION_REGISTRATION_CLASSLISTENER, className, ""), e);
                }
                ++i;
            }
            this.isResolved_ = true;
            listeners.trimToSize();
            this.container_ = listeners;
            return listeners;
        }
    }
}

